/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.core.storage;

import java.util.HashMap;
import java.util.Map;
import net.acomputerdog.core.hash.Hash;

public class TripleMap<T, K, U> {
    private final Map<T, TSMItem> item1Map = new HashMap<T, TSMItem>();
    private final Map<K, TSMItem> item2Map = new HashMap<K, TSMItem>();
    private final Map<U, TSMItem> item3Map = new HashMap<U, TSMItem>();

    public void addItems(T string1, K string2, U string3) {
        TSMItem items = new TSMItem(string1, string2, string3);
        this.putItem(this.item1Map, string1, items);
        this.putItem(this.item2Map, string2, items);
        this.putItem(this.item3Map, string3, items);
    }

    private <V> void putItem(Map<V, TSMItem> cat, V item, TSMItem items) {
        if (item != null && item instanceof String && !((String)item).trim().isEmpty()) {
            cat.put((TSMItem)item, items);
        }
    }

    public TSMItem getFrom1(T item) {
        return this.item1Map.get(item);
    }

    public TSMItem getFrom2(K item) {
        return this.item2Map.get(item);
    }

    public TSMItem getFrom3(U item) {
        return this.item3Map.get(item);
    }

    public boolean hasItem1(T item1) {
        return this.item1Map.containsKey(item1);
    }

    public boolean hasItem2(K item2) {
        return this.item2Map.containsKey(item2);
    }

    public boolean hasItem3(U item3) {
        return this.item3Map.containsKey(item3);
    }

    public class TSMItem {
        private final T item1;
        private final K item2;
        private final U item3;

        private TSMItem(T item1, K item2, U item3) {
            this.item1 = item1;
            this.item2 = item2;
            this.item3 = item3;
        }

        public T getItem1() {
            return this.item1;
        }

        public K getItem2() {
            return this.item2;
        }

        public U getItem3() {
            return this.item3;
        }

        public int hashCode() {
            int hash = 19;
            hash = Hash.hash(hash, this.item1);
            hash = Hash.hash(hash, this.item2);
            hash = Hash.hash(hash, this.item3);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof TSMItem) {
                TSMItem other = (TSMItem)obj;
                return this.doesEqual(other.item1, this.item1) && this.doesEqual(other.item2, this.item2) && this.doesEqual(other.item3, this.item3);
            }
            return false;
        }

        public String toString() {
            return "[" + this.item1 + ',' + this.item2 + ',' + this.item3 + ']';
        }

        private boolean doesEqual(Object obj1, Object obj2) {
            if (obj1 == null) {
                return obj2 == null;
            }
            return obj1.equals(obj2);
        }
    }
}

