/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.core.storage;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.acomputerdog.core.identity.Identifiable;

public class Registry<T extends Identifiable<K, V>, K, V> {
    private final Map<V, T> defMap = new LinkedHashMap<V, T>();
    private final Map<K, T> idMap = new LinkedHashMap<K, T>();

    public <T2 extends T> T2 register(T2 item) {
        this.defMap.put(item.getDefinition(), item);
        this.idMap.put(item.getId(), item);
        return item;
    }

    public boolean containsId(K def) {
        return this.defMap.containsKey(def);
    }

    public boolean containsDefinition(V def) {
        return this.defMap.containsKey(def);
    }

    public boolean containsValue(T item) {
        return this.defMap.containsValue(item);
    }

    public T getFromDef(V def) {
        return (T)((Identifiable)this.defMap.get(def));
    }

    public T getFromId(K id) {
        return (T)((Identifiable)this.idMap.get(id));
    }

    public Collection<T> getItems() {
        return this.defMap.values();
    }

    public Set<V> getDefinitions() {
        return Collections.unmodifiableSet(this.defMap.keySet());
    }

    public Set<K> getIds() {
        return Collections.unmodifiableSet(this.idMap.keySet());
    }
}

