/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.core.logger;

public enum LogLevel {
    DEBUG("DEBUG", 0, true, false, false),
    DETAIL("DETAIL", 1, true, false, false),
    INFO("INFO", 2, false, false, false),
    WARNING("WARNING", 3, false, false, false),
    ERROR("ERROR", 4, false, true, false),
    FATAL("FATAL", 5, false, true, false),
    STACK("STACK", 6, false, true, true);

    private final String levelName;
    private final int priority;
    private final boolean isDebug;
    private final boolean isError;
    private final boolean isVoiced;

    private LogLevel(String levelName, int priority, boolean isDebug, boolean isError, boolean isVoiced) {
        this.levelName = levelName;
        this.priority = priority;
        this.isDebug = isDebug;
        this.isError = isError;
        this.isVoiced = isVoiced;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isVoiced() {
        return this.isVoiced;
    }

    public boolean isAllowedBy(int priority) {
        return this.isVoiced || this.priority >= priority;
    }

    public boolean isAllowedBy(LogLevel priority) {
        return this.isAllowedBy(priority.getPriority());
    }

    public static LogLevel getByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null!");
        }
        LogLevel[] logLevelArray = LogLevel.values();
        int n = logLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            LogLevel level = logLevelArray[n2];
            if (name.equals(level.getLevelName())) {
                return level;
            }
            ++n2;
        }
        return null;
    }
}

