/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.core.logger;

import com.blazeloader.util.time.Clock;
import com.blazeloader.util.time.IClock;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import net.acomputerdog.core.logger.LogLevel;
import net.acomputerdog.core.logger.Logger;

public class CLogger
implements Logger {
    private static PrintStream defaultOut = System.out;
    private final PrintWriter exceptionOutput;
    private PrintStream loggerOutput;
    private final String name;
    private final IClock clock;
    private boolean includeDate;
    private boolean includeTime;
    private LogLevel minimumLogLevel;

    public static PrintStream getDefaultOut() {
        return defaultOut;
    }

    public static void setDefaultOut(PrintStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Default stream cannot be null!");
        }
        defaultOut = stream;
    }

    public CLogger(String name) {
        this(name, false, false);
    }

    public CLogger(String name, boolean includeDate, boolean includeTime) {
        this(name, includeDate, includeTime, LogLevel.DEBUG);
    }

    public CLogger(String name, boolean includeDate, boolean includeTime, LogLevel minimumLevel) {
        this(name, includeDate, includeTime, minimumLevel, new Clock());
    }

    public CLogger(String name, boolean includeDate, boolean includeTime, LogLevel minimumLevel, IClock clock) {
        this.name = name == null ? "NULL" : name;
        this.includeDate = includeDate;
        this.includeTime = includeTime;
        this.minimumLogLevel = minimumLevel;
        this.loggerOutput = defaultOut;
        this.exceptionOutput = new PrintWriter(new LogWriter());
        this.clock = clock;
    }

    private void logDirect(LogLevel level, String message) {
        this.loggerOutput.println(this.formatMessage(level, message));
    }

    protected String formatMessage(LogLevel level, String message) {
        String result = "";
        if (this.includeDate) {
            result = String.valueOf(result) + this.getFormattedDate();
        }
        if (this.includeTime) {
            result = String.valueOf(result) + this.getFormattedTime();
        }
        result = String.valueOf(result) + "[" + this.name + "] ";
        if (level != null) {
            result = String.valueOf(result) + "[" + level.getLevelName() + "]";
        }
        return String.valueOf(result) + ": " + message;
    }

    @Override
    public void logRaw(String message) {
        this.logDirect(null, message);
    }

    @Override
    public boolean log(LogLevel level, String message) {
        if (level.isAllowedBy(this.getMinimumLogLevel())) {
            this.logDirect(level, message);
            return true;
        }
        return false;
    }

    @Override
    public boolean logDebug(String message) {
        return this.log(LogLevel.DEBUG, message);
    }

    @Override
    public boolean logDetail(String message) {
        return this.log(LogLevel.DETAIL, message);
    }

    @Override
    public boolean logInfo(String message) {
        return this.log(LogLevel.INFO, message);
    }

    @Override
    public boolean logExceptions(String message, LogLevel level, Throwable ... throwables) {
        if (this.log(level, message)) {
            Throwable[] throwableArray = throwables;
            int n = throwables.length;
            int n2 = 0;
            while (n2 < n) {
                Throwable t = throwableArray[n2];
                t.printStackTrace(this.exceptionOutput);
                ++n2;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean logWarning(String message, Throwable ... throwables) {
        return this.logExceptions(message, LogLevel.WARNING, throwables);
    }

    @Override
    public boolean logError(String message, Throwable ... throwables) {
        return this.logExceptions(message, LogLevel.ERROR, throwables);
    }

    @Override
    public boolean logFatal(String message, Throwable ... throwables) {
        return this.logExceptions(message, LogLevel.FATAL, throwables);
    }

    @Override
    public boolean doesIncludeDate() {
        return this.includeDate;
    }

    @Override
    public void setIncludeDate(boolean includeDate) {
        this.includeDate = includeDate;
    }

    @Override
    public boolean doesIncludeTime() {
        return this.includeTime;
    }

    @Override
    public void setIncludeTime(boolean includeTime) {
        this.includeTime = includeTime;
    }

    @Override
    public LogLevel getMinimumLogLevel() {
        return this.minimumLogLevel;
    }

    @Override
    public void setMinimumLogLevel(LogLevel minimumLogLevel) {
        this.minimumLogLevel = minimumLogLevel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PrintStream getLoggerOutput() {
        return this.loggerOutput;
    }

    @Override
    public void setLoggerOutput(PrintStream loggerOutput) {
        if (loggerOutput == null) {
            throw new IllegalArgumentException("Logger output cannot be null!");
        }
        this.loggerOutput = loggerOutput;
    }

    protected String getFormattedDate() {
        return "[" + this.clock.getDate() + "] ";
    }

    protected String getFormattedTime() {
        return "[" + this.clock.getTime() + "] ";
    }

    private final class LogWriter
    extends Writer {
        private LogWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            StringBuilder builder = new StringBuilder();
            int index = off;
            while (index < off + len) {
                builder.append(cbuf[index]);
                ++index;
            }
            if (builder.length() > 0) {
                String[] outputs;
                String[] stringArray = outputs = builder.toString().split("\n|\r\n|\r");
                int n = outputs.length;
                int n2 = 0;
                while (n2 < n) {
                    String out = stringArray[n2];
                    if (!out.isEmpty() && !out.trim().isEmpty()) {
                        CLogger.this.log(LogLevel.STACK, out);
                    }
                    ++n2;
                }
            }
        }

        @Override
        public void flush() throws IOException {
            CLogger.this.loggerOutput.flush();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

