/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.OBFUtil.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.acomputerdog.OBFUtil.map.TargetType;
import net.acomputerdog.OBFUtil.table.OBFTable;

public class Obfuscator {
    private static final Pattern DESCRIPTOR_MATCHER = Pattern.compile("\\[*L[^;]+;|\\[[ZBCSIFDJ]|[ZBCSIFDJ]");

    public String getMemberName(String item) {
        item = item.split(" ")[0];
        int lastDot = item.lastIndexOf(46);
        return item.substring(lastDot + 1, item.length());
    }

    public String getMemberClass(String item) {
        item = item.split(" ")[0];
        int lastDot = item.lastIndexOf(46);
        return item.substring(0, lastDot);
    }

    public String obfuscateDescriptor(String descriptor, OBFTable table) {
        String obfuscatedDescriptor = "";
        String[] split = descriptor.split("\\)");
        List<String> classes = Obfuscator.splitDescriptor(split[0]);
        if (split.length < 2) {
            throw new IllegalArgumentException("Missing return type for \"" + descriptor + "\"");
        }
        int j = 0;
        while (j < classes.size()) {
            obfuscatedDescriptor = String.valueOf(obfuscatedDescriptor) + this.obfParameter(classes.get(j), table);
            ++j;
        }
        return "(" + obfuscatedDescriptor + ")" + this.obfParameter(split[1], table);
    }

    public String deObfuscateDescriptor(String descriptor, OBFTable table) {
        String obfuscatedDescriptor = "";
        String[] split = descriptor.split("\\)");
        List<String> classes = Obfuscator.splitDescriptor(split[0]);
        if (split.length < 2) {
            throw new IllegalArgumentException("Missing return type for \"" + descriptor + "\"");
        }
        int j = 0;
        while (j < classes.size()) {
            obfuscatedDescriptor = String.valueOf(obfuscatedDescriptor) + this.deObfParameter(classes.get(j), table);
            ++j;
        }
        return "(" + obfuscatedDescriptor + ")" + this.deObfParameter(split[1], table);
    }

    public String obfMemberClass(String item, OBFTable table) {
        String className = this.getMemberClass(item);
        if (table.hasDeobf(className, TargetType.CLASS)) {
            return item.replace(className, table.obf(className, TargetType.CLASS));
        }
        return item;
    }

    public String obfParameter(String item, OBFTable table) {
        String type;
        String dotted;
        if (item.endsWith(";") && table.hasDeobf(dotted = (type = this.extractClass(item)).replace('/', '.'), TargetType.CLASS)) {
            return item.replace(type, table.obf(dotted, TargetType.CLASS).replace('.', '/'));
        }
        return item;
    }

    public String deObfParameter(String item, OBFTable table) {
        String type;
        String dotted;
        if (item.endsWith(";") && table.hasObf(dotted = (type = this.extractClass(item)).replace('/', '.'), TargetType.CLASS)) {
            return item.replace(type, table.deobf(dotted, TargetType.CLASS).replace('.', '/'));
        }
        return item;
    }

    private String extractClass(String descriptedClass) {
        String[] split = descriptedClass.split("\\[");
        String result = split[split.length - 1];
        return result.substring(1, result.length() - 1);
    }

    public static List<String> splitDescriptor(String descriptor) {
        ArrayList<String> params = new ArrayList<String>();
        Matcher matcher = DESCRIPTOR_MATCHER.matcher(descriptor.trim());
        while (matcher.find()) {
            params.add(matcher.group());
        }
        return params;
    }
}

