/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.OBFUtil.parse.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.acomputerdog.OBFUtil.parse.FileParser;
import net.acomputerdog.OBFUtil.table.OBFTable;
import net.acomputerdog.core.java.Patterns;

public abstract class CSVFileParser
extends FileParser {
    private CSVFile csv;

    @Override
    public void loadEntries(File file, OBFTable table, boolean overwrite) throws IOException {
        this.csv = new CSVFile();
        super.loadEntries(file, table, overwrite);
        this.writeCSVToTable(file, this.csv, table);
        this.csv = null;
    }

    @Override
    protected void parseFile(BufferedReader reader, OBFTable table, boolean overwrite) throws IOException {
        String line;
        int lineNum = 0;
        String[] categories = new String[]{};
        while ((line = reader.readLine()) != null) {
            if (this.isLineEmpty(line)) continue;
            String[] items = line.split(Patterns.COMMA);
            if (lineNum == 0) {
                categories = items;
                lineNum = 0;
            } else {
                int itemNum = 0;
                String[] stringArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (itemNum < categories.length) {
                        this.csv.addItem(categories[itemNum], item);
                        ++itemNum;
                    } else {
                        String newItem = String.valueOf(this.csv.getItem(categories[itemNum - 1], this.csv.size() - 1)) + "," + item;
                        this.csv.setItem(categories[itemNum - 1], this.csv.size() - 1, newItem);
                    }
                    ++n2;
                }
                while (itemNum < categories.length) {
                    this.csv.addItem(categories[itemNum], "");
                    ++itemNum;
                }
            }
            ++lineNum;
        }
    }

    @Override
    public void storeEntries(File file, OBFTable table) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null!");
        }
        try (Writer out = null;){
            out = new BufferedWriter(new FileWriter(file));
            CSVFile csv = this.readCSVFromTable(file, table);
            out.write(csv.toString());
        }
    }

    private boolean isLineEmpty(String line) {
        if (line.isEmpty()) {
            return true;
        }
        char[] chars = (line = line.trim()).toCharArray();
        if (chars[0] == ',') {
            return true;
        }
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char chr = cArray[n2];
            if (chr != ',' && !Character.isWhitespace(chr)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected abstract void writeCSVToTable(File var1, CSVFile var2, OBFTable var3);

    protected abstract CSVFile readCSVFromTable(File var1, OBFTable var2);

    public static class CSVFile {
        private final Map<String, List<String>> categories = new HashMap<String, List<String>>();
        private final List<String> catNames = new ArrayList<String>();
        private int size = 0;

        private List<String> getCategory(String name) {
            List<String> category = this.categories.get(name);
            if (category == null) {
                category = new ArrayList<String>();
                this.categories.put(name, category);
                this.catNames.add(name);
            }
            return category;
        }

        public String[] getCategories() {
            return this.catNames.toArray(new String[this.catNames.size()]);
        }

        public String getItem(String category, int index) {
            return this.getCategory(category).get(index);
        }

        public void setItem(String category, int index, String item) {
            this.getCategory(category).set(index, item);
        }

        public void addItem(String category, String item) {
            List<String> catList = this.getCategory(category);
            catList.add(item);
            this.size = catList.size();
        }

        public int size() {
            return this.size;
        }

        public String[] getRow(int row) {
            if (row > this.size) {
                throw new IllegalArgumentException("Row number " + row + " is greater than maximum " + this.size);
            }
            String[] rowData = new String[this.categories.size()];
            int index = 0;
            String[] stringArray = this.getCategories();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                List<String> category = this.getCategory(str);
                rowData[index] = this.getRow(category, row);
                ++index;
                ++n2;
            }
            return rowData;
        }

        private String getRow(List<String> category, int row) {
            return category.get(row);
        }

        public void setRow(int row, String[] data) {
            int index = 0;
            String[] categoryIDs = this.getCategories();
            String[] stringArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                this.getCategory(categoryIDs[index]).set(row, str);
                ++index;
                ++n2;
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.mergeArray(this.getCategories(), builder);
            int row = 0;
            while (row < this.size()) {
                builder.append("\n");
                this.mergeArray(this.getRow(row), builder);
                ++row;
            }
            return builder.toString();
        }

        private void mergeArray(String[] strings, StringBuilder builder) {
            int index = 0;
            while (index < strings.length) {
                builder.append(strings[index]);
                if (index < strings.length - 1) {
                    builder.append(",");
                }
                ++index;
            }
        }
    }
}

