/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.OBFUtil.parse.types;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import net.acomputerdog.OBFUtil.map.TargetType;
import net.acomputerdog.OBFUtil.parse.FormatException;
import net.acomputerdog.OBFUtil.parse.types.OBFParser;
import net.acomputerdog.OBFUtil.table.DirectOBFTableSRG;
import net.acomputerdog.OBFUtil.table.OBFTable;
import net.acomputerdog.OBFUtil.table.OBFTableSRG;
import net.acomputerdog.core.java.Patterns;

public class BLOBFParser
extends OBFParser {
    private final boolean stripDescs;

    public BLOBFParser() {
        this(false);
    }

    public BLOBFParser(boolean stripMethodDescriptors) {
        this.stripDescs = stripMethodDescriptors;
    }

    @Override
    protected void parseFile(BufferedReader reader, OBFTable table, boolean overwrite) throws IOException {
        String str;
        boolean handleSrg = table instanceof DirectOBFTableSRG;
        int line = 0;
        while ((str = reader.readLine()) != null) {
            ++line;
            if (this.isCommentLine(str)) continue;
            String[] parts = str.split(Patterns.COLON);
            if (parts.length < 4) {
                throw new FormatException("Format error on line " + line + ": \"" + str + "\"");
            }
            TargetType type = TargetType.valueOf(parts[0]);
            if (type == null) {
                throw new FormatException("Illegal target type on line " + line + ": \"" + parts[0] + "\"");
            }
            if (handleSrg) {
                this.parseStringArraySRG(line, str, parts, type, (DirectOBFTableSRG)table, overwrite);
                continue;
            }
            this.parseStringArrayNormal(line, str, parts, type, (DirectOBFTableSRG)table, overwrite);
        }
    }

    protected void parseStringArraySRG(int line, String str, String[] parts, TargetType type, DirectOBFTableSRG table, boolean overwrite) throws FormatException, IOException {
        if (type == TargetType.METHOD) {
            if (parts.length < 7) {
                throw new FormatException("Format error on line " + line + ": \"" + str + "\"");
            }
            if (overwrite || !table.hasObf(parts[1], type)) {
                if (this.stripDescs) {
                    table.addTypeSRG(parts[1], parts[3], parts[5], type);
                } else {
                    table.addTypeSRG(String.valueOf(parts[1]) + " " + parts[2], String.valueOf(parts[3]) + " " + parts[4], String.valueOf(parts[5]) + " " + parts[6], type);
                }
            }
        } else if (overwrite || !table.hasObf(parts[1], type)) {
            table.addTypeSRG(parts[1], parts[2], parts[3], type);
        }
    }

    protected void parseStringArrayNormal(int line, String str, String[] parts, TargetType type, OBFTable table, boolean overwrite) throws FormatException, IOException {
        if (type == TargetType.METHOD) {
            if (parts.length < 7) {
                throw new FormatException("Format error on line " + line + ": \"" + str + "\"");
            }
            if (overwrite || !table.hasObf(parts[1], type)) {
                table.addType(String.valueOf(parts[1]) + " " + parts[2], String.valueOf(parts[5]) + " " + parts[6], type);
            }
        } else if (overwrite || !table.hasObf(parts[1], type)) {
            table.addType(parts[1], parts[3], type);
        }
    }

    @Override
    protected void writeTable(Writer out, OBFTable table) throws IOException {
        if (table instanceof OBFTableSRG) {
            TargetType[] targetTypeArray = TargetType.values();
            int n = targetTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TargetType type = targetTypeArray[n2];
                if (table.supportsType(type)) {
                    String[] stringArray = table.getAllObf(type);
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String obf = stringArray[n4];
                        this.writeEntry(out, obf, type, (OBFTableSRG)table);
                        ++n4;
                    }
                }
                ++n2;
            }
        } else {
            super.writeTable(out, table);
        }
    }

    @Override
    protected void writeEntry(Writer out, String obf, TargetType type, OBFTable table) throws IOException {
        out.write(type.name());
        out.write(":");
        String deobf = table.deobf(obf, type);
        if (type == TargetType.METHOD) {
            obf = this.separateDescriptor(obf);
            deobf = this.separateDescriptor(deobf);
        }
        out.write(obf);
        out.write(":");
        out.write(deobf);
        out.write("\n");
    }

    protected void writeEntry(Writer out, String obf, TargetType type, OBFTableSRG table) throws IOException {
        out.write(type.name());
        out.write(":");
        String srg = table.getSRGFromObf(obf, type);
        String deobf = table.deobf(obf, type);
        if (type == TargetType.METHOD) {
            obf = this.separateDescriptor(obf);
            srg = this.separateDescriptor(srg);
            deobf = this.separateDescriptor(deobf);
        }
        out.write(obf);
        out.write(":");
        out.write(srg);
        out.write(":");
        out.write(deobf);
        out.write("\n");
    }

    protected String separateDescriptor(String line) {
        if (line.indexOf(32) == -1) {
            return line;
        }
        String[] parts = line.split(" ");
        return String.valueOf(parts[0]) + ":" + (parts.length > 1 ? this.packageToPath(parts[1]) : " ");
    }

    protected String packageToPath(String pkg) {
        return pkg == null ? null : pkg.replace('.', '/');
    }
}

