/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.OBFUtil.parse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import net.acomputerdog.OBFUtil.table.OBFTable;

public abstract class FileParser {
    public void loadEntries(File file, OBFTable table, boolean overwrite) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null!");
        }
        try (BufferedReader in = null;){
            try {
                in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                this.parseFile(in, table, overwrite);
            }
            catch (IOException e) {
                throw new IOException("Exception whilst reading file", e);
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Exception whilst reading file", e);
            }
        }
    }

    protected abstract void parseFile(BufferedReader var1, OBFTable var2, boolean var3) throws IOException;

    public abstract void storeEntries(File var1, OBFTable var2) throws IOException;
}

