/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.util.transformers;

import com.blazeloader.bl.obf.AccessLevel;
import com.blazeloader.bl.obf.BLOBF;
import com.blazeloader.bl.obf.OBFLevel;
import com.blazeloader.util.transformers.mapping.DefaultTransformationMap;
import com.blazeloader.util.transformers.mapping.TransformationMap;
import com.blazeloader.util.transformers.transformations.FieldSelector;
import com.blazeloader.util.transformers.transformations.FinalityTransformation;
import com.blazeloader.util.transformers.transformations.MethodSelector;
import com.blazeloader.util.transformers.transformations.PublicityTransformation;
import com.blazeloader.util.transformers.transformations.TargetSelector;
import com.blazeloader.util.transformers.transformations.Transformation;
import java.util.List;
import net.acomputerdog.OBFUtil.map.TargetType;
import net.acomputerdog.OBFUtil.parse.types.ONFParser;
import net.acomputerdog.core.java.Patterns;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ONFTransformer {
    private static boolean initialised = false;
    private static List<ONFParser.DetectedTransformation> onfs = null;
    private final TransformationMap transformations = new DefaultTransformationMap();

    public static void setONFS(List<ONFParser.DetectedTransformation> transformations) {
        onfs = transformations;
    }

    public ONFTransformer() {
        if (initialised) {
            throw new IllegalStateException("Cannot create more than one ONFTransformer!");
        }
        if (onfs == null) {
            BLOBF.OBF.equals(null);
        }
        initialised = true;
        for (ONFParser.DetectedTransformation i : onfs) {
            this.loadTransformation(i);
        }
        onfs = null;
    }

    private void loadTransformation(ONFParser.DetectedTransformation transform) {
        String clName;
        String name;
        BLOBF obf;
        if (transform.isGlobal) {
            obf = BLOBF.getOBF(transform.mcpTarget, TargetType.CLASS, OBFLevel.MCP);
            name = "*";
            clName = obf.getValue();
        } else {
            obf = BLOBF.getOBF(transform.mcpTarget, transform.targetType, OBFLevel.MCP);
            name = obf.getValue();
            int lastDot = name.lastIndexOf(46);
            clName = name.substring(0, lastDot);
            name = name.substring(lastDot + 1, name.length());
        }
        TargetType type = transform.targetType.getBaseType();
        if (type == TargetType.METHOD) {
            name = String.valueOf(name.split(" ")[0].replace('/', '.')) + " " + name.split(" ")[1];
        }
        this.getTransformation(transform.directives.split(Patterns.COMMA), clName, name, type);
    }

    private void getTransformation(String[] changes, String clName, String name, TargetType type) {
        String[] stringArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            String change;
            TargetSelector selector = type == TargetType.METHOD ? new MethodSelector(name) : new FieldSelector(name);
            Transformation t = this.getTransformation(selector, change = stringArray[n2], clName);
            if (t != null) {
                this.transformations.addTransformation(t);
            }
            ++n2;
        }
    }

    private Transformation getTransformation(TargetSelector selector, String change, String clName) {
        switch (change) {
            case "f": 
            case "+f": {
                return new FinalityTransformation(selector, clName, true);
            }
            case "-f": {
                return new FinalityTransformation(selector, clName, false);
            }
            case "public": {
                return new PublicityTransformation(selector, clName, AccessLevel.PUBLIC);
            }
            case "private": {
                return new PublicityTransformation(selector, clName, AccessLevel.PRIVATE);
            }
            case "protected": {
                return new PublicityTransformation(selector, clName, AccessLevel.PROTECTED);
            }
            case "package": {
                return new PublicityTransformation(selector, clName, AccessLevel.PACKAGE);
            }
        }
        System.err.println("Invalid transformation: " + change);
        return null;
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassNode classNode = new ClassNode();
        new ClassReader(bytes).accept(classNode, 0);
        if (this.transformations.applyAll(transformedName, classNode)) {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept(writer);
            return writer.toByteArray();
        }
        return bytes;
    }
}

