/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.jarjar.convert;

import com.blazeloader.jarjar.tree.ClassMap;
import com.blazeloader.jarjar.tree.ClassTree;
import com.blazeloader.jarjar.tree.ClassTreeMatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import net.acomputerdog.OBFUtil.map.TargetType;
import net.acomputerdog.OBFUtil.table.DirectOBFTable;
import net.acomputerdog.OBFUtil.util.Obfuscator;

public class ClassRemapper {
    private Obfuscator obfuscator = new Obfuscator();
    private ClassMap source = new ClassMap(0);
    private ClassMap destination = new ClassMap(0);
    private ClassTree from;
    private ClassTree to;
    private ClassTreeMatcher matcher = null;

    public ClassRemapper(File sourceJar, File destinationJar) {
        try {
            this.source.readFromJar(sourceJar);
            this.destination.readFromJar(destinationJar);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void buildClassTrees() {
        if (this.from == null) {
            System.out.println("Building source class tree");
            this.from = new ClassTree(this.source);
            System.out.println("Source class tree has " + this.from.size() + " members.");
            System.out.println("Sorting source tree...");
            this.from.sort();
        }
        if (this.to == null) {
            System.out.println("Building destination class tree");
            this.to = new ClassTree(this.destination);
            System.out.println("Destination class tree has " + this.to.size() + " members.");
            System.out.println("Sorting destination tree...");
            this.to.sort();
        }
    }

    public ClassTreeMatcher loadMatcher() {
        this.buildClassTrees();
        System.out.println("Performing best match analysis");
        this.matcher = new ClassTreeMatcher(this.from, this.to);
        System.out.println("Classes matched: " + this.matcher.size());
        System.out.println("Average match: " + Math.floor(this.matcher.averageSimilarity() * 100.0) / 100.0 + "%");
        return this.matcher;
    }

    public ClassTreeMatcher loadMatcherFromJson(String path) {
        System.out.println("Loading mapping tree from: " + path);
        this.buildClassTrees();
        File input = new File(path);
        if (input.exists()) {
            String json = "";
            BufferedReader buff = null;
            try {
                try {
                    String line;
                    buff = new BufferedReader(new FileReader(input));
                    while ((line = buff.readLine()) != null) {
                        json = String.valueOf(json) + line;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.matcher = null;
                    ClassTreeMatcher classTreeMatcher = null;
                    if (buff != null) {
                        try {
                            buff.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return classTreeMatcher;
                }
            }
            finally {
                if (buff != null) {
                    try {
                        buff.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.matcher = ClassTreeMatcher.loadFromJson(this.from, this.to, json);
            System.out.println("Match tree successfuly loaded");
            System.out.println("Classes matched: " + this.matcher.size());
            System.out.println("Average match: " + Math.floor(this.matcher.averageSimilarity() * 100.0) / 100.0 + "%");
            return this.matcher;
        }
        System.out.println("Error: File not found.");
        return null;
    }

    private ClassTreeMatcher resolveAnonymouse(ClassTreeMatcher matcher, String before) {
        ClassTreeMatcher after = matcher.lookup(before);
        if (after == null && ClassTree.isAnon(before)) {
            return this.resolveAnonymouse(matcher, ClassTree.getOuter(before));
        }
        return after;
    }

    public DirectOBFTable remapTree(DirectOBFTable table) {
        DirectOBFTable result = new DirectOBFTable();
        String[] classes = table.getAllObf(TargetType.CLASS);
        if (this.matcher == null) {
            this.loadMatcher();
        }
        System.out.println("Remapping obfuscation classes...");
        int skippedClasses = 0;
        String[] stringArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            String before = className.replace('.', '/');
            ClassTreeMatcher after = this.resolveAnonymouse(this.matcher, before);
            if (after != null) {
                before = before.replace(after.before().getName(), "");
                String obf = String.valueOf(after.after().getName()) + before;
                if (result.hasObf(obf, TargetType.CLASS)) {
                    System.err.println("Error: Duplicate class obfuscation: [" + before + "] " + obf + " -> " + className);
                    System.err.println("       Already mapped as: [" + before + "] " + obf + " -> " + result.deobf(obf, TargetType.CLASS));
                }
                result.addType(obf, table.deobf(className, TargetType.CLASS), TargetType.CLASS);
            } else {
                System.out.println("Error: Classname missing from trees: \"" + className + "\" was \"" + table.deobf(className, TargetType.CLASS) + "\" Skipping.");
                ++skippedClasses;
            }
            ++n2;
        }
        if (skippedClasses > 0) {
            System.err.println("Error: " + skippedClasses + " classes skipped.");
        }
        classes = result.getAllObf(TargetType.CLASS);
        stringArray = table.getAllDeobf(TargetType.FIELD);
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            String obfName = this.obfuscator.getMemberName(table.obf(field, TargetType.FIELD));
            String mcpClass = this.obfuscator.getMemberClass(field);
            if (result.hasDeobf(mcpClass, TargetType.CLASS)) {
                String obfClass = result.obf(mcpClass, TargetType.CLASS);
                result.addType(String.valueOf(obfClass) + "." + obfName, field, TargetType.FIELD);
            }
            ++n2;
        }
        stringArray = table.getAllDeobf(TargetType.METHOD);
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String method = stringArray[n2];
            String[] split = method.split(" ");
            String obfName = this.obfuscator.getMemberName(table.obf(method, TargetType.METHOD));
            String mcpClass = this.obfuscator.getMemberClass(split[0]);
            if (result.hasDeobf(mcpClass, TargetType.CLASS)) {
                String obfClass = result.obf(mcpClass, TargetType.CLASS);
                String obfDescriptor = null;
                if (obfDescriptor == null) {
                    obfDescriptor = this.obfuscator.obfuscateDescriptor(method.split(" ")[1], result);
                }
                String mcpDescriptor = this.obfuscator.deObfuscateDescriptor(obfDescriptor, result);
                result.addType(String.valueOf(obfClass) + "." + obfName + " " + obfDescriptor, String.valueOf(split[0]) + " " + mcpDescriptor, TargetType.METHOD);
            }
            ++n2;
        }
        stringArray = table.getAllDeobf(TargetType.PACKAGE);
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String pack = stringArray[n2];
            result.addType(table.obf(pack, TargetType.PACKAGE), pack, TargetType.PACKAGE);
            ++n2;
        }
        return result;
    }
}

