/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.bl.obf;

import com.blazeloader.bl.obf.BLOBF;
import com.blazeloader.bl.obf.OBFLevel;
import net.acomputerdog.OBFUtil.map.ObfMapSrg;
import net.acomputerdog.OBFUtil.map.TargetType;
import net.acomputerdog.OBFUtil.table.DirectOBFTableSRG;

public class BLOBFTable<T extends BLOBFMapping>
extends DirectOBFTableSRG<BLOBF, T> {
    public BLOBF getBLOBF(String name, TargetType type, OBFLevel level) {
        Object item;
        BLOBFMapping map = (BLOBFMapping)this.tableMappings.getChecked(type);
        if (!map.hasType(name, level)) {
            throw new IllegalArgumentException("Unrecognised Obfuscation String: " + level.toString() + "@" + name + " for TargetType: " + type.toString());
        }
        switch (level) {
            case SRG: {
                item = map.bySrg(name);
                break;
            }
            case MCP: {
                item = (ObfMapSrg.Entry)map.byDeobf(name);
                break;
            }
            default: {
                item = (ObfMapSrg.Entry)map.byObf(name);
            }
        }
        if (!(item instanceof BLOBF)) {
            return map.remap((ObfMapSrg.Entry)item, new BLOBF(item.obf(), item.srg(), item.deObf()));
        }
        return (BLOBF)item;
    }

    public boolean hasType(String name, TargetType type, OBFLevel level) {
        return this.tableMappings.containsKey((Object)type) && ((BLOBFMapping)this.tableMappings.getChecked(type)).hasType(name, level);
    }

    @Override
    protected T createMap() {
        return (T)new BLOBFMapping();
    }

    protected class BLOBFMapping
    extends DirectOBFTableSRG.MappingSrg {
        protected BLOBFMapping() {
            super(BLOBFTable.this);
        }

        public BLOBF remap(ObfMapSrg.Entry entry, BLOBF obf) {
            this.obfuscated.put(entry.obf(), obf);
            this.deobfuscated.put(entry.deObf(), obf);
            this.searge.put(entry.srg(), obf);
            return obf;
        }

        public boolean hasType(String name, OBFLevel level) {
            switch (level) {
                case SRG: {
                    return this.hasSrg(name);
                }
                case MCP: {
                    return this.hasDeObf(name);
                }
            }
            return this.hasObf(name);
        }
    }
}

