/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.core.tree;

import net.acomputerdog.core.tree.Branch;

public class Leaf<T> {
    private T item;
    private final Branch<T> branch;

    public Leaf(Branch<T> branch, T item) {
        if (branch == null) {
            throw new IllegalArgumentException("Cannot attach to a nul branch!");
        }
        this.branch = branch;
        this.item = item;
    }

    public Leaf(Branch<T> branch) {
        this(branch, null);
    }

    public T getItem() {
        return this.item;
    }

    public void setItem(T item) {
        this.item = item;
    }

    public Branch<T> getBranch() {
        return this.branch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Leaf)) {
            return false;
        }
        Leaf leaf = (Leaf)o;
        return this.branch.equals(leaf.branch) && (this.item != null ? this.item.equals(leaf.item) : leaf.item == null);
    }

    public int hashCode() {
        int result = this.item != null ? this.item.hashCode() : 0;
        result = 31 * result + this.branch.hashCode();
        return result;
    }

    public String toString() {
        return "Leaf{item=" + this.item + ", branch=" + this.branch + '}';
    }
}

