/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.core.tree;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.acomputerdog.core.tree.Leaf;
import net.acomputerdog.core.tree.Tree;

public class Branch<T> {
    private final Branch<T> parent;
    private final Set<Branch<T>> branches;
    private final Set<Leaf<T>> leaves;
    private final Tree<T> tree;

    public Branch(Tree<T> tree, Branch<T> parent) {
        if (tree == null) {
            throw new IllegalArgumentException("Cannot attach to a null tree!");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Cannot attach to a null branch!");
        }
        this.tree = tree;
        this.parent = parent;
        this.branches = new HashSet<Branch<T>>();
        this.leaves = new HashSet<Leaf<T>>();
    }

    protected Branch(Tree<T> tree) {
        this.tree = tree;
        this.parent = null;
        this.branches = new HashSet<Branch<T>>();
        this.leaves = new HashSet<Leaf<T>>();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Branch getParent() {
        return this.parent;
    }

    public Set<Branch<T>> getBranches() {
        return Collections.unmodifiableSet(this.branches);
    }

    public Set<Leaf<T>> getLeaves() {
        return Collections.unmodifiableSet(this.leaves);
    }

    public int getNumBranches() {
        return this.branches.size();
    }

    public int getNumLeaves() {
        return this.leaves.size();
    }

    public void addBranch(Branch<T> branch) {
        if (branch == null) {
            throw new IllegalArgumentException("Cannot attach a null branch!");
        }
        if (branch == this) {
            throw new IllegalArgumentException("Cannot attach a branch to itself!");
        }
        this.branches.add(branch);
    }

    public void addLeaf(Leaf<T> leaf) {
        this.leaves.add(leaf);
    }

    public Tree<T> getTree() {
        return this.tree;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Branch)) {
            return false;
        }
        Branch branch = (Branch)o;
        return this.branches.equals(branch.branches) && this.leaves.equals(branch.leaves);
    }

    public int hashCode() {
        int result = this.branches.hashCode();
        result = 31 * result + this.leaves.hashCode();
        return result;
    }

    public String toString() {
        return "Branch{branches=" + this.branches + ", leaves=" + this.leaves + '}';
    }
}

