/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.OBFUtil.table;

import java.util.HashMap;
import java.util.Map;
import net.acomputerdog.OBFUtil.map.ObfMap;
import net.acomputerdog.OBFUtil.map.TargetType;
import net.acomputerdog.OBFUtil.map.TargetTypeMap;
import net.acomputerdog.OBFUtil.table.OBFTable;

public class DirectOBFTable<P extends ObfMap.Entry, T extends ObfMap<P>>
implements OBFTable {
    protected final TargetTypeMap<T> tableMappings = new TargetTypeMap();
    private int size = 0;

    @Override
    public String deobf(String obfName, TargetType type) {
        return ((ObfMap)this.tableMappings.getChecked(type)).byObf(obfName).deObf();
    }

    @Override
    public String obf(String deobfName, TargetType type) {
        return ((ObfMap)this.tableMappings.getChecked(type)).byDeobf(deobfName).obf();
    }

    @Override
    public boolean hasObf(String obfName, TargetType type) {
        return this.tableMappings.containsKey((Object)type) && ((ObfMap)this.tableMappings.getChecked(type)).hasObf(obfName);
    }

    @Override
    public boolean hasDeobf(String deobfName, TargetType type) {
        return this.tableMappings.containsKey((Object)type) && ((ObfMap)this.tableMappings.getChecked(type)).hasDeObf(deobfName);
    }

    @Override
    public boolean supportsType(TargetType type) {
        return this.tableMappings.containsKey((Object)type);
    }

    @Override
    public String[] getAllObf(TargetType type) {
        return ((ObfMap)this.tableMappings.getChecked(type)).getAllObf();
    }

    @Override
    public String[] getAllDeobf(TargetType type) {
        return ((ObfMap)this.tableMappings.getChecked(type)).getAllDeObf();
    }

    protected void preAdd(TargetType type) {
        ++this.size;
        if (!this.tableMappings.containsKey((Object)type)) {
            this.tableMappings.put(type, this.createMap());
        }
    }

    protected T createMap() {
        return (T)new Mapping();
    }

    @Override
    public void addType(String obfName, String deObfName, TargetType type) {
        this.preAdd(type);
        ((ObfMap)this.tableMappings.get((Object)type)).add(obfName, deObfName);
    }

    @Override
    public void writeToTable(OBFTable table, boolean overwrite) {
        for (Map.Entry i : this.tableMappings.entrySet()) {
            ((ObfMap)i.getValue()).write(table, overwrite, (TargetType)((Object)i.getKey()));
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public class Mapping
    implements ObfMap<P> {
        protected final Map<String, P> obfuscated = new HashMap();
        protected final Map<String, P> deobfuscated = new HashMap();

        @Override
        public String[] getAllObf() {
            return this.obfuscated.keySet().toArray(new String[this.obfuscated.size()]);
        }

        @Override
        public String[] getAllDeObf() {
            return this.deobfuscated.keySet().toArray(new String[this.deobfuscated.size()]);
        }

        @Override
        public P byDeobf(String deobf) {
            return (ObfMap.Entry)this.deobfuscated.get(deobf);
        }

        @Override
        public P byObf(String obf) {
            return (ObfMap.Entry)this.obfuscated.get(obf);
        }

        @Override
        public boolean hasObf(String obf) {
            return this.obfuscated.containsKey(obf);
        }

        @Override
        public boolean hasDeObf(String deobf) {
            return this.deobfuscated.containsKey(deobf);
        }

        @Override
        public void add(String obf, String deobf) {
            this.add(new ObfEntry(obf, deobf));
        }

        protected void add(P entry) {
            this.obfuscated.put(entry.obf(), entry);
            this.deobfuscated.put(entry.deObf(), entry);
        }

        @Override
        public void write(OBFTable table, boolean overwrite, TargetType type) {
            for (Map.Entry i : this.obfuscated.entrySet()) {
                if (!overwrite && table.hasObf(i.getKey(), type)) continue;
                table.addType(i.getKey(), ((ObfMap.Entry)i.getValue()).deObf(), type);
            }
        }
    }

    public class ObfEntry
    implements ObfMap.Entry {
        public String obfuscated;
        public String deobfuscated;

        public ObfEntry(String obf, String deobf) {
            this.obfuscated = obf;
            this.deobfuscated = deobf;
        }

        @Override
        public String obf() {
            return this.obfuscated;
        }

        @Override
        public String deObf() {
            return this.deobfuscated;
        }
    }
}

