/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.util.transformers.transformations;

import com.blazeloader.util.transformers.transformations.TargetSelector;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class Transformation {
    private final TargetSelector targeter;
    public final String targetClass;

    public Transformation(TargetSelector selector, String target) {
        this.targeter = selector.initWith(this);
        this.targetClass = target;
    }

    public boolean apply(ClassNode cls) {
        String dotName = Transformation.getDotName(cls.name);
        if (dotName.equals(this.targetClass)) {
            return this.targeter.match(cls);
        }
        return false;
    }

    public abstract void transformField(FieldNode var1);

    public abstract void transformMethod(MethodNode var1);

    public static String getDotName(String slashName) {
        return slashName.replace('/', '.');
    }
}

