/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.util.transformers.transformations;

import com.blazeloader.bl.obf.AccessLevel;
import com.blazeloader.util.transformers.transformations.TargetSelector;
import com.blazeloader.util.transformers.transformations.Transformation;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class PublicityTransformation
extends Transformation {
    private static final int ACC_PACKAGE = 0;
    public final AccessLevel access;

    public PublicityTransformation(TargetSelector selector, String targetClass, AccessLevel level) {
        super(selector, targetClass);
        this.access = level;
    }

    @Override
    public void transformField(FieldNode node) {
        int access = this.setPublicity(node.access, this.access);
        if (access != node.access) {
            System.out.println("FIELD: Change publicity: " + node.name + " -> " + (Object)((Object)this.access));
            node.access = access;
        }
    }

    @Override
    public void transformMethod(MethodNode node) {
        int access = this.setPublicity(node.access, this.access);
        if (access != node.access) {
            System.out.println("METHOD: Change publicity: " + node.name + " " + node.desc + " -> " + (Object)((Object)this.access));
            node.access = access;
        }
    }

    protected final int setPublicity(int currAccess, AccessLevel publicity) {
        int pubValue = publicity.getValue();
        int ret = currAccess & 0xFFFFFFF8;
        switch (currAccess & 7) {
            case 1: {
                if (pubValue == 4) {
                    return currAccess;
                }
            }
            case 4: {
                if (pubValue == 0) {
                    return currAccess;
                }
            }
            case 0: {
                if (pubValue != 2) break;
                return currAccess;
            }
        }
        return ret | pubValue;
    }
}

