/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.util.transformers.transformations;

import com.blazeloader.util.transformers.transformations.TargetSelector;
import com.blazeloader.util.transformers.transformations.Transformation;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class FinalityTransformation
extends Transformation {
    private final boolean finalValue;

    public FinalityTransformation(TargetSelector selector, String targetClass, boolean setFinalTo) {
        super(selector, targetClass);
        this.finalValue = setFinalTo;
    }

    @Override
    public void transformField(FieldNode node) {
        int access = this.setFinality(node.access, this.finalValue);
        if (access != node.access) {
            System.out.println("FIELD: Change final: " + node.name + " -> " + this.finalValue);
            node.access = access;
        }
    }

    @Override
    public void transformMethod(MethodNode node) {
        int access = this.setFinality(node.access, this.finalValue);
        if (access != node.access) {
            System.out.println("METHOD: Change final: " + node.name + node.signature + " -> " + this.finalValue);
            node.access = access;
        }
    }

    protected final int setFinality(int currAccess, boolean finalValue) {
        currAccess = finalValue ? (currAccess |= 0x10) : (currAccess &= 0xFFFFFFEF);
        return currAccess;
    }
}

