/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.util.transformers.transformations;

import com.blazeloader.util.transformers.transformations.TargetSelector;
import com.blazeloader.util.transformers.transformations.Transformation;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class FieldSelector
implements TargetSelector {
    private Transformation transformation;
    private final String fieldName;
    private final boolean global;

    public FieldSelector(String name) {
        this.global = "*".equals(name);
        this.fieldName = name;
    }

    @Override
    public TargetSelector initWith(Transformation transformation) {
        this.transformation = transformation;
        return this;
    }

    @Override
    public boolean match(ClassNode cls) {
        boolean didApply = false;
        for (FieldNode field : cls.fields) {
            if (!this.global && !field.name.equals(this.fieldName)) continue;
            this.transformation.transformField(field);
            didApply = true;
        }
        return didApply;
    }
}

