/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.util.time;

import com.blazeloader.util.time.Day;
import com.blazeloader.util.time.IClock;
import com.blazeloader.util.time.IPreciseTime;
import com.blazeloader.util.time.Month;
import java.util.GregorianCalendar;

public class Clock
implements IPreciseTime,
IClock {
    private GregorianCalendar calendar = (GregorianCalendar)GregorianCalendar.getInstance();

    protected int get(int v) {
        long milli = System.currentTimeMillis();
        if (milli != this.calendar.getTimeInMillis()) {
            this.calendar.setTimeInMillis(milli);
        }
        return this.calendar.get(v);
    }

    @Override
    public String getDate() {
        return String.valueOf(this.padded(this.getDay())) + "-" + this.padded(this.calendar.get(2) + 1) + "-" + this.padded(this.calendar.get(1));
    }

    @Override
    public String getTime() {
        return String.valueOf(this.padded(this.getHours())) + ":" + this.padded(this.calendar.get(12)) + ":" + this.padded(this.calendar.get(13));
    }

    protected String padded(int v) {
        return v < 10 ? "0" + v : String.valueOf(v);
    }

    @Override
    public String getTimePrecise() {
        return String.valueOf(this.getTime()) + ":" + this.padded(this.calendar.get(14));
    }

    @Override
    public int getWeeks() {
        return this.get(3);
    }

    @Override
    public int getDays() {
        return this.get(6);
    }

    @Override
    public int getMonths() {
        return this.get(2) % 12;
    }

    @Override
    public int getYears() {
        return this.get(1);
    }

    @Override
    public int getDay() {
        return this.get(5);
    }

    @Override
    public Day getDayOfWeek() {
        return Day.values()[(this.get(7) + 5) % 7];
    }

    @Override
    public Month getMonth() {
        return Month.values()[this.getMonths()];
    }

    @Override
    public boolean isLeap() {
        return this.calendar.isLeapYear(this.getYears());
    }

    @Override
    public String getEra() {
        return this.get(0) == 1 ? "AD" : "BC";
    }

    @Override
    public int getHours() {
        return this.get(11);
    }

    @Override
    public int getMinutes() {
        return this.get(12);
    }

    @Override
    public int getSeconds() {
        return this.get(13);
    }

    @Override
    public int getMilliseconds() {
        return this.get(14);
    }

    @Override
    public long getTotalMilliseconds() {
        return this.calendar.getTimeInMillis();
    }

    public String toString() {
        return String.valueOf(this.getDate()) + " " + this.getTimePrecise();
    }
}

