/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.jarjar.tree;

import com.blazeloader.jarjar.tree.ClassTree;
import com.blazeloader.jarjar.tree.Tree;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.acomputerdog.core.java.Patterns;

public class ClassTreeMatcher
implements Tree<ClassTreeMatcher, String> {
    private ClassTreeMatcher root;
    private ClassTreeMatcher parent;
    private ClassTree from;
    private ClassTree to;
    private double similarity;
    private List<ClassTreeMatcher> children = new ArrayList<ClassTreeMatcher>();
    private List<String> unmatchedClasses;
    private List<String> unassignedClasses;

    public static ClassTreeMatcher loadFromJson(ClassTree from, ClassTree to, String json) {
        JsonParser parser = new JsonParser();
        return new ClassTreeMatcher(from, to, parser.parse(json));
    }

    public ClassTreeMatcher(ClassTree one, ClassTree two) {
        this(100.0, one, two);
        this.root = this;
        this.initialise(null);
    }

    private ClassTreeMatcher(double sim, ClassTree one, ClassTree two) {
        this.similarity = sim;
        this.from = one;
        this.to = two;
    }

    private ClassTreeMatcher(ClassTree one, ClassTree two, JsonElement json) {
        this(100.0, one, two);
        int i;
        JsonArray arr;
        this.root = this;
        this.unassignedClasses = new ArrayList<String>();
        this.unmatchedClasses = new ArrayList<String>();
        this.loadChildrenFromJson(json);
        JsonObject object = json.getAsJsonObject();
        if (object.has("unassigned")) {
            arr = object.get("unassigned").getAsJsonArray();
            i = 0;
            while (i < arr.size()) {
                this.unassignedClasses.add(arr.get(i).getAsString());
                ++i;
            }
        }
        if (object.has("unmatched")) {
            arr = object.get("unmatched").getAsJsonArray();
            i = 0;
            while (i < arr.size()) {
                this.unmatchedClasses.add(arr.get(i).getAsString());
                ++i;
            }
        }
    }

    private ClassTreeMatcher(ClassTreeMatcher root, JsonObject json) {
        this.root = root;
        if (json.has("from")) {
            this.from = this.root().from.lookup(json.get("from").getAsString());
        }
        if (json.has("to")) {
            this.to = this.root().to.lookup(json.get("to").getAsString());
        }
        this.loadChildrenFromJson(json);
    }

    private void loadChildrenFromJson(JsonElement json) {
        JsonObject object = json.getAsJsonObject();
        if (object.has("similarity")) {
            this.similarity = object.get("similarity").getAsDouble();
        }
        if (object.has("children")) {
            JsonArray arr = object.get("children").getAsJsonArray();
            int i = 0;
            while (i < arr.size()) {
                this.addChild(new ClassTreeMatcher(this.root(), arr.get(i).getAsJsonObject()));
                ++i;
            }
        }
    }

    private ClassTreeMatcher initialise(ClassTreeMatcher root) {
        ArrayList<String> taken = new ArrayList<String>();
        taken.add(this.to.getName());
        ArrayList<String> matched = new ArrayList<String>();
        matched.add(this.from.getName());
        this.matchChilds(matched, taken);
        this.matchInnerClasses(matched, taken);
        int lostClasses = this.from.size() - matched.size();
        int available = this.to.size() - taken.size();
        if (lostClasses != 0) {
            System.err.println(String.valueOf(lostClasses) + " classes not identified.");
            System.err.println(String.valueOf(available) + " unmapped classes available.");
            this.matchLostClasses(matched, taken);
            this.matchLostInnerClasses(matched, taken);
            System.err.println(String.valueOf(this.from.size() - matched.size()) + " classes not identified. (after retry)");
            System.err.println(String.valueOf(this.to.size() - taken.size()) + " unmapped classes available. (after retry)");
        }
        if (root != null) {
            this.root = root;
        }
        this.root().recordUnmatchedClasses(this, matched, taken);
        return this;
    }

    public String writeToJson() {
        ClassTree node;
        JsonArray items;
        JsonObject element = this.writeChildsToJson(this.writeJson(new JsonObject()));
        if (this.unmatchedClasses != null && this.unmatchedClasses.size() > 0) {
            items = new JsonArray();
            for (String i : this.unmatchedClasses) {
                node = this.from.lookup(i);
                if (node == null) continue;
                items.add(new JsonPrimitive(i));
            }
            element.add("unmatched", items);
        }
        if (this.unassignedClasses != null && this.unassignedClasses.size() > 0) {
            items = new JsonArray();
            for (String i : this.unassignedClasses) {
                node = this.to.lookup(i);
                if (node == null) continue;
                items.add(new JsonPrimitive(i));
            }
            element.add("unassigned", items);
        }
        return element.toString();
    }

    protected JsonObject writeJson(JsonObject element) {
        element.add("similarity", new JsonPrimitive(this.similarity));
        element.add("from", new JsonPrimitive(this.from.getName()));
        element.add("to", new JsonPrimitive(this.to.getName()));
        return element;
    }

    protected JsonObject writeChildsToJson(JsonObject element) {
        if (this.children.size() == 0) {
            return element;
        }
        JsonArray items = new JsonArray();
        for (ClassTreeMatcher i : this.children) {
            items.add(i.writeChildsToJson(i.writeJson(new JsonObject())));
        }
        element.add("children", items);
        return element;
    }

    private void recordUnmatchedClasses(ClassTreeMatcher sender, List<String> matched, List<String> taken) {
        if (this.unmatchedClasses == null) {
            this.unmatchedClasses = new ArrayList<String>();
        }
        if (this.unassignedClasses == null) {
            this.unassignedClasses = new ArrayList<String>();
        }
        List<String> froms = sender.from.keySet();
        froms.removeAll(matched);
        this.unmatchedClasses.removeAll(matched);
        for (String i : froms) {
            if (this.unmatchedClasses.contains(i)) continue;
            this.unmatchedClasses.add(i);
        }
        List<String> tos = sender.to.keySet();
        tos.removeAll(taken);
        this.unassignedClasses.removeAll(taken);
        for (String i : tos) {
            if (this.unassignedClasses.contains(i)) continue;
            this.unassignedClasses.add(i);
        }
    }

    private void matchLostClasses(List<String> matched, List<String> taken) {
        ArrayList<ClassTreeMatcher> lostChilds = new ArrayList<ClassTreeMatcher>();
        List<String> froms = this.from.keySet();
        froms.removeAll(matched);
        List<String> tos = this.to.keySet();
        tos.removeAll(taken);
        Iterator<String> iter = froms.iterator();
        while (froms.size() > 0) {
            int removals = 0;
            while (iter.hasNext()) {
                ClassTreeMatcher parent;
                String i = iter.next();
                ClassTree f = this.from.lookup(i);
                if (f.isInner() || (parent = this.root().lookup(f.parent().getName())) == null) continue;
                ClassTree lastTree = null;
                double lastSim = -1.0;
                for (String j : tos) {
                    double sim;
                    ClassTree t = this.to.lookup(j);
                    if (parent.after() != t.parent() || t.isInner() || !((sim = f.similarity(t)) >= lastSim)) continue;
                    lastSim = sim;
                    lastTree = t;
                }
                if (lastTree == null) continue;
                iter.remove();
                tos.remove(lastTree.getName());
                taken.add(lastTree.getName());
                matched.add(i);
                ++removals;
                lostChilds.add(parent.addChild(new ClassTreeMatcher(lastSim, f, lastTree)));
            }
            if (removals == 0) break;
        }
    }

    private void matchLostInnerClasses(List<String> matched, List<String> taken) {
        ArrayList<ClassTreeMatcher> lostChilds = new ArrayList<ClassTreeMatcher>();
        List<String> froms = this.from.keySet();
        froms.removeAll(matched);
        List<String> tos = this.to.keySet();
        tos.removeAll(taken);
        Iterator<String> iter = froms.iterator();
        while (froms.size() > 0) {
            int removals = 0;
            while (iter.hasNext()) {
                ClassTreeMatcher parent;
                String i = iter.next();
                ClassTree f = this.from.lookup(i);
                if (!f.isInner() || (parent = this.root().lookup(f.parent().getName())) == null) continue;
                ClassTree lastTree = null;
                double lastSim = -1.0;
                for (String j : tos) {
                    double sim;
                    ClassTree t = this.to.lookup(j);
                    if (parent.after() != t.parent() || !t.isInner() || !((sim = f.similarity(t)) >= lastSim)) continue;
                    lastSim = sim;
                    lastTree = t;
                }
                if (lastTree == null) continue;
                iter.remove();
                tos.remove(lastTree.getName());
                taken.add(lastTree.getName());
                matched.add(i);
                ++removals;
                lostChilds.add(parent.addChild(new ClassTreeMatcher(lastSim, f, lastTree)));
            }
            if (removals == 0) break;
        }
    }

    private void matchChilds(List<String> matched, List<String> taken) {
        ArrayList<ClassTree> froms = new ArrayList<ClassTree>();
        froms.addAll(this.from.children());
        List<ClassTree> tos = this.to.children();
        Iterator iter = froms.iterator();
        while (froms.size() > 0) {
            int removals = 0;
            while (iter.hasNext()) {
                ClassTree other;
                ClassTree i = (ClassTree)iter.next();
                if (i.isInner() || matched.contains(i.getName())) continue;
                if (i.getName().indexOf(47) != -1 && (other = this.to.lookup(i.getName())) != null) {
                    matched.add(i.getName());
                    taken.add(other.getName());
                    this.addChild(new ClassTreeMatcher(100.0, i, other));
                    iter.remove();
                    ++removals;
                    continue;
                }
                ClassTree lastTree = null;
                double lastSim = -1.0;
                for (ClassTree j : tos) {
                    double sim = i.similarity(j);
                    if (!(sim > lastSim) || j.getName().indexOf(47) != -1) continue;
                    lastTree = j;
                    lastSim = sim;
                }
                if (lastTree == null) continue;
                ++removals;
                if (taken.contains(lastTree.getName())) {
                    ClassTreeMatcher old = this.root().reverseLookup(lastTree.getName());
                    if (!(lastSim > old.similarity)) continue;
                    matched.remove(old.from.getName());
                    matched.add(lastTree.getName());
                    froms.add(old.from);
                    old.from = i;
                    froms.remove(i);
                    iter = froms.iterator();
                    continue;
                }
                matched.add(i.getName());
                taken.add(lastTree.getName());
                iter.remove();
                this.addChild(new ClassTreeMatcher(lastSim, i, lastTree));
            }
            if (removals == 0) break;
        }
        for (ClassTreeMatcher i : this.children) {
            i.matchChilds(matched, taken);
        }
    }

    private void matchInnerClasses(List<String> matched, List<String> taken) {
        ArrayList<ClassTree> froms = new ArrayList<ClassTree>();
        froms.addAll(this.from.inner());
        List<ClassTree> tos = this.to.inner();
        Iterator iter = froms.iterator();
        while (froms.size() > 0) {
            int removals = 0;
            while (iter.hasNext()) {
                ClassTree i = (ClassTree)iter.next();
                if (!i.isInner() || matched.contains(i.getName())) continue;
                ClassTree lastTree = null;
                double lastSim = -1.0;
                for (ClassTree j : tos) {
                    double sim = i.similarity(j);
                    if (!(sim > lastSim) || j.getName().indexOf(47) != -1) continue;
                    lastTree = j;
                    lastSim = sim;
                }
                if (lastTree == null) continue;
                ++removals;
                if (taken.contains(lastTree.getName())) {
                    ClassTreeMatcher old = this.root().reverseLookup(lastTree.getName());
                    if (!(lastSim > old.similarity)) continue;
                    matched.remove(old.from.getName());
                    matched.add(lastTree.getName());
                    froms.add(old.from);
                    old.from = i;
                    froms.remove(i);
                    iter = froms.iterator();
                    continue;
                }
                matched.add(i.getName());
                taken.add(lastTree.getName());
                iter.remove();
                this.addChild(new ClassTreeMatcher(lastSim, i, lastTree));
            }
            if (removals == 0) break;
        }
        for (ClassTreeMatcher i : this.children) {
            i.matchInnerClasses(matched, taken);
        }
    }

    public ClassTreeMatcher define(ClassTree from, ClassTree to) {
        return this.define(from, to, true);
    }

    private ClassTreeMatcher define(ClassTree from, ClassTree to, boolean initialise) {
        ClassTreeMatcher parent = this.root().lookup(from.parent().getName());
        if (parent == null) {
            return this.define(from.parent(), to.parent(), false);
        }
        ClassTreeMatcher fromMatcher = this.root().lookup(from.getName());
        ClassTreeMatcher toMatcher = this.root().reverseLookup(to.getName());
        if (fromMatcher != null && toMatcher == null) {
            fromMatcher.to = to;
            fromMatcher.similarity = fromMatcher.from.similarity(to);
            return fromMatcher.parent();
        }
        if (toMatcher != null && fromMatcher == null) {
            toMatcher.from = from;
            toMatcher.similarity = from.similarity(toMatcher.to);
            return toMatcher.parent();
        }
        if (fromMatcher != null && toMatcher != null) {
            boolean parentOne = false;
            boolean parentTwo = false;
            parentOne = fromMatcher.parent().equals(parent);
            parentTwo = toMatcher.parent().equals(parent);
            if (parentOne && parentTwo) {
                fromMatcher.swap(toMatcher);
                return parent;
            }
            throw new IllegalStateException("Can only define a relationship between classes with the same parent");
        }
        ClassTreeMatcher child = parent.addChild(new ClassTreeMatcher(from.similarity(to), from, to));
        if (initialise) {
            child.initialise(parent.root());
        }
        this.getUnmatched().remove(from.getName());
        this.getUnassigned().remove(to.getName());
        return parent;
    }

    @Override
    public ClassTreeMatcher addChild(ClassTreeMatcher child) {
        this.children.add(child);
        if (child.parent != null) {
            child.parent.children.remove(child);
        }
        child.parent = this;
        child.root = this.root();
        return child;
    }

    @Override
    public ClassTreeMatcher sort() {
        Collections.sort(this.children);
        for (ClassTreeMatcher i : this.children) {
            i.sort();
        }
        return this;
    }

    public List<String> getUnmatched() {
        return this.unmatchedClasses == null && this.root() != this ? this.root().getUnmatched() : this.unmatchedClasses;
    }

    public List<String> getUnassigned() {
        return this.unassignedClasses == null && this.root() != this ? this.root().getUnmatched() : this.unassignedClasses;
    }

    public ClassTree after() {
        return this.to;
    }

    public ClassTree before() {
        return this.from;
    }

    public boolean nameChanged() {
        return !this.from.getName().equals(this.to.getName());
    }

    @Override
    public List<ClassTreeMatcher> children() {
        return this.children;
    }

    @Override
    public ClassTreeMatcher parent() {
        return this.parent != null ? this.parent : this.root();
    }

    @Override
    public ClassTreeMatcher root() {
        return this.root;
    }

    @Override
    public ClassTreeMatcher lookup(String className) {
        if (this.from.getName().equals(className)) {
            return this;
        }
        ClassTreeMatcher result = null;
        for (ClassTreeMatcher i : this.children) {
            result = i.lookup(className);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public ClassTreeMatcher reverseLookup(String className) {
        if (this.to.getName().equals(className)) {
            return this;
        }
        ClassTreeMatcher result = null;
        for (ClassTreeMatcher i : this.children) {
            result = i.reverseLookup(className);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    @Override
    public int size() {
        int size = 1;
        for (ClassTreeMatcher i : this.children) {
            size += i.size();
        }
        return size;
    }

    public void swap(ClassTreeMatcher other) {
        ClassTree inter = this.to;
        this.to = other.to;
        other.to = inter;
        this.similarity = this.from.similarity(this.to);
        other.similarity = other.from.similarity(other.to);
    }

    public double similarity() {
        double sim = this.similarity;
        for (ClassTreeMatcher i : this.children) {
            sim += i.similarity();
        }
        return sim;
    }

    public double averageSimilarity() {
        return this.similarity() / (double)this.size();
    }

    @Override
    public int compareTo(ClassTreeMatcher o) {
        return Double.compare(o.similarity, this.similarity);
    }

    public String toString() {
        return this.toString("");
    }

    public String bitMask() {
        String result = "";
        result = String.valueOf(result) + Math.floor(this.similarity * 100.0) / 100.0 + "% ";
        boolean f = this.from.fields() == this.to.fields();
        boolean m = this.from.methods() == this.to.methods();
        boolean i = this.from.interfaces() == this.to.interfaces();
        result = String.valueOf(result) + (f && m && i ? "1" : "0");
        boolean c = this.from.children().size() == this.to.children().size();
        boolean o = this.from.isInner() == this.to.isInner();
        result = String.valueOf(result) + (c && o ? "1" : "0");
        result = String.valueOf(result) + " ";
        boolean a = this.from.isAnonymous() == this.to.isAnonymous();
        boolean an = this.from.isAbstract() == this.to.isAbstract();
        result = String.valueOf(result) + (a && an ? "1" : "0");
        result = String.valueOf(result) + (this.nameChanged() ? "0" : "1");
        return String.valueOf(result) + " ";
    }

    @Override
    public String description() {
        String result = String.valueOf(this.from.getName()) + " -> " + this.to.getName();
        return String.valueOf(result) + " { fields: " + this.from.fields() + " -> " + this.to.fields() + "; methods: " + this.from.methods() + " -> " + this.to.methods() + "; interfaces: " + this.from.interfaces() + " -> " + this.to.interfaces() + " }";
    }

    private String toString(String indent) {
        String result = "";
        result = String.valueOf(result) + this.bitMask();
        result = String.valueOf(result) + indent + this.description();
        result = String.valueOf(result) + Patterns.LINE_SEPARATOR;
        indent = String.valueOf(indent) + "\t";
        for (ClassTreeMatcher i : this.children) {
            result = String.valueOf(result) + i.toString(indent);
        }
        return result;
    }

    @Override
    public List<String> keySet() {
        ArrayList<String> result = new ArrayList<String>();
        this.buildKeySet(result);
        return result;
    }

    private void buildKeySet(List<String> keyset) {
        keyset.add(this.from.getName());
        for (ClassTreeMatcher i : this.children) {
            i.buildKeySet(keyset);
        }
    }
}

