/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.jarjar.tree;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;

public class ClassMap
extends HashMap<String, ClassNode> {
    private final int directives;

    public ClassMap() {
        this(1);
    }

    public ClassMap(int directive) {
        this.directives = directive;
    }

    public void readFromJar(File jarFile) throws IOException {
        this.clear();
        try (ZipFile jar = null;){
            try {
                jar = new JarFile(jarFile, false);
                Enumeration<JarEntry> entries = ((JarFile)jar).entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".class")) continue;
                    name = name.split("\\.")[0];
                    ClassReader reader = new ClassReader(((JarFile)jar).getInputStream(entry));
                    ClassNode classNode = new ClassNode();
                    reader.accept(classNode, this.directives);
                    this.put(name, classNode);
                }
                System.out.println(String.valueOf(this.size()) + " classes successfully loaded from jar");
            }
            catch (IOException e) {
                e.printStackTrace();
                if (jar != null) {
                    jar.close();
                }
            }
        }
    }

    public Map.Entry<String, ClassNode> getEntry(String key) {
        for (Map.Entry<String, ClassNode> entry : this.entrySet()) {
            if (!((String)entry.getKey()).equals(key)) continue;
            return entry;
        }
        return null;
    }
}

