/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.jarjar.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;

public abstract class CommandReader
implements Runnable {
    private static final String spliterator = " (?=([^\"]*\"[^\"]*\")*[^\"]*$)";
    protected final InputStream in;
    protected final PrintStream out;
    private BufferedReader reader;

    public CommandReader(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.out.println("Command Reader Console 1.0");
        this.out.println("Type \"help\" to see a list of available commands.");
        this.reader = new BufferedReader(new InputStreamReader(this.in));
        String input = null;
        try {
            block4: while (true) {
                if ("exit".equals(input = this.reader.readLine())) {
                    return;
                }
                if (input == null || input.trim().isEmpty()) continue;
                String[] split = input.split(spliterator, -1);
                int i = 0;
                while (true) {
                    if (i >= split.length) {
                        if (split.length <= 0) continue block4;
                        if (!split[0].toLowerCase().equals("help")) break;
                        this.printHelp();
                        continue block4;
                    }
                    if (split[i].startsWith("\"")) {
                        split[i] = split[i].substring(1);
                    }
                    if (split[i].endsWith("\"")) {
                        split[i] = split[i].substring(0, split[i].length() - 1);
                    }
                    ++i;
                }
                try {
                    String output = this.handleCommand(split);
                    if (output == null || output.isEmpty()) continue;
                    this.out.println(output);
                }
                catch (Throwable e) {
                    this.out.print("Unknown error: ");
                    e.printStackTrace(this.out);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String fillSystemVariables(String line) {
        if (line.indexOf(37) == -1 && line.indexOf(36) == -1) {
            return line;
        }
        Set<Map.Entry<String, String>> keys = System.getenv().entrySet();
        if (line.indexOf(37) != -1) {
            for (Map.Entry<String, String> e : keys) {
                line = line.replaceAll("(?i)%" + e.getKey() + "%", e.getValue().replace('\\', '/'));
            }
        }
        if (line.indexOf(36) != -1) {
            String[] components = line.split("\\$");
            for (Map.Entry<String, String> e : keys) {
                String s = e.getKey().toLowerCase();
                String v = e.getValue().replace('\\', '/');
                int i = 0;
                while (i < components.length) {
                    if (components[i].toLowerCase().startsWith(s)) {
                        components[i] = components[i].replaceFirst(s, v);
                    }
                    ++i;
                }
            }
            StringBuilder builder = new StringBuilder();
            String[] stringArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                String i = stringArray[n2];
                builder.append(i);
                ++n2;
            }
            line = builder.toString();
        }
        return line;
    }

    protected String readLine() throws IOException {
        return this.reader.readLine();
    }

    public abstract String handleCommand(String ... var1) throws Throwable;

    public abstract void printHelp();
}

