/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.jarjar;

import com.blazeloader.jarjar.console.CommandReader;
import com.blazeloader.jarjar.console.Options;
import com.blazeloader.jarjar.convert.ClassRemapper;
import com.blazeloader.jarjar.convert.SeargToEnigmaConverter;
import com.blazeloader.jarjar.tree.ClassTree;
import com.blazeloader.jarjar.tree.ClassTreeMatcher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import net.acomputerdog.OBFUtil.map.TargetType;
import net.acomputerdog.OBFUtil.parse.types.SRGFileParser;
import net.acomputerdog.OBFUtil.table.DirectOBFTable;
import net.acomputerdog.OBFUtil.table.OBFTable;

public class RemapperConsole
extends CommandReader {
    private ClassTreeMatcher matcher;
    private final ClassRemapper remapper;
    private final File srg;
    private DirectOBFTable srgtable;
    private SRGFileParser parser;

    public RemapperConsole(ClassRemapper remapper, File srg) {
        this(remapper, srg, null);
    }

    public RemapperConsole(ClassRemapper remapper, File srg, String json) {
        super(System.in, System.out);
        this.remapper = remapper;
        this.srg = srg;
        if (json != null) {
            this.matcher = remapper.loadMatcherFromJson(json);
            if (this.matcher == null) {
                System.out.println("Error: Could not load matcher.");
            }
        } else {
            this.matcher = remapper.loadMatcher();
        }
    }

    @Override
    public String handleCommand(String ... args) throws Throwable {
        switch (args[0].toLowerCase()) {
            case "lookup": {
                boolean full;
                if (args.length < 2) {
                    return "Error: Too few arguments";
                }
                ClassTreeMatcher found = this.matcher.lookup(args[1]);
                boolean bl = full = args.length > 2 && "full".equalsIgnoreCase(args[2]);
                if (found != null) {
                    if (full) {
                        return found.toString();
                    }
                    return String.valueOf(found.bitMask()) + " " + found.description();
                }
                ClassTree unmapped = this.matcher.before().lookup(args[1]);
                if (unmapped != null) {
                    this.out.print("{null} <- ");
                    if (full) {
                        return unmapped.toString();
                    }
                    return unmapped.description();
                }
                return "Entry not found";
            }
            case "lookup-reverse": {
                boolean full;
                if (args.length < 2) {
                    return "Error: Too few arguments";
                }
                ClassTreeMatcher found = this.matcher.reverseLookup(args[1]);
                boolean bl = full = args.length > 2 && "full".equalsIgnoreCase(args[2]);
                if (found != null) {
                    if (full) {
                        return found.toString();
                    }
                    return String.valueOf(found.bitMask()) + " " + found.description();
                }
                ClassTree unmapped = this.matcher.after().lookup(args[1]);
                if (unmapped != null) {
                    this.out.print("{null} -> ");
                    if (full) {
                        return unmapped.toString();
                    }
                    return unmapped.description();
                }
                return "Entry not found";
            }
            case "lookup-parent": {
                ClassTreeMatcher result;
                if (args.length < 2) {
                    return "Error: Too few arguments";
                }
                boolean reverse = args.length == 3 && "reverse".equalsIgnoreCase(args[2]);
                ClassTree tree = reverse ? this.matcher.after() : this.matcher.before();
                ClassTreeMatcher classTreeMatcher = result = reverse ? this.matcher.reverseLookup(args[1]) : this.matcher.lookup(args[1]);
                if (result != null) {
                    return result.parent().description();
                }
                if ((tree = tree.lookup(args[1])) != null) {
                    tree = tree.parent();
                    ClassTreeMatcher classTreeMatcher2 = result = reverse ? this.matcher.reverseLookup(tree.getName()) : this.matcher.lookup(tree.getName());
                    if (result != null) {
                        return result.description();
                    }
                    this.out.print(reverse ? "{null} <- " : "{null} -> ");
                    return tree.description();
                }
                return "Entry not found.";
            }
            case "lookup-obf": {
                String result;
                ClassTreeMatcher match;
                if (args.length < 2) {
                    return "Error: Too few arguments";
                }
                OBFTable table = this.loadSrg();
                if (!table.hasDeobf(args[1], TargetType.CLASS)) {
                    args[1] = args[1].replace('/', '.');
                }
                if (table.hasDeobf(args[1], TargetType.CLASS) && (match = this.matcher.lookup(result = table.obf(args[1], TargetType.CLASS))) != null) {
                    return String.valueOf(match.bitMask()) + " " + match.description();
                }
                return "Entry not found.";
            }
            case "lookup-mcp": {
                OBFTable table;
                ClassTreeMatcher found;
                if (args.length < 2) {
                    return "Error: Too few arguments";
                }
                boolean reverse = args.length == 3 && "reverse".equalsIgnoreCase(args[2]);
                ClassTreeMatcher classTreeMatcher = found = reverse ? this.matcher.reverseLookup(args[1]) : this.matcher.lookup(args[1]);
                if (found != null && (table = this.loadSrg()).hasObf(found.before().getName(), TargetType.CLASS)) {
                    return table.deobf(found.before().getName(), TargetType.CLASS);
                }
                return "Entry not found";
            }
            case "define": {
                if (args.length < 3) {
                    return "Error: Too few arguments";
                }
                ClassTree from = this.matcher.before().lookup(args[1]);
                ClassTree to = this.matcher.after().lookup(args[2]);
                if (from == null) {
                    return "Error: From class not found.";
                }
                if (to == null) {
                    return "Error: To class not found.";
                }
                this.matcher.define(from, to);
                ClassTreeMatcher result = this.matcher.lookup(from.getName());
                return String.valueOf(result.bitMask()) + " " + result.description();
            }
            case "swap": {
                if (args.length < 3) {
                    return "Error: Too few arguments";
                }
                ClassTreeMatcher old = this.matcher.lookup(args[1]);
                ClassTreeMatcher neu = this.matcher.lookup(args[2]);
                if (old == null) {
                    return "Error: class not found: " + args[1];
                }
                if (neu == null) {
                    return "Error: class not found: " + args[2];
                }
                old.swap(neu);
                this.out.println(String.valueOf(old.bitMask()) + " " + old.description());
                return String.valueOf(neu.bitMask()) + " " + neu.description();
            }
            case "save-mcp": {
                if (args.length < 2) {
                    return "Error: Too few arguments.";
                }
                args[1] = this.fillSystemVariables(args[1]);
                File output = new File(args[1]);
                OBFTable table = this.remapper.remapTree(this.loadSrg());
                this.parser.storeEntries(output, table);
                this.out.println("Conversion complete.");
                return "MCP mappings saved to " + args[1];
            }
            case "save-enigma": {
                if (args.length < 2) {
                    return "Error: Too few arguments.";
                }
                args[1] = this.fillSystemVariables(args[1]);
                File output = new File(args[1]);
                OBFTable table = this.remapper.remapTree(this.loadSrg());
                SeargToEnigmaConverter converter = new SeargToEnigmaConverter(this.remapper.destination(), table);
                converter.storeEntries(output);
                return "Enigma mappings saved to " + args[1];
            }
            case "save-tree": {
                if (args.length < 2) {
                    return "Error: Too few arguments.";
                }
                args[1] = this.fillSystemVariables(args[1]);
                File output = new File(args[1]);
                BufferedWriter w = new BufferedWriter(new FileWriter(output));
                w.write(this.matcher.toString());
                ((Writer)w).close();
                return "Tree text saved to " + args[1];
            }
            case "save-json": {
                if (args.length < 2) {
                    return "Error: Too few arguments.";
                }
                args[1] = this.fillSystemVariables(args[1]);
                File output = new File(args[1]);
                BufferedWriter w = new BufferedWriter(new FileWriter(output));
                w.write(this.matcher.writeToJson());
                ((Writer)w).close();
                return "Tree json saved to " + args[1];
            }
            case "load-json": {
                if (args.length < 2) {
                    return "Error: Too few arguments.";
                }
                args[1] = this.fillSystemVariables(args[1]);
                this.matcher = this.remapper.loadMatcherFromJson(args[1]);
                if (this.matcher == null) {
                    return "Error: Could not load matcher.";
                }
                return "Table loaded.";
            }
            case "list": {
                if (args.length < 2) {
                    return "Error: Too few arguments.";
                }
                int count = 0;
                switch (args[1].toLowerCase()) {
                    case "unmatched": {
                        this.out.println("Unmatched source classes:");
                        for (String i : this.matcher.getUnmatched()) {
                            ClassTree item = this.matcher.before().lookup(i);
                            this.out.println(String.valueOf(++count) + ". Parent: " + item.parent().description());
                            this.out.println(item.toString());
                        }
                        break;
                    }
                    case "unassigned": {
                        this.out.println("Unassigned destination classes:");
                        for (String i : this.matcher.getUnassigned()) {
                            ClassTree item = this.matcher.after().lookup(i);
                            this.out.println(String.valueOf(++count) + ". Parent: " + item.parent().description());
                            this.out.println(item.toString());
                        }
                        break;
                    }
                }
                return null;
            }
            case "grep": {
                String line;
                boolean reverse = args.length == 2 && "reverse".equalsIgnoreCase(args[1]);
                Options ops = new Options();
                while ((line = this.readLine()) != null && !"\\".equals(line)) {
                    ops.readOption(line);
                }
                if (ops.size() == 0) {
                    this.out.println("Error: No conditions given!");
                    this.out.println("Specify conditions one per line as: {property}={value}");
                    return "Terminate with \"\\\"";
                }
                ClassTree tree = reverse ? this.matcher.after() : this.matcher.before();
                int matches = 0;
                for (String i : tree.keySet()) {
                    ClassTreeMatcher looked;
                    ClassTree node = tree.lookup(i);
                    if (ops.containsKey("fields") && ops.getInt("fields") != node.fields() || ops.containsKey("methods") && ops.getInt("methods") != node.methods() || ops.containsKey("interfaces") && ops.getInt("interfaces") != node.interfaces() || ops.containsKey("isInner") && ops.getBool("IsInner") != node.isInner() || ops.containsKey("isInterface") && ops.getBool("IsInterface") != node.isInner() || ops.containsKey("parent") && !((String)ops.get("parent")).equals(node.parent().getName())) continue;
                    ClassTreeMatcher classTreeMatcher = looked = reverse ? this.matcher.reverseLookup(i) : this.matcher.lookup(i);
                    if (ops.containsKey("unmatched") && (!ops.getBool("unmatched") ? looked == null : looked != null) || ops.containsKey("namechange") && (!ops.getBool("namechange") ? looked == null || !looked.before().getName().equals(looked.after().getName()) : looked != null && looked.before().getName().equals(looked.after().getName()))) continue;
                    if (looked == null) {
                        this.out.print(reverse ? "{null} -> " : "{null} <- ");
                        this.out.println(node.description());
                    } else {
                        if (ops.containsKey("samefields") && ops.getBool("samefields") != (looked.before().fields() == looked.after().fields()) || ops.containsKey("samemethods") && ops.getBool("samemethods") != (looked.before().methods() == looked.after().methods()) || ops.containsKey("sameinterfaces") && ops.getBool("sameinterfaces") != (looked.before().interfaces() == looked.after().interfaces())) continue;
                        this.out.println(looked.description());
                    }
                    ++matches;
                }
                return String.valueOf(matches) + " classes matched.";
            }
        }
        return "Command Not Found: " + args[0];
    }

    private OBFTable loadSrg() throws IOException {
        if (this.srgtable == null) {
            this.parser = new SRGFileParser("", false);
            this.srgtable = new DirectOBFTable();
            this.parser.loadEntries(this.srg, this.srgtable, true);
        }
        return this.srgtable;
    }

    @Override
    public void printHelp() {
        this.out.println("lookup [classname] {full}\t-\tRetrieves a single class mapping from a loaded tree.");
        this.out.println("lookup-reverse [classname] {full}\t-\tRetrieves the class that is mapped into the given one.");
        this.out.println("lookup-parent [classname] {reverse}\t-\tRetrieves the parent of the given class.");
        this.out.println("lookup-obf [mcp name]\t-\tFinds the obfuscated name for the given MCP name.");
        this.out.println("lookup-mcp [obf name]\t-\tFinds the MCP name for the given obfuscated name.");
        this.out.println("define [from] [to]\t-\tDefines a new mapping between two classes. (parents/children/interfaces are implicitly defined)");
        this.out.println("swap [one] [two]\t-\tSwaps the destinations of two classes.");
        this.out.println("save-mcp [file]\t-\tRemap and output mcp mappings for the current class map tree.");
        this.out.println("save-enigma [file]\t-\tCreates enigma mappings from the current tree that applies to the destination jar");
        this.out.println("save-tree [file]\t-\tOutput the entire class map tree to file.");
        this.out.println("save-json [file]\t-\tSaves the match tree to json. Useful if you want to edit it later.");
        this.out.println("load-json [file]\t-\tLoads a match tree from json.");
        this.out.println("list [unmatched|unassigned]\t-\tPrints a list of all classes not included in the matching tree.");
        this.out.println("grep {reverse}\t-\tFinds classes matching given conditions.");
        this.out.println("exit\t-\tExit");
    }
}

