# The script of the game goes in this file.

# Using init to tell renpy to run this code at the start of the game
init python:
    # Set image cache large enough so that it will be able to handle the overlay animations
    config.image_cache_size = 100
define config.developer = False
$ _skipping = False
define rollback_enabled = False
#Code that plays a clicking sound when passing a dialogue.
init python:

    def dismiss_callback():

        renpy.play("audio/sfx/click.wav")

        return True

    config.say_allow_dismiss = dismiss_callback
#Character Definitions. The suffix 'in' means the text will be blue.

define greentext = Character(what_color="66CC00")
define md = Character("Moondancer", color="000", who_xpos=-85, who_ypos=2)
define mdin = Character("Moondancer", color="000", who_xpos=-85, who_ypos=2, what_color="66CCFF")
define lh = Character("Lyra Heartstrings", color="000", who_xpos=-85, who_ypos=-3)
define silverstar = Character("Sheriff Silverstar", color="000", who_xpos=-83, who_ypos=-2)
define sunburst= Character("Sunburst", color="000", who_xpos=-83, who_ypos=3)
define lp= Character("Limestone Pie", color="000", who_xpos=-85, who_ypos=0)
define qp = Character("Quibble Pants", color="000", who_xpos=-83, who_ypos=0)
define sky = Character("Sky Stinger", color="000", who_xpos=-83, who_ypos=0)
define vt = Character("Vapor Trail", color="000", who_xpos=-83, who_ypos=0)
define bs = Character("Babs Seed", color="000", who_xpos=-83, who_ypos=3)
define zb = Character("Zephyr Breeze", color="000", who_xpos=-82, who_ypos=0)
define fp = Character("Fancy Pants", color="000", who_xpos=-85, who_ypos=0)
define sf = Character("Short Fuse", color="000", who_xpos=-83, who_ypos=3)
define tl = Character("Thunderlane", color="000", who_xpos=-83, who_ypos=1)
define sm = Character("Saffron Masala", color="000", who_xpos=-83, who_ypos=0)
define cp = Character("Coco Pommel", color="000", who_xpos=-83, who_ypos=0)
define sg = Character("Starlight Glimmer", color="000", who_xpos=-95, who_ypos=0)
define cozy = Character("Cozy Glow", color="000", who_xpos=-83, who_ypos=2)
define unknown = Character("???", color="000", who_xpos=-85, who_ypos=8)
define unknownin = Character("???", color="000", who_xpos=-85, who_ypos=8, what_color="66CCFF")

#Character Definitions during CGs

define greentextCG = Character(window_background=Frame("gui/cg_textbox.png", 25, 25), what_color="66CC00")
define mdCG = Character("Moondancer", window_background=Frame("gui/cg_textbox.png", 25, 25), who_color="FFF", who_xpos=-95, who_ypos=30)
define mdCGin = Character("Moondancer", window_background=Frame("gui/cg_textbox.png", 25, 25), color="FFF", who_xpos=-95, who_ypos=30, what_color="66CCFF")
define lhCG = Character("Lyra Heartstrings", window_background=Frame("gui/cg_textbox.png", 25, 25), color="FFF", who_xpos=-93, who_ypos=23)
define silverstarCG = Character("Sheriff Silverstar", window_background=Frame("gui/cg_textbox.png", 25, 25), color="FFF", who_xpos=-92, who_ypos=32)
define sunburstCG= Character("Sunburst", window_background=Frame("gui/cg_textbox.png", 25, 25), color="FFF", who_xpos=-92, who_ypos=32)
define qpCG = Character("Quibble Pants", window_background=Frame("gui/cg_textbox.png", 25, 25), who_color="FFF", who_xpos=-95, who_ypos=28)
define vtCG= Character("Vapor Trail", window_background=Frame("gui/cg_textbox.png", 25, 25), color="FFF", who_xpos=-95, who_ypos=30)
define bsCG= Character("Babs Seed", window_background=Frame("gui/cg_textbox.png", 25, 25), color="FFF", who_xpos=-95, who_ypos=30)
define unknownCG = Character("???", window_background=Frame("gui/cg_textbox.png", 25, 25), color="FFF", who_xpos=-95, who_ypos=35)
define unknownCGin = Character("???", window_background=Frame("gui/cg_textbox.png", 25, 25), color="FFF", who_xpos=-95, who_ypos=35, what_color="66CCFF")
define sgCG = Character("Starlight Glimmer", window_background=Frame("gui/cg_textbox.png", 25, 25), who_color="FFF", who_xpos=-91, who_ypos=25)
define cozyCG = Character("Cozy Glow", window_background=Frame("gui/cg_textbox.png", 25, 25), who_color="FFF", who_xpos=-93, who_ypos=30)

#Character Definitions for the Trial Segments
define trialmd = Character("Moondancer", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)
define triallh = Character("Lyra Heartstrings", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)
define trialsilverstar = Character("Sheriff Silverstar", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)
define trialsunburst = Character("Sunburst", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)
define triallp = Character("Limestone Pie", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)
define trialqp = Character("Quibble Pants", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)
define trialsky = Character("Sky Stinger", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)
define trialvt = Character("Vapor Trail", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)
define trialbs = Character("Babs Seed", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)
define trialzb = Character("Zephyr Breeze", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)
define trialfp = Character("Fancy Pants", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)
define trialsf = Character("Short Fuse", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)
define trialtl = Character("Thunderlane", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)
define trialsm = Character("Saffron Masala", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)
define trialcp = Character("Coco Pommel", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)
define trialcozy = Character("Cozy Glow", window_background=Frame("gui/trial_textbox.png", 25, 25, yminimum=323, yalign=1.0), who_color="FFF", who_xpos=-225, who_ypos=-20)


#Transitions used for the characters

transform charprotappear:
    fit "scale-down"
    xsize 750
    xpos 0.95 yalign 2.75
    easein 0.25 xpos 0.71

transform charprotdisappear:
    fit "scale-down"
    xsize 750
    xpos 0.71 yalign 2.75
    easeout 0.25 xpos 2.0

transform charappear:
    xalign 0.5
    yalign 0.25
    alpha 0.00
    easein 0.25 alpha 1.00

transform charfadein:
    alpha 0.00
    easein 0.25 alpha 1.00

transform chardisappear:
    alpha 1.00
    easein 0.25 alpha 0.00
    

transform charmovein:
    easein 0.25 xpos 0.40

transform charmoveout:
    easein 0.25 xpos 0.5

transform charrightmiddle_1:
    yalign 0.25
    xalign 0.5
    xpos 1.2
    linear 0.5 xpos 0.5

transform charmiddleright_1:
    xpos 0.5
    linear 0.5 xpos 1.2

transform charleftmiddle_1:
    yalign 0.25
    xpos -0.2
    linear 0.5 xpos 0.5

transform charmiddleleft_1:
    xpos 0.5
    linear 0.5 xpos -0.2

transform charrightmiddle_2:
    yalign 0.25
    xpos 1.2
    linear 0.55 xpos 0.40

transform charmiddleright_2:
    xpos 0.40
    linear 0.55 xpos 1.2

transform charleftmiddle_2:
    yalign 0.25
    xpos -0.2
    linear 0.5 xpos 0.40

transform charmiddleleft_2:
    xpos 0.40
    linear 0.5 xpos -0.2

transform trial_size: 
    zoom 0.9



#Transitions used for UI Elements
transform chapterboxappear:
    xpos 1923 ypos 108
    easein 0.5 xpos 1555

transform musicboxappear:
    xpos -420 ypos 73
    easein 0.5 xpos 0

transform chapterboxdisappear:
    xpos 1555 ypos 109
    easeout 0.5 xpos 1923

transform musicboxdisappear:
    xpos 0 ypos 73
    easeout 0.5 xpos -420

#Miscelanous Transitions

define dis = { "master" : Dissolve(0.1) }
define disalt = { "uielements" : Dissolve(0.1)}
define black = { "master" : Fade(0.5, 0.0, 0.5) }

# INFORMATION ABOUT SHOW
# Images are drawn in a stack- with images at the bottom being the ones that were shown first, and the ones
# towards the top the ones that were shown later
# Images that are towards the top of this stack are drawn in front of those towards the bottom

# When an image is initially shown, it is added to the top of this stack, drawn in front of everything
# When an image is shown again afterwards, it only REPLACES the image- it's order on the stack does not change
# When an image is hidden, then it is REMOVED from this stack, so when you show it again, it will be put to the
# front

# Using the events on show and on hide- so that the entire section can move
# when showing/hiding the specific screen
transform slide_inout(start_x_pos, start_y_pos, end_x_pos):
    on show:
        pos((start_x_pos, start_y_pos))
        easein 0.5 xpos end_x_pos
    on hide:
        pos((end_x_pos, start_y_pos))
        easein 0.5 xpos start_x_pos

transform slide(start_x_pos, start_y_pos, end_x_pos):
    pos((start_x_pos, start_y_pos))
    easein 0.5 xpos end_x_pos

transform rotate_360():
    rotate 0
    linear 2.5 rotate 360
    repeat

# The news ticker tape effect is officially called the scrolling marquee effect
# The way that this effect works is that we use a crop transform to only show a section
# of the text we want to appear in the section. Then, we drag this cropped section over the text going
# left to right, making it look like the text is moving across the section.

# Basically, instead of the text moving, it is the cropped section that is moving
# Start_pos = starting position of the crop movement. If you want a greater timing in-between
# the text being shown, this number should be a greater negative number
# End_pos = ending position of the crop movement. This number should be large enough so that the
# entire text should be off of the section.
# Duration = how long in seconds it should take for the text to fully go across the section
transform scrolling_marquee_musictext(start_x_pos, end_x_pos, duration):  
    on appear, show:
        crop (start_x_pos, 0, 320, 72)
        linear duration crop (end_x_pos, 0, 320, 72)
        crop (start_x_pos, 0, 320, 72)
        repeat
    on hide:
        linear 1 crop (1000, 0, 320, 72)

# Can either move individual elements of left gui or the entirety of it
# Using floats = represents percentage of the outer container image this transform is being applied to
# is a part of
# Using ints = represents pixels relative to the outer container
# Frames are used for breaking up screens

screen left_gui():
    frame:
        background None
        padding((0, 0))
        anchor((0, 0))
        xysize((400, 172))
        pos((0, 175))
        at guiInfo.musictext_frame_transform

        # Position = relative to the outer frame
        # Start with bars first so that it can be displayed behind
        # the scrolling text box
        add Movie(play="images/ui/mus_bars_sidemask.webm", start_image= "images/ui/bars_0001.png", side_mask=True):
            anchor((0, 0))
            pos((15, -29))

        add "images/ui/mus_building.png":
            anchor((0, 0))
            pos((48, 9))

        add "images/ui/mus_sun.png":
            anchor((0, 0))
            pos((230, -35))
            at rotate_360
            
        add "images/ui/mus_box.png":
            anchor((0, 0))
            pos((0, 123))

        frame:
            background None
            padding((0, 0))
            anchor((0, 0))
            xysize((320, 47))
            pos((0, 128))

            showif guiInfo.musictext_previous == guiInfo.musictext_name:
                # As RenPy goes through the entire ifelse tree to run on appear events
                # even if the above statement is false
                # We need to make sure that it is a valid image path before the first switch
                add "images/ui/music/[guiInfo.musictext_previous].png" at guiInfo.musictext_transform:
                    anchor((0, 0))
                    # Need to set position a bit higher relative to interior text box as there is
                    # padding around the text in the text image itself
                    pos((0, 0))
            else:
                # Use an if statement in order to trigger timer each time hide event is bubbled down
                if guiInfo.musictext_previous != guiInfo.musictext_name:
                    timer 1.25 action SetVariable("guiInfo.musictext_previous", guiInfo.musictext_name)
    add "images/ui/[guiInfo.chaptertext].png":
        pos(0.8, 0.15)
        at guiInfo.chaptertext_frame_transform

screen right_gui():
    frame:
        background None
        padding((0, 0))
        anchor((0, 0))
        xysize((400, 172))
        pos((0, 175))
        at guiInfo.musictext_frame_transform

        # Position = relative to the outer frame
        # Start with bars first so that it can be displayed behind
        # the scrolling text box
        add Movie(play="images/ui/mus_bars_sidemask.webm", start_image= "images/ui/bars_0001.png", side_mask=True):
            anchor((0, 0))
            pos((15, -29))

        add "images/ui/mus_building.png":
            anchor((0, 0))
            pos((48, 9))

        add "images/ui/mus_moon.png":
            anchor((0, 0))
            pos((230, -35))
            at rotate_360
            
        add "images/ui/mus_box.png":
            anchor((0, 0))
            pos((0, 123))

        frame:
            background None
            padding((0, 0))
            anchor((0, 0))
            xysize((320, 47))
            pos((0, 128))

            showif guiInfo.musictext_previous == guiInfo.musictext_name:
                # As RenPy goes through the entire ifelse tree to run on appear events
                # even if the above statement is false
                # We need to make sure that it is a valid image path before the first switch
                add "images/ui/music/[guiInfo.musictext_previous].png" at guiInfo.musictext_transform:
                    anchor((0, 0))
                    # Need to set position a bit higher relative to interior text box as there is
                    # padding around the text in the text image itself
                    pos((0, 0))
            else:
                # Use an if statement in order to trigger timer each time hide event is bubbled down
                if guiInfo.musictext_previous != guiInfo.musictext_name:
                    timer 1.25 action SetVariable("guiInfo.musictext_previous", guiInfo.musictext_name)
    add "images/ui/[guiInfo.chaptertext].png":
        pos(0.8, 0.15)
        at guiInfo.chaptertext_frame_transform
                

init python:
    class GuiInfo:
        def __init__(self):
            self.musictext_previous = ""
            self.musictext_name = ""
            self.musictext_frame_transform = None
            self.musictext_transform = None
            self.chaptertext = "chapter_prologue"
            self.chaptertext_frame_transform = None

# The game starts here.

label start:
    
    default guiInfo = GuiInfo()
    $ guiInfo.musictext_previous = "darknesstime"
    $ guiInfo.musictext_name = "darknesstime"
    $ guiInfo.musictext_frame_transform = slide_inout(-500, 100, 0)
    $ guiInfo.musictext_transform = scrolling_marquee_musictext(-400, 480, 5)
    $ guiInfo.chaptertext_frame_transform = slide_inout(1.2, 0.15, 0.8)
    
    transform namebox_rotate(who):
        rotate -4
    if config.developer == True:
        menu:
            "Trial Test.":
                jump debug_trialtest
            "Prologue.":
                jump debug_prologue

label debug_prologue:
    if config.developer == True:
        $ menu_flag = True
        menu:
            "Opening.":
                jump prologue_opening
            "Lyra Intro.":
                jump prologue_lyra
            "Dome Investigation.":
                jump prologue_silverstar
            "Limestone Intro.":
                jump prologue_limestone
            "Hotel Back.":
                jump prologue_babs
            "Hotel Front.":
                jump prologue_hoteldoors
            "Cozy Market.":
                jump prologue_masala
            "Credits":
                call screen credits
            "Hotel Inside.":
                jump prologue_cozy


label prologue_opening:
    $ menu_flag = True
    window hide
    stop music fadeout 1.0
    show cg moondancer studying with fade
    unknownCGin "{i}\"How do minds fracture when pressed against the unthinkable?\"{/i}"
    unknownCGin "{i}\"What compels a pony to hold to his values or succumb to corruption?\"{/i}"
    unknownCGin "{i}\"In the final years of his life, Brightscroll dedicated himself to unravelling the power of belief.\"{/i}"
    unknownCGin "{i}\"Those who knew him spoke of an unshakable hunger and a relentless pursuit of knowledge that cared little for limits or caution.\"{/i}"
    unknownCGin "{i}\"His final experiment sought to recreate such pressures, to observe the breaking point of trust and loyalty.\"{/i}"
    unknownCGin "{i}\"Ultimately, that hunger claimed him: One of his subjects reduced his study to ash, and with it, his life.\"{/i}"
    unknownCGin "{i}\"The irony was inescapable — the stallion who devoted himself so wholly perished to the same desperation he sought to study.\"{/i}"
    unknownCGin "{i}\"Brightscroll had lost the respect of his colleges and subjects. He went from scholar to tormentor.\"{/i}"
    unknownCGin "{i}\"However, his name endures as a cautionary tale of knowledge twisted too far.\"{/i}"
    unknownCGin "...That was the end of the book."
    unknownCGin "Studying ponies until they shattered... What a cruel obsession. But somehow, that wasn't the most disturbing biography I had read yet."
    unknownCGin "*Yawn*"
    unknownCGin "...How long have I been studying today? I think I've lost track of time."
    window hide
    pause (0.5)
    hide cg moondancer studying with fade
    unknownCGin "I stood up, stretching my legs while I gently levitated the book back to its site."
    unknownCGin "I was closer and closer to finishing the biography section of the library."
    unknownCGin "But for now, I should go home and make some dinner. I was starving."
    window hide
    pause (0.5)
    show canterlot:
        alpha 0.0
        linear 0.5 alpha 1.00
    show overlay cozymarket:
        subpixel True blend 'multiply' 
        alpha 0.0
        linear 0.5 alpha 1.00
    with Pause(0.60)
    $ overlay_background = "images/backgrounds/canterlot/charboxoverlay_canterlot"

    # This shows a character sprite. A placeholder is used, but you can
    # replace it by adding a file named "eileen happy.png" to the images
    # directory.


    #The very first scene of the prologue:

    play music "Darkness Time (V3).ogg"
    $ guiInfo.musictext_name = "darknesstime"
    unknownin "Guess I overdid it on the studying again... Luna has already raised the moon and the streets were deserted."
    unknownin "At least the walk home will be peaceful."
    unknownin "Though, I guess I should introduce myself before going any further."
    show canterlot:
        linear 0.5 alpha 0.00
    show overlay cozymarket:
        subpixel True blend 'multiply' 
        linear 0.5 alpha 0.00
    show moondancer 1a with fade:
        xpos 0.25 ypos -0.1
    mdin "My name is Moondancer. I'm just a normal unicorn from Canterlot."
    mdin "Though, I guess you could say I'm a bookworm, as I like to spend most of my time studying."
    hide moondancer with fade
    show canterlot:
        alpha 0.0
        linear 0.5 alpha 1.00
    show overlay cozymarket:
        subpixel True blend 'multiply' 
        alpha 0.0
        linear 0.5 alpha 1.00
    mdin "The air was chilly, though thankfully I had my sweater. I moved forward, with the moon above me."
    mdin "Some would be frightened of being outside this late at night, but I found the scene to be rather serene."
    mdin "No groups blocking the paths with their loud chatter, no distractions pulling me away from my thoughts."
    mdin "Besides, I knew I would have Celestia and Luna looking after me."
    play sound "sfx/footstepsmedium.wav"
    greentext "*Clop clop clop*"
    mdin "...Who did those hoofsteps belong to?"
    mdin "..."
    mdin "Maybe the late hours were getting to me, perhaps I was just imagining things."
    mdin "I decided to simply march forward."
    show charbox_overlay first_phase appear
    unknown "{color=#ffd966}Wait{/color}!"
    show charbox_overlay second_phase appear
    show moondancer 3a at charprotappear
    md "Huh?!"
    mdin "I looked around once more."
    mdin "..."
    show moondancer at charprotdisappear
    show charbox_overlay full_phase disappear
    # Since we do not hide the overlay/background, its order in the drawing stack is not reset
    # so when we show moondancer again, she will be in front of the background/overlay
    mdin "Except, nopony was here. I could've sworn that voice was real."
    mdin "I wasn't sure if somepony was pulling a prank on me, but that didn't matter. I didn't want to deal with this right now."
    mdin "I quickened my pace, my hoofsteps echoing loudly behind me."
    show overlay cozymarket:
        matrixcolor InvertMatrix(0.0)*BrightnessMatrix(0.0)
        linear 0.25 matrixcolor InvertMatrix(0.0)*BrightnessMatrix(-0.45)
        linear 0.25 matrixcolor InvertMatrix(0.0)*BrightnessMatrix(0.0)
        linear 0.25 matrixcolor InvertMatrix(0.0)*BrightnessMatrix(0.0)
        linear 0.25 matrixcolor InvertMatrix(0.0)*BrightnessMatrix(-0.45)
        linear 0.25 matrixcolor InvertMatrix(0.0)*BrightnessMatrix(0.0)
    mdin "But the lamps above me began to flicker."
    show overlay cozymarket:
        ease_quart 0.4 matrixcolor InvertMatrix(0.0)*BrightnessMatrix(-0.45)        
    show canterlot:
        ease_quart 0.4 blur 20.0
    mdin "After some seconds, I was completely left in the darkness of the night. If this was a prank, then it went too far."
    show light2 onlayer overlays:
        pos (-144, -540) rotate 180.0
        matrixcolor SaturationMatrix(2.55)*BrightnessMatrix(0.13)
        blend 'add'
        alpha 0.0
        linear 0.25 alpha 1.00
    mdin "I lit up my horn, creating my own source of illumination."
    mdin "And then-"
    show charbox_overlay first_phase appear onlayer uielements:
        matrixcolor BrightnessMatrix(-0.3)
    show silhouette at charappear
    unknownin "..."
    mdin "I saw an ominous shadow. It stood still, waiting to be approached."
    show silhouette at charmovein
    show charbox_overlay second_phase appear onlayer uielements
    show moondancer 1l at charprotappear onlayer uielements:
        matrixcolor BrightnessMatrix(-0.2)*HueMatrix(-10.0) 
    md "…What do you want?"
    mdin "…"
    mdin "No response."
    show silhouette at chardisappear
    show moondancer at charprotdisappear onlayer uielements
    show charbox_overlay full_phase disappear onlayer uielements
    mdin "I stood completely still, and yet I could feel it staring intensely at me."
    mdin "I started to feel panic. Who wouldn't? Facing a stranger in the dark... it's not something anypony could be ready for."
    mdin "I turned around, wanting to take a different route and avoid the potential danger ahead."
    mdin "It would take a few more minutes for me to make it home, but that didn't matter."
    mdin "As long as I'm safe, then everything will be-"
    stop music fadeout 1.0
    scene black
    hide light2 onlayer overlays
    window hide
    play sound "sfx/stabwound.wav"
    greentextCG "*Bonk*"
    mdCGin "...Fine."
    mdCGin "..."
    mdCGin "..."
    mdCGin "..."
    mdCGin "How long has it been? Seconds? Minutes? Hours?"
    mdCGin "When your mind slips, time stops meaning anything."
    mdCGin "They say life can end in an instant... and I believe that now."
    mdCGin "A single moment, and everything you've built, everything you've dreamed, can be cut short."
    mdCGin "You're never given a warning. No time to prepare, no chance to turn away."
    mdCGin "..."
    mdCGin "But... even if fate tried to end my story here—"
    mdCGin "{color=#ffd966}My story isn't done yet.{/color}"
    window hide
    $ renpy.pause (3.0)
    #Titlecard: Permanent Vacancy
    play sound "titlecardprologue.ogg"
    show titlecardprologuebackground:
        alpha 0.0
        ease 1.0 alpha 1.0
    $ renpy.pause (1.0)
    show titlecardprologueshadow1:
        blend 'multiply'
        alpha 0.0 xpos 117 
        easein 0.30 xpos 0 alpha 1.0
    show titlecardprologuecharacter1:
        alpha 0.0 xpos 117 
        easein 0.30 xpos 0 alpha 1.0
    $ renpy.pause (0.5)
    show titlecardprologueborder:
        alpha 0.0 xpos -459 
        easein 0.3 xpos 0 alpha 1.0
    $ renpy.pause (1.2)
    show titlecardprologuetext:
        alpha 0.0
        pos (-18, -36) zoom 1.05 
        easeout 0.25 pos (9, 27) zoom 0.95 alpha 1.0
        ease 0.6 pos (0, 0) zoom 1.0 
    $ renpy.pause (5.0)
    show titlecardprologuebackground:
        ease 0.5 alpha 0.0
    show titlecardprologueshadow1:
        easeout 0.30 xpos 117 alpha 0.0
    show titlecardprologuecharacter1:
        easeout 0.30 xpos 117 alpha 0.0
    show titlecardprologueborder:
        easeout 0.3 xpos -459 alpha 0.0
    $ renpy.pause (0.5)
    show titlecardprologuetext:
        easeout 0.25 pos (-18, -36) zoom 1.05 alpha 0.0
    $ renpy.pause (2.0)
    mdCGin "..."
    mdCGin "..."
    mdCGin "Slowly but surely, I started to regain consciousness and control of my body."
    mdCGin "I could feel a deep ache pounding behind my eyes."
    mdCGin "Soft grass brushed against my back as I stirred, squinting against the blurry light."
    mdCGin "Even if it was painful right now, I guess I'm still alive. I really thought I was done for."
    show cg hotel view2 with fade
    mdCGin "Regardless... Where am I? How did I get here?"
    mdCGin "My glasses—where are they?"
    mdCGin "I scrambled for them on my side, and..."
    mdCGin "Found them."
    mdCGin "As my view became clearer, the first thing I saw was a massive building towering in front of me."
    mdCGin "It looked decrepit... all the windows were boarded up."
    $ renpy.start_predict("images/backgrounds/povhotel/*.png")
    show cg confused ponies with dissolve:
        xanchor 0.0
        xpos 0
    mdCGin "I got up on my hooves to try and figure out where I was, but nothing looked familiar."
    show cg confused ponies:
        ease 3.0 xpos -1326
    mdCGin "Aside from the run down building, there was something... off about the sky. It didn't quite look right."
    show cg confused ponies:
        ease 3.0 xpos 0
    mdCGin "There were a bunch of other ponies gathered in front of the building, too. They were all looking around, confused, lost, angry, scared..."
    mdCGin "Were they abducted just like I was?"
    mdCGin "But... why us? I didn't recognize any of these ponies."
    mdCGin "Well, except for one."

label prologue_lyra:
    $ menu_flag = True
    play music "Climax Reasoning (V3).ogg"
    $ guiInfo.musictext_name = "climaxreasoning"
    scene black with fade
    show hotel exterior with dis:
        subpixel True ypos 1.22 zpos -2790.0 zzoom True
    show lyra 7a with dis:
        subpixel True pos (0.25, 2.22) zpos -1300.0
    camera:
        subpixel True pos (36, 2538) zpos -1449.0 perspective True
    show light1 onlayer overlays:
        blend 'add' 
    $ overlay_background = "images/backgrounds/povhotel/charboxoverlay_hotelpov"
    #show musicbox_alt onlayer uielements at musicboxappear, zorder 5
    show charbox_overlay first_phase appear onlayer uielements:
        matrixcolor BrightnessMatrix(0.0)
    show screen left_gui
    $ guiInfo.musictext_name = "climaxreasoning"
    $ guiInfo.musictext_transform = scrolling_marquee_musictext(-400, 480, 5)
    md "Ugh, my head..."
    show lyra 3a with dis
    unknown "Uh? Oh!"
    show lyra 1b with dis
    unknown "Moondancer, you're finally awake!"
    camera:
        easein 0.3 xpos 153
    show charbox_overlay second_phase appear onlayer uielements
    show moondancer 3a onlayer uielements at charprotappear, zorder 4:
        matrixcolor BrightnessMatrix(0.0)
    md "Hm?"
    camera:
        easein 0.3 xpos 36
    show lyra 1a with dis
    show charbox_overlay second_phase disappear onlayer uielements
    show moondancer onlayer uielements at charprotdisappear
    unknown "I'm Lyra Heartstrings... You do remember me, right?"
    show charbox_overlay first_phase disappear onlayer uielements
    hide screen left_gui
    window auto hide
    pause 0.3
    play sound "audio/sfx/Intro_V3.mp3"
    show genericbackground behind lyra:
        matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.14)*SaturationMatrix(1.0)*BrightnessMatrix(0.07)*HueMatrix(648.0) 
        subpixel True pos (0.0, 2.34) zpos -1318.0 
        alpha 0.0
        linear 0.5 alpha 1.0
    show light1 onlayer overlays:
        linear 0.5 alpha 0.0
    show light2 onlayer overlays:
        blend 'add'
        alpha 0.0
        linear 0.5 alpha 1.0
    pause 0.2
    show lyra:
        subpixel True xpos 0.25
        ease 0.5 xpos 0.05
    show ring behind lyra:
        subpixel True pos (0.5, 2.36) zpos -1422.0 alpha 0.22 blend 'add' 
        alpha 0.0
        linear 0.3 alpha 0.3
        zrotate 0.0
        linear 5.0 zrotate 620.0
    show cmlyra behind lyra:
        subpixel True pos (0.5, 2.36) zpos -1422.0 alpha 0.22 blend 'add' 
        alpha 0.0
        linear 0.3 alpha 0.3
    pause 0.1
    show introbars behind lyra:
        subpixel True pos (0.04, 2.71) zpos -1377.0
        matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
        easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0)
    show intronamelyra behind lyra:
        subpixel True pos (0.04, 2.71) zpos -1377.0
        matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0) 
        easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
    pause 2.0
    show lyra:
        ease 0.5 xpos 0.25
    show ring behind lyra:
        linear 0.3 alpha 0.0
        zrotate 0.0
    show cmlyra behind lyra:
        linear 0.3 alpha 0.0
    show genericbackground behind lyra:
        linear 0.5 alpha 0.0
    show light1 onlayer overlays:
        linear 0.5 alpha 1.0
    show light2 onlayer overlays:
        linear 0.5 alpha 0.0
    pause 0.6
    hide ring
    hide intronamelyra
    hide introbars
    hide cmlyra
    hide genericbackground
    window auto show
    show charbox_overlay first_phase appear onlayer uielements
    show screen left_gui
    mdin "Lyra Heartstrings..."
    mdin "She used to be part of my group of friends back in Canterlot, until she moved to Ponyville."
    mdin "Since then, I've seen her around on a few occasions, usually for some party or something, but we've never really talked much."
    mdin "She's always asked me to come see her in Ponyville, but...I never really found the time to visit."
    camera:
        easein 0.3 xpos 153
    show charbox_overlay second_phase appear onlayer uielements
    show moondancer 1b onlayer uielements at charprotappear
    md "Well, I guess we finally got to see each other again, huh?"
    show lyra 1b with dis
    lh "Yeah! It's nice to see you."
    show moondancer 2b onlayer uielements with disalt
    md "Where are we, anyway? I don't remember coming here at all."
    show lyra 2d with dis
    lh "...Honestly, I don't know."
    lh "I've been looking around, but this dome is keeping us trapped."
    show moondancer 1e onlayer uielements with disalt
    md "...Dome? What are you talking about?"
    show lyra 6b with dis
    lh "For some reason... we're inside a giant glass sphere. None of us had managed to break out yet."
    md "If there's no exit, then how did we enter here in the first place?"
    show lyra 1g with dis
    lh "I don't know... I can't remember how I got here at all."
    show moondancer 2c onlayer uielements with disalt
    md "Oh."
    show lyra 2a with dis
    lh "What about you, Moondancer?"
    camera:
        easein 0.3 xpos 36
    show charbox_overlay second_phase disappear onlayer uielements
    show moondancer onlayer uielements at charprotdisappear
    mdin "The events of last night flashed through my mind."
    mdin "That dark figure — It must be the one responsible behind this."
    mdin "How long has it been since then? Why was I brought here to begin with?"
    mdin "It almost feels like a fever dream, but it was my unfortunate reality."
    camera:
        easein 0.3 xpos 153
    show charbox_overlay second_phase appear onlayer uielements
    show moondancer 2a onlayer uielements at charprotappear
    md "Well, I recall that I was making my way home very late at night."
    md "I stumbled upon a pony I couldn't recognize. I tried to escape, but I was struck from behind."
    md "Then, I woke up in whatever this place is."
    show moondancer 2c onlayer uielements with disalt
    mdin "On top of that, I'm incredibly hungry. Couldn't this have waited until I had dinner, at least?"
    show lyra 4a with dis
    lh "You were attacked?! That's... that's just horrible!"
    show moondancer 1e onlayer uielements with disalt
    md "Hold on, you weren't?"
    show lyra 1g with dis
    lh "Not really... I kind of just went to sleep, and then I appeared here. Almost feels like a dream, y'know?"
    mdin "Something doesn't seem consistent here. Maybe both kidnappings took place late at night?"
    mdin "But how can you be in two different places at the same time? Ugh, I really shouldn't have overstayed at the library."
    camera:
        easein 0.3 xpos 36
    show charbox_overlay second_phase disappear onlayer uielements
    show moondancer 1a onlayer uielements at charprotdisappear
    md "*Sigh* No point in lingering on the past. I guess I'll go and investigate this place."
    show lyra 1f with dis
    lh "Moondancer... Hold on!"
    camera:
        easein 0.3 xpos 153
    show charbox_overlay second_phase appear onlayer uielements
    show moondancer 1a onlayer uielements at charprotappear
    md "Huh?"
    show lyra 5c with dis
    lh "I know it's sudden, but... Can I go with you?"
    show moondancer 1o onlayer uielements with disalt
    md "..."
    lh "..."
    show lyra 1g with dis
    lh "You see... Everypony else is already investigating – except for me. I stayed behind, just to make sure you were safe."
    show moondancer 5a onlayer uielements with disalt
    md "Wait, really?"
    show lyra 1c with dis
    lh "...Mhm!"
    show lyra 1e with dis
    lh "I know I'm not as smart as you... But I'd still like to help."
    lh "Maybe I would notice some things too, or maybe just a second pair of eyes would be useful."
    show moondancer 2a onlayer uielements with disalt
    md "..."
    show lyra 5c with dis
    lh "But if you don't want to... that's fine, too."
    camera:
        easein 0.3 xpos 36
    show charbox_overlay second_phase disappear onlayer uielements
    show moondancer onlayer uielements at charprotdisappear
    mdin "I'm not sure if I could trust anypony in a situation like this. I mean, how can I be so sure everyone here is innocent?"
    mdin "But Lyra... I don't think she's malicious."
    mdin "If she really looked after me while I was out... I guess the right thing to do would be going with her."
    camera:
        easein 0.3 xpos 153
    show charbox_overlay second_phase appear onlayer uielements
    show moondancer 2a onlayer uielements at charprotappear
    md "...Alright. You can tag along."
    show lyra 1b with dis
    lh "Really? That's awesome!"
    show lyra 1d with dis
    lh "Thanks a lot, Moondancer."
    show moondancer 1a onlayer uielements with disalt
    md "Don't mention it."
    show lyra 2a with dis
    lh "So, where are we going to check first?"
    show moondancer 4a onlayer uielements with disalt
    md "For starters, I was going to check the dome's walls."
    show lyra 6a with dis
    lh "The edges? You think they're important?"
    show moondancer 1b onlayer uielements with disalt
    md "I mean, I didn't notice we were inside a dome until you mentioned it."
    md "Maybe we can figure out what it's made of—or if there's a way through."
    camera:
        easein 0.3 xpos 36
    show charbox_overlay second_phase disappear onlayer uielements
    show moondancer onlayer uielements at charprotdisappear
    show lyra 2a with dis
    lh "Hmm... That makes sense."
    show lyra 3b with dis
    lh "Okay! Then let's check it out!"
    show charbox_overlay first_phase disappear onlayer uielements
    hide screen left_gui
    $ renpy.pause(delay=0.2)
    show lyra at chardisappear
    $ renpy.pause(delay=0.5)
    hide charbox_overlay 
    window hide
label prologue_silverstar:
    $ menu_flag = True
    scene black with black
    show light1 onlayer overlays:
        ease 0.5 alpha 0.0
        blend 'add'
    $ renpy.pause(delay=0.5)
    $ renpy.start_predict("images/backgrounds/povdome/*.png")
    camera:
        subpixel True pos (0, 0) zpos 0 perspective False
    hide light2 onlayer overlays
    mdCGin "Lyra and I approached the edges of this place."
    mdCGin "All I could see was a landscape full of trees and rocks. It seems we really *are* in the middle of nowhere."
    mdCGin "Regardless, we were right next to the border."
    $ overlay_background = "images/backgrounds/povdome/charboxoverlay_domepov"
    show hotel dome with black:
        subpixel True ypos 1.22 zpos -2790.0 zzoom True
    show light1 onlayer overlays:
        ease 0.5 alpha 1.0
    camera:
        subpixel True pos (207, 2331)  zpos -216.0 perspective True
    show silverstar 4a with dis:
        subpixel True pos (0.88, 1.95) zpos -2605.0 
    show lyra 3a with dis:
        subpixel True pos (0.34, 2.06) zpos -1048.0
    window show
    show charbox_overlay first_phase appear onlayer uielements
    show screen left_gui
    mdin "I guess now I have the chance to figure out what's going on..."
    greentext "Oh, hello there! If you're still confused, I will help you figure the controls out!"
    greentext "You can move the mouse to aim. Aim at something or somepony you want to interact with and press the left mouse button to investigate!"
    greentext "Use the W/A/S/D keys to adjust your viewpoint, or if you'd like, you can hold down the right mouse button down and move your view around."
    greentext "If you're not sure what you can interact with, you can press the Enter key to highlight suspicious spots!"
    greentext "Good luck and have fun investigating this place!"
    window hide

label debug_investigationtest:
    transform tilted():
        rotate 1.3
    init python:
        # Variable to control image alpha
        image_visible = False
    screen Investigation():
            
        key "K_RETURN" action ToggleVariable("image_visible", True, False)

        add "dome_label" xpos 500 + cam_x(-0.33) ypos 327 + cam_y(-0.33) alpha If(image_visible, 1.0, 0.0)

        add "mystery_label" xpos 1195 + cam_x(-0.34) ypos 100 + cam_y(-0.33) alpha If(image_visible, 1.0, 0.0)

        add "lyra_label" xpos 820 + cam_x(-0.6) ypos 35 + cam_y(-0.6) alpha If(image_visible, 1.0, 0.0)
        
        imagebutton:
            
            xpos -0.5 + cam_x(-0.001) ypos -65 + cam_y(-0.33)
            
            auto "images/ui/domeButton_%s.png" action [ToggleScreen("Investigation"), Jump("domeButtonDialouge")]
            
            

        imagebutton:
            
            xpos 1245 + cam_x(-0.34) ypos 360 + cam_y(-0.33)
            
            auto "images/ui/silverstarButton_%s.png" action [ToggleScreen("Investigation"), Jump("silverstarButtonDialouge")]

        imagebutton:
            
            xpos 840 + cam_x(-0.6) ypos 315 + cam_y(-0.6)
            
            auto "images/ui/lyraButton_%s.png" action [ToggleScreen("Investigation"), Jump("lyraButtonDialouge")]
            
        

        
    default lyraCheck = False
    default domeCheck = False
    default silverstarCheck = False

    $ menu_flag = True

label debug_investigationContinue:
    
    $ restore_master_layer(0.3)
    camera:
            ease 0.5 pos (207, 2331) zpos -216.0
    $ set_camera_pan(True, max_x=550, max_y=200)
    if lyraCheck == False or domeCheck == False or silverstarCheck == False:
        call screen Investigation

label lyraButtonDialouge:
    if lyraCheck == False or domeCheck == False or silverstarCheck == False:
        pause (0.3)
        $ save_master_layer_position()
        $ reset_master_layer(0.108)
        pause (0.3)
        $ set_camera_pan(False)
        play sound "sfx/tabopen.wav"
        camera:
            easein 0.3 pos (324, 2331) zpos -1197.0
        show charbox_overlay second_phase appear onlayer uielements
        show moondancer 1b onlayer uielements at charprotappear
        md "...Hey, Lyra?"
        show lyra 2a with dis
        lh "Yes?"
        show moondancer 5a onlayer uielements with disalt
        md "How long was I asleep?"
        show lyra 2d with dis
        lh "I'm not sure how long exactly. I wasn't the first to wake up, but I think I watched over you for maybe an hour or so?"
        show moondancer 3a onlayer uielements with disalt
        md "You really watched me sleep for that long!"
        show lyra 1d with dis
        lh "Of course! I had to make sure you were okay."
        show moondancer 1n onlayer uielements with disalt
        md "I see... Well, thanks."
        show lyra 1a with dis
        lh "Hey, what are friends for, right?"
        mdin "Right...friends..."
        show charbox_overlay second_phase disappear onlayer uielements
        show moondancer onlayer uielements at charprotdisappear
        pause (0.3)
        $ lyraCheck = True
        jump debug_investigationContinue
    
label domeButtonDialouge:
    pause (0.3)
    $ save_master_layer_position()
    $ reset_master_layer(0.108)
    pause (0.3)
    $ set_camera_pan(False)
    if lyraCheck == False or domeCheck == False or silverstarCheck == False:
        play sound "sfx/tabopen.wav"
        camera:
            ease 0.3 xpos -567 zpos -1251.0 
        mdin "So there really is a dome keeping us all in."
        mdin "I knocked my hoof on the wall. It felt like thick, strong glass, but I also felt something...magical about it?"
        mdin "It reaches up so high, too. Where would you even get a glass bowl this big?"
        mdin "I can see so much of the world outside, and yet, I don't recognize where we are."
        camera:
            easein 0.3 pos (207, 2331) zpos -1197.0
        show lyra 6a with dis
        lh "Do you think this is what a pet fish feels like?"
        md "I'm sure feeling like a small fry right now..."
        $ domeCheck = True

        
        jump debug_investigationContinue

label silverstarButtonDialouge:
    if lyraCheck == False or domeCheck == False or silverstarCheck == False:
        pause (0.3)
        $ save_master_layer_position()
        $ reset_master_layer(0.108)
        pause (0.5)
        $ set_camera_pan(False)
        play sound "sfx/tabopen.wav"
        camera:
            ease 0.5 pos (1269, 2187) zpos -2754.0
        unknown "..."
        mdin "He's been staring at the wall for quite a while now..."
        mdin "The hat, the badge...it's like he came straight out of a western..."
        mdin "He looks pretty focused, maybe I shouldn't interrupt."
        $ silverstarCheck = True

        
        jump debug_investigationContinue

label investigationComplete:
    camera:
        ease 0.5 pos (207, 2331) zpos -216.0
    greentext "Investigation Complete."
    # All 3 Points Investigated
    camera:
        easein 0.3 pos (194, 2331) zpos -1197.0
    show lyra 3a with dis
    lh "So, what do you think?"
    show charbox_overlay second_phase appear onlayer uielements
    show moondancer 2b at charprotappear onlayer uielements
    camera:
        easein 0.3 xpos 324
    md "I don't think I found anything all that helpful..."
    show lyra 2b with dis
    lh "Well, maybe *he* knows what's going on. I'm going to go ask!"
    show moondancer 5b onlayer uielements with disalt
    md "Lyra, he's probably busy. Maybe we shouldn't-"
    camera:
        easein 0.3 xpos 194
    show moondancer at charprotdisappear onlayer uielements
    show charbox_overlay second_phase disappear onlayer uielements
    show lyra:
        easein 0.25 alpha 0.00
    mdin "Lyra ignored me as she approached the sheriff with little hesitation."
    show lyra 1a:
        subpixel True pos (1.1, 1.95) zpos -2191.0 
        alpha 0.00
        easein 0.25 alpha 1.00
    camera:
        easein 0.3 pos (1665, 2232) zpos -2340.0 
    lh "Hey there!"
    camera:
        easein 0.3 pos (1269, 2187)  zpos -2754.0
    show silverstar 1e with dis
    unknown "..."
    show silverstar 1b with dis
    unknown "Howdy!"
    camera:
        easein 0.3 pos (1692, 2232) zpos -2340.0 
    show lyra 1b with dis
    lh "Nice to meet ya! I'm Lyra Heartstrings and this is my friend Moondancer."
    camera:
        easein 0.3 pos (1269, 2187)  zpos -2754.0
    unknown "Oh, I see."
    show silverstar 2c with Dissolve(0.1)
    unknown "A pleasure to meet ya ladies. Sheriff Silverstar at your service."
    #<INTRODUCTION:Sheriff Silverstar>
    show charbox_overlay first_phase disappear onlayer uielements
    hide screen left_gui
    show lyra:
        linear 0.5 alpha 0.0
    window auto hide
    pause 0.3
    play sound "audio/sfx/Intro_V3.mp3"
    show genericbackground behind silverstar:
        matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.14)*SaturationMatrix(0.61)*BrightnessMatrix(0.07)*HueMatrix(369.0) 
        subpixel True pos (0.63, 2.0) zpos -2623.0 
        alpha 0.0
        linear 0.5 alpha 1.0
    show light1 onlayer overlays:
        linear 0.5 alpha 0.0
    show light2 onlayer overlays:
        blend 'add'
        alpha 0.0
        linear 0.5 alpha 1.0
    pause 0.2
    show silverstar:
        subpixel True xpos 0.88
        ease 0.5 xpos 0.66
    show ring behind silverstar:
        subpixel True pos (1.13, 2.09) zpos -2727.0 alpha 0.22 blend 'add' 
        alpha 0.0
        linear 0.3 alpha 0.3
        zrotate 0.0
        linear 5.0 zrotate 620.0
    show cmsilverstar behind silverstar:
        subpixel True pos (1.13, 2.09) zpos -2727.0 alpha 0.22 blend 'add'
        alpha 0.0
        linear 0.3 alpha 0.3
    pause 0.1
    show introbars behind silverstar:
        subpixel True pos (0.67, 2.44) zpos -2682.0
        matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.0)*SaturationMatrix(1.23)*BrightnessMatrix(-0.1)*HueMatrix(153.0)
        matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
        easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0)
    show intronamesilverstar behind silverstar:
        subpixel True pos (0.67, 2.44) zpos -2682.0
        matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0) 
        easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
    pause 2.0
    show silverstar:
        ease 0.5 xpos 0.88
    show ring behind silverstar:
        linear 0.3 alpha 0.0
        zrotate 0.0
    show genericbackground behind silverstar:
        linear 0.5 alpha 0.0
    show cmsilverstar behind silverstar:
        linear 0.3 alpha 0.0
    show lyra 3b:
        linear 0.5 alpha 1.0
    show light2 onlayer overlays:
        linear 0.5 alpha 0.0
    show light1 onlayer overlays:
        alpha 0.0
        linear 0.5 alpha 1.0
    pause 0.6
    hide ring
    hide introbars
    hide genericbackground
    hide cmsilverstar
    hide intronamesilverstar
    window auto show
    show charbox_overlay first_phase appear onlayer uielements
    show screen left_gui
    
    camera:
        easein 0.3 pos (1665, 2232) zpos -2340.0 
    lh "Wait, you're a real sheriff? That's awesome!"
    camera:
        easein 0.3 pos (1269, 2187)  zpos -2754.0
    show silverstar 2a with dis
    silverstar "Sure am! I've been keepin' the peace in Appleloosa for goin' on ten years now."
    show silverstar 1e with dis
    silverstar "...Though I reckon I'm far away from home. Ain't no desert or tumbleweeds 'round here."
    camera:
        easein 0.3 pos (1386, 2187)  zpos -2754.0
    show moondancer 4b onlayer uielements at charprotappear
    show charbox_overlay second_phase appear onlayer uielements 
    md "Appleloosa? Isn't that in the southern part of Equestria?"
    show silverstar 1c with dis
    silverstar "Sure is."
    camera:
        easein 0.3 pos (1269, 2187)  zpos -2754.0
    show silverstar 4a with dis
    show moondancer onlayer uielements at charprotdisappear
    show charbox_overlay second_phase disappear onlayer uielements
    silverstar "One moment I was breakin' up a bar fight, the next... I'm here. Feels like somepony pulled the rug right out from under me."
    camera:
        easein 0.3 pos (1665, 2232) zpos -2340.0 
    show lyra 2d with dis
    lh "So you're as lost as we are, aren't you?"
    camera:
        easein 0.3 pos (1269, 2187)  zpos -2754.0
    show silverstar 3a with dis
    silverstar "Pretty much, but I've been investigating this here confinement of sorts."
    show silverstar 1e with dis
    silverstar "I figured not even raw earth pony strength can leave a mark."
    show silverstar at chardisappear
    mdin "Silverstar approached the wall..."
    play sound "sfx/thud.wav"
    greentext "*Slam*"
    camera:
        easein 0.3 pos (1665, 2232) zpos -2340.0 
    show lyra 1i
    lh "..."
    play sound "sfx/pianoreaction.wav"
    show lyra 4a with dis
    lh "What? That really did nothing?!"
    mdin "...Yup, just like he claimed."
    mdin "No crack, no dent... not even a sound of strain. What is this thing made of?"
    show lyra 1g with dis
    lh "Bummer, that kick seemed really strong."
    camera:
        easein 0.3 pos (1269, 2187)  zpos -2754.0
    show silverstar 3b:
        subpixel True pos (0.88, 1.95) zpos -2605.0 
        alpha 0.00
        easein 0.25 alpha 1.00
    silverstar "Thanks, though it seems my strength won't be of any use."
    silverstar "Back in Appleloosa, I'd rely on my wits and my lasso to handle trouble."
    show silverstar 1e with dis
    silverstar "Bandits, outlaws, even the occasional sandstorm. Nothing I couldn't handle."
    camera:
        easein 0.3 pos (1665, 2232) zpos -2340.0 
    show lyra 1g with dis
    lh "And this really feels like something else, doesn't it?"
    camera:
        easein 0.3 pos (1269, 2187)  zpos -2754.0
    show silverstar 1c with dis
    silverstar "Oh, absolutely!"
    show silverstar 3a with dis
    silverstar "...But say, since y'all're unicorns, do y'all think ya can use yer magic?"
    silverstar "Maybe y'all can teleport outta here, or even blast these walls."
    camera:
        easein 0.3 pos (1386, 2187)  zpos -2754.0
    show moondancer 4b onlayer uielements at charprotappear
    show charbox_overlay second_phase appear onlayer uielements
    md "I guess we could try, but are you sure it would work?"
    md "It sounds... too simple."
    show silverstar 1c with dis
    silverstar "I get what yer sayin', but isn't it for the best to try everythin' before givin' up?"
    silverstar "Sometimes the simplest solution is the right one."
    show silverstar 1b with dis
    silverstar "'Course, sometimes it ain't. But ya won't know 'til ya try."
    camera:
        easein 0.3 pos (1773, 2232) zpos -2340.0 
    show lyra 1b with dis
    lh "Yeah! And if there is a chance to escape, maybe it's worth trying!"
    camera:
        ease 0.5 pos (1503, 2241) zpos -1008.0 
    show moondancer onlayer uielements at charprotdisappear
    show charbox_overlay second_phase disappear onlayer uielements
    mdin "...I silenced my protests, and closed my eyes shut."
    mdin "I attempted to picture myself outside, and I felt a rush of magic through my horn."
    mdin "..."
    mdin "But it ended up in nothing, as I could feel myself struggling."
    show moondancer 1l onlayer uielements at charprotappear
    show charbox_overlay second_phase appear onlayer uielements
    md "Ugh! I can't teleport!"
    camera:
        easein 0.3 pos (1773, 2232) zpos -2340.0
    show lyra 1f with dis
    lh "Hold on, let me try!"
    mdin "Lyra closed her eyes and focused, a yellow glowing in her horn."
    mdin "She struggled, her horn letting out some sparks."
    mdin "...But all of her efforts were in vain."
    show lyra 5a with dis
    lh "I can't... I can't teleport either..."
    camera:
        easein 0.3 pos (1386, 2187)  zpos -2754.0
    show silverstar 3b with dis
    silverstar "This is weird. Aren't unicorns basically capable of teleportin' anywhere they want?"
    stop music fadeout 1.0
    $ guiInfo.musictext_name = "null"
    camera:
        ease 0.5 pos (324, 2331) zpos -1197.0
    show sunburst 1a with dis:
        subpixel True pos (0.34, 2.06) zpos -1048.0
    unknown "Normally, that'd be the case. However, this dome is {color=#ffd966}enchanted{/color}."
    camera:
        ease 0.5 pos (1386, 2187)  zpos -2754.0
    show silverstar 1e with dis
    silverstar "Hmm?"
    camera:
        ease 0.5 pos (324, 2331) zpos -1197.0
    show moondancer 1a onlayer uielements with dis
    mdin "An unicorn approached us. His cloack and glasses... Was he some sort of wizard?"
    unknown "..."
    camera:
        ease 0.5 pos (1773, 2232) zpos -2340.0
    show lyra 1f with dis
    lh "..."
    camera:
        easein 0.3 pos (1386, 2187)  zpos -2754.0     
    silverstar "..."
    silverstar "Mind explaining yerself, mister...er..."
    camera:
        easein 0.3 pos (1269, 2187)  zpos -2754.0
    show silverstar 1c with dis
    show moondancer onlayer uielements at charprotdisappear
    show charbox_overlay second_phase disappear onlayer uielements
    silverstar "Say, what's the name again?"
    camera:
        ease 0.5 pos (207, 2331) zpos -1197.0
    show sunburst 5a with dis
    unknown "Ah, I guess an introduction is in order. My apologies."
    show sunburst 1a with dis
    unknown "I'm Sunburst, the royal crystaller of the crystal empire."
    # <INTRODUCTION:Sunburst>
    show charbox_overlay first_phase disappear onlayer uielements
    hide screen left_gui
    show lyra:
        linear 0.5 alpha 0.0
    show silverstar:
        linear 0.5 alpha 0.0
    window auto hide
    pause 0.3
    play sound "audio/sfx/Intro_V3.mp3"
    show genericbackground behind sunburst:
        matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.14)*SaturationMatrix(0.61)*BrightnessMatrix(0.07)*HueMatrix(666.0)
        subpixel True pos (0.09, 2.18) zpos -1066.0
        alpha 0.0
        linear 0.5 alpha 1.0
    show light1 onlayer overlays:
        blend 'add'
        linear 0.5 alpha 0.0
    show light2 onlayer overlays:
        blend 'add'
        alpha 0.0
        linear 0.5 alpha 1.0
    pause 0.2
    show sunburst:
        subpixel True xpos 0.34
        ease 0.5 xpos 0.14
    show ring behind sunburst:
        subpixel True pos (0.59, 2.20) zpos -1170.0 alpha 0.22 blend 'add' 
        alpha 0.0
        linear 0.3 alpha 0.3
        zrotate 0.0
        linear 5.0 zrotate 620.0
    show cmsunburst behind sunburst:
        subpixel True pos (0.59, 2.20) zpos -1170.0 alpha 0.22 blend 'add'
        alpha 0.0
        linear 0.3 alpha 0.3
    pause 0.1
    show introbars behind sunburst:
        subpixel True pos (0.13, 2.55) zpos -1125.0
        matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.0)*SaturationMatrix(0.8)*BrightnessMatrix(-0.21)*HueMatrix(846.0) 
        matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
        easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0)
    show intronamesunburst behind sunburst:
        subpixel True pos (0.13, 2.55) zpos -1125.0
        matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0) 
        easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
    pause 2.0
    show sunburst:
        ease 0.5 xpos 0.34
    show ring behind sunburst:
        linear 0.3 alpha 0.0
        zrotate 0.0
    show genericbackground behind sunburst:
        linear 0.5 alpha 0.0
    show cmsunburst behind sunburst:
        linear 0.3 alpha 0.0
    show lyra:
        linear 0.5 alpha 1.0
    show silverstar:
        linear 0.5 alpha 1.0
    show light1 onlayer overlays:
        alpha 0.0
        linear 0.5 alpha 1.0
    show light2 onlayer overlays:
        blend 'add'
        linear 0.5 alpha 0.0
    pause 0.6
    play music "Cool Morning (V3).ogg"
    $ guiInfo.musictext_name = "coolmorning"
    hide ring
    hide introbars
    hide intronamesunburst
    hide genericbackground
    hide cmsunburst
    window auto show
    show charbox_overlay first_phase appear onlayer uielements
    show screen left_gui
    camera:
        easein 0.5 pos (1269, 2187)  zpos -2754.0
    show silverstar 2a with dis
    silverstar "Crystaller, ya say? That sounds like a mighty lot of work!"
    silverstar "Polishing crystals for the king and queen ain't an easy feat."
    camera:
        ease 0.5 pos (207, 2331) zpos -1197.0
    show sunburst 1g with dis
    play sound "sfx/dramatic.wav"
    sunburst "Polishing crystals?! It's absolutely nothing like that..."
    camera:
        ease 0.5 pos (1269, 2187)  zpos -2754.0
    show silverstar 2b with dis
    play sound "sfx/embrarassed.wav"
    silverstar "Oh..."
    camera:
        ease 0.5 pos (207, 2331) zpos -1197.0
    show sunburst 4a with dis
    sunburst "I take care of the king and queen's daughter, Flurry Heart. That's my role as a crystaller."
    camera:
        ease 0.5 pos (1665, 2232) zpos -2340.0 
    show lyra 2c with dis
    lh "So basically, you're foalsitting a princess? That's nice, but... it doesn't explain the cloak though."
    camera:
        ease 0.5 pos (207, 2331) zpos -1197.0
    show sunburst 1h with dis
    sunburst "Well, aside from taking care of the princess, I also am her magic teacher."
    show sunburst 2c with dis
    sunburst "Besides... I feel very weird if I don't have my cloak with me..."
    camera:
        easein 0.3 pos (324, 2331) zpos -1197.0
    show moondancer 2b onlayer uielements at charprotappear
    show charbox_overlay second_phase appear onlayer uielements
    md "Sunburst. If you're meant to be taking care of Flurry Heart, then what are you doing here?"
    md "I assume you were kidnapped as well?"
    show sunburst 2e with dis
    sunburst "Well... I was taking a train to Ponyville for a personal visit."
    sunburst "I was reading some books and started to fall asleep. And the first thing I know is that I woke up in this place."
    camera:
        easein 0.3 pos (1773, 2232) zpos -2340.0 
    show lyra 4a with dis
    lh "You were kidnapped in the train? How did nopony notice that?"
    camera:
        ease 0.5 pos (1386, 2187)  zpos -2754.0
    show silverstar 4a with dis
    silverstar "That sounds real dirty. They didn't miss the opportunity to get ya."
    camera:
        ease 0.5 pos (324, 2331) zpos -1197.0
    show sunburst 2c with dis
    sunburst "To be fair... I was basically alone in my wagon. I didn't think I was in actual danger at first."
    show sunburst 5a with dis
    sunburst "Ugh! I really should've waited for tomorrow's train. Maybe I wouldn't be in this mess."
    sunburst "And to who could've done this... I'm afraid that's a question that we can't answer yet."
    show moondancer 1e onlayer uielements with disalt
    md "Talking about questions, I've got one."
    show moondancer 4b onlayer uielements with disalt
    md "You mentioned that this dome was enchanted. Can you tell us more about this?"
    show sunburst 1d with dis
    sunburst "...Oh! Right!"
    camera:
        easein 0.3 pos (207, 2331) zpos -1197.0
    show sunburst 7a with dis
    show moondancer onlayer uielements at charprotdisappear
    show charbox_overlay second_phase disappear onlayer uielements
    sunburst "The dome's enchantment, it's designed to {color=#ffd966}trap ponies{/color}, especially unicorns."
    sunburst "It prevents teletransportation, and it can even suppress magic entirely."
    show sunburst 5b with dis
    sunburst "But lucky for us, our magic is still functional."
    show sunburst 3c with dis
    sunburst "Can you imagine how difficult it'd be to live without the usage of magic?"
    camera:
        ease 0.5 pos (1269, 2187)  zpos -2754.0
    play sound "sfx/dramatichigher.wav"
    show silverstar 1i with dis
    silverstar "Hey! Us earth ponies don't require magic, we can do anythin' just as fine."
    camera:
        ease 0.5 pos (207, 2331) zpos -1197.0
    show sunburst 6a with dis
    sunburst "Oh- I'm so sorry. I didn't mean to imply-"
    camera:
        ease 0.5 pos (1269, 2187)  zpos -2754.0
    show silverstar 1b with dis
    silverstar "Just messin' with ya, you're good."
    camera:
        easein 0.3 pos (1386, 2187)  zpos -2754.0
    show moondancer 2c onlayer uielements at charprotappear
    show charbox_overlay second_phase appear onlayer uielements
    md "So in short, we can't escape."
    camera:
        ease 0.5 pos (324, 2331) zpos -1197.0
    show sunburst 2b with dis
    sunburst "...Well, not entirely."
    show sunburst 3a with dis
    sunburst "Enchantments like this are complex, but they're not perfect. There's always a {color=#ffd966}weak spot{/color}—a flaw in the design."
    sunburst "If we can find it, we might be able to disrupt the spell."
    camera:
        ease 0.5 pos (1773, 2232) zpos -2340.0 
    show lyra 2d with dis
    lh "...Disrupt the spell? That sounds... very complicated."
    lh "How do we even start looking for something like that?"
    show sunburst 7a with dis
    camera:
        ease 0.5 pos (324, 2331) zpos -1197.
    sunburst "If I had my research materials—scrolls, books, even a simple parchment—I could start piecing it together."
    show moondancer onlayer uielements at charprotdisappear
    show charbox_overlay second_phase disappear onlayer uielements
    camera:
        easein 0.3 pos (207, 2331) zpos -1197.0
    show sunburst 1b with dis
    sunburst "In fact, I could also even ask for help!"
    camera:
        ease 0.5 pos (1665, 2232) zpos -2340.0
    show lyra 1b with dis
    lh "Wait, really? Then, what are we waiting for?"
    camera:
        ease 0.5 pos (207, 2331) zpos -1197.0
    show sunburst 2c with dis
    sunburst "...W-Well... I don't have anything at hoof that could be useful."
    play sound "sfx/embrarassed.wav"
    show sunburst 2d with dis
    sunburst "Besides, I'm more of a, well, scholar rather than a practitioner. I know the theory, but putting it into practice is another story."
    camera:
        ease 0.5 pos (1692, 2232) zpos -2340.0
    show lyra 1f with dis
    lh "Oh."
    camera:
        easein 0.3 pos (1269, 2187)  zpos -2754.0
    show silverstar 3a with dis
    silverstar "So if magic ain't workin', and brute force ain't it either, then what's left?"
    silverstar "Maybe we could be missing something, like a switch or a secret passage."
    camera:
        ease 0.5 pos (207, 2331) zpos -1197.0
    show sunburst 3b with dis
    sunburst "A secret exit would not make any sense. Our captors would be risking us discovering it!"
    camera:
        ease 0.5 pos (1665, 2232) zpos -2340.0
    show lyra 3b with dis
    lh "Wait! What if instead of finding a tunnel, we make our own!"
    camera:
        ease 0.5 pos (207, 2331) zpos -1197.0
    show sunburst 1f with dis
    sunburst "...Make our own tunnel?"
    stop music fadeout 1.0
    $ guiInfo.musictext_name = "null"
    show limestone 1a behind sunburst:
        subpixel True pos (-0.11, 2.04) zpos -1687.0
        alpha 0.0
        linear 0.3 alpha 1.0
    camera:
        easein 0.3 pos (-666, 2322) zpos -1836.0
    unknown "Hey, you! Move aside."
    camera:
        easein 0.3 pos (207, 2331) zpos -1197.0
    show sunburst 6a with dis
    play sound "sfx/surprise.wav"
    sunburst "Huh?"
    camera:
        easein 0.3 pos (-666, 2322) zpos -1836.0
    show limestone 1d with dis
    mdin "This mare's gaze... it's almost like she's staring through my soul."
    unknown "If magic's in the way, then I'll make my own exit."
    mdin "Brushing past us, she examined the barrier."
    camera:
        easein 0.3 pos (207, 2331) zpos -1197.0
    sunburst "H-Hold on, what are you-"
    camera:
        ease 0.5 pos (234, 2304) zpos -522.0
    mdin "And suddenly... She started digging."
    show charbox_overlay first_phase disappear onlayer uielements
    hide screen left_gui
    window hide
    $ renpy.pause(0.3)
    scene digging with black
    show light1 onlayer overlays:
        ease 0.5 alpha 0.0
    camera:
        subpixel True pos (0, 0) zpos 0.0 perspective False
    window hide
    $ renpy.pause(0.5)
    play music "Class Trial - Sun Edition (V3).ogg"
    $ guiInfo.musictext_name = "classtrial_sun"
    silverstarCG "Wow! Hold it there, lady!"
    $ renpy.start_predict("images/backgrounds/povdome/*.png")
    mdCGin "Her hooves moved like a blur, tearing into the ground with a speed and precision that left us all stunned."
    mdCGin "Dirt flew everywhere as she carved a tunnel deeper and deeper below the dome."
    play sound "sfx/pianoreaction.wav"
    sunburstCG "Agh! My cloak!"
    mdCGin "Her digging continued vigorously, with more dirt tossed on our way."
    mdCGin "For a moment, it felt like she might actually break through—like her sheer determination could overcome even the most impossible odds."
    mdCGin "But then... she stopped."
    unknownCG "Ugh! It's no use."
    window hide

label prologue_limestone:
    $ menu_flag = True
    scene black with fade
    $ renpy.pause(1.1)
    $ overlay_background = "images/backgrounds/povdome/charboxoverlay_domepov"
    camera:
        subpixel True pos (-666, 2322) zpos -1836.0 perspective True
    show hotel dome:
        subpixel True ypos (1.22) zpos -2790.0 zzoom True
    show limestone 1d:
        subpixel True pos (-0.11, 2.04) zpos -1687.0 alpha 0.0
        ease 0.5 alpha 1.0
    show light1 onlayer overlays:
        alpha 1.0
    $ renpy.pause(0.3)
    show screen left_gui
    show charbox_overlay first_phase appear onlayer uielements
    window show
    mdin "The mare jumped out of the tunnel she just made."
    show limestone 2b with dis
    unknown "There's some magical nonsense down there. I can't dig out of this dump."
    camera:
        easein 0.3 pos (207, 2331) zpos -1197.0
    show sunburst 1c with dis:
        subpixel True pos (0.34, 2.06) zpos -1048.0
    show silverstar 1f behind sunburst with dis:
        subpixel True pos (0.88, 1.95) zpos -2605.0
    show lyra 1f with dis:
        subpixel True pos (1.10, 1.95) zpos -2191.0
    sunburst "Wait, magical nonsense?"
    camera:
        easein 0.3 pos (-666, 2322) zpos -1836.0
    show limestone 3b with dis
    unknown "Uhh, yeah, magical nonsense? A magic barrier?"
    camera:
        easein 0.3 pos (207, 2331) zpos -1197.0
    show sunburst 5a with dis
    sunburst "Jeez, I get it."
    camera:
        ease 0.5 pos (1269, 2187) zpos -2754.0
    show silverstar 1b with dis
    silverstar "Well, I'll be! You've got some serious digging skills."
    silverstar "How did you manage to dig such a hole with your bare hooves, Ms..."
    show silverstar 1e with dis
    silverstar "..."
    show silverstar 1c with dis
    silverstar "Erm.. What do they call ya, again?"
    camera:
        ease 0.5 pos (-666, 2322) zpos -1836.0
    show limestone 5b with dis
    lp "Name's Limestone Pie. I've been dealing with dirt and rocks since I was a foal."
    # <INTRODUCTION:Limestone Pie>
    show charbox_overlay first_phase disappear onlayer uielements
    hide screen left_gui
    show sunburst:
        linear 0.5 alpha 0.0
    window auto hide
    pause 0.3
    play sound "audio/sfx/Intro_V3.mp3"
    show genericbackground behind limestone:
        matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.14)*SaturationMatrix(0.22)*BrightnessMatrix(0.07)*HueMatrix(261.0)
        subpixel True pos (-0.36, 2.16) zpos -1705.0
        alpha 0.0
        linear 0.5 alpha 1.0
    show light1 onlayer overlays:
        linear 0.5 alpha 0.0
    show light2 onlayer overlays:
        blend 'add'
        alpha 0.0
        linear 0.5 alpha 1.0
    pause 0.2
    show limestone:
        subpixel True xpos -0.11
        ease 0.5 xpos -0.33
    show ring behind limestone:
        subpixel True pos (0.14, 2.18) zpos -1809.0 alpha 0.22 blend 'add' 
        alpha 0.0
        linear 0.3 alpha 0.3
        zrotate 0.0
        linear 5.0 zrotate 620.0
    show cmlimestone behind limestone:
        subpixel True pos (0.14, 2.18) zpos -1809.0 alpha 0.22 blend 'add'
        alpha 0.0
        linear 0.3 alpha 0.3
    pause 0.1
    show introbars behind limestone:
        subpixel True pos (-0.32, 2.53) zpos -1764.0
        matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.0)*SaturationMatrix(0.8)*BrightnessMatrix(-0.21)*HueMatrix(765.0) 
        matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
        easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0)
    show intronamelimestone behind limestone:
        subpixel True pos (-0.32, 2.53) zpos -1764.0
        matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0) 
        easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
    pause 2.0
    show limestone:
        ease 0.5 xpos -0.11
    show ring behind limestone:
        linear 0.3 alpha 0.0
        zrotate 0.0
    show genericbackground behind limestone:
        linear 0.5 alpha 0.0
    show cmlimestone behind limestone:
        linear 0.3 alpha 0.0
    show sunburst:
        linear 0.5 alpha 1.0
    show light1 onlayer overlays:
        linear 0.5 alpha 1.0
    show light2 onlayer overlays:
        linear 0.5 alpha 0.0
    pause 0.6
    hide ring
    hide introbars
    hide intronamelimestone
    hide genericbackground
    hide cmlimestone
    window auto show
    show charbox_overlay first_phase appear onlayer uielements
    show screen left_gui
    camera:
        ease 0.5 pos (1269, 2187) zpos -2754.0
    show silverstar 2a with dis
    silverstar "Well now, reckon it's mighty nice meetin' ya, Limestone."
    silverstar "Gotta say, your skills are somethin' else!"
    camera:
        ease 0.5 pos (207, 2331) zpos -1197.0
    show sunburst 5b with dis
    sunburst "Yeah! Even if they might be a bit... messy, maybe they can help with something else."
    camera:
        ease 0.3 pos (-666, 2322) zpos -1836.0
    show limestone 1b with dis
    stop music fadeout 1.0
    $ guiInfo.musictext_name = "null"
    lp "Don't get too cozy. I'm out of here the moment I find a way."
    camera:
        easein 0.3 pos (207, 2331) zpos -1197.0
    show sunburst 1d with dis
    sunburst "...Huh? I was just saying that with our combined efforts, we could get out of here."
    camera:
        easein 0.3 pos (-666, 2322) zpos -1836.0
    show limestone 2c with dis
    play music "Class Trial - Resurrection (V3).ogg"
    $ guiInfo.musictext_name = "classtrial_resurrection"
    lp "What? You expect me to cooperate?"
    show limestone 1g with Dissolve(0.1)
    lp "As if I'm going to trust anypony here."
    camera:
        easein 0.3 pos (207, 2331) zpos -1197.0
    show sunburst 1g with dis
    sunburst "Then what's your plan? You just saw that there's no way out!"
    camera:
        easein 0.3 pos (-666, 2322) zpos -1836.0
    show limestone 1e with dis
    lp "I know what I saw! Don't need to remind me of the obvious."
    show limestone 1d with dis
    lp "One of you could be the one behind all of this, so don't come any closer."
    camera:
        easein 0.3 pos (207, 2331) zpos -1197.0
    show sunburst 1f with dis
    show lyra 1f with dis
    sunburst "..."
    camera:
        ease 0.5 pos (1269, 2187) zpos -2754.0
    show silverstar 1f with dis
    silverstar "..."
    camera:
        easein 0.3 xpos 1395
    show moondancer 1e onlayer uielements at charprotappear
    show charbox_overlay second_phase appear onlayer uielements
    md "..."
    camera:
        easein 0.3 pos (1809, 2232) zpos -2340.0
    lh "..."
    show lyra 1g with dis
    show moondancer onlayer uielements at charprotdisappear
    show charbox_overlay second_phase disappear onlayer uielements
    camera:
        easein 0.3 pos (1665, 2232) zpos -2340.0
    lh "...Then, what are you planning to do? Avoid everpony?"
    camera:
        ease 0.5 pos (-666, 2322) zpos -1836.0
    show limestone 1c with dis
    lp "Of course! Any problem with that?"
    camera:
        ease 0.5 pos (1665, 2232) zpos -2340.0
    show lyra 1g with dis
    lh "But why?"
    lh "Everyone has been confused and scared since we got here. Instead of avoiding others, we should be helping each other instead!"
    camera:
        ease 0.5 pos (-666, 2322) zpos -1836.0
    show limestone 3a with dis
    lp "..."
    lp "Fine. If you're so persistent in trusting each other, then let me ask you a question."
    show limestone 2b with dis
    lp "What would you do if you were taken away from your family, and you then wake up in some weird dome in the middle of nowhere with a bunch of ponies you don't even know?"
    lp "Your family needs you, but you don't know if you'll ever see them again. They will think you're dead, too."
    lp "So, what do you do?"
    show limestone 5a with dis
    lp "Will you trust the strangers, even if they might be the reason you were kidnapped in the first place?"
    show limestone 5b with dis
    lp "Or will you protect yourself and not trust anypony?"
    camera:
        ease 0.5 pos (1665, 2232) zpos -2340.0
    show lyra 5b with dis
    lh "..."
    camera:
        easein 0.3 pos (1269, 2187) zpos -2754.
    show silverstar 1g with dis
    silverstar "..."
    camera:
        ease 0.5 pos (207, 2331) zpos -1197.0
    show sunburst 2d with dis
    sunburst "..."
    mdin "At Limestone's question, everyone fell dead silent."
    mdin "I remembered everypony who was waiting for me at home. My sister, the librarians, my friends..."
    mdin "...I think I started to understand now."
    camera:
        easein 0.3 pos (-666, 2322) zpos -1836.0
    show limestone 1a with dis
    lp "..."
    show limestone 2b with dis
    stop music fadeout 1.0
    $ guiInfo.musictext_name = "null"
    lp "See what I mean now? Trust is naive in this situation."
    camera:
        ease 0.5 pos (1665, 2232) zpos -2340.0
    lh "..."
    lh "..."
    camera:
        ease 0.5 pos (-666, 2322) zpos -1836.0
    show limestone 1g with dis
    lp "Tch, I thought so. If nopony has anything else to say, I'm leaving."
    show limestone 3c with dis
    lp "Have fun getting along or whatever."
    show limestone:
        linear 0.3 alpha 0.0
    $ renpy.pause(0.3)
    hide limestone
    camera:
        ease 0.5 pos (1665, 2232) zpos -2340.0
    show lyra 5c with dis
    lh "..."
    show lyra 1f with dis
    lh "Limestone, wait!"
    mdin "Limestone turned her back and left without saying a word."
    mdin "For her harsh exterior and rough temper... Maybe it's for the best that she left us alone."
    lh "..."
    show lyra 5b with dis
    lh "..."
    camera:
        ease 0.5 pos (207, 2331) zpos -1197.0
    show sunburst 5a with dis
    sunburst "She's... very scary, not gonna lie."
    camera:
        easein 0.5 pos (1269, 2187) zpos -2754.
    show silverstar 1d with dis
    silverstar "Miss Limestone's probably just wound up a bit."
    silverstar "Ain't no pony gets riled up without a reason. Might be we just need to give her some room."
    camera:
        ease 0.5 pos (207, 2331) zpos -1197.0
    show sunburst 1c with dis
    sunburst "I get that's the case, but still!"
    camera:
        easein 0.5 pos (1269, 2187) zpos -2754.
    show silverstar 4a with dis
    play sound 'audio/sfx/surprise.wav'
    silverstar "And y'all heard what she said, didn't ya? There's a chance one of us might be mixed up in this mess."
    camera:
        easein 0.3 pos (1386, 2187) zpos -2754.
    show moondancer 2b onlayer uielements at charprotappear
    show charbox_overlay second_phase appear onlayer uielements
    md "About one of us being the ones behind this, that's what Limestone said..."
    show moondancer 4a onlayer uielements with disalt
    md "For some reason, that makes so much sense!"
    camera:
        easein 0.3 pos (1807, 2232) zpos -2340.0
    show lyra 2d with dis
    play sound 'audio/sfx/shock.wav'
    lh" Moondancer... You don't think there's a traitor, do you?"
    show moondancer 5b onlayer uielements with disalt
    md "Well, it's a possible explanation."
    md "Kidnapping so many ponies would take a lot of planning—and it's a job for more than one single pony."
    camera:
        easein 0.3 pos (1386, 2187) zpos -2754.
    show silverstar 3a with dis
    silverstar "I agree. Having a mole might also be a way to keep us in check."
    silverstar "I mean, there's only so much you can catch in the shadows. A mole can provide specific information about each of us by interactin'."
    camera:
        ease 0.5 pos (324, 2331) zpos -1197.0
    show sunburst 1b with dis
    sunburst "..."
    camera:
        easein 0.3 pos (207, 2331) zpos -1197.0
    show sunburst 1f with dis
    show moondancer onlayer uielements at charprotdisappear
    show charbox_overlay second_phase disappear onlayer uielements
    sunburst "A traitor? I'm sorry, but that doesn't make any sense."
    show sunburst 1e with dis
    sunburst "Wouldn't they risk exposing themselves by interacting with us?"
    sunburst "We would notice if somepony is acting suspicious, or if they're communicating with our captor."
    show sunburst 3b with dis
    sunburst "It's too risky, and honestly, I don't see the point of one of us being the culprit."
    camera:
        ease 0.5 pos (1665, 2232) zpos -2340.0
    show lyra 1h with dis
    lh "...I agree with Sunburst, it's really hard to believe!"
    play music "Climax Reasoning (V3).ogg"
    $ guiInfo.musictext_name = "climaxreasoning"
    lh "I think most of us here are innocent. We don't have a reason to doubt each other yet!"
    camera:
        easein 0.3 pos (1809, 2232) zpos -2340.0
    show moondancer 4b onlayer uielements at charprotappear
    show charbox_overlay second_phase appear onlayer uielements
    md "I get what you're saying, but we can't rule it out entirely."
    show moondancer 1e with dis
    md "Right now, the only thing we can do is consider every possibility, no matter how unlikely."
    md "Our best option at the moment is to keep investigating. Any intel we gather might make a difference."
    camera:
        ease 0.5 pos (324, 2331) zpos -1197.0
    show sunburst 2e with dis
    sunburst "Oh, I guess that's fair."
    show sunburst 4a with dis
    sunburst "I guess there's nothing left to see here, right?"
    show moondancer 1b onlayer uielements with disalt
    md "I don't think so. We already learned everything we need to know about the dome."
    camera:
        ease 0.5 pos (207, 2331) zpos -1197.0
    show sunburst 7a with dis
    show moondancer onlayer uielements at charprotdisappear
    show charbox_overlay second_phase disappear onlayer uielements
    sunburst "Very well then. I'll move forward with my investigation. Hopefully, I'll find something useful."
    camera:
        easein 0.3 pos (1269, 2187) zpos -2754.
    show silverstar 1b with dis
    $ renpy.start_predict("images/backgrounds/povhotel/*.png")
    silverstar "Same here. Don't know what else I'll find, but I'll be darn sure to do my best."
    camera:
        ease 0.5 pos (207, 2331) zpos -1197.0
    show sunburst 3a with dis
    sunburst "Maybe we should meet up later to report what we've discovered?"
    camera:
        easein 0.3 pos (1269, 2187) zpos -2754.
    show silverstar 1a with dis
    silverstar "That's a mighty good idea. It was nice to meet you. Take care, will ya?"
    camera:
        ease 0.5 pos (207, 2331) zpos -1197.0
    show sunburst 1h with dis
    sunburst "I'll... see you guys soon."
    hide silverstar
    show sunburst at chardisappear
    mdin "Silverstar and Sunburst parted ways, leaving us on our own."
    hide sunburst
    camera:
        easein 0.3 pos (1665, 2232) zpos -2340.0
    show lyra 1g with dis
    lh "..."
    camera:
        easein 0.3 pos (1809, 2232) zpos -2340.0
    show moondancer 1n onlayer uielements at charprotappear
    show charbox_overlay full_phase appear onlayer uielements
    md "Alright, let's move on."
    show lyra 5b with dis
    lh "..."
    show lyra 5c with dis
    lh "Oh, right."
    lh "So, where do we go next, Moondancer? Should we check inside the hotel?"
    mdin "It would be an obvious choice to check the sole building in here."
    mdin "But something about it felt wrong, like a trap we were meant to fall for."
    mdin "While I couldn't explain my reasoning, I think it's for the best that we avoid it."
    show moondancer 2a onlayer uielements with disalt
    md "Honestly, I don't trust it. I think we're better off checking anything else."
    show lyra 1f with dis
    lh "Really? Why?"
    show moondancer 2b onlayer uielements with disalt
    md "Look, I don't know how to explain it, I just..."
    show moondancer 1e onlayer uielements with disalt
    md "Let's just keep looking outside, okay?"
    lh "..."
    show moondancer onlayer uielements at charprotdisappear
    show charbox_overlay second_phase disappear onlayer uielements
    camera:
        easein 0.3 pos (1665, 2232) zpos -2340.0
    show lyra 1i with dis
    lh "Right."
    show charbox_overlay first_phase disappear onlayer uielements
    window hide
    hide screen left_gui
    $ renpy.pause (0.5)
    show light1 onlayer overlays:
        linear 0.5 alpha 0.0
    scene black with black
    camera:
        subpixel True pos (0, 0) zpos 0.0 perspective False
    window hide
    $ renpy.pause(0.5)
    mdCGin "Lyra and I walked behind the hotel. We only stumbled upon a set of bushes and foliage."
label prologue_babs:
    $ menu_flag = True
    $ overlay_background = "images/backgrounds/povhotelback/charboxoverlay_hotelbackpov"
    $ renpy.pause(1.0)
    camera:
        subpixel True pos (0, 0) zpos 0.0 perspective False
    window hide
    show hotel back with dis:
        subpixel True pos (0, 1.22) zpos -2790.0 zzoom True
    show light1 onlayer overlays:
        alpha 1.0
        matrixcolor SaturationMatrix(1.0)*HueMatrix(162.0) 
        blend 'add'
    camera:
        subpixel True pos (-621, 2403) zpos -1449.0 perspective True
    show lyra 6a:
        subpixel True pos (-0.11, 2.11) zpos -1300.0 alpha 0.0
        linear 0.3 alpha 1.0
    $ renpy.pause(0.5)
    show screen left_gui
    show charbox_overlay first_phase appear onlayer uielements
    window show

    lh "Doesn't look like there's much to see here."
    md "Maybe, but there's only one way to know for sure. Let's look around."
    window hide
    camera:
        ease 0.5 pos (-326, 2241) zpos -198.0

    screen Investigation2():
            
        key "K_RETURN" action ToggleVariable("image_visible", True, False)

        add "vent_label" xpos 886 + cam_x(-0.33) ypos -27 + cam_y(-0.33) alpha If(image_visible, 1.0, 0.0)

        add "bush_label" xpos 140 + cam_x(-0.34) ypos 397 + cam_y(-0.33) alpha If(image_visible, 1.0, 0.0)

        add "foliage_label" xpos 110 + cam_x(-0.34) ypos 197 + cam_y(-0.33) alpha If(image_visible, 1.0, 0.0)

        add "lyra_label" xpos 610 + cam_x(-0.54) ypos 205 + cam_y(-0.55) alpha If(image_visible, 1.0, 0.0)
        
        imagebutton:
            
            xpos 22 + cam_x(-0.33) ypos 367 + cam_y(-0.33)
            
            auto "images/ui/foliageButton_%s.png" action [ToggleScreen("Investigation2"), Jump("foliageButtonDialouge")]

        imagebutton:
            
            xpos 170 + cam_x(-0.33) ypos 637 + cam_y(-0.33)
            
            auto "images/ui/bushButton_%s.png" action [ToggleScreen("Investigation2"), Jump("bushButtonDialouge")]
            
        imagebutton:
            
            xpos 1013 + cam_x(-0.34) ypos 50 + cam_y(-0.33)
            
            auto "images/ui/ventButton_%s.png" action [ToggleScreen("Investigation2"), Jump("ventButtonDialouge")]

        imagebutton:
            
            xpos 685 + cam_x(-0.54) ypos 410 + cam_y(-0.55)
            
            auto "images/ui/lyraButton2_%s.png" action [ToggleScreen("Investigation2"), Jump("lyraButton2Dialouge")]
            
    default lyraCheck2 = False
    default ventCheck = False
    default bushCheck = False
    default foliageCheck = False
    $ menu_flag = True
    
label debug_investigationContinue2:
    if lyraCheck2 == False or ventCheck == False or bushCheck == False or foliageCheck == False:
        $ restore_master_layer(0.2)
        camera:
            easein 0.5 pos (-326, 2241) zpos -198.0
    
        $ set_camera_pan(True, max_x=440, max_y=200)
        
        call screen Investigation2

label lyraButton2Dialouge:

    if lyraCheck2 == False or ventCheck == False or bushCheck == False or foliageCheck == False:
        pause (0.5)
        $ save_master_layer_position()
    
        $ reset_master_layer(0.108)
        camera:
            easein 0.3 pos (-621, 2403) zpos -1449.0
        play sound "sfx/tabopen.wav"
        pause (0.2)
        $ set_camera_pan(False)
        show lyra 5b with dis
        lh "..."
        show moondancer 5a onlayer uielements at charprotappear
        show charbox_overlay second_phase appear onlayer uielements
        camera:
            easein 0.3 pos (-504, 2403) zpos -1449.0
        md "Lyra? Are you ok?"
        show lyra 1e with dis
        lh "Huh? Oh, yeah, I'm fine..."
        mdin "What's with her?"
        show moondancer 5a onlayer uielements at charprotdisappear
        show charbox_overlay second_phase disappear onlayer uielements
        $ lyraCheck2 = True

        jump debug_investigationContinue2
    
label ventButtonDialouge:
    if lyraCheck2 == False or ventCheck == False or bushCheck == False or foliageCheck == False:
        pause (0.5)
        $ save_master_layer_position()
        $ reset_master_layer(0.108)
        camera:
            ease 0.5 pos (-153, 1008) zpos -2187.0
        play sound "sfx/tabopen.wav"
        pause (0.2)
        $ set_camera_pan(False)

        if ventCheck == True:
            show moondancer 1b onlayer uielements at charprotappear
            show charbox_overlay second_phase appear onlayer uielements
            md "Looks like Sky was right, it's way too small for either of us to crawl through. Sorry, Lyra."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 3a with dis
            lh "They make it look so much easier in the movies..."
            show moondancer 1b onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements

        if ventCheck == False:
            show lyra 3b with dis
            lh "Ooh, a vent! You think we can get inside through there?"
            show moondancer 1b onlayer uielements at charprotappear
            show charbox_overlay second_phase appear onlayer uielements
            md "I'd rather we go in through the door..."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 2b with dis
            lh "Aw, c'mon, we could crawl through like a sneaky secret agent, or a cool action hero, or a shifty alien monster ready to strike some poor engineer fixing wires!"
            ##BACK OF THE HOTEL
            show moondancer 1f onlayer uielements with disalt
            md "I think you've been watching too many movies, Lyra."
            mdin "Still, the cover looks loose enough, if I pulled hard enough..."
            show sky 2a behind lyra with dis:
                subpixel True pos (0.85, 2.11) zpos -2092.0
            unknown "I wouldn't bother."
            stop music
            $ guiInfo.musictext_name = "null"
            show moondancer 3a onlayer uielements with disalt
            play sound "sfx/surprise.wav"
            md "Huh?"
            ##<Zoom back out>
            show moondancer 3a onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements
            camera:
                easein 0.3 pos (326, 2241) zpos -198.0
            #<Enter Sky>
            unknown "Trying to open the vent, are you?"
            show lyra 2a with dis
            camera:
                easein 0.3 pos (-621, 2403) zpos -1449.0
            lh "Yeah! Um...who are you?"
            show sky 1e with dis
            camera:
                ease 0.3 pos (0.60, 2.21) zpos -2241.0
            unknown "The name is Sky Stinger, fastest flier you'll ever meet."
            #<INTRODUCTION: Sky Stinger>
            show charbox_overlay first_phase disappear onlayer uielements
            hide screen left_gui
            show lyra:
                linear 0.5 alpha 0.0
            window auto hide
            pause 0.3
            play sound "audio/sfx/Intro_V3.mp3"
            show genericbackground behind sky:
                matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.14)*SaturationMatrix(0.51)*BrightnessMatrix(0.07)*HueMatrix(324.0) 
                subpixel True pos (0.56, 2.23) zpos -2043.0
                alpha 0.0
                linear 0.5 alpha 1.0
            show light1 onlayer overlays:
                linear 0.5 alpha 0.0
            show light2 onlayer overlays:
                blend 'add'
                alpha 0.0
                linear 0.5 alpha 1.0
            pause 0.2
            show sky:
                subpixel True xpos 0.85
                ease 0.5 xpos 0.63
            show ring behind sky:
                subpixel True pos (1.06, 2.25) zpos -2243.0 alpha 0.22 blend 'add' 
                alpha 0.0
                linear 0.3 alpha 0.3
                zrotate 0.0
                linear 5.0 zrotate 620.0
            show cmsky behind sky:
                subpixel True pos (1.06, 2.25) zpos -2243.0 alpha 0.22 blend 'add' 
                alpha 0.0
                linear 0.3 alpha 0.3
            pause 0.1
            show introbars behind sky:
                subpixel True pos (0.53, 2.60) zpos -1955.0
                matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.84)*SaturationMatrix(0.54)*BrightnessMatrix(-0.28)*HueMatrix(1179.0)  
                matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
                easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0)
            show intronamesky behind sky:
                subpixel True pos (0.53, 2.60) zpos -1955.0
                matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0) 
                easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
            pause 2.0
            show sky:
                ease 0.5 xpos 0.85
            show ring behind sky:
                linear 0.3 alpha 0.0
                zrotate 0.0
            show genericbackground behind sky:
                linear 0.5 alpha 0.0
            show light1 onlayer overlays:
                linear 0.5 alpha 1.0
            show light2 onlayer overlays:
                linear 0.5 alpha 0.0
            show cmsky behind sky:
                linear 0.3 alpha 0.0
            show lyra:
                linear 0.5 alpha 1.0
            pause 0.6
            hide ring
            hide introbars
            hide intronamesky
            hide genericbackground
            hide cmsky
            window auto show
            show charbox_overlay first_phase appear onlayer uielements
            show screen left_gui
            show sky 1c with dis
            play music "Climax Reasoning (V3).ogg"
            $ guiInfo.musictext_name = "climaxreasoning"
            sky "Anyway, we already opened the vent to try and get inside. Unfortunately, it's too small, only a foal could slip through."
            camera:
                easein 0.3 pos (-621, 2403) zpos -1449.0
            show lyra 5a with dis
            lh "Aww..."
            show lyra 3a with dis
            lh "Wait, 'we'?"
            camera:
                ease 0.3 pos (0.60, 2.21) zpos -2241.0
            show sky 2a with dis
            sky "Hold on, where is she? C'mon, introduce yourself!"

            #<Enter Vapor>
            show vapor 1a behind sky with dis:
                subpixel True pos (1.29, 2.11) zpos -2074.0
            camera:
                easein 0.3 pos (1.05, 2.22) zpos -2174.0
            unknown "..."

            mdin "She's a lot shier compared to Sky..."

            unknown "Um, I'm Vapor Trail... Nice to meet you."

            #<INTRODUCTION: Vapor Trail>
            show charbox_overlay first_phase disappear onlayer uielements
            hide screen left_gui
            show sky:
                linear 0.5 alpha 0.0
            window auto hide
            pause 0.3
            play sound "audio/sfx/Intro_V3.mp3"
            show genericbackground behind vapor:
                matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.14)*SaturationMatrix(0.74)*BrightnessMatrix(0.07)*HueMatrix(315.0) 
                subpixel True pos (1.05, 2.23) zpos -2092.0
                alpha 0.0
                linear 0.5 alpha 1.0
            show light1 onlayer overlays:
                linear 0.5 alpha 0.0
            show light2 onlayer overlays:
                blend 'add'
                alpha 0.0
                linear 0.5 alpha 1.0
            pause 0.2
            show vapor:
                subpixel True xpos 1.29
                ease 0.5 xpos 1.07
            show ring behind vapor:
                subpixel True pos (1.50, 2.25) zpos -2196.0 alpha 0.22 blend 'add' 
                alpha 0.0
                linear 0.3 alpha 0.3
                zrotate 0.0
                linear 5.0 zrotate 620.0
            show cmvapor behind vapor:
                subpixel True pos (1.50, 2.25) zpos -2196.0 alpha 0.22 blend 'add' 
                alpha 0.0
                linear 0.3 alpha 0.3
            pause 0.1
            show introbars behind vapor:
                subpixel True pos (1.06, 2.60) zpos -2151.0
                matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.84)*SaturationMatrix(0.54)*BrightnessMatrix(-0.28)*HueMatrix(1215.0)
                matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
                easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0)
            show intronamevapor behind vapor:
                subpixel True pos (1.06, 2.60) zpos -2151.0
                matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0) 
                easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
            pause 2.0
            show vapor:
                ease 0.5 xpos 1.29
            show ring behind vapor:
                linear 0.3 alpha 0.0
                zrotate 0.0
            show genericbackground behind vapor:
                linear 0.5 alpha 0.0
            show light1 onlayer overlays:
                linear 0.5 alpha 1.0
            show light2 onlayer overlays:
                linear 0.5 alpha 0.0
            show cmvapor behind vapor:
                linear 0.3 alpha 0.0
            show sky:
                linear 0.5 alpha 1.0
            pause 0.6
            hide ring
            hide introbars
            hide intronamevapor
            hide genericbackground
            hide cmvapor
            window auto show
            show charbox_overlay first_phase appear onlayer uielements
            show screen left_gui
            camera:
                easein 0.3 pos (0.60, 2.21) zpos -2241.0
            show sky 4c with dis
            sky "She's my wing-pony, probably the best wing-pony ever, too!"
            camera:
                easein 0.3 pos (-621, 2403) zpos -1449.0
            show lyra 3b with dis
            lh "Nice to meet you! I'm Lyra, and this is my friend Moondancer!"
            camera:
                ease 0.3 pos (0.60, 2.21) zpos -2241.0
            sky "Great! So, what were you two doing?"
            show moondancer 1e onlayer uielements at charprotappear
            show charbox_overlay second_phase appear onlayer uielements
            camera:
                ease 0.3 pos (0.67, 2.21) zpos -2241.0
            md "We were looking around this mysterious place. Maybe we could find a way inside this building."
            show sky 1h with dis
            sky "A way in!? Why? We should be looking for a way to bust out of this place!"
            show moondancer 4b onlayer uielements with disalt
            md "I agree, but that dome is tough, none of our unicorn magic works, and even the earth ponies we met couldn't put a crack into it."
            show sky 1e with dis
            sky "Well, good thing I'm not a unicorn or earth pony, then!"
            show moondancer 1k onlayer uielements with disalt
            play sound "sfx/dramatic.wav"
            md "That's... not what I meant."
            show sky 3b with dis
            sky "Hey! We pegasi have to soar through the sky, not be trapped in... whatever this is!"
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 3c with dis
            lh "Really? But it seems like there's enough room to fly in here."
            camera:
                ease 0.3 pos (0.67, 2.21) zpos -2241.0
            show sky 4a with dis
            play sound "sfx/shock.wav"
            sky "You did NOT just say that."
            sky "Just look at that wide open sky! We're missing out if we're trapped in here!"
            md "So, what do you plan on doing?"
            show sky 4f with dis
            sky "I'm gonna build up as much speed as I can and smash through the glass to get us all free!"
            camera:
                easein 0.3 pos (1.12, 2.22) zpos -2174.0
            show vapor 1d with dis
            play sound "sfx/surprise.wav"
            vt "Sky, no! You already ran into the glass three times already! Flying any faster into it is just going to get you hurt!"
            camera:
                ease 0.3 pos (0.67, 2.21) zpos -2241.0
            sky "That's why you're here, Vapey! All I need is for you to give me a little boost!"
            camera:
                easein 0.3 pos (1.12, 2.22) zpos -2174.0
            show vapor 2a with dis
            vt "But... I...!"
            camera:
                ease 0.3 pos (0.67, 2.21) zpos -2241.0
            show sky 4a with dis
            sky "Look, we gotta get out of here ASAP, I don't want whoever trapped us in here hurting you!"
            camera:
                easein 0.3 pos (1.12, 2.22) zpos -2174.0
            show vapor 2a with dis
            play sound "sfx/surprise.wav"
            vt "But what worries me is *you* getting hurt, Sky!"
            camera:
                ease 0.3 pos (0.67, 2.21) zpos -2241.0
            show sky 1i with dis
            sky "..."
            camera:
                easein 0.3 pos (1.12, 2.22) zpos -2174.0
            show vapor 2b with dis
            vt "I'm just... I'm really scared, and I don't want anything to happen to you..."
            mdin "These two definitely have some history together. I think they're more than just friends."
            camera:
                ease 0.3 pos (0.67, 2.21) zpos -2241.0
            show sky 5c with dis
            sky "..."
            play sound "sfx/embrarassed.wav"
            sky "...Alright, Vapey, you win..."
            camera:
                easein 0.3 pos (1.12, 2.22) zpos -2174.0
            show vapor 2f with dis
            vt "...Thank you, Sky."
            camera:
                ease 0.3 pos (0.67, 2.21) zpos -2241.0
            show sky 5b with dis
            sky "I just... wish we didn't have to deal with this right now."
            camera:
                easein 0.3 pos (1.12, 2.22) zpos -2174.0
            show vapor 3b with dis
            vt "Yeah, we had a really important training session for the Wonderbolts today."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 3a with dis
            lh "Wait, are you guys Wonderbolts?!"
            camera:
                ease 0.3 pos (0.67, 2.21) zpos -2241.0
            show sky 4c with dis
            sky "Ha! We practically are!"
            camera:
                easein 0.3 pos (1.12, 2.22) zpos -2174.0
            show vapor 4a with dis
            play sound "sfx/dramatichigher.wav"
            vt "...We're just trainees."
            camera:
                ease 0.3 pos (0.67, 2.21) zpos -2241.0
            show sky 1f with dis
            sky "Come on, where's your confidence?"
            camera:
                easein 0.3 pos (1.12, 2.22) zpos -2174.0
            show vapor 4c with dis
            vt "Um, I mean... We're on our way to become full-fledged Wonderbolts!"
            camera:
                ease 0.3 pos (0.67, 2.21) zpos -2241.0
            show sky 4c with dis
            sky "Great! That's my Vapey~"
            camera:
                easein 0.3 pos (1.12, 2.22) zpos -2174.0
            show vapor 1g with dis
            vt "..."
            mdin "Wow. She's blushing pretty hard."
            show vapor 3a with dis
            vt "I hope we find a way out soon."
            vt "Spitfire might think we're slacking off... but that's not true! We've been working really hard the past few months!"
            camera:
                ease 0.3 pos (0.67, 2.21) zpos -2241.0
            show sky 3a with dis
            sky "Well, not like we can do much just sitting around. We should keep looking around. Maybe we'll find something this time."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            lh "Is there anything up there worth investigating?"
            camera:
                easein 0.3 pos (1.12, 2.22) zpos -2174.0
            show vapor 1b with dis
            vt "Not really. There's not much up high to report about. There aren't even any clouds in here."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 5f with dis
            lh "Oh."
            show moondancer 2a onlayer uielements with disalt
            md "Regardless, please let us know if you find anything else."
            md "We'll continue investigating down here."
            camera:
                easein 0.3 pos (1.12, 2.22) zpos -2174.0
            show vapor 4d with dis
            vt "Got it, it was nice meeting you!"
            camera:
                ease 0.3 pos (0.67, 2.21) zpos -2241.0
            show sky 4c with dis
            sky "Good luck!"
            #<Sky and Vapor leave>
            show vapor at chardisappear
            show sky at chardisappear
            mdin "They flew away."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 1d with dis
            lh "Well, it's nice that those two have each other's backs to help investigate, wouldn't you agree, Moondancer?"
            show moondancer 5c onlayer uielements with disalt
            md "Huh? Oh, yeah, I guess."
            show lyra 5d with dis
            lh "..."
            if ventCheck == False:
                window auto hide
                show silhouette behind lyra with dis:
                    subpixel True blur 20.0 zrotate 81.0 
                    pos (-0.46, 1.37) zpos -3631.0 
                    linear 0.5 pos (1.03, 1.20) zpos -2452.0 
                $ renpy.pause(0.5)
                show silhouette:
                    alpha 1.0
                    linear 0.3 alpha 0.0
                $ renpy.pause (0.5)
                window auto show
                show moondancer 3a onlayer uielements with disalt
                md "...!"
                mdin "What was that...?"
                md "Lyra! Did you see that?"
                show lyra 2a with dis
                lh "See what?"
                md "Some sort of black blur that just went past!"
                lh "I didn't see anything like that."
                show moondancer 1o onlayer uielements with disalt
                md "...Nevermind, I must have imagined it."
                show moondancer 1o onlayer uielements at charprotdisappear
                show charbox_overlay second_phase disappear onlayer uielements
                $ ventCheck = True

        

        jump debug_investigationContinue2


label foliageButtonDialouge:

    if lyraCheck2 == False or ventCheck == False or bushCheck == False or foliageCheck == False:
        pause (0.5)
        $ save_master_layer_position()
        $ reset_master_layer(0.108)
        play sound "sfx/tabopen.wav"
        pause (0.2)
        $ set_camera_pan(False)
        
        if foliageCheck == True:
            camera:
                easein 0.3 pos (-621, 2403) zpos -1449.0
            show lyra 1f with dis
            lh "Neighagra Falls, huh?"
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show moondancer 4b onlayer uielements at charprotappear
            show charbox_overlay second_phase appear onlayer uielements
            md "I wouldn’t take his claim so seriously, Lyra. There’s a good chance he was just remembering a time he went to Neighagra Falls and took a nap under a tree."
            show moondancer 4b onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements


        if foliageCheck == False:
            show moondancer 1c onlayer uielements at charprotappear
            show charbox_overlay second_phase appear onlayer uielements
            md "Hm..."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 3a with dis
            lh "I don't get it, it's just some trees, is there really something important here?"

            md "I think it's worth checking out."

            lh "You think there's some sort of button hidden in the trunk that leads to a secret entrance?"
            show moondancer 1f onlayer uielements with disalt

            md "Lyra, that's not what I-"
            show zephyr 1b behind lyra with dis:
                subpixel True pos (0.1, 2.11) zpos -2020.0
            play sound "sfx/thud.wav"
            stop music
            $ guiInfo.musictext_name = "null"
            unknown "Hey-hey! What's the commotion over there?"
            #<Enter Zephyr>
            camera:
                easein 0.3 pos (-151, 2331) zpos -2169.0
            mdin "Where did this guy even come from?"
            mdin "He looks way too carefree and relaxed considering we're all trapped in here..."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            play music "OUTLAW RUNNER.ogg"
            $ guiInfo.musictext_name = "outlawrunner"
            lh "Huh?"
            camera:
                easein 0.3 pos (-151, 2331) zpos -2169.0
            show zephyr 1a with dis
            unknown "Weren't you girls arguing about something?"
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 2b with dis

            lh "We were just... talking about our situation, we're fine."
            camera:
                easein 0.3 pos (-151, 2331) zpos -2169.0
            show zephyr 4a with dis
            unknown "Oh."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 1h with dis
            lh "..."
            show moondancer 1c onlayer uielements with disalt
            md "..."
            camera:
                easein 0.3 pos (-268, 2331) zpos -2169.0
            show moondancer 1c onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements
            show zephyr 3b with dis
            unknown "Ah, how rude of me! I forgot to introduce myself."
            show zephyr 5a with dis
            unknown "The name is Zephyr Breeze, don't forget, kay?"

            #<INTRODUCTION: Zephyr Breeze>
            show charbox_overlay first_phase disappear onlayer uielements
            hide screen left_gui
            show lyra:
                linear 0.5 alpha 0.0
            window auto hide
            pause 0.3
            play sound "audio/sfx/Intro_V3.mp3"
            show genericbackground behind zephyr:
                matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.14)*SaturationMatrix(0.74)*BrightnessMatrix(0.07)*HueMatrix(315.0) 
                subpixel True pos (-0.15, 2.18) zpos -2038.0
                alpha 0.0
                linear 0.5 alpha 1.0
            show light1 onlayer overlays:
                linear 0.5 alpha 0.0
            show light2 onlayer overlays:
                blend 'add'
                alpha 0.0
                linear 0.5 alpha 1.0
            pause 0.2
            show zephyr:
                subpixel True xpos 0.10
                ease 0.5 xpos -0.12
            show ring behind zephyr:
                subpixel True pos (0.35, 2.20) zpos -2038.0 alpha 0.22 blend 'add'
                alpha 0.0
                linear 0.3 alpha 0.3
                zrotate 0.0
                linear 5.0 zrotate 620.0
            show cmzephyr behind zephyr:
                subpixel True pos (0.35, 2.20) zpos -2038.0 alpha 0.22 blend 'add'
                alpha 0.0
                linear 0.3 alpha 0.3
            pause 0.1
            show introbars behind zephyr:
                subpixel True pos (-0.11, 2.55) zpos -2097.0
                matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.84)*SaturationMatrix(0.54)*BrightnessMatrix(-0.28)*HueMatrix(1215.0)
                matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
                easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0)
            show intronamezephyr behind zephyr:
                subpixel True pos (-0.11, 2.55) zpos -2097.0
                matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0) 
                easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
            pause 2.0
            show zephyr:
                ease 0.5 xpos 0.10
            show ring behind zephyr:
                linear 0.3 alpha 0.0
                zrotate 0.0
            show genericbackground behind zephyr:
                linear 0.5 alpha 0.0
            show light1 onlayer overlays:
                linear 0.5 alpha 1.0
            show light2 onlayer overlays:
                linear 0.5 alpha 0.0
            show cmzephyr behind zephyr:
                linear 0.3 alpha 0.0
            show lyra:
                linear 0.5 alpha 1.0
            pause 0.6
            hide ring
            hide introbars
            hide intronamezephyr
            hide genericbackground
            hide cmzephyr
            window auto show
            show charbox_overlay first_phase appear onlayer uielements
            show screen left_gui
            zb "So, what are you girls doing?"
            camera:
                easein 0.3 pos (-621, 2403) zpos -1449.0
            show lyra 2a with dis
            lh "I guess we were just investigating this place."
            camera:
                easein 0.3 pos (-268, 2331) zpos -2169.0
            show zephyr 3a with dis
            zb "Investigating? Why?"
            camera:
                easein 0.3 pos (-151, 2331) zpos -2169.0
            show moondancer 1k onlayer uielements at charprotappear
            show charbox_overlay second_phase appear onlayer uielements
            play sound "sfx/dramatichigher.wav"
            md "...What do you mean why?"
            show zephyr 3b with dis
            zb "Well, I was taking a nap below a tree, and when I woke up to stretch my wings I heard you two talking about something pretty loudly."
            show moondancer 4b onlayer uielements with disalt
            md "Hold on, were you just taking a nap this entire time?!"
            show zephyr 5a with dis
            zb "Of course! Every stallion needs their beauty sleep."
            show zephyr 1g with dis
            zb "Siesta!"
            show moondancer 1q onlayer uielements with disalt
            md "..."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 2c with dis
            play sound "sfx/embrarassed.wav"
            lh "...Zephyr. You don't actually know anything about what's going on, right?"
            camera:
                easein 0.3 pos (-151, 2331) zpos -2169.0
            show zephyr 1b with dis
            zb "Of course I do!"
            show zephyr 2a with dis
            zb "We're... uhh... Let me think..."
            show zephyr 1g with dis
            zb "I've got it! It's... a surprise party, right?"
            show moondancer 1c onlayer uielements with disalt
            md "..."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 2d with dis
            lh "..."
            camera:
                easein 0.3 pos (-151, 2331) zpos -2169.0
            show zephyr 2d with dis
            zb "Is it a wedding reception then? Who got married?"
            show moondancer 1f onlayer uielements with disalt
            play sound "sfx/dramatic.wav"
            md "No, there's no party. We all passed out and somepony brought us to the middle of nowhere."
            show zephyr 3c with dis
            zb "The middle of nowhere? Ha! Please, this isn't the middle of nowhere."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 4a with dis
            play sound "sfx/surprise.wav"
            lh "Wait, you know where we are?"
            camera:
                easein 0.3 pos (-151, 2331) zpos -2169.0
            zb "Yeah! We're somewhere in Neighagra Falls. I can tell because I recognize some of these trees."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 1i with dis
            lh "..."
            show moondancer 1o onlayer uielements with disalt
            md "..."
            md "...You recognize some trees?"
            camera:
                easein 0.3 pos (-151, 2331) zpos -2169.0
            zb "Of course! You never forget a good nap spot."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 6a with dis
            lh "I... guess that's true? But how can you really recognize a place by just a bunch of trees?"
            camera:
                easein 0.3 pos (-151, 2331) zpos -2169.0
            show zephyr 5a with dis
            zb "Oh, it's easy. Just-{p=0.7}{nw}" 
            show moondancer 4b onlayer uielements with disalt
            play sound "sfx/pianoreaction.wav"
            md "That's not important. The point is that we're trapped in this dome and there is no way out."
            show zephyr 5a with dis
            zb "..."
            show zephyr 4b with dis
            zb "...Wait, t-trapped?!"
            zb "This isn't good! I have to... I have to..."
            show zephyr 2d with dis
            zb "Actually, now that I think about it, I don't have anything scheduled for today."
            show zephyr 2a with dis
            zb "But if I'm stuck here... Then who's going to water my plants?"
            show zephyr 2b with dis
            zb "Hold on, do I even have plants?"
            show zephyr 1g with dis
            zb "Nope, I don't! Nevermind, false alarm. Carry on~"
            show moondancer 1q onlayer uielements with disalt
            mdin "I slapped a hoof to my face. How could this guy... how could he be so oblivious to our situation?"
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 3c with dis
            lh "..."
            show lyra 2d with dis
            lh "So, you're not worried about being here? Don't you have family or friends to return to?"
            camera:
                easein 0.3 pos (-151, 2331) zpos -2169.0
            show zephyr 5b with dis
            zb "Ah, I'm... sure they'll be fine. Zephyr Breeze is just taking a sudden vacation..."
            show zephyr 3c with dis
            zb "Yeah!"
            show moondancer 4b onlayer uielements with disalt
            play sound "sfx/dramatichigher.wav"
            md "This is not just a 'sudden vacation', we were literally kidnapped."
            md "If you're not going to take this seriously, at least don't waste the time of those of us who are."
            show zephyr 1f with dis
            zb "..."
            zb "..."
            show zephyr 5b with dis
            zb "Alright... I guess I'll leave now."
            show zephyr 3c with dis
            zb "But fear not! Zephyr will do the best investigation you'll ever see, and we'll all be out of here in no time!"
            zb "Don't worry, ladies! You count on Zephyr, okay?~"
            #<Zephyr Exits>
            show zephyr at chardisappear
            play music "Cool Morning (V3).ogg"
            $ guiInfo.musictext_name = "coolmorning"
            mdin "...He left."
            mdin "Honestly? Good riddance."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 2d with dis
            lh "Moondancer… That was uh… a bit harsh, don’t you think?"
            show moondancer 5b onlayer uielements with disalt
            md "Harsh? That stallion has only two brain cells, and they're fighting for third place."
            lh "He’s scared like the rest of us. Maybe this is just how he’s coping."
            md "Fear’s no excuse for being a distraction. We need to focus, not… whatever that was."
            show moondancer 5b onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements
            $ foliageCheck = True
        
        jump debug_investigationContinue2

label bushButtonDialouge:

    if lyraCheck2 == False or ventCheck == False or bushCheck == False or foliageCheck == False:
        pause (0.5)
        $ save_master_layer_position()
        $ reset_master_layer(0.108)
        play sound "sfx/tabopen.wav"
        pause (0.2)
        $ set_camera_pan(False)
        
        if bushCheck == True:
            camera:
                easein 0.3 pos (-666, 2403) zpos -1449.0
            show lyra 1g with dis
            lh "Poor Babs...Being abducted is scary enough, but for them to do it to a little filly?"

            mdin "I don't even want to think of why someone would kidnap a filly. I have to focus on investigating..."

        if bushCheck == False:
            show moondancer 1b onlayer uielements at charprotappear
            show charbox_overlay second_phase appear onlayer uielements
            md "Just a few bushes. Nothing too out of the ordinary, I guess."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 1d with dis
            lh "If only these were the kind that had berries on them."
            show moondancer 1p onlayer uielements with disalt
            mdin "I could feel my stomach growling. I don't even remember the last time I'd eaten before I got knocked unconscious..."
            show lyra 2a with dis
            lh "Of course, Bon Bon was the one who knew which ones were poisonous..."
            show moondancer 1n onlayer uielements with disalt
            mdin "...Suddenly, I'm not so hungry anymore."
            #<Bush rustling SFX>
            stop music
            $ guiInfo.musictext_name = "null"
            greentext "*Ruttle*"
            show moondancer 5c onlayer uielements with disalt
            md "...?"
            mdin "I swear I just saw that bush move, but it couldn't have been the wind..."
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show lyra 6a with dis
            lh "Hey, I think there's something in the bushes here!"
            show moondancer 3a onlayer uielements with disalt
            md "Hold on, that might not be a good idea-"
            show moondancer 3a onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements
            camera:
                easein 0.3 xpos -594
            mdin "Lyra got closer to the source of the noise, when suddenly..."
            hide screen left_gui
            show charbox_overlay first_phase disappear onlayer uielements
            pause (0.5)
            show light1 onlayer overlays:
                linear 0.5 alpha 0.0
            window hide
            scene black with black
            camera:
                pos (0, 0) zpos 0
            show bushfilly with black
            pause (0.5)
            play sound "sfx/dramatichigher.wav"
            unknownCG "Stay back! Don't come any closa!"
            mdCGin "A voice with a city accent and childish ring came out. That voice definitely belonged to a filly."
            lhCG "Hey there! We're not going to hurt you."
            unknownCG "How do I know dat? Maybe youse the ones who dragged me here in the first place!"
            lhCG "We're just as confused as you are. Believe me, if we had any answers, we'd already be out of here."
            unknownCG "...Youse really not part of dis?"
            lhCG "Nope. We're investigating too. What about you?"
            mdCGin "The filly hesitated before stepping out fully from behind the bush."
            hide bushfilly with black
            $ renpy.pause (1.0)
            show hotel back with black:
                subpixel True pos (0, 1.22) zpos -2790.0 zzoom True
            camera:
                subpixel True pos (-1575, 2493) zpos -2286.0 perspective True
            show lyra 6a with dis:
                subpixel True pos (-0.11, 2.11) zpos -1300.0
            show babs 3a behind lyra with dis:
                subpixel True pos (-0.59, 2.11) zpos -2137.0
            show light1 onlayer overlays:
                ease 0.5 alpha 1.0
            $ renpy.pause(0.3)
            show screen left_gui
            window show
            play music "Cool Morning (V3).ogg"
            $ guiInfo.musictext_name = "coolmorning"
            show charbox_overlay first_phase appear onlayer uielements
            unknown "Uh, keepin' myself safe, I guess."
            camera:
                easein 0.3 pos (-1458, 2493) zpos -2286.0
            show moondancer 4a onlayer uielements at charprotappear
            show charbox_overlay second_phase appear onlayer uielements
            md "I don't think staying hidden in the bushes will keep you safe."
            mdin "But then again, I don't think any place here is all that safe."
            camera:
                easein 0.3 pos (-666, 2403) zpos -1449.0
            show lyra 2b with dis
            lh "Say, what’s your name, little filly?"
            camera:
                easein 0.3 pos (-1575, 2493) zpos -2286.0
            show charbox_overlay full_phase disappear onlayer uielements
            show moondancer 4a onlayer uielements at charprotdisappear
            show babs 3b with dis
            unknown "..."
            show babs 1a with dis
            unknown "Name's Babs Seed. Not dat it matters much right now."
            #<INTRODUCTION: Babs Seed>
            hide screen left_gui
            show lyra:
                linear 0.5 alpha 0.0
            window auto hide
            pause 0.3
            play sound "audio/sfx/Intro_V3.mp3"
            show genericbackground behind babs:
                matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.14)*SaturationMatrix(0.74)*BrightnessMatrix(0.07)*HueMatrix(405.0)
                subpixel True pos (-0.84, 2.33) zpos -2155.0
                alpha 0.0
                linear 0.5 alpha 1.0
            show light2 onlayer overlays:
                ease 0.5 alpha 1.0
            show light1 onlayer overlays:
                ease 0.5 alpha 0.0
            pause 0.2
            show babs:
                subpixel True xpos -0.59
                ease 0.5 xpos -0.81
            show ring behind babs:
                subpixel True pos (-0.34, 2.35) zpos -2259.0 alpha 0.22 blend 'add' 
                alpha 0.0
                linear 0.3 alpha 0.3
                zrotate 0.0
                linear 5.0 zrotate 620.0
            show cmbabs behind babs:
                subpixel True pos (-0.34, 2.35) zpos -2259.0 alpha 0.22 blend 'add'
                alpha 0.0
                linear 0.3 alpha 0.3
            pause 0.1
            show introbars behind babs:
                subpixel True pos (-0.80, 2.70) zpos -2214.0
                matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.84)*SaturationMatrix(0.54)*BrightnessMatrix(-0.28)*HueMatrix(1494.0) 
                matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
                easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0)
            show intronamebabs behind babs:
                subpixel True pos (-0.80, 2.70) zpos -2214.0
                matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0) 
                easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
            pause 2.0
            show babs:
                ease 0.5 xpos -0.59
            show ring behind babs:
                linear 0.3 alpha 0.0
                zrotate 0.0
            show genericbackground behind babs:
                linear 0.5 alpha 0.0
            show cmbabs behind babs:
                linear 0.3 alpha 0.0
            show lyra:
                linear 0.5 alpha 1.0
            show light2 onlayer overlays:
                ease 0.5 alpha 0.0
            show light1 onlayer overlays:
                ease 0.5 alpha 1.0
            pause 0.6
            hide ring
            hide introbars
            hide intronamebabs
            hide genericbackground
            hide cmvbabs
            window auto show
            show charbox_overlay first_phase appear onlayer uielements
            show screen left_gui
            camera:
                easein 0.3 pos (-666, 2403) zpos -1449.0
            lh "Nice to meet you, Babs. What's that cape you're wearing? It looks pretty cool."
            camera:
                easein 0.3 pos (-1575, 2493) zpos -2286.0
            show babs 4a with dis
            bs "Dis? My cousin Apple Bloom gave it to me after making me an official member of the Cutie Mark Crusadas."
            camera:
                easein 0.3 pos (-666, 2403) zpos -1449.0
            lh "The Cutie Mark Crusaders? Like the ones from Ponyville?"
            camera:
                easein 0.3 pos (-1575, 2493) zpos -2286.0
            show babs 1d with dis
            bs "Yeah, dat one."
            bs "I was in the middle of a crusade in Manehattan, helpin' a pony strugglin' with his Cutie Mark."
            bs "He used to be a talent manager, but then lost his job and forgot his own purpose."
            mdin "I'm pretty sure I've heard about this some months ago."
            show babs 3a with dis
            bs "I managed to help him remember his passion of helpin' other ponies. On the way home, I suddenly felt really tired, and then I woke up in this place."
            bs "I think it was magic or somethin', I dunno."
            camera:
                easein 0.3 pos (-666, 2403) zpos -1449.0
            show lyra 2a with dis
            play sound "sfx/surprise.wav"
            lh "Oh... Do you think he's the one who... Y'know, brought you here?"
            camera:
                easein 0.3 pos (-1575, 2493) zpos -2286.0
            show babs 2a with dis
            bs "No, he was an earth pony, not an unicorn."
            play sound "sfx/dramatic.wav"
            mdin "Whoever brought us here... They had no reservations, not even about a filly."
            show babs 2d with dis
            play sound "sfx/embrarassed.wav"
            bs "My sister must be really worried about me right now. I wanna go home..."
            camera:
                easein 0.3 pos (-666, 2403) zpos -1449.0
            lh "Do you want to tag along? I can't imagine how scary it must be to be all by yourself."
            camera:
                easein 0.3 pos (-1575, 2493) zpos -2286.0
            show babs 1d with dis
            bs "Wait, taggin' along?"
            camera:
                easein 0.3 pos (-666, 2403) zpos -1449.0
            show lyra 1e with dis
            lh "Yeah! We'll make sure to keep you safe."
            camera:
                easein 0.3 pos (-1575, 2493) zpos -2286.0
            show babs 1a with dis
            bs "..."
            mdin "Babs Seed's eyes glanced between the two of us, contemplating Lyra's proposition."
            bs "..."
            show babs 3a with dis
            bs "...I appreciate da offer, but I can't trust just anypony right now."
            camera:
                easein 0.3 pos (-666, 2403) zpos -1449.0
            show lyra 1g with dis
            lh "...Really? Why not?"
            camera:
                easein 0.3 pos (-1575, 2493) zpos -2286.0
            show babs 1c with dis
            bs "Like I said, I dunno if youse the ones behind alla dis. I'll take my chances bein' by maself."
            camera:
                easein 0.3 pos (-666, 2403) zpos -1449.0
            show lyra 1h with dis
            lh "..."
            lh "..."
            show lyra 5f with dis
            lh "O-Okay..."
            #<Babs leaves>
            camera:
                easein 0.3 pos (-1575, 2493) zpos -2286.0
            show babs 1c with dis
            show babs at chardisappear
            mdin "Babs left us."
            camera:
                easein 0.3 pos (-666, 2403) zpos -1449.0
            show lyra 5c with dis
            play sound "sfx/dramatic.wav"
            lh "Is it really alright to let that filly be on her own?"
            camera:
                easein 0.3 pos (-504, 2403) zpos -1449.0
            show moondancer 2a onlayer uielements at charprotappear
            show charbox_overlay second_phase appear onlayer uielements
            md "Well, she's smart enough to not trust strangers, I think she'll be fine for the time being. Besides, we have more important things to worry about right now."
            lh "If you say so..."
            show moondancer 2a onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements
            $ bushCheck = True
        
        jump debug_investigationContinue2

label investigationComplete2new:
    $ reset_master_layer(0.108)
    camera:
        easein 0.5 pos (-326, 2241) zpos -198.0
    greentext "Investigation Complete."
    show moondancer 1g onlayer uielements at charprotappear
    show charbox_overlay second_phase appear onlayer uielements
    md "Well, I think that's all to see around here. Where else can we check?"
    stop music fadeout 1.0
    $ guiInfo.musictext_name = "null"
    show lyra 5d with dis
    camera:
        easein 0.3 pos (-504, 2403) zpos -1449.0
    lh "There's still the hotel... but let me guess—you still don't want to check it out, do you?"
    show moondancer 1o onlayer uielements with disalt
    play sound "sfx/dramatic.wav"
    md "..."
    play music "Almost Hell Heaven (v3).ogg"
    $ guiInfo.musictext_name = "almosthellheaven"
    lh "..."
    show lyra 1h with dis
    lh "Look, I know how you feel about it. You're worried it's going to get us into trouble—or worse."
    md "..."
    lh "..."
    show lyra 5b with dis
    lh "*Sigh*"
    show lyra 1g with dis
    lh "Moondancer... Can I ask you something?"
    show moondancer 1d onlayer uielements with disalt
    md "Hmm?"
    play sound "sfx/surprise"
    lh "...Can you trust me?"
    md "...What do you mean?"
    show lyra 5f with dis
    lh "I mean... I know this situation is scary. For all of us. I'm scared too. Terrified, even!"
    lh "But if we don't start trusting each other, even a little, then what chance do we have?"
    show lyra 5a with dis
    lh "I've been trying to help, trying to keep everyone together... but it feels like no one really wants to trust me."
    show lyra 5b with dis
    lh "...I don't blame them, but still. I can't do this on my own... I don't want to do this on my own."
    show lyra 1g with dis
    lh "So, whatever's coming next, no matter how dangerous or scary it gets... I want you to know I'm on your side — Always. You're my friend, Moondancer."
    lh "So, please... don't shut me out. Don't try to face this by yourself."
    lh "I want you to {color=#f1c232}trust me{/color}."
    md "..."
    show moondancer onlayer uielements at charprotdisappear
    show charbox_overlay second_phase disappear onlayer uielements
    camera:
        easein 0.3 xpos -675
    mdin "Even if Lyra has been on my side since I woke up, I've been trying to handle this alone."
    mdin "The more we discovered about our predicament, the more I found trust to be dangerous."
    mdin "Despite that, Lyra never gave up. She kept insisting that trust was the only way forward, always trying to bring us together."
    mdin "While I didn't agree with her wholeheartedly, she had a point."
    mdin "...Maybe it would be a good idea to have somepony to rely upon."
    mdin "..."
    mdin "Taking a deep breath, I finally turned to face Lyra."
    show moondancer 1b onlayer uielements at charprotappear
    show charbox_overlay second_phase appear onlayer uielements
    stop music fadeout 1.0
    $ guiInfo.musictext_name = "null"
    camera:
        easein 0.3 pos (-504, 2403) zpos -1449.0
    md "Alright... we'll check the hotel. Together."
    show lyra 1b with dis
    lh "Really?"
    show moondancer 2b onlayer uielements with disalt
    md "Yeah. I mean, it's not like I'm thrilled about it, but..."
    show moondancer 1r onlayer uielements with disalt
    md "You're right, I trust you."
    show lyra 1d with dis
    lh "That's exactly what I needed to hear!"
    play music "Cool Morning (V3).ogg"
    $ guiInfo.musictext_name = "coolmorning"
    mdin "Her smile... it was warm, like a candle illuminating the darkness."
    mdin "I hope I was sincere enough to her..."
    show lyra 1a with dis
    lh "Let's go!"
    show moondancer 1a onlayer uielements with disalt
    md "Alright... lead the way."
    hide screen left_gui
    show charbox_overlay full_phase disappear onlayer uielements
    show moondancer onlayer uielements at charprotdisappear
    show lyra at chardisappear
    $ renpy.pause(0.5)
    show light1 onlayer overlays:
        linear 0.5 alpha 0.0
    scene black with black
    camera:
        subpixel True pos (0, 0) zpos 0.0 perspective False
    window hide
    $ renpy.pause(0.5)
    $ renpy.start_predict("images/backgrounds/povhotel/*.png")
    mdCGin "Lyra and I circled the building again, this time much closer."
    mdCGin "Its decrepit nature was even more evident on close inspection, you could see the moss growing through the cracks."
    mdCGin "It was also getting really dark..."
label prologue_hoteldoors:
    $ menu_flag = True
    $ overlay_background = "images/backgrounds/povhotel/charboxoverlay_hotelpov"
    show hotel doors with black:
        subpixel True pos (0, 1.22) zpos -2790.0 zzoom True
    camera:
        subpixel True pos (26, 3081) zpos -2849.0 perspective True
    show lyra 1f:
        subpixel True pos (-0.45, 2.69) zpos -1810.0 alpha 0.0
        linear 0.3 alpha 1.0
    show quibble 5a behind lyra with dis:
        subpixel True pos (0.00, 2.69) zpos -1810.0 alpha 0.0
        linear 0.3 alpha 1.0
    show fancy 1a behind quibble with dis:
        subpixel True pos (0.69, 2.69) zpos -2269.0 alpha 0.0
        linear 0.3 alpha 1.0
    show fuse 4a behind fancy with dis:
        subpixel True pos (0.3, 2.45) zpos -2700.0 alpha 0.0
        linear 0.3 alpha 1.0
    show screen left_gui
    show charbox_overlay first_phase appear onlayer uielements:
        matrixcolor InvertMatrix(0.0)*ContrastMatrix(0.89)*SaturationMatrix(0.79)*BrightnessMatrix(-0.07)*HueMatrix(36.0) 
    show sunsetoverlay onlayer overlays:
        blend 'multiply' 
    show light3 onlayer overlays:
        blend 'add'
    screen Investigation3():
            
        key "K_RETURN" action ToggleVariable("image_visible", True, False)

        add "door_mystery_label" xpos 816 + cam_x(-0.33) ypos 267 + cam_y(-0.33) alpha If(image_visible, 1.0, 0.0)

        add "mystery_label" xpos 1090 + cam_x(-0.40) ypos 357 + cam_y(-0.33) alpha If(image_visible, 1.0, 0.0)

        add "lyra_label" xpos 180 + cam_x(-0.42) ypos 325 + cam_y(-0.55) alpha If(image_visible, 1.0, 0.0)

        add "mystery_label" xpos 550 + cam_x(-0.45) ypos 657 + cam_y(-0.33) alpha If(image_visible, 1.0, 0.0)
        
        imagebutton:
            
            xpos 775 + cam_x(-0.33) ypos 330 + cam_y(-0.33)
            
            auto "images/ui/doorFuseButton_%s.png" action [ToggleScreen("Investigation3"), Jump("fuseButtonDialouge")]
            
            

        imagebutton:
            
            xpos 1163 + cam_x(-0.34) ypos 571 + cam_y(-0.33)
            
            auto "images/ui/fancyButton_%s.png" action [ToggleScreen("Investigation3"), Jump("fancyButtonDialouge")]

        imagebutton:
            
            xpos 500 + cam_x(-0.4) ypos 884 + cam_y(-0.55)
            
            auto "images/ui/quibbleButton_%s.png" action [ToggleScreen("Investigation3"), Jump("quibbleButtonDialouge")]

        imagebutton:
            
            xpos 250 + cam_x(-0.4) ypos 605 + cam_y(-0.55)
            
            auto "images/ui/lyraButton3_%s.png" action [ToggleScreen("Investigation3"), Jump("lyraButton3Dialouge")]
            
        

        
    default lyraCheck3 = False
    default fuseCheck = False
    default fancyCheck = False
    default quibbleCheck = False
        
    $ menu_flag = True
    

label debug_investigationContinue3:
    if lyraCheck3 == False or fuseCheck == False or fancyCheck == False or quibbleCheck == False:
        $ restore_master_layer(0.2)
        camera:
            easein 0.3 pos (126, 2481) zpos -198.0
    
        $ set_camera_pan(True, max_x=100, max_y=0)
    
        call screen Investigation3
        
    



label lyraButton3Dialouge:

    
    if lyraCheck3 == False or fuseCheck == False or fancyCheck == False or quibbleCheck == False:
        pause (0.5)
        $ save_master_layer_position()
        $ reset_master_layer(0.108)
        play sound "sfx/tabopen.wav"
        camera:
            easein 0.3 pos (-1260, 2984) zpos -1959.0
        pause (0.2)
        $ set_camera_pan(False)
        show lyra 3a with dis
        lh "Did you see all the moss growing on the sides? It's like this place hasn't seen anypony for years!"
        camera:
            easein 0.3 pos (-1172, 2984) zpos -1959.0
        show moondancer 2a onlayer uielements at charprotappear:
            matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.0)*SaturationMatrix(1.0)*BrightnessMatrix(-0.06)*HueMatrix(-9.0)
        show charbox_overlay second_phase appear onlayer uielements
        md "Yeah, we might be far away from anypony who could help if we've been taken to an abandoned building."
        lh "That's not a great sign..."
        show moondancer 2a onlayer uielements at charprotdisappear
        show charbox_overlay second_phase disappear onlayer uielements
        $ lyraCheck3 = True

        
        jump debug_investigationContinue3
label fuseButtonDialouge:
    if lyraCheck3 == False or fuseCheck == False or fancyCheck == False or quibbleCheck == False:
        pause (0.5)
        $ save_master_layer_position()
        $ reset_master_layer(0.108)
        play sound "sfx/tabopen.wav"
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        pause (0.2)
        $ set_camera_pan(False)
        if fuseCheck == True:

            unknown "GAAAAAH! COME ON!"

            mdin "I don't think he's in the mood to talk..."
        if fuseCheck == False:
            unknown "Rrrrgh...! Open...up...you...stupid...door!"
            camera:
                easein 0.3 pos (855, 2984) zpos -2418.0
            show fancy 2c with dis
            unknown "If it didn't open the first twenty-eight times you tried..."
            camera:
                easein 0.3 pos (126, 2781) zpos -2849.0
            play sound "sfx/shock.wav"
            unknown "SHUT UP!"
            mdin "...He seems busy, maybe I should talk to the other guy."
            $ fuseCheck = True
        jump debug_investigationContinue3

label quibbleButtonDialouge:
    if lyraCheck3 == False or fuseCheck == False or fancyCheck == False or quibbleCheck == False:
        pause (0.5)
        $ save_master_layer_position()
        $ reset_master_layer(0.108)
        play sound "sfx/tabopen.wav"
        pause (0.2)
        $ set_camera_pan(False)
        if quibbleCheck == True:
            camera:
                easein 0.3 pos (-460, 3173) zpos -1959.0
            unknown "..."
            show lyra 2a with dis
            camera:
                easein 0.3 pos (-1260, 2984) zpos -1959.0
            lh "Helloooooo?"
            camera:
                easein 0.3 pos (-460, 3173) zpos -1959.0
            unknown "..."
            camera:
                easein 0.3 pos (-372, 2984) zpos -1959.0
            show moondancer 1b onlayer uielements at charprotappear:
                matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.0)*SaturationMatrix(1.0)*BrightnessMatrix(-0.06)*HueMatrix(-9.0)
            show charbox_overlay second_phase appear onlayer uielements
            md "Lyra, you waited for me to wake up, we should do the same."
            show moondancer 1b onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements

        if quibbleCheck == False:
            camera:
                easein 0.3 pos (-460, 3173) zpos -1959.0
            unknown "..."
            mdin "This stallion is still asleep. Guess I wasn't the last one to wake up, after all."
            camera:
                easein 0.3 pos (-1260, 2984) zpos -1959.0
            show lyra 2d with dis
            lh "Heyyyy! Hello? Are you okay?!"
            camera:
                easein 0.3 pos (-460, 3173) zpos -1959.0
            unknown "..."
            camera:
                easein 0.3 pos (-1172, 2984) zpos -1959.0
            show moondancer 1a onlayer uielements at charprotappear:
                matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.0)*SaturationMatrix(1.0)*BrightnessMatrix(-0.06)*HueMatrix(-9.0)
            show charbox_overlay second_phase appear onlayer uielements
            md "Still asleep. He must be out cold."
            camera:
                easein 0.3 pos (-1172, 2984) zpos -1959.0
            show lyra 3b with dis
            lh "What if I slap him awake? That oughta do it, right?"
            show moondancer 5b onlayer uielements with disalt
            md "Lyra, I can think of one pony more deserving to be slapped, and it isn't this stallion."
            mdin "Still, I'm also waiting to wake up from whatever this nightmare is..."
            show moondancer 1h onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements
            $ quibbleCheck = True
        jump debug_investigationContinue3

label fancyButtonDialouge:
    if lyraCheck3 == False or fuseCheck == False or fancyCheck == False or quibbleCheck == False:
        pause (0.5)
        $ save_master_layer_position()
        $ reset_master_layer(0.108)
        play sound "sfx/tabopen.wav"
        camera:
            easein 0.3 pos (972, 2984) zpos -2418.0
        pause (0.5)
        $ set_camera_pan(False)
        
        if fancyCheck == True:
            show moondancer 1e onlayer uielements at charprotappear:
                matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.0)*SaturationMatrix(1.0)*BrightnessMatrix(-0.06)*HueMatrix(-9.0)
            show charbox_overlay second_phase appear onlayer uielements
            md "Is there anything else you can tell us about our current situation, Fancy Pants?"
            show fancy 1e with dis
            fp "I’m afraid I’ve told you everything I know, Ms. Moondancer."
            show moondancer 1e onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements

        if fancyCheck == False:
            show moondancer 1c onlayer uielements at charprotappear:
                matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.0)*SaturationMatrix(1.0)*BrightnessMatrix(-0.06)*HueMatrix(-9.0)
            show charbox_overlay second_phase appear onlayer uielements
            md "Um, excuse me, sir?"
            camera:
                easein 0.3 pos (972, 2984) zpos -2418.0
            show fancy 1d with dis
            unknown "Yes, can I help you?"
            show moondancer 4a onlayer uielements with disalt
            md "I don’t suppose you have any idea what’s going on here, do you?"
            show fancy 1e with dis
            unknown "I’m afraid not. I’m just as lost as you all are."
            camera:
                easein 0.3 pos (-1172, 2984) zpos -1959.0
            show lyra 5f with dis
            lh "Aw…"
            show moondancer 4a onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements
            camera:
                easein 0.3 pos (855, 2984) zpos -2418.0
            show fancy 4a with dis
            unknown "...My apologies, where are my manners? I haven't even introduced myself to you!"
            show fancy 5b with dis
            unknown "My name is Fancy Pants, a highly regarded pony in the Canterlot elite."
            #<INTRODUCTION: Fancy Pants>
            show charbox_overlay first_phase disappear onlayer uielements
            hide screen left_gui
            show fuse:
                linear 0.5 alpha 0.0
            window auto hide
            pause 0.3
            play sound "audio/sfx/Intro_V3.mp3"
            show genericbackground behind fancy:
                matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.14)*SaturationMatrix(0.92)*BrightnessMatrix(0.05)*HueMatrix(720.0) 
                subpixel True pos (0.44, 2.76) zpos -2287.0
                alpha 0.0
                linear 0.5 alpha 1.0
            show light3 onlayer overlays:
                linear 0.5 alpha 0.0
            show sunsetoverlay onlayer overlays:
                linear 0.5 alpha 0.0
            show light2 onlayer overlays:
                blend 'add'
                alpha 0.0
                linear 0.5 alpha 1.0
            pause 0.2
            show fancy:
                subpixel True xpos 0.69
                ease 0.5 xpos 0.47
            show ring behind fancy:
                subpixel True pos (0.94, 2.78) zpos -2391.0 alpha 0.22 blend 'add' 
                alpha 0.0
                linear 0.3 alpha 0.3
                zrotate 0.0
                linear 5.0 zrotate 620.0
            show cmfancy behind fancy:
                subpixel True pos (0.94, 2.78) zpos -2391.0 alpha 0.22 blend 'add'
                alpha 0.0
                linear 0.3 alpha 0.3
            pause 0.1
            show introbars behind fancy:
                subpixel True pos (0.48, 3.13) zpos -2346.0
                matrixcolor InvertMatrix(0.0)*ContrastMatrix(2.54)*SaturationMatrix(0.29)*BrightnessMatrix(-0.3)*HueMatrix(1242.0) 
                matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
                easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0)
            show intronamefancy behind fancy:
                subpixel True pos (0.48, 3.13) zpos -2346.0
                matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0) 
                easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
                easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
            pause 2.0
            show fancy:
                ease 0.5 xpos 0.69
            show ring behind fancy:
                linear 0.3 alpha 0.0
                zrotate 0.0
            show genericbackground behind fancy:
                linear 0.5 alpha 0.0
            show light3 onlayer overlays:
                linear 0.5 alpha 1.0
            show sunsetoverlay onlayer overlays:
                linear 0.5 alpha 1.0
            show light2 onlayer overlays:
                linear 0.5 alpha 0.0
            show cmfancy behind fancy:
                linear 0.3 alpha 0.0
            show fuse:
                linear 0.5 alpha 1.0
            pause 0.6
            hide ring
            hide introbars
            hide intronamefancy
            hide genericbackground
            hide cmfancy
            show charbox_overlay first_phase appear onlayer uielements
            show screen left_gui
            camera:
                easein 0.3 pos (-1260, 2984) zpos -1959.0
            show lyra 3b with dis
            lh "Wow!"

            lh "Hi, Fancy Pants! It’s me, Lyra! You remember me, right?"
            camera:
                easein 0.3 pos (855, 2984) zpos -2418.0
            show fancy 2a with dis
            fp "But of course I remember you Ms. Heartstrings! Your talent with the lyre is truly unforgettable!"
            camera:
                easein 0.3 pos (-1260, 2984) zpos -1959.0
            show lyra 2b with dis
            lh "Aw shucks, you’re gonna make me blush!"
            show lyra 1d with dis
            lh "Oh, this is my friend Moondancer, she lives in Canterlot just like you!"
            camera:
                easein 0.3 pos (855, 2984) zpos -2418.0
            show fancy 3a with dis
            fp "A pleasure to make your acquaintance, Ms. Moondancer!"
            camera:
                easein 0.3 pos (972, 2984) zpos -2418.0
            show moondancer 1a onlayer uielements at charprotappear
            show charbox_overlay second_phase appear onlayer uielements
            md "You're a member of the Canterlot elite, huh?"
            show fancy 4d with dis
            fp "Oh? I admit it is quite unusual for my name to be unheard of, especially to somepony who's also a Canterlot resident."
            show moondancer 3b onlayer uielements with disalt
            md "Well, I usually keep myself to the library…"
            show fancy 3b with dis
            fp "Ah, a scholar, I take it? How wonderful!"

            mdin "Usually those Canterlot elites are total snobs, why is this guy so different?"

            fp "In regards to our current predicament, I am doing my best to try and get to the bottom of this, but it hasn’t been easy."

            mdin "What was a figure like him doing here, of all places?"

            mdin "Abducting over a dozen ponies is no easy feat, let alone a member of the elite."
            show moondancer 1e onlayer uielements with disalt
            md "Do you remember how you got here, Fancy Pants?"
            show fancy 4a with dis
            fp "…As a matter of fact, I do."

            fp "I was taking a carriage on my way home. However, the vehicle suddenly came to a halt."

            fp "I came out to check on the driver, but then I was struck on the back of my head."
            show fancy 1g with dis
            fp "Before I could truly pass out, I heard the voice of a mare — Though I’m afraid I can’t remember any of what she said."
            show moondancer 2a onlayer uielements with disalt
            md "…A mare?"

            fp "I’m quite sure of it. After that I awoke here just like the rest of you."

            md "I see…"
            camera:
                easein 0.3 pos (-1172, 2984) zpos -1959.0
            show lyra 1f with dis
            lh "So, why are you standing outside? Isn’t it worth trying to explore inside?"
            camera:
                easein 0.3 pos (972, 2984) zpos -2418.0
            show fancy 4a with dis
            fp "I'm afraid it hasn't been that simple, Ms. Lyra. We've been trying to enter this decrepit building ever since we woke up."
            fp "But the door is locked shut, and no amount of force seems to be enough to open it."
            camera:
                easein 0.3 pos (-1172, 2984) zpos -1959.0
            lh "Well that's strange. Why would we be put into this dome with a building if we can't enter it?"
            show moondancer 2a onlayer uielements with disalt
            md "So there's absolutely no way inside?"
            camera:
                easein 0.3 pos (972, 2984) zpos -2418.0
            show fancy 5c with dis
            fp "Not entirely. To your right there's what appears to be a market."
            show fancy 6b with dis
            stop music
            $ guiInfo.musictext_name = "null"
            fp "Regardless, I think we're simply {color=#f1c232}not meant to enter this place yet.{/color}"
            show moondancer 5b onlayer uielements with disalt
            md "...Not meant to enter yet?"
            show fancy 4a with dis
            play music "eternal_darkness.ogg"
            $ guiInfo.musictext_name = "eternaldarkness"
            fp "Simply put, whoever brought us here isn't done preparing whatever is inside, or is just looking for the best opportunity to reveal the building's contents."
            md "But what could they have possibly been trying to prepare? From what I've seen, this looks like an ordinary, run-down hotel."
            show fancy 4c with dis
            fp "I don't believe it's that simple."
            fp "Whoever brought us here has a purpose – and I fear it may not be a pleasant one."
            show moondancer 2c onlayer uielements with disalt
            mdin "A purpose... As ominous as it was, it explained our predicament."
            mdin "There was a twisted narrative that would justify every oddity, every deliberate decision."
            mdin "But even then, what is the purpose? What is somepony trying to accomplish with this? And more importantly..."
            mdin "What can we do?"
            stop music
            $ guiInfo.musictext_name = "null"
            camera:
                easein 0.3 pos (-1172, 2984) zpos -1959.0
            show lyra 1f with dis
            lh "..."
            show lyra 1i with dis
            lh "But we're here for each other, right?"
            mdin "Lyra's voice halted me from spiraling into endless what-ifs and worst case scenarios."
            show lyra 6b with dis
            lh "We may not know what we got into, but I doubt they can handle a dozen ponies."
            camera:
                easein 0.3 pos (972, 2984) zpos -2418.0
            show fancy 1g with dis
            fp "..."
            show fancy 1c with dis
            fp "That's... a way to put it, yes."
            camera:
                easein 0.3 pos (-1172, 2984) zpos -1959.0
            show lyra 1h with dis
            lh "The point is — we can face this if we stick together."
            show moondancer 1n onlayer uielements with disalt
            play music 'Cool Morning (V3).ogg'
            $ guiInfo.musictext_name = "coolmorning"
            mdin "Optimistic. Oblivious so."
            mdin "However even as misplaced as her optimism may be, it reminded me that panic won't solve anything."
            mdin "Regardless, I think I've seen enough of the hotel for now."
            show lyra 2b with dis
            lh "Well, let's move forward! There's still a few things to see."
            show moondancer onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements
            $ fancyCheck = True

        
        jump debug_investigationContinue3

label investigationComplete3new:
        $ restore_master_layer(0.2)
        camera:
            easein 0.3 pos (126, 2481) zpos -198.0
        greentext "Investigation Complete."
        camera:
            easein 0.3 pos (-1260, 2984) zpos -1959.0
        show lyra 2a with dis
        lh "So, what do you think, Moondancer?"
        camera:
            easein 0.3 pos (-1172, 2984) zpos -1959.0
        show moondancer 3b onlayer uielements at charprotappear
        show charbox_overlay second_phase appear onlayer uielements
        md "If we can't get inside, then maybe-"
        play sound "sfx/dramatic.wav"
        stop music fadeout 1.0
        $ guiInfo.musictext_name = "null"
        unknown "HEY! If you're all done chit-chatting, why don't you help me get this door open?"
        show moondancer 3b onlayer uielements at charprotdisappear
        show charbox_overlay second_phase disappear onlayer uielements
        #<Close up on Short Fuse and the Door>
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        show fuse 1h with dis
        unknown "Rrrrgh...! Open...up...you...stupid...door!"
        camera:
            easein 0.3 pos (855, 2984) zpos -2418.0
        show fancy 2c with dis
        fp "If it didn't open the first twenty-nine times you tried..."
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        show fuse 4a with dis
        unknown "SHUT UP!"
        mdin "The small pegasus pushed against the door, unable to move it in the slightest."
        mdin "He's... really short. He can't be another foal like Babs, right?"
        camera:
            easein 0.3 pos (855, 2984) zpos -2418.0
        play music "Class Trial - Sun Edition (V3).ogg"
        $ guiInfo.musictext_name = "classtrial_sun"
        fp "I insist that even with our current predicament, we shouldn't resort to such... reckless measures."
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        show fuse 2d with dis
        unknown "Then what else am I supposed to do, Can't See Pants?"
        camera:
            easein 0.3 pos (855, 2984) zpos -2418.0
        fp "The building has been enchanted to make the interior of the building inaccessible by any method, forcing your way in is just a wasted effort."
        show fancy 3d with dis
        fp "So, please stop before it gets any of us into trouble."
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        unknown "Trouble?"
        show fuse 3a with dis
        unknown "A Washout is never afraid of trouble, a Washout *is* trouble. So, shut up and help me!"

        mdin "The short pegasus continued to struggle for a few moments until he landed on the ground, visibly tired."
        show fuse 2d with dis
        unknown "*Huff* *Puff*"
        camera:
            easein 0.3 pos (855, 2984) zpos -2418.0
        show fancy 2c with dis
        fp "Exhausted already, it seems?"
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        show fuse 1f with dis
        unknown "You must be a really good partner, huh? Letting somepony else do all the heavy lifting while you just sit back and look good."
        camera:
            easein 0.3 pos (855, 2984) zpos -2418.0
        fp "A good partner is one who won’t allow his fellow partner to fall into danger. Clearly, my words have fallen on deaf ears."
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        show fuse 1h with dis
        unknown "You think I’m going to just sit around and do nothing? I’m not just going to sit around and be at the mercy of whoever put us in this stupid dome!"
        camera:
            easein 0.3 pos (855, 2984) zpos -2418.0
        show fancy 3c with dis
        fp "I understand what you’re trying to say, but wouldn’t it be rash to act without any consideration of what we might face?"
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        unknown "Hah! Like I said, a Washout isn't scared of danger."
        camera:
            easein 0.3 pos (855, 2984) zpos -2418.0
        fp "You have mentioned these “Washouts” quite a few times, but I have no idea what they are. Would you care to explain?"
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        show fuse 2f with dis
        unknown "Psh! Of course a pony like you wouldn’t know."
        show fuse 3a with dis
        unknown "First off, the name is Short Fuse. I became a Washout after being rejected from the Wonderbolts."

        #<INTRODUCTION:Short Fuse>
        show charbox_overlay first_phase disappear onlayer uielements
        hide screen left_gui
        show fancy:
            linear 0.5 alpha 0.0
        window auto hide
        pause 0.3
        play sound "audio/sfx/Intro_V3.mp3"
        show genericbackground behind fuse:
            matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.14)*SaturationMatrix(0.32)*BrightnessMatrix(-0.01)*HueMatrix(594.0)
            subpixel True pos (0.05, 2.57) zpos -2718.0
            alpha 0.0
            linear 0.5 alpha 1.0
        show light3 onlayer overlays:
                linear 0.5 alpha 0.0
        show sunsetoverlay onlayer overlays:
                linear 0.5 alpha 0.0
        show light2 onlayer overlays:
                blend 'add'
                alpha 0.0
                linear 0.5 alpha 1.0
        pause 0.2
        show fuse:
            subpixel True xpos 0.30
            ease 0.5 xpos 0.08
        show ring behind fuse:
            subpixel True pos (0.55, 2.59) zpos -2822.0 alpha 0.22 blend 'add' 
            alpha 0.0
            linear 0.3 alpha 0.3
            zrotate 0.0
            linear 5.0 zrotate 620.0
        show cmfuse behind fuse:
            subpixel True pos (0.55, 2.59) zpos -2822.0 alpha 0.22 blend 'add' 
            alpha 0.0
            linear 0.3 alpha 0.3
        pause 0.1
        show introbars behind fuse:
            subpixel True pos (0.09, 2.94) zpos -2777.0
            matrixcolor InvertMatrix(0.0)*ContrastMatrix(2.54)*SaturationMatrix(0.29)*BrightnessMatrix(-0.3)*HueMatrix(1152.0)
            matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
            easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0)
        show intronamefuse behind fuse:
            subpixel True pos (0.09, 2.94) zpos -2777.0
            matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0) 
            easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
        pause 2.0
        show fuse:
            ease 0.5 xpos 0.30
        show ring behind fuse:
            linear 0.3 alpha 0.0
            zrotate 0.0
        show genericbackground behind fuse:
            linear 0.5 alpha 0.0
        show light3 onlayer overlays:
                linear 0.5 alpha 1.0
        show sunsetoverlay onlayer overlays:
                linear 0.5 alpha 1.0
        show light2 onlayer overlays:
                linear 0.5 alpha 0.0
        show cmfuse behind fuse:
            linear 0.3 alpha 0.0
        show fancy:
            linear 0.5 alpha 1.0
        pause 0.6
        hide ring
        hide introbars
        hide intronamefuse
        hide genericbackground
        hide cmfuse
        show charbox_overlay first_phase appear onlayer uielements
        show screen left_gui
        mdin "Short Fuse… Fittingly enough, it made his lack of temper evident."
        show fuse 2a with dis
        sf "Honestly, that might have been the best thing that has ever happened to me."

        sf "The Washouts are like, much cooler than the Wonderbolts. We do all kinds of extreme aerobatics and performances."
        show fuse 1b with dis
        sf "And of course, there are a ton of explosions! The Bolts are never going to match that."

        sf "One time, our leader tied herself to a rocket and almost made it into space. That was incredible!"
        camera:
            easein 0.3 pos (-1260, 2984) zpos -1959.0
        show lyra 2c with dis
        lh "Oh? How did it go?"
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        show fuse 1f with dis
        sf "Well, she may have ended up in the hospital, but she’s doing just fine."
        show fuse 2e with dis
        sf "That's what we Washouts live for! What’s life without a little bit of trouble?"
        camera:
            easein 0.3 pos (1305, 2984) zpos -2147.0
        show thunder 1b with dis:
            subpixel True pos (0.91, 2.69) zpos -1998.0
        stop music fadeout 1.0
        $ guiInfo.musictext_name = "null"
        unknown "But this goes beyond some ‘trouble’ when it puts other’s lives in danger."
        mdin "Another pegasus descended from the sky, landing next to us."
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        show fuse 2d with dis
        play music "Climax Reasoning (v3).ogg"
        $ guiInfo.musictext_name = "climaxreasoning"
        sf "Tch! Of course you’d say that."
        camera:
            easein 0.3 pos (1305, 2984) zpos -2147.0
        show thunder 6a with dis
        unknown "Well, what else do you want me to say?"
        camera:
            easein 0.3 pos (855, 2984) zpos -2418.0
        show fancy 1b with dis
        fp "Ah, greetings!"
        show fancy 5a with dis
        fp "We have more company, so you might want to introduce yourself to these lovely mares."
        camera:
            easein 0.3 pos (1305, 2984) zpos -2147.0
        show thunder 6b with dis
        unknown "Is that so? Well then…"
        show thunder 5c with dis
        unknown "I’m Thunderlane, a proud Wonderbolt! A pleasure to meet you!"

        #<INTRODUCTION:Thunderlane>
        show charbox_overlay first_phase disappear onlayer uielements
        hide screen left_gui
        show fancy:
            linear 0.5 alpha 0.0
        show fuse:
            linear 0.5 alpha 0.0
        window auto hide
        pause 0.3
        play sound "audio/sfx/Intro_V3.mp3"
        show genericbackground behind fuse:
            matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.04)*SaturationMatrix(0.32)*BrightnessMatrix(-0.01)*HueMatrix(351.0) 
            subpixel True pos (0.66, 2.81) zpos -2016.0
            alpha 0.0
            linear 0.5 alpha 1.0
        show light3 onlayer overlays:
            linear 0.5 alpha 0.0
        show sunsetoverlay onlayer overlays:
            linear 0.5 alpha 0.0
        show light2 onlayer overlays:
            blend 'add'
            alpha 0.0
            linear 0.5 alpha 1.0
        pause 0.2
        show thunder:
            subpixel True xpos 0.91
            ease 0.5 xpos 0.69
        show ring behind thunder:
            subpixel True pos (1.16, 2.83) zpos -2120.0 alpha 0.22 blend 'add' 
            alpha 0.0
            linear 0.3 alpha 0.3
            zrotate 0.0
            linear 5.0 zrotate 620.0
        show cmthunder behind thunder:
            subpixel True pos (1.16, 2.83) zpos -2120.0 alpha 0.22 blend 'add' 
            alpha 0.0
            linear 0.3 alpha 0.3
        pause 0.1
        show introbars behind thunder:
            subpixel True pos (0.7, 3.18) zpos -2075.0
            matrixcolor InvertMatrix(0.0)*ContrastMatrix(2.54)*SaturationMatrix(0.45)*BrightnessMatrix(-0.26)*HueMatrix(720.0) 
            matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
            easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0)
        show intronamethunder behind thunder:
            subpixel True pos (0.7, 3.18) zpos -2075.0
            matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0) 
            easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
        pause 2.0
        show thunder:
            ease 0.5 xpos 0.91
        show ring behind thunder:
            linear 0.3 alpha 0.0
            zrotate 0.0
        show genericbackground behind thunder:
            linear 0.5 alpha 0.0
        show light3 onlayer overlays:
            linear 0.5 alpha 1.0
        show sunsetoverlay onlayer overlays:
            linear 0.5 alpha 1.0
        show light2 onlayer overlays:
            linear 0.5 alpha 0.0
        show cmthunder behind thunder:
            linear 0.3 alpha 0.0
        show fancy:
            linear 0.5 alpha 1.0
        show fuse:
            linear 0.5 alpha 1.0
        pause 0.6
        hide ring
        hide introbars
        hide intronamethunder
        hide genericbackground
        hide cmthunder
        show charbox_overlay first_phase appear onlayer uielements
        show screen left_gui
        camera:
            easein 0.3 pos (-1260, 2984) zpos -1959.0
        show lyra 1d with dis
        lh "Woah, a Wonderbolt! Just like those two other pegasi we met!"
        camera:
            easein 0.3 pos (1305, 2984) zpos -2147.0
        show thunder 2a with dis
        tl "Heh, I’m guessing you mean Sky and Vapor? They’ve been helping me look around the place."
        camera:
            easein 0.3 pos (-1260, 2984) zpos -1959.0
        lh "Yeah, it’s so cool that you’re here with us!"
        show lyra 2a with dis
        lh "…Actually, I don't think I've seen you in any of the shows."
        camera:
            easein 0.3 pos (1305, 2984) zpos -2147.0
        show thunder 8a with dis
        tl "Well, that’s because I officially joined the group not too long ago."
        camera:
            easein 0.3 pos (855, 2984) zpos -2418.0
        show fancy 2a with dis
        fp "So, Mr. Thunderlane. I take it you’re done looking at the surroundings of the building?"
        camera:
            easein 0.3 pos (1305, 2984) zpos -2147.0
        show thunder 7a with dis
        tl "Yeah… And I didn’t find a single opening."
        camera:
            easein 0.3 pos (855, 2984) zpos -2418.0
        show fancy 4d with dis
        fp "Is that really so? Was there no window or vent to be opened?"
        camera:
            easein 0.3 pos (1305, 2984) zpos -2147.0
        show thunder 4a with dis
        tl "Nope. All the windows are shut, and all the vents are too small to crawl through."
        camera:
            easein 0.3 pos (855, 2984) zpos -2418.0
        fp "What about the roof? Surely there must have been a trapdoor of sorts."
        camera:
            easein 0.3 pos (1305, 2984) zpos -2147.0
        tl "Well, if there was, we didn't see any."
        camera:
            easein 0.3 pos (855, 2984) zpos -2418.0
        show fancy 7b with dis
        fp "*Sigh* It seems that we're apparently incapable of accessing the building in {color=#f1c232}any capacity.{/color}"
        mdin "Of course we wouldn't be able to investigate it."
        camera:
            easein 0.3 pos (972, 2984) zpos -2418.0
        show moondancer 1c onlayer uielements at charprotappear
        show charbox_overlay second_phase appear onlayer uielements
        md "So much for investigating, this doesn’t make any sense!"
        show moondancer 1c onlayer uielements at charprotdisappear
        show charbox_overlay second_phase disappear onlayer uielements
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        show fuse 2b with dis
        sf "I mean, at least some of us tried. The same can't be said for everypony."
        camera:
            easein 0.3 pos (855, 2984) zpos -2418.0
        show fancy 2b with dis
        play sound "sfx/dramatic.wav"
        fp "Short Fuse, we've already been through this."
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        sf "Yeah, and I figured out you're too scared of getting your hooves dirty, unlike me!"
        camera:
            easein 0.3 pos (1305, 2984) zpos -2147.0
        show thunder 1c with dis
        play sound "sfx/dramatichigher.wav"
        tl "And I think *you* should stop acting like everything will be solved with brute force."
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        show fuse 3a with dis
        sf "Please! You'd miss me if I didn't."
        sf "Besides, I'm taking some risks. Same can't be said about you and the Wonderbolts!"
        show fuse 2b with dis
        sf "Seriously, when was the last time you bozos tried something new? Always the same stunts and flights."
        camera:
            easein 0.3 pos (855, 2984) zpos -2418.0
        show fancy 3d with dis
        fp "Now, Short Fuse. There is no need to get personal. I ask you to take a moment to–"
        camera:
            easein 0.3 pos (1305, 2984) zpos -2147.0
        show thunder 3b with dis
        play music "Class Trial - Resurrection (v3).ogg"
        $ guiInfo.musictext_name = "classtrial_resurrection"
        tl "See? This is what got you expelled from the group to begin with."
        show thunder 4a with dis
        tl "I used to think we could have been great fliers together, but now..."
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        show fuse 2d with dis
        sf "Oh, don’t bother with your gaslighting. When I was kicked out, you didn’t even bother reaching out."
        camera:
            easein 0.3 pos (1305, 2984) zpos -2147.0
        show thunder 6a with dis
        tl "Because I was working hard on becoming a Wonderbolt!"
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        sf "Working hard, and you were stuck as a trainee until season 7."
        camera:
            easein 0.3 pos (1305, 2984) zpos -2147.0
        show thunder 1d with dis
        tl "Don't you dismiss my efforts like that!"
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        show fuse 3a with dis
        sf "And what are you gonna do about it?"
        camera:
            easein 0.3 pos (1305, 2984) zpos -2147.0
        show thunder 5e with dis
        play sound "sfx/shock.wav"
        tl "..."
        mdin "Thunderlane spread his wing open, staring fiercely at Short Fuse. They looked like they were ready to brawl at any moment…"
        camera:
            easein 0.3 pos (-1260, 2984) zpos -1959.0
        show lyra 4a with dis
        play sound "sfx/pianoreaction.wav"
        lh "Guys, wait!"
        camera:
            easein 0.3 pos (126, 2781) zpos -2849.0
        show fuse 2a with dis
        sf "You trying to square up or what? I’d hate to embarrass a Wonderbolt in front of his fans."
        show fuse 2e with dis
        sf "Oh right, you got none!"
        camera:
            easein 0.3 pos (1305, 2984) zpos -2147.0
        show thunder 5a with dis
        tl "...!"
        mdin "Thunderlane launched towards Short Fuse in a swift motion."
        show fuse at chardisappear
        mdin "However, Short Fuse flew off before Thunderlane could catch him."
        show thunder 5e with dis
        tl "Hey! Where do you think you're going?"
        sf "Time to test if you're Wonderbolts material, Thunder boy. Catch me if you can!"
        show thunder at chardisappear
        mdin "The two pegasi darted away, leaving us in a cloud of dust."
        md "*Cough*"
        show moondancer 1l onlayer uielements at charprotappear
        show charbox_overlay second_phase appear onlayer uielements
        stop music fadeout 1.0
        $ guiInfo.musictext_name = "null"
        md "Seriously, what is Short Fuse's problem?"
        camera:
            easein 0.3 pos (972, 2984) zpos -2418.0
        show fancy 7b with dis
        fp "I must apologize. He can be rather impulsive at times, but I believe he means well… for the most part."
        show moondancer 1g onlayer uielements with disalt
        md "I hope so. Somepony like him could be a liability in a situation like this."
        show fancy 6b with dis
        fp "I should make sure that neither of them get into trouble. If you’ll excuse me…"
        show fancy at chardisappear
        #<Fancy leaves>
        camera:
            easein 0.3 pos (-1172, 2984) zpos -1959.0
        show lyra 3a with dis
        play music "Climax Reasoning (v3).ogg"
        $ guiInfo.musictext_name = "climaxreasoning"
        lh "So, now what?"
        show moondancer 2a onlayer uielements with disalt
        md "Well, I think we should-"
        unknown "Ugh..."
        show moondancer 1e onlayer uielements with disalt
        show lyra 1f with dis
        mdin "Ah! That stallion! He's waking up!"
        show moondancer 1e onlayer uielements at charprotdisappear
        show charbox_overlay second_phase disappear onlayer uielements
        camera:
            easein 0.3 pos (-460, 2984) zpos -1959.0
        unknown "Agh…so loud! What is going-"
        show quibble 4b with dis
        unknown "…"
        show quibble 3b with dis
        unknown "Oh, fantastic. I woke up in the middle of nowhere yet again."
        camera:
            easein 0.3 pos (-1260, 2984) zpos -1959.0
        show lyra 3a with dis
        lh "Hey! Are you alright?"

        mdin "Lyra approached the stallion, but he quickly held up a hoof to stop her in her tracks."
        camera:
            easein 0.3 pos (-460, 2984) zpos -1959.0
        show quibble 1b with dis
        unknown "Hold on. Who are you? What am I doing here?"
        camera:
            easein 0.3 pos (-1260, 2984) zpos -1959.0
        show lyra 2d with dis
        lh "Well, I’m Lyra Heartstrings, and this is my friend Moondancer. We woke up here just like you!"
        camera:
            easein 0.3 pos (-460, 2984) zpos -1959.0
        show quibble 1c with dis
        unknown "...You don't know why we're here, huh?"
        show quibble 2b with dis
        unknown "Alright, whatever. I guess I’ll play along."
        unknown "The name is Quibble Pants, don’t know what else to say."
        #<INTRODUCTION:Quibble Pants>
        show charbox_overlay first_phase disappear onlayer uielements
        hide screen left_gui
        show lyra:
            linear 0.5 alpha 0.0
        window auto hide
        pause 0.3
        play sound "audio/sfx/Intro_V3.mp3"
        show genericbackground behind quibble:
            matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.14)*SaturationMatrix(0.51)*BrightnessMatrix(0.07)*HueMatrix(423.0) 
            subpixel True pos (-0.24, 2.78) zpos -1894.0
            alpha 0.0
            linear 0.5 alpha 1.0
        show light3 onlayer overlays:
            linear 0.5 alpha 0.0
        show sunsetoverlay onlayer overlays:
            linear 0.5 alpha 0.0
        show light2 onlayer overlays:
            blend 'add'
            alpha 0.0
            linear 0.5 alpha 1.0
        pause 0.2
        show quibble:
            subpixel True xpos 0.00
            ease 0.5 xpos -0.21
        show ring behind quibble:
            subpixel True pos (0.26, 2.80) zpos -1894.0 alpha 0.22 blend 'add' 
            alpha 0.0
            linear 0.3 alpha 0.3
            zrotate 0.0
            linear 5.0 zrotate 620.0
        show cmquibble behind quibble:
            subpixel True pos (0.26, 2.80) zpos -1894.0 alpha 0.22 blend 'add' 
            alpha 0.0
            linear 0.3 alpha 0.3
        pause 0.1
        show introbars behind quibble:
            subpixel True pos (-0.225, 3.15) zpos -1903.0
            matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.84)*SaturationMatrix(0.54)*BrightnessMatrix(-0.34)*HueMatrix(900.0) 
            matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
            easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0)
        show intronamequibble behind quibble:
            subpixel True pos (-0.225, 3.15) zpos -1903.0
            matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0) 
            easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
        pause 2.0
        show quibble:
            ease 0.5 xpos 0.00
        show ring behind quibble:
            linear 0.3 alpha 0.0
            zrotate 0.0
        show genericbackground behind quibble:
            linear 0.5 alpha 0.0
        show light3 onlayer overlays:
            linear 0.5 alpha 1.0
        show sunsetoverlay onlayer overlays:
            linear 0.5 alpha 1.0
        show light2 onlayer overlays:
            linear 0.5 alpha 0.0
        show cmquibble behind quibble:
            linear 0.3 alpha 0.0
        show lyra:
            linear 0.5 alpha 1.0
        pause 0.6
        hide ring
        hide introbars
        hide intronamequibble
        hide genericbackground
        hide cmquibble
        window auto show
        show charbox_overlay first_phase appear onlayer uielements
        show screen left_gui
        camera:
            easein 0.3 xpos -372
        show moondancer 2b onlayer uielements at charprotappear
        show charbox_overlay second_phase appear onlayer uielements
        md "Quibble Pants. Did you just say this is not the first time you wake up in an unknown place?"
        show quibble 2a with dis
        qp "It’s a long story. Let’s just say that some of my friends love pulling pranks on me."
        show quibble 1c with dis
        qp "One time, I woke up in the middle of a forest and my friends acted like some bunch of bandits that were going to kill me."
        camera:
            easein 0.3 pos (-1172, 2984) zpos -1959.0
        show lyra 4a with dis
        lh "Wait, really? That sounds… a little too much."
        camera:
            easein 0.3 pos (-372, 2984) zpos -1959.0
        show quibble 1a with dis
        qp "Anyways, what’s the deal with this place? I don’t remember how I got here, nor do I see an exit anywhere."
        md "Unfortunately, all of us are in the same boat. You're the last one to wake up."
        qp "..."
        show quibble 2a with dis
        stop music fadeout 1.0
        $ guiInfo.musictext_name = "null"
        qp "So, how did we get here then? Surely you can’t enter this place if there wasn’t an opening anywhere."
        camera:
            easein 0.3 pos (-1172, 2984) zpos -1959.0
        show lyra 1g with dis
        lh "We… don’t actually know. We were all kidnapped and have been investigating this place for some time now. We haven’t found anything so far."
        camera:
            easein 0.3 pos (-372, 2984) zpos -1959.0
        show quibble 1c with dis
        qp "I guess I’ll take your word for it. But I think that maybe you missed something."
        camera:
            easein 0.3 pos (-1172, 2984) zpos -1959.0
        show lyra 6b with dis
        lh "We didn’t miss anything. We tested magic, force, even digging out of here. Nothing worked."
        camera:
            easein 0.3 pos (-372, 2984) zpos -1959.0
        show quibble 2a with dis
        play sound "sfx/dramatichigher.wav"
        qp "Right. So you’re telling me somepony just threw up an impenetrable magic dome overnight, teleported us all inside, and now we’re stuck?"
        show quibble 3b with dis
        qp "Yeah, that’s ridiculous."
        show moondancer 4b onlayer uielements with disalt
        play music "Class Trial - Resurrection (v3).ogg"
        $ guiInfo.musictext_name = "classtrial_resurrection"
        md "We’re standing under it right now, how is it still up for debate?"
        show quibble 3c with dis
        qp "I don’t know, maybe because this whole situation is insane?"
        show quibble 2a with dis
        qp "For all we know, this could be yet another prank, or a setup."
        qp "Maybe some rich noblepony thought it’d be hilarious to trap a bunch of us in a giant fishbowl."
        qp "And the fact that you supposedly haven’t been able to break out… it’s too convoluted in my opinion."
        camera:
            easein 0.3 pos (-1172, 2984) zpos -1959.0
        show lyra 1h with dis
        lh "This seems way too complex to just be a prank."
        camera:
            easein 0.3 pos (-372, 2984) zpos -1959.0
        show quibble 1a with dis
        qp "You'd be surprised what ponies are willing to do for a laugh. Maybe if we find whoever’s running this joke, we can get out of here."
        show moondancer 1e onlayer uielements with disalt
        md "Or we could acknowledge reality and start figuring out what to do next."
        show quibble 4a with dis
        qp "Fine. Let's say you're right. Then what? Just give up and start making ourselves at home in the creepy abandoned hotel over there?"
        camera:
            easein 0.3 pos (-1172, 2984) zpos -1959.0
        show lyra 6a with dis
        lh "We can't even get inside the hotel yet. All the entrances are locked for some reason."
        camera:
            easein 0.3 pos (-372, 2984) zpos -1959.0
        show quibble 3b with dis
        qp "Oh great! More mysteries. Fantastic. Love that for us."
        show moondancer 1n onlayer uielements with disalt
        play sound "sfx/dramatic.wav"
        md "Complaining won't change the situation."
        show quibble 1c with dis
        qp "Neither will acting calm like we know everything."
        show quibble 2a with dis
        qp "If we were really kidnapped, shouldn't you be freaking out? I mean, you were literally taken into an isolated place against your will."
        camera:
            easein 0.3 pos (-1172, 2984) zpos -1959.0
        show lyra 1g with dis
        lh "You're right, but..."
        camera:
            easein 0.3 pos (-372, 2984) zpos -1959.0
        show quibble 1c with dis
        qp "So, why aren't you panicking? Why are you treating this like a vacation?"
        show moondancer 1h onlayer uielements with disalt
        play sound "sfx/shock.wav"
        md "Excuse me, a vacation?!"
        qp "You've been so nonchalant about this situation as if it was nothing but the newspaper’s sudoku."
        show moondancer 4b onlayer uielements with disalt
        md "The reason why we've been so calm—And that is an overstatement—It's because panicking won’t help."
        show quibble 2b with dis
        qp "Oh, how pragmatic of you."
        show quibble 1a with dis
        qp "I'm not believing in anything until I see proof, evidence. So far, you've got none."
        show moondancer 1g onlayer uielements with disalt
        mdin "This guy...!"
        md "Fine. If you're so insistent, then why don't you go investigate yourself?"
        show quibble 1b with dis
        qp "That is what I was going to do anyways."
        camera:
            easein 0.3 pos (-460, 2984) zpos -1959.0
        show quibble 4a with dis
        show moondancer onlayer uielements at charprotdisappear
        show charbox_overlay second_phase disappear onlayer uielements
        stop music fadeout 1.0
        $ guiInfo.musictext_name = "null"
        qp "Ugh, and I was having a normal Tuesday before I got dragged into something I didn’t sign up for."
        camera:
            easein 0.3 pos (-1260, 2984) zpos -1959.0
        show lyra 1f with dis
        lh "Quibble Pants, hold up!"
        camera:
            easein 0.3 pos (-460, 2984) zpos -1959.0
        show quibble 1d with dis
        qp "Huh?"
        camera:
            easein 0.3 pos (-1260, 2984) zpos -1959.0
        show lyra 1b with dis
        lh "Do you want to investigate together?"
        camera:
            easein 0.3 pos (-460, 2984) zpos -1959.0
        qp "Investigate together?"
        camera:
            easein 0.3 pos (-372, 2984) zpos -1959.0
        show moondancer 3a onlayer uielements at charprotappear
        show charbox_overlay second_phase appear onlayer uielements
        md "What?"

        mdin "Lyra, my blood pressure’s rising just talking to this guy, and you wanna work with him?"
        camera:
            easein 0.3 pos (-1260, 2984) zpos -1959.0
        show lyra 1a with dis
        show moondancer onlayer uielements at charprotdisappear
        show charbox_overlay second_phase disappear onlayer uielements
        lh "Yeah! The more numbers we have on our side, the faster we can figure this out."
        camera:
            easein 0.3 pos (-1260, 2984) zpos -1959.0
        show lyra 1b with dis
        lh "Besides, you seem like a very smart pony!"
        camera:
            easein 0.3 pos (-460, 2984) zpos -1959.0
        show quibble 1b with dis
        qp "Oh, uh… Thanks."
        camera:
            easein 0.3 pos (-1260, 2984) zpos -1959.0
        lh "So, what do you say?"
        camera:
            easein 0.3 pos (-460, 2984) zpos -1959.0
        show quibble 4b with dis
        qp "Hmm... Facing this situation alone or tagging along with a couple of ponies I just met."
        qp "You two already seem to know what's going on as well, but..."
        qp "..."
        show quibble 1a with dis
        qp "Sorry, but I think I'll go on my own."
        camera:
            easein 0.3 pos (-1260, 2984) zpos -1959.0
        show lyra 1f with dis
        lh "Wait, huh?"
        camera:
            easein 0.3 pos (-460, 2984) zpos -1959.0
        show quibble 4e with dis
        qp "Don't take this personally, I just work better alone."
        camera:
            easein 0.3 pos (-1260, 2984) zpos -1959.0
        show lyra 5b with dis
        lh "..."
        show lyra 5c with dis
        lh "I guess that's fair... I just hope you're able to trust us at some point."
        camera:
            easein 0.3 pos (-460, 2984) zpos -1959.0
        show quibble 1b with dis
        qp "Right..."
        #<Quibble leaves>
        show quibble 1b at chardisappear
        mdin "He left. What an intense guy."
        play music "Climax Reasoning (v3).ogg"
        $ guiInfo.musictext_name = "climaxreasoning"
        camera:
            easein 0.3 pos (-1172, 2984) zpos -1959.0
        show moondancer 2a onlayer uielements at charprotappear
        show charbox_overlay second_phase appear onlayer uielements
        show lyra 3c with dis
        lh "So there’s really nothing else to see here, huh?"
        md "For now, at least. But I suspect that won’t remain true for long."
        show lyra 1g with dis
        lh "And I thought this was the main place we were supposed to check… Talk about a big bust."
        lh "Well, I guess the last place to see is that market, right?"
        show moondancer 5a onlayer uielements with disalt
        md "Worth a shot, I suppose. Not like we can investigate anything else."
        show lyra 3b with dis
        lh "Alright! Come on, Moondancer!"
        hide screen left_gui
        show charbox_overlay full_phase disappear onlayer uielements
        show moondancer onlayer uielements at charprotdisappear
        window auto hide
        show light3 onlayer overlays:
            linear 0.6 alpha 0.0
        show sunsetoverlay onlayer overlays:
            linear 0.6 alpha 0.0
        $ renpy.pause(0.3)
        scene black with black
        camera:
            pos (0, 0) zpos 0.0
        $ renpy.pause(0.3)
        mdin "Lyra and I made our way to the market Fancy Pants mentioned."
        scene black with fade
        show screen left_gui
        show charbox_overlay first_phase appear onlayer uielements
        show popup cozymarket onlayer uielements:
            ypos 0.39 xpos -0.23 
            linear 0.30 xpos 0.07 
        camera:
            subpixel True pos (36, 2538) zpos -1449.0 perspective True
        show hotel exterior:
            subpixel True ypos 1.22 zpos -2790.0 zzoom True
        show lyra 2a with dis:
            subpixel True pos (0.25, 2.22) zpos -1300.0
        show light3 onlayer overlays:
            alpha 1.0
        show sunsetoverlay onlayer overlays:
            alpha 1.0
        $ overlay_background = "images/backgrounds/povhotel/charboxoverlay_hotelpov"
        lh "Cozy Market? Is that a brand?"
        camera:
            easein 0.3 xpos 153
        show charbox_overlay second_phase appear onlayer uielements
        show moondancer 1e onlayer uielements at charprotappear, zorder 4
        md "This sign... It looks like it was drawn by a foal."
        show lyra 1h with dis
        lh "Hey! Drawing signs is very difficult. Even Pinkie Pie struggles at it sometimes!"
        $ renpy.start_predict("images/backgrounds/povmarket/*.png")
        show moondancer 1a onlayer uielements with Dissolve(0.1)
        md "Whatever. Let's just get this over with..."
        hide screen left_gui
        show charbox_overlay full_phase disappear onlayer uielements
        show moondancer onlayer uielements at charprotdisappear
        show popup cozymarket onlayer uielements:
            linear 0.30 xpos -0.23
        $ renpy.pause(0.3)
label prologue_masala:
    $ menu_flag = True
    show light3 onlayer overlays:
            linear 0.3 alpha 0.0
    show sunsetoverlay onlayer overlays:
            linear 0.3 alpha 0.0
    scene black with black
    $ overlay_background = "images/backgrounds/povmarket/charboxoverlay_marketpov"
    camera:
        pos (0, 0) zpos 0.0
    $ renpy.pause(1.5)
    show screen left_gui
    show cozymarket with dis:
        subpixel True pos (450, 1.22) zpos -2790.0 zzoom True
    show leftshelf with dis:
        subpixel True pos (450, 1.22) zpos -2790.0 zzoom True
    show rightshelf with dis:
        subpixel True pos (450, 1.22) zpos -2790.0 zzoom True
    show lyra 1b with dis:
        subpixel True pos (-0.18, 2.11) zpos -2000.0
    camera:
        subpixel True pos (-801, 2403) zpos -2149.0 perspective True
    show overlay cozymarket onlayer overlays:
        blend "multiply"
    show screen left_gui
    show charbox_overlay first_phase appear onlayer uielements:
        matrixcolor InvertMatrix(0.0)*ContrastMatrix(0.89)*SaturationMatrix(1.32)*BrightnessMatrix(-0.07)*HueMatrix(-27.0) 
    window show
    lh "Huh, for some reason, I kinda thought this place would be more... full."
    md "I got a bad feeling about this..."
    window hide

    screen Investigation4():
            
        key "K_RETURN" action ToggleVariable("image_visible", True, False)

        add "fridge_label" xpos 545 + cam_x(-0.31) ypos 227 + cam_y(-0.33) alpha If(image_visible, 1.0, 0.0)

        add "boxes_label" xpos 360 + cam_x(-0.32) ypos 557 + cam_y(-0.33) alpha If(image_visible, 1.0, 0.0)

        add "door_label" xpos 1576 + cam_x(-0.33) ypos 267 + cam_y(-0.33) alpha If(image_visible, 1.0, 0.0)

        add "shelves_label" xpos 1090 + cam_x(-0.33) ypos 357 + cam_y(-0.33) alpha If(image_visible, 1.0, 0.0)

        add "lyra_label" xpos 210 + cam_x(-0.36) ypos 425 + cam_y(-0.38) alpha If(image_visible, 1.0, 0.0)
        
        imagebutton:
            
            xpos 460 + cam_x(-0.33) ypos 450 + cam_y(-0.33)
            
            auto "images/ui/fridgeButton_%s.png" action [ToggleScreen("Investigation4"), Jump("fridgeButtonDialouge")]
                

        imagebutton:
            
            xpos 400 + cam_x(-0.32) ypos 771 + cam_y(-0.33)
            
            auto "images/ui/boxButton_%s.png" action [ToggleScreen("Investigation4"), Jump("boxButtonDialouge")]

        imagebutton:
            
            xpos 1635 + cam_x(-0.33) ypos 425 + cam_y(-0.37)
            
            auto "images/ui/doorCozyMarketButton_%s.png" action [ToggleScreen("Investigation4"), Jump("doorCozyMarketButtonDialouge")]

        imagebutton:
            
            xpos 1070 + cam_x(-0.33) ypos 605 + cam_y(-0.33)
            
            auto "images/ui/shelfButton_%s.png" action [ToggleScreen("Investigation4"), Jump("shelfButtonDialouge")]

        imagebutton:
            
            xpos 290 + cam_x(-0.38) ypos 705 + cam_y(-0.4)
            
            auto "images/ui/lyraButton4_%s.png" action [ToggleScreen("Investigation4"), Jump("lyraButton4Dialouge")]
            
        

        
    default lyraCheck4 = False
    default shelfCheck = False
    default doorCozyMarketCheck = False
    default boxCheck = False
    default fridgeCheck = False
        
    $ menu_flag = True
    

label debug_investigationContinue4:
    if lyraCheck4 == False or shelfCheck == False or doorCozyMarketCheck == False or boxCheck == False or fridgeCheck == False:
        $ restore_master_layer(0.2)
        camera:
            easein 0.5 pos (900, 1543) zpos 275.0
    
        $ set_camera_pan(True, max_x=200, max_y=100)
    
        call screen Investigation4
        
    



label lyraButton4Dialouge:

    
    if lyraCheck4 == False or shelfCheck == False or doorCozyMarketCheck == False or boxCheck == False or fridgeCheck == False:
        pause (0.5)
        $ save_master_layer_position()
        $ reset_master_layer(0.108)
        play sound "sfx/tabopen.wav"
        pause (0.2)
        $ set_camera_pan(False)

        if lyraCheck4 == True:
            camera:
                easein 0.3 pos (-801, 2403) zpos -2149.0
            show lyra 7a with dis
            lh "..."
            camera:
                easein 0.3 pos (-713, 2403) zpos -2149.0
            show moondancer 1n onlayer uielements at charprotappear
            show charbox_overlay second_phase appear onlayer uielements
            md "Lyra."
            show lyra 1c with dis
            lh "What? I wasn't thinking about the oats, I swear!"

            mdin "Lyra, you've been drooling this entire time…"
            show moondancer 1n onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements

        if lyraCheck4 == False:
            camera:
                easein 0.3 pos (-713, 2403) zpos -2149.0
            show moondancer 2b onlayer uielements at charprotappear
            show charbox_overlay second_phase appear onlayer uielements
            md "Hey, Lyra?"
            show lyra 1c with dis
            lh "..."
            show moondancer 1a onlayer uielements with disalt
            md "...Lyra?"
            lh "..."
            show moondancer 1h onlayer uielements with disalt
            play sound 'audio/sfx/dramatichigher.wav'
            md "LYRA!"
            show lyra 4a with dis
            play sound 'audio/sfx/dramatic.wav'
            lh "GAH! Huh? Oh, what is it?"
            show moondancer 1k onlayer uielements with disalt
            md "... Can you help me investigate instead of just standing there drooling?"
            show lyra 5c with dis
            lh "Sorry! It's just... those are my favorite brand of oats over there..."
            md "Lyra, we don't even know if any of this stuff is safe to eat."
            show lyra 5d with dis
            lh "*Sigh* Fine..."
            mdin "Believe me, Lyra, I'd love to have something to fill my stomach, too..."
            show moondancer 1k onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements
            $ lyraCheck4 = True

        
        jump debug_investigationContinue4
    
    
label shelfButtonDialouge:
    if lyraCheck4 == False or shelfCheck == False or doorCozyMarketCheck == False or boxCheck == False or fridgeCheck == False:
        pause (0.5)
        $ save_master_layer_position()
        $ reset_master_layer(0.108)
        play sound "sfx/tabopen.wav"
        camera:
            ease 0.5 pos (1980, 2317) zpos -1625.0

        pause (0.5)
        $ set_camera_pan(False)

    
     
    
    
        mdin "These shelves are stocked with grains, canned foods, and other imported snacks."
        show moondancer 1g onlayer uielements at charprotappear
        show charbox_overlay second_phase appear onlayer uielements
        md "Can't exactly make a meal out of anything here. Not unless you eat corn straight from the can, anyway."
        camera:
            ease 0.3 pos (450, 2011) zpos -1958.0
        mdin "The other shelf had various toiletries. Soap, shampoo, toothpaste, and a few health care products like bandages and disinfectants."
        mdin "Helpful for a small injury, but if somepony's life were in danger..."
        show moondancer 1g onlayer uielements at charprotdisappear
        show charbox_overlay second_phase disappear onlayer uielements
        $ shelfCheck = True

        
        jump debug_investigationContinue4

label doorCozyMarketButtonDialouge:

    
    if lyraCheck4 == False or shelfCheck == False or doorCozyMarketCheck == False or boxCheck == False or fridgeCheck == False:
        pause (0.5)
        $ save_master_layer_position()
        $ reset_master_layer(0.108)
        play sound "sfx/tabopen.wav"
        camera:
            ease 0.5 pos (3015, 1642) zpos -2471.0
    
    
        pause (0.5)
        $ set_camera_pan(False)
        mdin "If I had to guess, this would lead to the staff room. Not that I see any staff around here."
        show moondancer 1n onlayer uielements at charprotappear
        show charbox_overlay second_phase appear onlayer uielements
        md "Locked, of course..."
        camera:
            easein 0.3 pos (-713, 2403) zpos -2149.0
        show lyra 3b with dis
        lh "You think whoever abducted us is behind that door?"
        md "I don't think it'd be that easy, Lyra."
        show moondancer 1n onlayer uielements at charprotdisappear
        show charbox_overlay second_phase disappear onlayer uielements
        $ doorCozyMarketCheck = True

        
        jump debug_investigationContinue4

label boxButtonDialouge:

    
    if lyraCheck4 == False or shelfCheck == False or doorCozyMarketCheck == False or boxCheck == False or fridgeCheck == False:
        pause (0.5)
        $ save_master_layer_position()
        $ reset_master_layer(0.108)
        play sound "sfx/tabopen.wav"
        camera:
            ease 0.5 pos (900, 1543) zpos 275.0
    
    
        pause (0.5)
        $ set_camera_pan(False)
        if boxCheck == True:
            mdin "Nothing but junk in there, no reason to keep looking through."
        if boxCheck == False:

            mdin "Maybe there's something useful in these boxes."
            mdin "I searched through as many boxes as I could, but they were filled with nothing but random junk."
            show moondancer 1b onlayer uielements at charprotappear
            show charbox_overlay second_phase appear onlayer uielements
            md "Well that was a total waste of time..."
            camera:
                easein 0.3 pos (-713, 2403) zpos -2149.0
            show lyra 1d with dis
            lh "I wouldn't say that, now we know there's nothing in those boxes!"
            mdin "I wish I had your optimism, Lyra..."
            show moondancer 1b onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements
            $ boxCheck = True

        
        jump debug_investigationContinue4

label fridgeButtonDialouge:

    
    if lyraCheck4 == False or shelfCheck == False or doorCozyMarketCheck == False or boxCheck == False or fridgeCheck == False:
        pause (0.5)
        $ save_master_layer_position()
        $ reset_master_layer(0.108)
        play sound "sfx/tabopen.wav"
        camera:
            ease 0.3 pos (-171, 1741) zpos -2471.0
    
    
        pause (0.5)
        $ set_camera_pan(False)
        if fridgeCheck == True:
            show moondancer 2a onlayer uielements at charprotappear
            show charbox_overlay second_phase appear onlayer uielements
            md "Why bother putting only a few bottles of drinks in the fridge?"
            camera:
                easein 0.3 pos (-713, 2403) zpos -2149.0
            show lyra 1i with dis
            lh "Maybe whoever took us is keeping all the good stuff for themselves?"

            md "That’s one theory…"
            show moondancer 2a onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements
        if fridgeCheck == False:
            show lyra 1c with dis
            lh "Ooh, maybe there's something good to eat in the fridge!"
            mdin "We opened the fridge, but there were only some bottles of soda, cider, and a few bags of ice."
            camera:
                easein 0.3 pos (-801, 2403) zpos -2149.0
            show lyra 5e with dis
            lh "Aw, I was hoping there'd be some fruits or vegetables to eat in here. Oh well, at least I can quench my thirst."
            camera:
                easein 0.3 pos (-713, 2403) zpos -2149.0
            show moondancer 4b onlayer uielements at charprotappear
            show charbox_overlay second_phase appear onlayer uielements
            md "Lyra, we don't know if that's-"
            greentext "*Kshhhh!*"
            show moondancer 3a onlayer uielements with disalt
            md "...Huh?"
            show lyra 1d with dis
            lh "Ahhh, much better!"
            md "The soda was still...fizzy?"
            lh "Mmhm! Really hit the spot!"
            mdin "If the soda was still fizzy, that would mean those bottles were put in the fridge recently..."
            show moondancer 3a onlayer uielements at charprotdisappear
            show charbox_overlay second_phase disappear onlayer uielements
            $ fridgeCheck = True

        
        jump debug_investigationContinue4

label investigationComplete4:
    # Everything Investigated
    $ reset_master_layer(0.108)
    camera:
            easein 0.5 pos (900, 1543) zpos 275.0
    greentext "Investigation Complete."
    camera:
        easein 0.3 pos (-801, 2403) zpos -2149.0
    show lyra 5f with dis
    lh "I really thought there'd be more than just a few snacks in here. Or at least something else useful that would help us escape."
    md "Yeah, but there's still a little more in here to investigate. Come on, Lyra."
    mdin "We turned the corner into the next aisle, and..."
    # CG Weapons in the Market
    stop music fadeout 1.0
    $ guiInfo.musictext_name = "null"
    hide screen left_gui
    show charbox_overlay first_phase disappear onlayer uielements
    window hide
    $ renpy.pause(0.3)
    scene black with black
    camera:
        pos (0, 0) zpos 0.0
    $ renpy.pause(0.5)
    hide overlay cozymarket onlayer overlays
    #<CG: Weapons in the Market>
    show cg weapons with fade
    
    mdCGin "On the wall were lined up a variety of tools. From shovels to hammers, axes and what appeared to be a stun gun."
    mdCG "Huh? What are these doing here?"
    lhCG "An axe? Why in Equestria would someone need an axe in a place like this?"
    unknownCG "S-Step back!"
    lhCG "Huh?"
    scene black with black
    camera:
        pos (0, 0) zpos 0.0
    $ renpy.pause(1.5)
    show screen left_gui
    show cozymarket with dis:
        subpixel True pos (450, 1.22) zpos -2790.0 zzoom True
    show leftshelf with dis:
        subpixel True pos (450, 1.22) zpos -2790.0 zzoom True
    show rightshelf with dis:
        subpixel True pos (450, 1.22) zpos -2790.0 zzoom True
    show pommel 1a behind masala with dis:
        subpixel True pos (0.75, 2.11) zpos -2074.0
    show lyra 1a with dis:
        subpixel True pos (-0.18, 2.11) zpos -2000.0
    camera:
        subpixel True pos (990, 2403) zpos -2223.0 perspective True
    show overlay cozymarket onlayer overlays:
        blend "multiply"
    show screen left_gui
    show charbox_overlay first_phase appear onlayer uielements
    window show
    unknown "You aren't allowed in here. S-So please go away!"
    #<Fade to Normal>
    camera:
        easein 0.3 xpos 990 zpos -2223.0
    mdin "Without either of us realizing, a mare came up from behind. She looked timid, but completely on edge."
    camera:
        easein 0.3 pos (-801, 2403) zpos -2149.
    show lyra 4a with dis
    lh "We were just checking this place, we're not going to–"
    camera:
        easein 0.3 xpos 990 zpos -2223.0
    show pommel 3a with dis
    unknown "You can't take these... Please, just leave them alone and go!"
    md "..."
    camera:
        easein 0.3 pos (-801, 2403) zpos -2149
    show lyra 2d with dis
    lh "..."
    camera:
        easein 0.3 xpos 990 zpos -2223.0
    show pommel 2a with dis
    unknown "..."
    mdin "She's trembling, I don't know how we can de-escalate..."
    camera:
        easein 0.3 pos (342, 2394) zpos -2025.0
    show masala 6a behind lyra with dis:
        subpixel True pos (0.41, 2.11) zpos -1876.0
    unknown "What's the commotion, Coco?"
    mdin "This taller mare... have I seen her before?"
    camera:
        easein 0.3 xpos 990 zpos -2223.0
    show pommel 6a with dis
    unknown "Well, two ponies entered the market and I'm just making sure nopony touches these things."
    camera:
        easein 0.3 pos (342, 2394) zpos -2025.0
    show masala 6b with dis
    unknown "Ah, thank you for keeping guard on the tools, but you can stop now."
    show masala 5c with dis
    unknown "What do you say we introduce ourselves to the two mares?"
    camera:
        easein 0.3 xpos 990 zpos -2223.0
    show pommel 3b with dis
    unknown "Oh… Alright."
    show pommel 3c with dis
    unknown "I'm Coco Pommel, just a dressmaker from Manehattan."
    #<INTRODUCTION: Coco Pommel>
    show charbox_overlay first_phase disappear onlayer uielements
    hide screen left_gui
    show masala:
        linear 0.5 alpha 0.0
    window auto hide
    pause 0.3
    play sound "audio/sfx/Intro_V3.mp3"
    show genericbackground behind pommel:
        matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.14)*SaturationMatrix(0.95)*BrightnessMatrix(0.06)*HueMatrix(270.0) 
        subpixel True pos (0.50, 2.23) zpos -2092.0
        alpha 0.0
        linear 0.5 alpha 1.0
    show overlay cozymarket onlayer overlays:
        linear 0.5 alpha 0.0
    pause 0.2
    show pommel:
        subpixel True xpos 0.75
        ease 0.5 xpos 0.53
    show ring behind pommel:
        subpixel True pos (1.00, 2.25) zpos -2196.0 alpha 0.22 blend 'add' 
        alpha 0.0
        linear 0.3 alpha 0.3
        zrotate 0.0
        linear 5.0 zrotate 620.0
    show cmpommel behind pommel:
        subpixel True pos (1.00, 2.25) zpos -2196.0 alpha 0.22 blend 'add' 
        alpha 0.0
        linear 0.3 alpha 0.3
    pause 0.1
    show introbars behind pommel:
        subpixel True pos (0.54, 2.60) zpos -2151.0
        matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.84)*SaturationMatrix(0.54)*BrightnessMatrix(-0.24)*HueMatrix(1233.0) 
        matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
        easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0)
    show intronamepommel behind pommel:
        subpixel True pos (0.54, 2.60) zpos -2151.0
        matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0) 
        easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
    pause 2.0
    show pommel:
        ease 0.5 xpos 0.75
    show ring behind pommel:
        linear 0.3 alpha 0.0
        zrotate 0.0
    show genericbackground behind pommel:
        linear 0.5 alpha 0.0
    show overlay cozymarket onlayer overlays:
        linear 0.5 alpha 1.0
    show cmpommel behind pommel:
        linear 0.3 alpha 0.0
    show masala:
        linear 0.5 alpha 1.0
    pause 0.6
    hide ring
    hide introbars
    hide intronamepommel
    hide genericbackground
    hide cmvpommel
    window auto show
    show charbox_overlay first_phase appear onlayer uielements
    show screen left_gui
    play music 'Cool Morning (V3).ogg'
    $ guiInfo.musictext_name = "coolmorning"
    camera:
        easein 0.3 pos (342, 2394) zpos -2025.0
    show masala 1a with dis
    unknown "And the name is Saffron Masala, nice to meet you!"
    #<INTRODUCTION: Saffron Masala>
    show charbox_overlay first_phase disappear onlayer uielements
    hide screen left_gui
    show pommel:
        linear 0.5 alpha 0.0
    window auto hide
    pause 0.3
    play sound "audio/sfx/Intro_V3.mp3"
    show genericbackground behind masala:
        matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.14)*SaturationMatrix(0.65)*BrightnessMatrix(0.05)*HueMatrix(765.0) 
        subpixel True pos (0.16, 2.23) zpos -1894.0
        alpha 0.0
        linear 0.5 alpha 1.0
    show overlay cozymarket onlayer overlays:
        linear 0.5 alpha 0.0
    pause 0.2
    show masala:
        subpixel True xpos 0.41
        ease 0.5 xpos 0.19
    show ring behind masala:
        subpixel True pos (0.66, 2.25) zpos -1894.0 alpha 0.22 blend 'add' 
        alpha 0.0
        linear 0.3 alpha 0.3
        zrotate 0.0
        linear 5.0 zrotate 620.0
    show cmmasala behind masala:
        subpixel True pos (0.66, 2.25) zpos -1894.0 alpha 0.22 blend 'add' 
        alpha 0.0
        linear 0.3 alpha 0.3
    pause 0.1
    show introbars behind masala:
        subpixel True pos (0.20, 2.60) zpos -1953.0
        matrixcolor InvertMatrix(0.0)*ContrastMatrix(2.54)*SaturationMatrix(0.29)*BrightnessMatrix(-0.37)*HueMatrix(1341.0)
        matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
        easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0)
    show intronamemasala behind masala:
        subpixel True pos (0.20, 2.60) zpos -1953.0
        matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0) 
        easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
        easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
    pause 2.0
    show masala:
        ease 0.5 xpos 0.41
    show ring behind masala:
        linear 0.3 alpha 0.0
        zrotate 0.0
    show genericbackground behind masala:
        linear 0.5 alpha 0.0
    show overlay cozymarket onlayer overlays:
        linear 0.5 alpha 1.0
    show cmmasala behind masala:
        linear 0.3 alpha 0.0
    show pommel:
        linear 0.5 alpha 1.0
    pause 0.6
    hide ring
    hide introbars
    hide intronamemasala
    hide genericbackground
    hide cmmasala
    show screen left_gui
    show charbox_overlay first_phase appear onlayer uielements
    mdin "Coco Pommel and Saffron Masala... I believe that would make us fifteen ponies in total."
    camera:
        easein 0.3 pos (-801, 2403) zpos -2149
    show lyra 1b with dis
    lh "Hold on… Are you the Saffron Masala? Like, the owner of The Tasty Treat?"
    show lyra 1d with dis
    lh "Oh Celestia, your food is amazing! I still dream about that biryani!"
    camera:
        easein 0.3 pos (342, 2394) zpos -2025.0
    show masala 5d with dis
    sm "Thank you, I really appreciate it! Though the restaurant is run by me and my father, I don't feel great taking all the credit, haha."
    camera:
        easein 0.3 pos (-801, 2403) zpos -2149
    show lyra 2b with dis
    lh "Oops, sorry."
    camera:
        easein 0.3 pos (342, 2394) zpos -2025.0
    show masala 5c with dis
    sm "It's fine, a common mistake."
    camera:
        easein 0.3 xpos 990 zpos -2223.0
    show pommel 3a with dis
    cp "Ah... don't talk about food, it makes me hungry! I haven't eaten anything since yesterday."
    camera:
        easein 0.3 pos (342, 2394) zpos -2025.0
    show masala 2c with dis
    sm "Oh, Celestia. Why is that?"
    camera:
        easein 0.3 xpos 990 zpos -2223.0
    show pommel 6b with dis
    cp "I-I was, umm... Really focused on working on a dress."
    cp "Sometimes I'm so focused that I tend forget to eat or sleep..."
    camera:
        easein 0.3 pos (342, 2394) zpos -2025.0
    show masala 5a with dis
    sm "Aw, I would love to cook for you, but there's no kitchen for what I've seen."
    camera:
        easein 0.3 xpos 990 zpos -2223.0
    show pommel 4a with dis
    cp "Oh, well. At least we have food for a few days..."
    camera:
        easein 0.3 pos (-801, 2403) zpos -2149
    show lyra 1c with dis
    lh "See, Moondancer? I told you we'd have edible food here."
    show moondancer 5b onlayer uielements at charprotappear
    show charbox_overlay second_phase appear onlayer uielements
    play sound 'audio/sfx/shock.wav'
    camera:
        easein 0.3 pos (-702, 2403) zpos -2149
    md "Hold on, are we sure it's even safe to eat?"
    camera:
        easein 0.3 pos (441, 2394) zpos -2025.0
    show masala 4a with dis
    sm "Well, I was checking the food here and I haven't been able to find anything fresh."
    sm "It's only canned food, grains and other junk food. Though I guess I can still work with this, as long as there's spices somewhere."
    camera:
        ease 0.5 pos (3285, 1642) zpos -2471.0 
    md "So there's really no vegetables or fruits here, right? What about behind that door?"
    camera:
        easein 0.3 pos (441, 2394) zpos -2025.0
    show masala 6a with dis
    sm "Oh, that?"
    sm "Sadly, the door is locked. We couldn't enter it no matter how hard we tried."
    show moondancer 1n onlayer uielements with Dissolve(0.1)
    mdin "Great, yet another mystery..."
    sm "Regardless, if we're trapped, at least we are guaranteed to last for a couple of days. Provided food is divided equally, at least."
    camera:
        easein 0.3 pos (-702, 2403) zpos -2149
    show lyra 2b with dis
    lh "Great! Maybe they wanted to make sure we'd get all the food we needed?"
    camera:
        easein 0.3 xpos 1098 zpos -2223.0
    show pommel 3b with dis
    cp "Don't be ridiculous... Kidnappers don't care about the living conditions of their victims."
    show pommel 3c with dis
    cp "They could even leave the victim to starve, for all they cared."
    show moondancer 2b onlayer uielements with Dissolve(0.1)
    md "What about these tools? Surely a kidnapper wouldn't provide the victim any means of escaping, either."
    show pommel 5c with dis
    cp "..."
    play sound 'audio/sfx/embrarassed.wav'
    cp "Aah! I don't know anymore! This situation has been really confusing."
    camera:
        easein 0.3 pos (441, 2394) zpos -2025.0
    show masala 4b with dis
    sm "I mean, I don't think you can really use these tools for escape."
    sm "But the fact that they made some tools accessible for everyone…"
    show masala 6a with dis
    sm "Something makes me think that we're meant to use them."
    camera:
        easein 0.3 pos (-702, 2403) zpos -2149
    show lyra 4a with dis
    play sound 'audio/sfx/shock.wav'
    lh "What? But why would I even want to use a stun gun?!"
    camera:
        easein 0.3 xpos 1098 zpos -2223.0
    show pommel 1b with dis
    cp "But having these tools... wouldn't it also be a liability for our kidnappers?"
    cp "We could use these to seriously injure them. It doesn't make sense to me."
    camera:
        easein 0.3 pos (441, 2394) zpos -2025.0
    sm "..."
    show masala 6b with dis
    sm "You're right, my apologies. That was a ridiculous theory."
    show moondancer 1e onlayer uielements with Dissolve(0.1)
    md "No. I think you're onto something."
    show masala 2c with dis
    sm "Huh?"
    md "So far we've been thinking of this like a normal kidnapping situation."
    md "But that doesn't explain everything we've encountered so far. That makes me believe... Something more {color=#f1c232}sinister{/color} is coming next."
    camera:
        easein 0.3 xpos 1098 zpos -2223.0
    show pommel 2a with dis
    cp "M-More sinister?"
    camera:
        ease 0.5 pos (900, 2308) zpos 275.0
    stop music
    $ guiInfo.musictext_name = "null"
    play sound 'audio/sfx/intercom.wav'
    unknown "{i}Everypony, please come to the hotel for an important gathering.{/i}"
    show moondancer 3a onlayer uielements with Dissolve(0.1)
    mdin "Before I could respond, a sudden voice echoed through the store, like if it came from a magic speaker."
    mdin "It had a childish ring to it... as if it came from a foal."
    camera:
        easein 0.3 pos (-702, 2403) zpos -2149
    play sound 'audio/sfx/dramatic.wav'
    lh "What the hay? Who said that?"
    camera:
        easein 0.3 xpos 1098 zpos -2223.0
    play sound 'audio/sfx/dramatichigher.wav'
    cp "I... I don't like this. Not one bit."
    mdin "My heart sank as I processed the announcement. It didn't feel like a request. It was an order."
    camera:
        easein 0.3 pos (-702, 2403) zpos -2149
    lh "The hotel? But it was just closed a moment ago!"
    lh "Do you think we should go?"
    camera:
        easein 0.3 pos (441, 2394) zpos -2025.0
    show masala 2b with dis
    sm "Hold on, are we sure we want to comply with whatever they're saying?"
    camera:
        ease 0.5 pos (900, 2308) zpos 275.0
    unknown "{i}Failure to attend will result in immediate {color=#f1c232}punishment{/color}, so don't make me wait.{/i}"
    show moondancer 1l onlayer uielements with Dissolve(0.1)
    mdin "Punishment? That voice... It was now threatening us."
    camera:
        easein 0.3 xpos 1098 zpos -2223.0
    show pommel 5b with dis
    play sound 'audio/sfx/pianoreaction.wav'
    cp "Ah! I don't want to die for being disobedient... I have to go!"
    camera:
        easein 0.3 pos (441, 2394) zpos -2025.0
    play sound 'audio/sfx/footstepsfast.wav'
    show pommel at chardisappear
    show masala 2d with dis
    sm "Coco, wait!-"
    mdin "Coco Pommel didn't hesitate to leave us."
    show masala at chardisappear
    play sound 'audio/sfx/footstepsmedium.wav'
    mdin "Saffron Masala ran after her, leaving Lyra and I alone."
    camera:
        easein 0.3 pos (-702, 2403) zpos -2149
    lh "..."
    show moondancer 2c with dis
    md "The announcer sounded like a filly..."
    md "I'm pretty sure it was a trick, ike a voice-altering spell."
    show lyra 1g with dis
    lh "But the only time I've heard of ponies changing their voices was with those flowers from the Everfree Forest."
    lh "...There's no way an actual filly is involved in this! It's just... creepy to think about."
    show fancy 1a behind pommel with dis:
        subpixel True pos (1.44, 2372) zpos -2274.0
    camera:
        easein 0.3 pos (2417, 2.22) zpos -2423.0
    show fancy 1g behind pommel with dis:
        subpixel True pos (1.44, 2.11) zpos -2274.0
    fp "Ladies? Apologies for interrupting, but I believe your presence is already requested somewhere."
    mdin "Despite his usual composure, Fancy Pants's tone carried an edge of urgency."
    camera:
        easein 0.3 pos (-702, 2403) zpos -2149
    show lyra 2c with dis
    lh "Oh. Fancy Pants! Are you gathering everypony?"
    camera:
        easein 0.3 pos (2417, 2.22) zpos -2423.0
    show fancy 7b with dis
    fp "We don't want to find out the true extent of our captor's malice. I advise that we simply follow along."
    camera:
        easein 0.3 pos (-702, 2403) zpos -2149
    show lyra 5b
    lh "Right, sorry. Let's go, Moondancer."
    hide screen left_gui
    show charbox_overlay full_phase disappear onlayer uielements
    show moondancer onlayer uielements at charprotdisappear
    window hide
    label prologue_cozy:
        $ menu_flag = True
        $ renpy.start_predict("images/backgrounds/povfoyer/*.png")
        scene black with black
        camera:
            pos (0, 0) zpos 0.0
        $ renpy.pause(1.2)
        hide overlay cozymarket onlayer overlays
        mdCGin "'Punishment.' That's what the voice said."
        mdCGin "Something so simple, yet so ominous. What could it possibly mean?"
        mdCGin "It wasn't just the punishment hanging over us now. There was still the hotel, the dome, the kidnapping... none of it made sense."
        mdCGin "I didn't have all the answers yet."
        mdCGin "..."
        $ overlay_background = "images/backgrounds/povfoyer/charboxoverlay_foyerpov"
        mdCGin "..."
        mdCGin "We finally made our way to the hotel, which was indeed open."
        mdCGin "Inside was almost everypony present, with a few missing. They shared our same look of uncertainty."
        mdCGin "But as I kept looking into the crowd, I couldn't find the pony who had called us."
        window hide
        $ renpy.pause (1.2)
        scene black
        show foyerbackground with black:
            subpixel True pos (400, 1.7) zpos -3590.0 zzoom True
        camera:
            subpixel True pos (1747, 2349) zpos -2561.0 perspective True
        show sunburst 1a behind fancy with dis:
            subpixel True pos (1.0, 2.11) zpos -1800.0
        show zephyr 5a behind sunburst with dis:
            subpixel True pos (1.6, 2.11) zpos -1774.0
        show sky 1h behind zephyr with dis:
            subpixel True pos (-0.25, 2.11) zpos -1800.0
        show quibble 1a behind sky with dis:
            subpixel True pos (0.75, 2.11) zpos -1874.0
        show masala 4b behind quibble with dis:
            subpixel True pos (0.30, 2.11) zpos -1876.0
        show thunder 1b behind masala with dis:
            subpixel True pos (1.3, 2.11) zpos -1974.0
        show vapor 2a behind thunder with dis:
            subpixel True pos (-0.53, 2.11) zpos -2028.0
        show fancy 1d behind vapor with dis:
            subpixel True pos (1.15, 2.11) zpos -2376.0
            alpha 0.0
            linear 0.3 alpha 1.0
        show limestone 1a behind fancy with dis:
            subpixel True pos (0.6, 2.11) zpos -2374.0
        show babs 1a behind limestone with dis:
            subpixel True pos (-0.3, 2.11) zpos -2874.0
        show lyra 1f behind babs with dis:
            subpixel True pos (1.45, 2.11) zpos -2574.0
        show silverstar 1e behind vapor with dis:
            subpixel True pos (-0.05, 2.11) zpos -2974.0
        show pommel 4b behind lyra with dis:
            subpixel True pos (0.85, 2.11) zpos -2774.0
        show fuse 2d behind pommel with dis:
            subpixel True pos (0.45, 2.11) zpos -2974.0
        show foyertable behind vapor with dis:
            subpixel True pos (291, 1.84) zpos -3049.0 zzoom True
        show sunsetoverlay onlayer overlays:
            alpha 1.0
            blend 'multiply'
        hide limestone
        hide sunburst
        show screen right_gui
        show charbox_overlay first_phase appear onlayer uielements
        play music 'Almost Hell Heaven (v3).ogg'
        $ guiInfo.musictext_name = "almosthellheaven"
        fp "You stay here. I'll gather the remaining ponies."
        show fancy at chardisappear
        mdin "Fancy Pants left immediately."
        camera:
            easein 0.3 pos (-971, 2403) zpos -1949.0
        sky "Who called us? Where are they?"
        camera:
            easein 0.3 pos (-1472, 2403) zpos -2177.0
        vt "A-Are we finally meeting our kidnappers?"
        camera:
            easein 0.3 pos (1171, 2403) zpos -2923.0
        cp "We entered the hotel, but we haven't found anypony!"
        camera:
            easein 0.3 pos (400, 2403) zpos -3123.0
        sf "Oh great, a freakin' prankster. Typical."
        camera:
            easein 0.3 pos (2600, 2403) zpos -1923.0
        zb "Sorry for being fashionably late — I'm here now~"
        camera:
            easein 0.3 pos (-1046, 2493) zpos -3059.0
        show babs 1c with dis
        bs "What's with dis guy...?"
        camera:
            easein 0.3 pos (2036, 2403) zpos -2123.0
        show thunder 6a with dis
        tl "One, two, three..."
        mdin "Thunderlane counted under his breath."
        show thunder 1c with dis
        tl "...Alright... Twelve of us are here."
        camera:
            easein 0.3 pos (-510, 2385) zpos -3185.0
        show silverstar 3a with dis
        silverstar "I reckon seeing fifteen of us here when I first woke up. There's still three missing."
        camera:
            easein 0.3 pos (950, 2403) zpos -2023.0
        show quibble 2a with dis
        qp "Really? Did they not get the memo or something?"
        mdin "Three missing..."
        mdin "Fancy Pants appeared, levitating Limestone in an aura of magic."
        camera:
            easein 0.3 pos (690, 2403) zpos -2523.0
        show limestone 4a behind fancy with dis:
            subpixel True pos (0.6, 2.11) zpos -2374.0
        show fancy 1b behind vapor with dis:
            subpixel True pos (1.15, 2.11) zpos -2376.0
        play sound 'audio/sfx/shock.wav'
        lp "Ugh! I said put me down!"
        play sound 'audio/sfx/thud.wav'
        mdin "He unceremoniously dropped her on the ground, landing with a loud thud."
        show limestone 3a with dis
        mdin "With Limestone accounted for, that left just one."
        mdin "And that pony was... Sunburst!"
        camera:
            xpos 690 
            easein 0.3 xpos 879 
        show charbox_overlay second_phase appear onlayer uielements
        show moondancer 2b onlayer uielements at charprotappear
        md "Silverstar! Have you seen Sunburst?"
        camera:
            easein 0.3 pos (-384, 2385) zpos -3185.0
        silverstar "Huh? I'm afraid I haven't."
        camera:
            easein 0.3 pos (2350, 2403) zpos -2723.0
        lh "Where could he be? We agreed to meet up later!"
        camera:
            easein 0.3 xpos 2332
        show charbox_overlay second_phase disappear onlayer uielements
        show moondancer onlayer uielements at charprotdisappear
        mdin "On cue, he finally burst through the doors, panting heavily."
        show sunburst 1c behind zephyr with dis:
            subpixel True pos (1.0, 2.11) zpos -1800.0
        camera:
            easein 0.3 pos (1453, 2385) zpos -2021.0 
        sunburst "I'm... I'm so sorry everyone. I thought I had seen something-"
        camera:
            easein 0.3 pos (400, 2403) zpos -3123.0
        show fuse 1f with dis
        sf "So, does that mean everypony is here?"
        camera:
            easein 0.3 pos (-510, 2385) zpos -3185.0
        silverstar "I think so, yeah."
        camera:
            easein 0.3 pos (1453, 2385) zpos -2021.0 
        sunburst "Where's... Who called us here?"
        camera:
            easein 0.3 pos (-971, 2403) zpos -1949.0
        sky "Yeah! Why summon us if you're not even going to show up?"
        camera:
            easein 0.3 pos (100, 2394) zpos -2025.0
        stop music fadeout 1.0
        $ guiInfo.musictext_name = "null"
        sm "..."
        show masala 2c with dis
        sm "Everypony, over there!"
        mdin "We all looked to where Saffron was pointing, and what appeared in front of us was..."
        hide screen right_gui
        window hide
        show charbox_overlay first_phase disappear onlayer uielements
        hide masala
        hide quibble
        hide limestone
        hide silverstar
        hide babs
        hide pommel
        hide zephyr
        hide fuse
        hide fancy
        hide sunburst
        hide sky
        hide vapor
        hide foyertable
        hide thunder
        hide lyra
        scene black with black
        hide foyerbackground
        camera:
            pos (0, 0) zpos 0
        
        pause 3.0

        image headmasterappear = Movie(play="images/videos/headmasterappear.webm")
        show headmasterappear
        pause 12.5
        hide headmasterappear
        pause 1.0
        show foyerbackground with black:
            subpixel True pos (400, 1.7) zpos -3590.0 zzoom True
        camera:
            subpixel True pos (1300, 1903) zpos -3649.0
        show sunburst 6a behind fancy with dis:
            subpixel True pos (1.0, 2.11) zpos -1800.0
        show zephyr 1a behind sunburst with dis:
            subpixel True pos (1.6, 2.11) zpos -1774.0
        show sky 1d behind zephyr with dis:
            subpixel True pos (-0.25, 2.11) zpos -1800.0
        show quibble 1d behind sky with dis:
            subpixel True pos (0.75, 2.11) zpos -1874.0
        show masala 1a behind quibble with dis:
            subpixel True pos (0.30, 2.11) zpos -1876.0
        show thunder 2c behind masala with dis:
            subpixel True pos (1.3, 2.11) zpos -1974.0
        show vapor 1a behind thunder with dis:
            subpixel True pos (-0.53, 2.11) zpos -2028.0
        show fancy 7d behind vapor with dis:
            subpixel True pos (1.15, 2.11) zpos -2376.0
        show limestone 1f behind fancy with dis:
            subpixel True pos (0.6, 2.11) zpos -2374.0
        show babs 1d behind limestone with dis:
            subpixel True pos (-0.3, 2.11) zpos -2874.0
        show lyra 4a behind babs with dis:
            subpixel True pos (1.45, 2.11) zpos -2574.0
        show silverstar 1a behind vapor with dis:
            subpixel True pos (-0.05, 2.11) zpos -2974.0
        show pommel 2a behind lyra with dis:
            subpixel True pos (0.85, 2.11) zpos -2774.0
        show fuse 1d behind pommel with dis:
            subpixel True pos (0.45, 2.11) zpos -2974.0
        show foyertable behind vapor with dis:
            subpixel True pos (291, 1.84) zpos -3049.0 zzoom True
        show cozy 1a behind pommel with dis:
            subpixel True pos (1750, 1.48) zpos -3500
        show charbox_overlay first_phase appear onlayer uielements
        show screen right_gui
        play sound 'audio/sfx/pianoreaction.wav'
        play music 'cozyglowreturns.ogg'
        $ guiInfo.musictext_name = "cozyglowreturns"
        md "..."
        camera:
            easein 0.3 pos (2350, 2403) zpos -2723.0
        lh "..."
        camera:
            easein 0.3 pos (1453, 2385) zpos -2021.0 
        sunburst "..."
        camera:
            easein 0.3 pos (1747, 2349) zpos -2561.0 perspective True
        fp "..."
        mdin "The room fell into a dead silence when the little pegasus, wearing a strange amulet around her neck, popped up."
        mdin "What is going on?"
        camera:
            easein 0.3 pos (1300, 1903) zpos -3649.0
        show cozy 2a with dis
        unknown "Golly, you all look so tense! Isn't this exciting?"
        camera:
            easein 0.3 pos (-546, 2385) zpos -3185.0
        show silverstar 1f with dis
        silverstar "A...A filly? What is a filly doing here?"
        camera:
            easein 0.3 pos (950, 2403) zpos -2023.0
        show quibble 3c with dis
        qp "You've gotta be kidding me! A child? Really!?"
        camera:
            easein 0.3 pos (100, 2394) zpos -2025.0
        show masala 6a with dis
        sm "Well, she's not the only filly here. Maybe she got kidnapped too?"
        camera:
            easein 0.3 pos (2600, 2403) zpos -1923.0
        show zephyr 2d
        zb "Or maybe she got lost?"
        camera:
            easein 0.3 pos (1300, 1903) zpos -3649.0
        show cozy 1c with dis
        unknown "Hey! Don't treat me like a child. Your group already has one."
        camera:
            easein 0.3 pos (-1046, 2493) zpos -3059.0
        show babs 3e
        bs "..."
        camera:
            easein 0.3 pos (1720, 2403) zpos -2525.0
        show fancy 7a with dis
        fp "Excuse me for asking, but who are you?"
        fp "Most important yet—what are your intentions?"
        camera:
            easein 0.3 pos (400, 2403) zpos -3123.0
        show fuse 2c with dis
        sf "What? Do you think she'll answer just because you were so polite?"
        camera:
            easein 0.3 pos (1171, 2403) zpos -2923.0
        cp "S-Something isn't right... Are you the one behind this?"
        camera:
            easein 0.3 pos (2000, 2403) zpos -2123.0
        show thunder 6a
        tl "Yeah! What are you doing here?"
        camera:
            easein 0.3 pos (100, 2394) zpos -2025.0
        show masala 6a with dis
        sm "Wait, are we sure we should be blaming a filly for our situation?"
        camera:
            easein 0.3 pos (1300, 1903) zpos -3649.0
        show cozy 2b with dis
        unknown "Well, aren't you all impatient? Fine, I'll entertain you."
        show cozy 4d with dis
        unknown "The name's Cozy Glow! I'll be your lovely {color=#f1c232}host{/color} for this little game. Isn't that just delightful?"
        #<INTRODUCTION: Cozy Glow>
        show charbox_overlay first_phase disappear onlayer uielements
        hide screen right_gui
        show masala:
            linear 0.5 alpha 0.0
        window auto hide
        pause 0.3
        play sound "audio/sfx/Intro_V3.mp3"
        show genericbackground behind cozy:
            matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.14)*SaturationMatrix(1.49)*BrightnessMatrix(0.02)*HueMatrix(396.0) 
            subpixel True pos (0.63, 1.75) zpos -3518.0
            alpha 0.0
            linear 0.5 alpha 1.0
        pause 0.2
        show cozy:
            subpixel True xpos 0.911
            ease 0.5 xpos 0.68
        show ring behind cozy:
            subpixel True pos (1.13, 1.78) zpos -3622.0 alpha 0.22 blend 'add' 
            alpha 0.0
            linear 0.3 alpha 0.3
            zrotate 0.0
            linear 5.0 zrotate 620.0
        show cmcozy behind cozy:
            subpixel True pos (1.13, 1.78) zpos -3622.0 alpha 0.22 blend 'add' 
            alpha 0.0
            linear 0.3 alpha 0.3
        pause 0.1
        show introbars behind cozy:
            subpixel True pos (0.68, 2.11) zpos -3577.0
            matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.84)*SaturationMatrix(0.54)*BrightnessMatrix(-0.24)*HueMatrix(1233.0) 
            matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
            easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0)
        show intronamecozy behind cozy:
            subpixel True pos (0.68, 2.11) zpos -3577.0
            matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-1953.0, 0.0, 0.0) 
            easein 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            linear 1.0 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(-27.0, 0.0, 0.0)
            easeout 0.75 matrixtransform RotateMatrix(0.0, 0.0, 3.0)*OffsetMatrix(2691.0, 0.0, 0.0)
        pause 2.0
        show cozy:
            ease 0.5 xpos 0.911
        show ring behind cozy:
            linear 0.3 alpha 0.0
            zrotate 0.0
        show genericbackground behind cozy:
            linear 0.5 alpha 0.0
        show cmcozy behind cozy:
            linear 0.3 alpha 0.0
        show masala:
            linear 0.5 alpha 1.0
        pause 0.6
        hide ring
        hide introbars
        hide intronamecozy
        hide genericbackground
        hide cmvcozy
        window auto show
        show charbox_overlay first_phase appear onlayer uielements
        show screen right_gui
        camera:
            easein 0.3 pos (2000, 2403) zpos -2123.0
        show thunder 1b
        tl "..."
        camera:
            easein 0.3 xpos 2153 
        show moondancer 1c onlayer uielements at charprotappear
        show charbox_overlay second_phase appear onlayer uielements
        md "..."
        show moondancer 5b onlayer uielements with disalt
        md "...Host? What are you talking about?"
        camera:
            easein 0.3 pos (1300, 1903) zpos -3649.0
        show cozy 2b with dis
        show moondancer onlayer uielements at charprotdisappear
        show charbox_overlay second_phase disappear onlayer uielements
        cozy "Let me explain..."
        show cozy 4a with dis
        cozy "You're trapped here with no way out! But of course you'd already know that."
        show cozy 3a with dis
        cozy "You must be thinking: 'Trapped? I can't be trapped here forever? How do I get out?'"
        show cozy 3c with dis
        cozy "Well, lucky for you, there is a way to escape from this dome."
        camera:
            easein 0.3 pos (2350, 2403) zpos -2723.0
        show lyra 3a
        play sound 'audio/sfx/surprise.wav'
        lh "A... way to escape?"
        camera:
            easein 0.3 pos (-546, 2385) zpos -3185.0
        show silverstar 1d with dis
        silverstar "Is that even possible?"
        camera:
            easein 0.3 pos (2600, 2403) zpos -1923.0
        show zephyr 1g with dis
        zb "Oh, awesome. So where's the exit door? I've got a couple of ponies waiting for me outside~"
        camera:
            easein 0.3 pos (690, 2403) zpos -2523.0
        show quibble 1a with dis
        show limestone 2b with dis
        play sound 'audio/sfx/dramatichigher.wav'
        lp "There's no way it's that simple, you idiot."
        camera:
            easein 0.3 pos (1300, 1903) zpos -3649.0
        show cozy 2a with dis
        cozy "Hey, that idiot is right! It's actually pretty simple!"
        camera:
            easein 0.3 pos (2600, 2403) zpos -1923.0
        show zephyr 3c with dis
        zb "Ha! See? I told you."
        show zephyr 2e with dis
        play sound 'embrarassed.wav'
        zb "...Hey!"
        camera:
            easein 0.3 pos (1300, 1903) zpos -3649.0
        show cozy 3b with dis
        cozy "In order to escape, you have to do just {color=#f1c232}one thing!{/color} And that is..."
        stop music
        $ guiInfo.musictext_name = "null"
        play sound 'audio/sfx/shock.wav'
        show cozy 4c with dis
        cozy "Kill somepony else!"
        camera:
            easein 0.3 pos (690, 2403) zpos -2523.0
        show limestone 1c with dis
        show quibble 1d with dis
        lp "..."
        camera:
            easein 0.3 pos (-1472, 2403) zpos -2177.0
        show vapor 1c with dis
        vt "..."
        camera:
            easein 0.3 pos (-1046, 2493) zpos -3059.0
        show babs 1g with dis
        bs "..."
        camera:
            easein 0.3 pos (2350, 2403) zpos -2723.0
        show lyra 4a with dis
        lh "..."
        camera:
            easein 0.3 xpos 2458 
        show moondancer 1l onlayer uielements at charprotappear
        show charbox_overlay second_phase appear onlayer uielements
        md "..."
        play music 'cozyglowreturns.ogg'
        $ guiInfo.musictext_name = "cozyglowreturns"
        md "...Kill each other?"
        show moondancer onlayer uielements at charprotdisappear
        show charbox_overlay second_phase disappear onlayer uielements
        camera:
            easein 0.3 pos (1462, 2403) zpos -1949.0
        show sunburst 2a with dis
        play sound 'audio/sfx/pianoreaction.wav'
        sunburst "Y-You can't... You can't be serious!"
        camera:
            easein 0.3 pos (950, 2403) zpos -2023.0
        show quibble 4d with dis
        qp "A-Alright, that's enough...This prank isn't funny anymore!"
        camera:
            easein 0.3 pos (1720, 2403) zpos -2525.0
        show fancy 1g with dis
        fp "Murder... Isn't that perhaps a bit too grotesque?"
        camera:
            easein 0.3 pos (100, 2394) zpos -2025.0
        show masala 3a with dis
        sm "Y-Yeah! Nopony will kill each other just because you ask them to."
        camera:
            easein 0.3 pos (-1508, 2403) zpos -2177.0
        show vapor 3d with dis
        vt "A-Are we sure we should listen to what this filly is saying?"
        camera:
            easein 0.3 pos (-971, 2403) zpos -1949.0
        show sky 1h with dis
        play sound 'audio/sfx/dramatichigher.wav'
        sky "And what if we simply refuse to kill?"
        camera:
            easein 0.3 pos (1300, 1903) zpos -3649.0
        show  cozy 3b with dis
        cozy "Hmm... Interesting question."
        show cozy 3c with dis
        cozy "I guess you'll be here forever!"
        show cozy 2b with dis
        cozy "...Well, at least until I get bored and leave you without food or supplies."
        cozy "I only have so much attention to give to the daily life segments of this game, you know?"
        camera:
            easein 0.3 pos (2000, 2403) zpos -2123.0
        show thunder 1c with dis
        play sound 'audio/sfx/surprise.wav'
        tl "No, that isn't going to happen."
        tl "I'm a Wonderbolt, my team would notice if I'm gone. They would search everywhere just to find me."
        camera:
            easein 0.3 pos (1720, 2403) zpos -2525.0
        show fancy 7b with dis
        fp "I have to agree, as it's not possible to get away with kidnapping fifteen ponies, especially if we consider the status of some of us."
        fp "Many relevant figures gone without a trace... surely that wouldn't go unnoticed."
        camera:
            easein 0.3 pos (1300, 1903) zpos -3649.0
        show cozy 1b with dis
        cozy "*Sigh* I expected this reaction. But that's fine!"
        show cozy 3c with dis
        cozy "I'll let you in on a little secret. {color=#f1c232}It's already been a week{/color} since you all have disappeared!"
        camera:
            easein 0.3 pos (1720, 2403) zpos -2525.0
        show fancy 7e with dis
        play sound 'audio/sfx/dramatic.wav'
        fp "A week?!"
        camera:
            easein 0.3 pos (1171, 2403) zpos -2923.0
        show pommel 2b with dis
        cp "W-Wait, how?!"
        camera:
            easein 0.3 pos (1300, 1903) zpos -3649.0
        show cozy 4d with dis
        cozy "It's simple, really. Once you were kidnapped, you were put to sleep until everypony else was gathered."
        cozy "And just today, you're finally allowed to wake up. But the thing is, no one came here to rescue you."
        show cozy 4c with dis
        cozy "So keep waiting for salvation, I'll enjoy watching your so-called harmony crumble into chaos."
        mdin "...A week?"
        mdin "Hearing that didn't sit well with my stomach, and it was not just from hunger."
        mdin "Does that mean we've been missing for a couple of days and no one has come to find us?"
        mdin "Who was this filly? How did she get away with these abductions?"
        mdin "But most importantly, what is that thing on her neck?"
        camera:
            easein 0.3 pos (500, 2403) zpos -2149.0
        show starlight 2a behind sunburst with dis:
            subpixel True pos (0.5, 2.11) zpos -2000.0
        stop music
        $ guiInfo.musictext_name = "null"
        play sound 'audio/sfx/shock.wav'
        unknown "That's enough, Cozy Glow!"
        mdin "Somepony shouted through the entrance. It was a mare who I hadn't seen before."
        camera:
            easein 0.3 pos (1462, 2403) zpos -1949.0
        show sunburst 1d with dis
        sunburst "..."
        show sunburst 1g with dis
        sunburst "Starlight!"
        camera:
            easein 0.3 pos (500, 2403) zpos -2149.0
        show starlight 1c with dis
        sg "I was right to be suspicious when you came into my office, Cozy. I see you've stolen the {color=#f1c232}Alicorn Amulet{/color}, too."
        camera:
            easein 0.3 pos (1300, 1903) zpos -3649.0
        show cozy 2c with dis
        cozy "Ugh, Starlight Glimmer. Of course you'd show up to try and ruin my fun!"
        camera:
            easein 0.3 pos (500, 2403) zpos -2149.0
        show starlight 3b with dis
        sg "Well, whatever game you were planning on playing with these ponies, it ends now."
        camera:
            easein 0.3 pos (1300, 1903) zpos -3649.0
        show cozy 6a with dis
        cozy "What are you going to do about it? This little amulet makes me unstoppable!"
        camera:
            easein 0.3 pos (500, 2403) zpos -2149.0
        show starlight 2b with dis
        sg "We'll see about that!"
        hide screen right_gui
        window hide
        show charbox_overlay first_phase disappear onlayer uielements
        hide masala
        hide quibble
        hide limestone
        hide silverstar
        hide babs
        hide pommel
        hide zephyr
        hide fuse
        hide fancy
        hide sunburst
        hide sky
        hide vapor
        hide foyertable
        hide thunder
        hide lyra
        scene black with black
        hide foyerbackground
        show sunsetoverlay onlayer overlays:
            linear 0.5 alpha 0.0
        camera:
            pos (0, 0) zpos 0
        
        pause 2.0
        play music 'Class Trial - Resurrection (V3).ogg'
        #Starlight CG
        show cg sg execution 1 with fade
        sgCG "I won't let you hurt them!"
        mdCGin "Starlight's magic flashed bright, her horn gave off excess sparks as she charged up a spell."
        sgCG "Everypony, stay back!"
        mdCGin "We all did as we were told, getting as far away from Starlight and Cozy as possible."
        cozyCG "Oh, that's adorable."
        cozyCG "But if you really want a challenge..."
        mdCGin "The amulet around Cozy's neck began to shine an unsettingly bright red."
        #CG Alicorn Cozy
        show cg sg execution 2 with fade
        cozyCG "Then...challenge accepted!"
        bsCG "L-Look!"
        play sound 'audio/sfx/dramatic.wav'
        vtCG "Is that...a horn?"
        qpCG "No...that's not possible!"
        cozyCG "I didn't think I'd have to show off so soon, but I guess I'll have to make an example out of you!"
        #CG Starlight Trapped 1
        show cg sg execution 3 with fade
        play sound 'audio/sfx/surprise.wav'
        sgCG "Aah!"
        play sound 'audio/sfx/pianoreaction.wav'
        sunburstCG "S-Starlight!"
        sgCG "D-Don't worry, I'll get out of this!"
        cozyCG "Now then, this is what happens to naughty ponies who try to get in my way!"
        #CG Starlight Trapped 2
        mdCGin "Starlight's bubble shrank in size."
        sgCG "Gah!"
        mdCGin "I had to... I had to try to help this pony!"
        mdCGin "I tried to take a step forward, but this aura of malice coming from this magic bubble..."
        mdCGin "It was like my body refused to move."
        mdCGin "At the corner of my eye, I saw everyone just as frozen. Everyone, except..."
        sunburstCG "Starlight! Hang on, I'll...I'll get you out of there!"
        sgCG "Don't worry...about me...! Just focus on-"
        hide cg sg execution 3
        stop music
        $ guiInfo.musictext_name = "null"
        play sound 'audio/sfx/stabwound.wav'
        greentextCG "*Pop*"
        $ renpy.pause (3.0)
        show cg sg execution 4 with black
        $ renpy.pause (3.0)
        sunburstCG "..."
        sunburstCG "S-Starlight?"
        sunburstCG "No! No no no no no, you can't-!"
        #CG Starlight's Execution
        mdCGin "It all happened so suddenly."
        mdCGin "One moment, Starlight was there, and the next..."
        mdCGin "She was gone."
        scene black with black
        camera:
            easein 0.3 pos (1200, 2153) zpos -1349.0
        
        hide black with black
        show sunsetoverlay onlayer overlays:
            linear 0.5 alpha 1.0
        show foyerbackground with fade:
            subpixel True pos (400, 1.7) zpos -3590.0 zzoom True
        show sunburst 1i behind fancy with dis:
            subpixel True pos (1.0, 2.11) zpos -1800.0
        show zephyr 4b behind sunburst with dis:
            subpixel True pos (1.6, 2.11) zpos -1774.0
        show sky 4d behind zephyr with dis:
            subpixel True pos (-0.25, 2.11) zpos -1800.0
        show quibble 4c behind sky with dis:
            subpixel True pos (0.75, 2.11) zpos -1874.0
        show masala 2d behind quibble with dis:
            subpixel True pos (0.30, 2.11) zpos -1876.0
        show thunder 2c behind masala with dis:
            subpixel True pos (1.3, 2.11) zpos -1974.0
        show vapor 1d behind thunder with dis:
            subpixel True pos (-0.53, 2.11) zpos -2028.0
        show fancy 7e behind vapor with dis:
            subpixel True pos (1.15, 2.11) zpos -2376.0
        show limestone 1f behind fancy with dis:
            subpixel True pos (0.6, 2.11) zpos -2374.0
        show babs 1g behind limestone with dis:
            subpixel True pos (-0.3, 2.11) zpos -2874.0
        show lyra 4a behind babs with dis:
            subpixel True pos (1.45, 2.11) zpos -2574.0
        show silverstar 1k behind vapor with dis:
            subpixel True pos (-0.05, 2.11) zpos -2974.0
        show pommel 2b behind lyra with dis:
            subpixel True pos (0.85, 2.11) zpos -2774.0
        show fuse 3c behind pommel with dis:
            subpixel True pos (0.45, 2.11) zpos -2974.0
        show foyertable behind vapor with dis:
            subpixel True pos (291, 1.84) zpos -3049.0 zzoom True
        show cozy 1a behind pommel with dis:
            subpixel True pos (1750, 1.48) zpos -3500
        show screen right_gui
        md "..."
        camera:
            easein 0.3 pos (2350, 2403) zpos -2723.0
        lh "..."
        camera:
            easein 0.3 pos (2000, 2403) zpos -2123.0
        tl "..."
        camera:
            easein 0.3 pos (-1100, 2403) zpos -3023.0
        bs "..."
        camera:
            easein 0.3 pos (690, 2403) zpos -2523.0
        lp "..."
        mdin "Everypony was appalled at the gruesome sight."
        camera:
            easein 0.3 pos (1390, 2403) zpos -1949.0
        sunburst "..."
        sunburst "..."
        mdin "Amidst the dreadful silence, Sunburst's sobs were the only noise that filled the ambience."

        camera:
            easein 0.3 pos (1171, 2403) zpos -2923.0
        cp "..."
        camera:
            easein 0.3 pos (-600, 2403) zpos -3023.0
        silverstar "..."
        camera:
            easein 0.3 pos (2600, 2403) zpos -1923.0
        zb "..."
        camera:
            easein 0.3 pos (-971, 2403) zpos -1949.0
        sky "..."
        camera:
            easein 0.3 pos (1300, 1903) zpos -3649.0
        show cozy 4a with dis
        cozy "Well, that was surprisingly easy! I was hoping she'd put up more of a fight."
        show cozy 4b with dis
        cozy "Oh well, that should prove that I'm not fooling around. Should any of you try to lay your hooves on me, you'll meet the same fate as her."
        show cozy 1c with dis
        cozy "Now, let's go over the rules for our game, unless anypony wants to object?"
        md "..."
        mdin "Everypony was too shocked to protest."
        show cozy 2b with dis
        cozy "Very well! Like I said, the only way to escape is to kill one of your friends."
        show cozy 4a with dis
        cozy "But that's not enough. A subsequent {color=#f1c232}trial{/color} will be held, where you'll try to determine the identity of the killer."
        cozy "If they get caught, only they'll face punishment and the rest of you will continue to live as normal."
        cozy "But if you fail to identify the killer however, everyone *besides* the killer faces punishment, and they get to leave the dome."
        show cozy 4b with dis
        cozy "Sounds very simple, if you ask me."
        show cozy 2a with dis
        cozy "Oh well! I've opened the rest of the building for you. Go ahead, explore, and settle in wherever you'd like."
        show cozy 6a with dis
        cozy "Have fun, and happy killing!"
        hide cozy with dis
        mdin "..."
        mdin "............"
        hide screen right_gui

        window hide
        hide masala
        hide quibble
        hide limestone
        hide silverstar
        hide babs
        hide pommel
        hide zephyr
        hide fuse
        hide fancy
        hide sunburst
        hide sky
        hide vapor
        hide foyertable
        hide thunder
        hide lyra
        scene black with black
        camera:
            pos (0, 0) zpos 0
        play music 'eternal_darkness.ogg'
        mdCGin "Everything felt heavier now. The air, the silence, the weight in my chest—it all pressed down on me like the walls of this place were closing in."
        hide sunsetoverlay onlayer overlays
        mdCGin "I looked around at the others, searching for something—comfort, understanding, maybe even strength..."
        mdCGin "...But all I saw were faces twisted with fear and despair."
        mdCGin "No one spoke. No one moved. It was like we'd all been frozen in the moment we saw Starlight disappear."
        mdCGin "And Cozy Glow... The way she was smiling, like this was some twisted game she couldn't wait to play."
        mdCGin "That filly—{i}if she even is a filly{/i}—held all the cards. Her words, her threats, the blood-red glow of that amulet..."
        mdCGin "The rules she laid out were simple—sickeningly simple. Escape was possible, but the price?"
        mdCGin "Take a life, then let the rest take the fall. And for what? Freedom? Survival?"
        window hide
        $ renpy.pause(1.0)
        show ptp_pommel_alive:
            zoom 1.12 alpha 0.0 matrixcolor BrightnessMatrix(1.0)
            easeout 0.30 zoom 0.99 alpha 1.0 matrixcolor BrightnessMatrix(0.0)
            linear 0.10 zoom 1.0
        $ renpy.pause(0.15)
        show ptp_limestone_alive:
            zoom 1.12 alpha 0.0 matrixcolor BrightnessMatrix(1.0)
            easeout 0.30 zoom 0.99 alpha 1.0 matrixcolor BrightnessMatrix(0.0)
            linear 0.10 zoom 1.0
        $ renpy.pause(0.15)
        show ptp_quibble_alive:
            zoom 1.12 alpha 0.0 matrixcolor BrightnessMatrix(1.0)
            easeout 0.30 zoom 0.99 alpha 1.0 matrixcolor BrightnessMatrix(0.0)
            linear 0.10 zoom 1.0
        $ renpy.pause(0.15)
        show ptp_silverstar_alive:
            zoom 1.12 alpha 0.0 matrixcolor BrightnessMatrix(1.0)
            easeout 0.30 zoom 0.99 alpha 1.0 matrixcolor BrightnessMatrix(0.0)
            linear 0.10 zoom 1.0
        $ renpy.pause(0.15)
        show ptp_babs_alive:
            zoom 1.12 alpha 0.0 matrixcolor BrightnessMatrix(1.0)
            easeout 0.30 zoom 0.99 alpha 1.0 matrixcolor BrightnessMatrix(0.0)
            linear 0.10 zoom 1.0
        $ renpy.pause(4.0)
        mdCGin "The ponies in this room... They were strangers to me yesterday. But now? They were something more."
        mdCGin "Fellow captives. Potential allies. {i}Potential threats{/i}."
        mdCGin "I looked at the earth ponies first."
        mdCGin "One stomped the floor, muttering curses under his breath. Another just stared at her own trembling hooves."
        mdCGin "They were supposed to be the strong ones—the grounded, dependable type."
        mdCGin "But right now? Even they looked ready to break."
        show ptp_pommel_alive:
            linear 0.5 alpha 0.0
        $ renpy.pause(0.15)
        show ptp_limestone_alive:
            linear 0.5 alpha 0.0
        $ renpy.pause(0.15)
        show ptp_quibble_alive:
            linear 0.5 alpha 0.0
        $ renpy.pause(0.15)
        show ptp_silverstar_alive:
            linear 0.5 alpha 0.0
        $ renpy.pause(0.15)
        show ptp_babs_alive:
            linear 0.5 alpha 0.0
        window hide
        $ renpy.pause(2.0)
        show ptp_fuse_alive:
            zoom 1.12 alpha 0.0 matrixcolor BrightnessMatrix(1.0)
            easeout 0.30 zoom 0.99 alpha 1.0 matrixcolor BrightnessMatrix(0.0)
            linear 0.10 zoom 1.0
        $ renpy.pause(0.15)
        show ptp_vapor_alive:
            zoom 1.12 alpha 0.0 matrixcolor BrightnessMatrix(1.0)
            easeout 0.30 zoom 0.99 alpha 1.0 matrixcolor BrightnessMatrix(0.0)
            linear 0.10 zoom 1.0
        $ renpy.pause(0.15)
        show ptp_thunder_alive:
            zoom 1.12 alpha 0.0 matrixcolor BrightnessMatrix(1.0)
            easeout 0.30 zoom 0.99 alpha 1.0 matrixcolor BrightnessMatrix(0.0)
            linear 0.10 zoom 1.0
        $ renpy.pause(0.15)
        show ptp_sky_alive:
            zoom 1.12 alpha 0.0 matrixcolor BrightnessMatrix(1.0)
            easeout 0.30 zoom 0.99 alpha 1.0 matrixcolor BrightnessMatrix(0.0)
            linear 0.10 zoom 1.0
        $ renpy.pause(0.15)
        show ptp_zephyr_alive:
            zoom 1.12 alpha 0.0 matrixcolor BrightnessMatrix(1.0)
            easeout 0.30 zoom 0.99 alpha 1.0 matrixcolor BrightnessMatrix(0.0)
            linear 0.10 zoom 1.0
        $ renpy.pause(4.0)
        mdCGin "The pegasi weren't doing much better."
        mdCGin "Flight should've been their freedom. But here? It was a reminder of what they just lost."
        mdCGin "One moment, they were living their own lives. The next? Forced into a twisted game."
        mdCGin "I wondered which one would be the first to fall from grace when fear takes over their body."
        show ptp_fuse_alive:
            linear 0.5 alpha 0.0
        $ renpy.pause(0.15)
        show ptp_vapor_alive:
            linear 0.5 alpha 0.0
        $ renpy.pause(0.15)
        show ptp_thunder_alive:
            linear 0.5 alpha 0.0
        $ renpy.pause(0.15)
        show ptp_sky_alive:
            linear 0.5 alpha 0.0
        $ renpy.pause(0.15)
        show ptp_zephyr_alive:
            linear 0.5 alpha 0.0
        window hide
        $ renpy.pause(2.0)
        show ptp_fancy_alive:
            zoom 1.12 alpha 0.0 matrixcolor BrightnessMatrix(1.0)
            easeout 0.30 zoom 0.99 alpha 1.0 matrixcolor BrightnessMatrix(0.0)
            linear 0.10 zoom 1.0
        $ renpy.pause(0.15)
        show ptp_masala_alive:
            zoom 1.12 alpha 0.0 matrixcolor BrightnessMatrix(1.0)
            easeout 0.30 zoom 0.99 alpha 1.0 matrixcolor BrightnessMatrix(0.0)
            linear 0.10 zoom 1.0
        $ renpy.pause(0.15)
        show ptp_lyra_alive:
            zoom 1.12 alpha 0.0 matrixcolor BrightnessMatrix(1.0)
            easeout 0.30 zoom 0.99 alpha 1.0 matrixcolor BrightnessMatrix(0.0)
            linear 0.10 zoom 1.0
        $ renpy.pause(0.15)
        show ptp_moondancer_alive:
            zoom 1.12 alpha 0.0 matrixcolor BrightnessMatrix(1.0)
            easeout 0.30 zoom 0.99 alpha 1.0 matrixcolor BrightnessMatrix(0.0)
            linear 0.10 zoom 1.0
        $ renpy.pause(0.15)
        show ptp_sunburst_alive:
            zoom 1.12 alpha 0.0 matrixcolor BrightnessMatrix(1.0)
            easeout 0.30 zoom 0.99 alpha 1.0 matrixcolor BrightnessMatrix(0.0)
            linear 0.10 zoom 1.0
        $ renpy.pause(4.0)
        mdCGin "Then there were the unicorns. My kind."
        mdCGin "I could see the denial in their eyes. The same look I probably had myself right now."
        mdCGin "But deep down, we all knew the truth. Even our magic was useless here."
        mdCGin "All the knowledge, all the logic, all the spellwork. None of that could explain what was happening."
        show ptp_fancy_alive:
            linear 0.5 alpha 0.0
        $ renpy.pause(0.15)
        show ptp_masala_alive:
            linear 0.5 alpha 0.0
        $ renpy.pause(0.15)
        show ptp_lyra_alive:
            linear 0.5 alpha 0.0
        $ renpy.pause(0.15)
        show ptp_moondancer_alive:
            linear 0.5 alpha 0.0
        $ renpy.pause(0.15)
        show ptp_sunburst_alive:
            linear 0.5 alpha 0.0
        window hide
        $ renpy.pause(2.0)
        scene black
        mdCGin "\"How do minds fracture when pressed against the unthinkable?\""
        mdCGin "\"What compels a pony to hold to their values or succumb to corruption?\""
        mdCGin "If Cozy was to be believed, it would only be a matter of time until somepony finally decides to play along."
        stop music
        mdCGin "Until then, {color=#f1c232}it's me versus everypony.{/color}"
        window hide
        $ renpy.pause (3.0)
        show gradient onlayer overlays:
            alpha 0.0
        play sound "chapterend.ogg"
        show genericbackground at courtroom_BG:
            subpixel True ypos 0.5 zpos -6000.0 zzoom True 
        window auto hide
        show moondancer 1a:
            subpixel True xpos 450 zpos -666.0
            matrixcolor BrightnessMatrix(-1.0)
        show lyra 1a behind moondancer:
            subpixel True xpos 792 zpos -900.0
            matrixcolor BrightnessMatrix(-1.0)
        show quibble 1a behind moondancer:
            subpixel True xpos 144 zpos -900.0 
            matrixcolor BrightnessMatrix(-1.0)
        show fuse 1a behind quibble:
            subpixel True xpos -171 zpos -1134.0
            matrixcolor BrightnessMatrix(-1.0)
        show babs 1a behind lyra:
            subpixel True xpos 1098 zpos -1134.0
            matrixcolor BrightnessMatrix(-1.0)
        show masala 1a behind fuse:
            subpixel True xpos -441 zpos -1368.0 
            matrixcolor BrightnessMatrix(-1.0)
        show sky 1a behind babs:
            subpixel True xpos 1413 zpos -1368.0 
            matrixcolor BrightnessMatrix(-1.0)
        show zephyr 1a behind masala:
            subpixel True xpos -792 zpos -1602.0 
            matrixcolor BrightnessMatrix(-1.0)
        show vapor 1a behind sky:
            subpixel True xpos 1737 zpos -1602.0 
            matrixcolor BrightnessMatrix(-1.0)
        show pommel 1a behind zephyr:
            subpixel True xpos -1125 zpos -1836.0 
            matrixcolor BrightnessMatrix(-1.0)
        show sunburst 1a behind vapor:
            subpixel True xpos 2088 zpos -1836.0 
            matrixcolor BrightnessMatrix(-1.0)
        show fancy 1a behind pommel:
            subpixel True xpos -1512 zpos -2070.0 
            matrixcolor BrightnessMatrix(-1.0)
        show limestone 1a behind sunburst:
            subpixel True xpos 2403 zpos -2070.0 
            matrixcolor BrightnessMatrix(-1.0)
        show thunder 1a behind fancy:
            subpixel True xpos -1899 zpos -2304.0 
            matrixcolor BrightnessMatrix(-1.0)
        show silverstar 1a behind limestone:
            subpixel True xpos 2808 zpos -2304.0
            matrixcolor BrightnessMatrix(-1.0)
        camera:
            subpixel True 
            parallel:
                xpos -9 ypos 320 
                ease_expo 2.54 ypos -42 
                ease_expo 4.0 ypos 86 
            parallel:
                zpos -1504.8 
                ease_expo 2.54 zpos -1324.8 
                ease_expo 4.0 zpos -181.8 
        with Pause(6.08)
        camera:
            ypos 86 zpos -181.8 
        show prologue_tobecontinued onlayer uielements:
            alpha 0.0
            linear 0.5 alpha 1.0
        $ renpy.pause(5.0)
        show prologue_tobecontinued onlayer uielements:
            linear 0.5 alpha 0.0
        scene black with black
        camera:
            pos (0, 0) zpos 0
        $ renpy.pause(5.0)
        call screen credits
        scene black with black
        hide prologue_tobecontinued onlayer uielements
        $ renpy.pause(5.0)

        window hide
        define smolderCG = Character("Smolder", window_background=Frame("gui/cg_textbox.png", 25, 25), who_color="FFF", who_xpos=-90, who_ypos=27)
        define silverstreamCG = Character("Silverstream", window_background=Frame("gui/cg_textbox.png", 25, 25), who_color="FFF", who_xpos=-90, who_ypos=23)
        define ocellusCG = Character("Ocellus", window_background=Frame("gui/cg_textbox.png", 25, 25), who_color="FFF", who_xpos=-95, who_ypos=30)
        define sandbarCG = Character("Sandbar", window_background=Frame("gui/cg_textbox.png", 25, 25), who_color="FFF", who_xpos=-90, who_ypos=27)
        define yonaCG = Character("Yona", window_background=Frame("gui/cg_textbox.png", 25, 25), who_color="FFF", who_xpos=-95, who_ypos=30)
        define gallusCG = Character("Gallus", window_background=Frame("gui/cg_textbox.png", 25, 25), who_color="FFF", who_xpos=-95, who_ypos=30)
        window hide
        smolderCG "Ugh, are we done?"
        silverstreamCG "We've only been studying for five minutes, Smolder!"
        smolderCG "But this sucks!"
        ocellusCG "Well, no one said that learning about friendship was easy."
        smolderCG "Yeah, but did it have to be so boring?"
        sandbarCG "Aw, it's not so bad, Smolder!"
        yonaCG "Yeah, studying always better when Yona with friends!"
        gallusCG "Yeah, a lot of things are better when I'm with you guys, and they're a lot more fun than studying, that's for sure."
        sandbarCG "Well, after we're done studying, we can go do one of those fun things together, alright?"
        ocellusCG "That sounds good! I've been dying to go swimming at the lake again!"
        gallusCG "And deal with Yona doing cannonballs when I just wanna take a nap by the water?"
        yonaCG "Griffon just jealous that yaks best at splashing!"
        silverstreamCG "Hmmm..."
        gallusCG "Something on your mind, Silverstream?"
        silverstreamCG "Oh, it's nothing! I wanted to ask Counselor Starlight a question earlier today, but she wasn't in her office again!"
        ocellusCG "'Again'?"
        silverstreamCG "Yeah, it's weird, I've been trying to see her for a week at this point, but she's just not around!"
        yonaCG "That sound strange..."
        gallusCG "She probably went off on one of those friendship missions or whatever that our professors usually go on."
        smolderCG "The ones where our homework becomes super easy?"
        gallusCG "You know it. A shame Starlight must've been called away instead of Professor Applejack..."
        yonaCG "Must be important friendship mission if counselor gone for so long."
        sandbarCG "Actually, now that I think of it, has anyone seen Cozy Glow lately? I haven't seen her around much either."
        ocellusCG "Hm...not since last week, I think? Yeah, I haven't seen her in or out of class either."
        gallusCG "You think she got called away for the same friendship quest?"
        sandbarCG "Starlight and Cozy Glow on the same friendship quest? Hm..."
        smolderCG "Maybe she got some pony sickness or something."
        silverstreamCG "Oh, I'm sure she's fine! She's always been so dedicated to learning all about friendship, I don't think she'd want to miss out on any lessons if she could help it!"
        sandbarCG "Yeah, I guess you're right, they'll turn up eventually."
        gallusCG "Well, I hope Cozy's good with make-up work, cause I'm not helping her with all that!"
        yonaCG "That not what good friend supposed to do, Gallus!"
        gallusCG "Oh, well..."
        window hide
        $ renpy.pause(3.0)

        label debug_trialtest:
            jump trialtestskip
            $ menu_flag = True
            
            scene trialtest
            #transform namebox_rotate(who):
            #    rotate 0
            camera:
                perspective True
                ypos -100
                easein 1.15 ypos 0
            show courtroom 1b at courtroom_BG:
                xzoom -1.0
            show podium 1a at podium_FG
            show gradient onlayer overlays:
                blend "add"
            show overlay onlayer overlays:
                blend "add"
            show trial_case01 onlayer uielements:
                align (0.0, 0.0)
                alpha 0.00
                easein 0.25 alpha 1.00
            show portrait moondancer onlayer uielements:
                xanchor 0.0
                yanchor 0.0
                ypos 70
                alpha 0.00
                easein 0.25 alpha 1.00
            show quibble 1a behind podium at trial_left
            show moondancer 1a behind podium at trial_center
            show zephyr 1a behind podium at trial_right
            trialmd "Let's start with the basic facts — The Victim was found in the cafeteria with stab wounds and a rope was rangled around him."
            show courtroom 1e
            show portrait fancy onlayer uielements
            hide quibble
            hide moondancer
            hide zephyr
            show fuse 1a behind podium at trial_left
            show fancy 1a behind podium at trial_center
            show pommel 1a behind podium at trial_right
            camera:
                xpos -90
                easein 1.15 xpos 0 
            trialfp "The body was... quite in a devastating state."
            camera:
                rotate 10
                ypos -50
                xpos 0
                easein 1.15 xpos -108
            show courtroom 1c
            show portrait zephyr onlayer uielements
            hide fuse
            hide fancy
            hide pommel
            show pommel 1a at trial_leftontop
            show fancy 1a at trial_rightontop
            show moondancer 1a behind podium at trial_left
            show zephyr 1a behind podium at trial_center
            show babs 1a behind podium at trial_right
            show cozy 1a behind babs:
                subpixel True pos (0.64, -0.07) zpos -200.0 zoom 0.55 yrotate -36.0     
            trialzb "Oh, I know how to solve this. Whoever's the killer, raise your hoof!"
            show courtroom 1a
            show portrait sunburst onlayer uielements
            hide moondancer
            hide zephyr
            hide babs
            hide fancy
            hide pommel
            hide cozy
            show pommel 1a behind podium at trial_left
            show sunburst 1a behind podium at trial_center
            show thunder 1a behind podium at trial_right
            camera:
                rotate 0
                xpos 0
                ypos 100
                easein 1.15 ypos 0
            trialsunburst "Zephyr... I don't think that's how it works."
            show portrait limestone onlayer uielements
            hide pommel
            hide sunburst
            hide thunder
            show silverstar 1a behind podium at trial_left
            show limestone 1a behind podium at trial_center
            show fuse 1a behind podium at trial_right
            camera:
                xpos -117 
                easein 1.15 xpos 0 
            triallp "Setting this nonsense aside, there was also a cup of tea spilled near the body."
            camera:
                subpixel True 
                xpos -10 ypos 114 rotate -5.0
                easein 0.94 xpos 0 ypos -5 rotate -8.0
            show portrait thunder onlayer uielements
            hide silverstar
            hide limestone
            hide fuse
            show sunburst 1a behind podium at trial_left
            show thunder 1a behind podium at trial_center
            show masala 1a behind podium at trial_right
            trialtl "Maybe the tea was poisoned?"
            camera:
                subpixel True xpos -50 zpos 153.0  rotate 0.0 
                ypos -212 
                easein 1.21 ypos -5 
            show courtroom 1b:
                xzoom 1.0
            show portrait vapor onlayer uielements
            hide sunburst
            hide thunder
            hide masala
            show masala 1a:
                pos (0.0, -0.12) zpos 414.0
                matrixcolor BrightnessMatrix(-1.53)
                yrotate -9.0
                orientation (0.0, -180.0, 0.0)
            show thunder 1a:
                pos (0.43, -0.12) zpos 414.0
                matrixcolor BrightnessMatrix(-1.53)
                yrotate 9.0
                orientation (0.0, -180.0, 0.0) 
            show sky 1a behind podium at trial_left
            show vapor 1a behind podium at trial_center
            show silverstar 1a behind podium at trial_right
            trialvt "B-But why? Was not the stabbing enough to kill him?"
            camera:
                subpixel True 
                xpos 90 zpos 20
                easein 1.44 xpos 0 
            show portrait fuse onlayer uielements
            hide sky
            hide vapor
            hide silverstar
            hide thunder
            hide masala
            show limestone 1a behind podium at trial_left
            show fuse 1a behind podium at trial_center
            show pommel 1a behind podium at trial_right
            trialsf "Maybe the killer is just a sadistic freak! It was a crime of passion, after all."
            camera:
                subpixel True xpos 27 zpos -81.0 xrotate 18.0 yrotate 0.0 
                ypos -608 
                easein 1.17 ypos -453 
            show portrait silverstar onlayer uielements
            hide limestone
            hide fuse
            hide pommel
            show vapor 1a behind podium at trial_left
            show silverstar 1a behind podium at trial_center
            show limestone 1a behind podium at trial_right
            trialsilverstar "I dunno y'all, but something tells me the knife might've just been a cover-up."
            camera:
                subpixel True ypos -201 zpos -441.0 xrotate 18.0 
                xpos 108 
                easein 1.15 xpos -81 
            show courtroom 1d
            show portrait babs onlayer uielements
            hide vapor
            hide silverstar
            hide limestone
            show zephyr 1a behind podium at trial_left
            show babs 1a behind podium at trial_center
            show sky 1a behind podium at trial_right
            trialbs "A cover up?! But it was clearly used!."
            camera:
                subpixel True ypos -138 xrotate 0.0 
                zpos -405.0 rotate 0.0
                easein 1.17 zpos -207.0 rotate 9.0
            show portrait masala onlayer uielements
            hide zephyr
            hide babs
            hide sky
            show thunder 1a behind podium at trial_left
            show masala 1a behind podium at trial_center
            show lyra 1a behind podium at trial_right
            trialsm "Well, then why did the killer leave the knife at the scene of the crime? It wouldn't be difficult to dispose or clean it up."
            camera:
                xpos -18 zpos -207.0 
                easein 0.99 xpos 468 zpos -423.0
            show courtroom 1c
            show portrait lyra onlayer uielements
            triallh "...Maybe they were in a hurry?"
            camera:
                subpixel True zpos 0.0 xpos -162 ypos 0.0 rotate 0.0
                easein 1.15 xpos 0
            show portrait sky onlayer uielements
            hide masala
            hide lyra
            hide thunder
            show babs 1a behind podium at trial_left
            show sky 1a behind podium at trial_center
            show vapor 1a behind podium at trial_right
            show cozy 1a behind babs:
                subpixel True pos (0.07, -0.09) zpos -220 zoom 0.55 yrotate 36.0

            trialsky "Ugh! It's obvious that Cozy Glow did it, who else could've done it?"
            camera:
                subpixel True 
                pos (0, 0) zpos 0.0 
                easein 0.96 pos (-450, -162) zpos -549.0 
            show cozy 1a:
                subpixel True 
                pos (0.07, -0.09) yrotate 36.0 zoom 0.55 
                easein 0.96 pos (0.09, -0.16) yrotate 9.0 zoom 0.66 
            show portrait cozy onlayer uielements
            trialcozy "Oh, come on! That is clearly against the rules for me to do."
            camera:
                subpixel True 
                xpos 0.0 ypos 20 zpos 0.0 
                easein 2.01 zpos -288.0 
            hide cozy
            hide sky
            hide babs
            hide vapor
            show courtroom 1a
            show podium 1a at podium_FG
            show portrait pommel onlayer uielements
            show fancy 1a behind podium at trial_left
            show pommel 1a behind podium at trial_center
            show sunburst 1a behind podium at trial_right
            trialcp "Hold on, are we even certain of the cause of death yet?"
            camera:
                subpixel True ypos 0 zpos 0.0 
                xpos 150 
                easein 1.88 xpos 0 
            show portrait moondancer onlayer uielements
            hide fancy
            hide pommel
            hide sunburst
            show quibble 1a behind podium at trial_left
            show moondancer 1a behind podium at trial_center
            show zephyr 1a behind podium at trial_right
            trialmd "The victim didn't show any signs of have been poisoned... That could only mean one thing."
            show portrait moondancer onlayer uielements:
                linear 1.0 alpha 0.0
            show trial_case01 onlayer uielements:
                linear 1.0 alpha 0.0
            camera:
                subpixel True zpos -450.0 
                ypos 0 
                easein 1.52 ypos -130
            trialmd "The cause of death is likely loss of blood."
            scene outro with fade
            show gradient onlayer overlays:
                alpha 0.0
            show genericbackground at courtroom_BG:
                subpixel True ypos 0.5 zpos -6000.0 zzoom True 

            #Trial transforms

            transform courtroom_BG:
                zpos -200 zzoom True
                anchor (0.5, 0.5)
                xpos 0.5
                ypos 0.33
            transform podium_FG:
                zpos 200 zzoom True
                anchor (0.5, 0.5)
                xpos 0.5
                ypos 0.36
            
            transform trial_left:
                zoom 0.9
                xalign 0.5
                yalign 0.5
                xpos 0.15
                ypos 0.52
                matrixtransform RotateMatrix(0.0, 18.0, 0.0)

            transform trial_center:
                zoom 0.9
                xalign 0.5
                yalign 0.5
                xpos 0.5

            transform trial_right:
                zoom 0.9
                xalign 0.5
                yalign 0.5
                xpos 0.85
                ypos 0.52
                matrixtransform RotateMatrix(0.0, -18.0, 0.0)

            transform trial_leftontop:
                zoom 0.9
                xzoom -1.0
                xalign 0.5
                yalign 0.5
                xpos 0.3
                zpos 300
                matrixcolor BrightnessMatrix(-2.0)
                matrixtransform RotateMatrix(0.0, 18.0, 0.0)
            
            transform trial_rightontop:
                zoom 0.9
                xzoom -1.0
                xalign 0.5
                yalign 0.5
                xpos 0.7
                zpos 300
                matrixcolor BrightnessMatrix(-2.0)
                matrixtransform RotateMatrix(0.0, 18.0, 0.0)


            window auto hide

            show moondancer 1a:
                subpixel True xpos 450 zpos -666.0 
            show lyra 1a behind moondancer:
                subpixel True xpos 792 zpos -900.0
            show quibble 1a behind moondancer:
                subpixel True xpos 144 zpos -900.0 
            show fuse 1a behind quibble:
                subpixel True xpos -171 zpos -1134.0
            show babs 1a behind lyra:
                subpixel True xpos 1098 zpos -1134.0
            show masala 1a behind fuse:
                subpixel True xpos -441 zpos -1368.0 
            show sky 1a behind babs:
                subpixel True xpos 1413 zpos -1368.0 
            show zephyr 1a behind masala:
                subpixel True xpos -792 zpos -1602.0 
            show vapor 1a behind sky:
                subpixel True xpos 1737 zpos -1602.0 
            show pommel 1a behind zephyr:
                subpixel True xpos -1125 zpos -1836.0 
            show fancy 1a behind vapor:
                subpixel True xpos 2088 zpos -1836.0 
            show sunburst 1a behind pommel:
                subpixel True xpos -1512 zpos -2070.0 
            show limestone 1a behind fancy:
                subpixel True xpos 2403 zpos -2070.0 
            show thunder 1a behind sunburst:
                subpixel True xpos -1899 zpos -2304.0 
            show silverstar 1a behind limestone:
                subpixel True xpos 2808 zpos -2304.0
            
            
            window auto hide
            camera:
                subpixel True 
                parallel:
                    xpos -9 ypos 320 
                    ease_circ 0.54 ypos -42 
                    ease_expo 2.0 ypos 86 
                parallel:
                    zpos -1504.8 
                    ease_circ 0.54 zpos -1324.8 
                    ease_expo 2.0 zpos -181.8 
            with Pause(5.05)
            camera:
                ypos 86 zpos -181.8 
            window auto show
label trialtestskip:
    greentextCG "End of the game."
    # This ends the game.

    return
