init python:
    # This ensures the game cannot be stopped by user input while credits are scrolling
    config.key_repeat = True
    

## ATL for the scrolling screen object
## Speed is the time (in seconds) it takes for the object to move from the bottom to the top
transform credits_scroll(speed):
    # Start just below the visible screen area (ypos 1.0)
    ypos 1.0
    # Move to just above the visible screen area (ypos -1.0), over the specified time (speed)
    linear speed ypos -3.4
    # Use subpixel movement for smoother scrolling
    subpixel True

## Credits screen definition
screen credits():
    # A black background
    add "#000"

    # The frame containing the credits, applying the scrolling transform
    frame at credits_scroll(50.0): # Adjust the speed (e.g., 30.0 seconds) as needed
        background None
        xalign 0.5
        # A vertical box to stack your credits vertically
        vbox:
            # Add some initial empty space at the start
            null height 200
            text "My Little Pony: Trial of Harmony" style "credits_title"
            null height 100

            text "Created and Directed by" style "credits_role"
            text "Bright Kiltersot" style "credits_name"
            null height 50

            text "Artwork" style "credits_role"
            text "Bright Kiltersot" style "credits_name"
            null height 50

            text "Writing" style "credits_role"
            text "Bright Kiltersot" style "credits_name"
            text "2ShyShy" style "credits_name"
            null height 50

            text "Proofreading" style "credits_role"
            text "2ShyShy" style "credits_name"
            text "Jam5022" style "credits_name"
            text "GeoDash897" style "credits_name"
            text "MCCL" style "credits_name"
            text "Silver Swirl" style "credits_name"
            text "RyukUK" style "credits_name"
            text "Derpy Man" style "credits_name"
            null height 50

            text "Music" style "credits_role"
            text "Titlescreen: MLP Theme (Jazz Upbeat Version - TheJournalisticBrony)" style "credits_name"
            text "Eternal Darkness: MLP Theme (Horror Version - Speckle the Changeling)" style "credits_name"
            text "Cozy Glow Returns TS - SwaggBronii" style "credits_name"
            null height 50

            text "3D Modeling" style "credits_role"
            text "Bright Kiltersot" style "credits_name"
            text "MCCL" style "credits_name"
            null height 50

            text "Model Texturing" style "credits_role"
            text "Bright Kiltersot" style "credits_name"
            null height 50

            text "UI" style "credits_role"
            text "Bright Kiltersot" style "credits_name"
            text "Alex8668 (Original concept)" style "credits_name"
            null height 50

            text "Programming" style "credits_role"
            text "GeoDash897" style "credits_name"
            text "MCCL" style "credits_name"
            text "Bright Kiltersot" style "credits_name"
            null height 50

            text "Beta Testing" style "credits_role"
            text "Gothicdnrprty" style "credits_name"
            text "Animewolfgamer" style "credits_name"
            text "Silver Swirl" style "credits_name"
            text "SmolBee" style "credits_name"
            text "Memespie #13 (MCCL)" style "credits_name"
            text "Jam5022" style "credits_name"
            null height 50

            text "Special Thanks" style "credits_role"
            text "MCCL, for carrying so much weight in this project." style "credits_name"
            text "Rosa Ushiromiya" style "credits_name"
            text "ToastyPK" style "credits_name"
            text "Animewolfgamer" style "credits_name"
            text "Silver Swirl" style "credits_name"
            text "LightningBolt" style "credits_name"
            text "IAmADeliciousPotato" style "credits_name"
            text "Seed Bud" style "credits_name"
            text "THUND3RL4N3R" style "credits_name"
            text "Swaggbronii" style "credits_name"
            text "Thank you all for your support!" style "credits_name"
            null height 50

            text "Trial of Harmony Team" style "credits_role"
            text "MCCL" style "credits_name"
            text "2ShyShy" style "credits_name"
            text "Jam5022" style "credits_name"
            text "GeoDash897" style "credits_name"
            text "This wouldn't have been possible without you." style "credits_name"
            null height 50

            text "Thank you for playing." style "credits_name"
            null height 50

            # Add all your credits here
            # ...

            # Add empty space at the end to ensure all text scrolls off-screen
            null height 5000

    # A timer to automatically return from the screen when the animation finishes
    # The duration should match the 'speed' specified in the transform, plus a little extra for padding
    timer 50.0 action Return()

style credits_title:
    xalign 0.5
    size 60
    color "#FFFFFF"

style credits_role:
    xalign 0.5
    size 40
    color "#CCCCCC"

style credits_name:
    xalign 0.5
    size 30
    color "#AAAAAA"
