init python:
    CC_COLOR_BURN_NAME = "crosscouloir.color_burn"

    _color_burn_blend_mode = BlendMode(CC_COLOR_BURN_NAME)

    _color_burn_blend_mode.vars = """
uniform float u_lod_bias;
uniform sampler2D tex0;
attribute vec2 a_tex_coord;
varying vec2 v_tex_coord;

uniform sampler2D tex1;
"""
    _color_burn_blend_mode.fragment_functions = """
float blendColorBurn(float base, float blend) {
    return (blend==0.0)?blend:max((1.0-((1.0-base)/blend)),0.0);
}

vec3 blendColorBurn(vec3 base, vec3 blend) {
    return vec3(blendColorBurn(base.r,blend.r),blendColorBurn(base.g,blend.g),blendColorBurn(base.b,blend.b));
}

vec3 blendColorBurn(vec3 base, vec3 blend, float opacity) {
    return (blendColorBurn(base, blend) * opacity + base * (1.0 - opacity));
}
"""
    _color_burn_blend_mode.vertex_shader = """
v_tex_coord = a_tex_coord;
"""
    _color_burn_blend_mode.fragment_shader = """
vec4 bgcolor = texture2D(tex0, v_tex_coord.st, u_lod_bias);
vec4 maskcolor = texture2D(tex1, v_tex_coord.st, u_lod_bias);
vec3 blended = blendColorBurn(bgcolor.xyz, maskcolor.xyz, maskcolor.w);
gl_FragColor = vec4(blended, bgcolor.w);
"""
    _color_burn_blend_mode.register()

    def cc_color_burn(base, tex, fit=True):
        return Model().child(base, fit=fit).texture(tex).shader(CC_COLOR_BURN_NAME)