# camera_pan.rpy

default camera_pan_enabled = False
default _camera_x = 0
default _camera_y = 0
default _manual_x = 0
default _manual_y = 0
default _rmb_held = False
default _wasd_held = False

# Master layer saved position
default _saved_master_x = 0
default _saved_master_y = 0

# Tweening
default _tween_active = False
default _tween_start_x = 0
default _tween_start_y = 0
default _tween_target_x = 0
default _tween_target_y = 0
default _tween_duration = 0
default _tween_elapsed = 0

init python:
    import pygame

    class RMBTracker(renpy.Displayable):
        """Tracks right mouse button presses/releases globally."""
        def render(self, w, h, st, at):
            return renpy.Render(1, 1)
        def event(self, ev, x, y, st):
            global _rmb_held
            if ev.type == pygame.MOUSEBUTTONDOWN and ev.button == 3:
                _rmb_held = True
            elif ev.type == pygame.MOUSEBUTTONUP and ev.button == 3:
                _rmb_held = False
            return None

    def update_camera(max_x, max_y, smoothing):
        """
        Update the actual camera position using WASD or RMB.
        Applies the transform to the master layer only (the true camera).
        """
        global _camera_x, _camera_y, _manual_x, _manual_y
        global _rmb_held, _wasd_held
        global _tween_active, _tween_elapsed, _tween_duration
        global _tween_start_x, _tween_start_y, _tween_target_x, _tween_target_y

        if _tween_active:
            _tween_elapsed += 0.01
            t = min(_tween_elapsed / _tween_duration, 1.0)
            t = t * t * (3 - 2 * t)  # smoothstep easing

            _camera_x = _tween_start_x + (_tween_target_x - _tween_start_x) * t
            _camera_y = _tween_start_y + (_tween_target_y - _tween_start_y) * t

            if t >= 1.0:
                _tween_active = False
                _manual_x, _manual_y = _camera_x, _camera_y

        else:
            keys = pygame.key.get_pressed()
            dx, dy = 0, 0
            move_speed = 12

            if keys[pygame.K_w]: dy -= move_speed
            if keys[pygame.K_s]: dy += move_speed
            if keys[pygame.K_a]: dx -= move_speed
            if keys[pygame.K_d]: dx += move_speed

            if dx or dy:
                _wasd_held = True
                _manual_x = max(-max_x, min(max_x, _manual_x + dx))
                _manual_y = max(-max_y, min(max_y, _manual_y + dy))
            else:
                _wasd_held = False

            if _wasd_held:
                target_x, target_y = _manual_x, _manual_y
            elif _rmb_held:
                mx, my = renpy.get_mouse_pos()
                nx = (mx / float(config.screen_width) - 0.5) * 2
                ny = (my / float(config.screen_height) - 0.5) * 2
                target_x, target_y = nx * max_x, ny * max_y
                _manual_x, _manual_y = target_x, target_y
            else:
                target_x, target_y = _manual_x, _manual_y

            _camera_x += (target_x - _camera_x) * smoothing
            _camera_y += (target_y - _camera_y) * smoothing

        # ?? Apply camera transform to the whole master layer
        renpy.layer_at_list(
            [Transform(xoffset=int(-_camera_x), yoffset=int(-_camera_y))],
            layer="master"
        )

    def set_camera_pan(enabled=True, max_x=150, max_y=80, smoothing=0.15):
        global camera_pan_enabled
        camera_pan_enabled = enabled
        if enabled:
            renpy.show_screen("camera_pan", max_x=max_x, max_y=max_y, smoothing=smoothing)
        else:
            renpy.hide_screen("camera_pan")
            renpy.layer_at_list(
                [Transform(xoffset=int(-_camera_x), yoffset=int(-_camera_y))],
                layer="master"
            )

    def move_camera_to(x, y, duration=1.0):
        global _tween_active, _tween_start_x, _tween_start_y
        global _tween_target_x, _tween_target_y, _tween_duration, _tween_elapsed
        _tween_active = True
        _tween_start_x, _tween_start_y = _camera_x, _camera_y
        _tween_target_x, _tween_target_y = x, y
        _tween_duration = duration
        _tween_elapsed = 0.0

    def save_master_layer_position():
        """Save current master layer offset"""
        global _saved_master_x, _saved_master_y
        _saved_master_x, _saved_master_y = _camera_x, _camera_y

    def reset_master_layer(duration=0.5):
        """Tween camera back to (0,0)."""
        global _tween_active, _tween_start_x, _tween_start_y
        global _tween_target_x, _tween_target_y, _tween_duration, _tween_elapsed
        _tween_active = True
        _tween_start_x, _tween_start_y = _camera_x, _camera_y
        _tween_target_x, _tween_target_y = 0, 0
        _tween_duration = duration
        _tween_elapsed = 0.0

    def restore_master_layer(duration=0.5):
        """Tween camera back to saved master position."""
        global _tween_active, _tween_start_x, _tween_start_y
        global _tween_target_x, _tween_target_y, _tween_duration, _tween_elapsed
        _tween_active = True
        _tween_start_x, _tween_start_y = _camera_x, _camera_y
        _tween_target_x, _tween_target_y = _saved_master_x, _saved_master_y
        _tween_duration = duration
        _tween_elapsed = 0.0

screen camera_pan(max_x=150, max_y=80, smoothing=0.15):
    add RMBTracker()

    key "repeat_K_w" action NullAction()
    key "repeat_K_a" action NullAction()
    key "repeat_K_s" action NullAction()
    key "repeat_K_d" action NullAction()

    timer 0.01 repeat True action Function(update_camera, max_x, max_y, smoothing)

init python:

    def cam_x(scale=1.0):
        return int(_camera_x * scale)

    def cam_y(scale=1.0):
        return int(_camera_y * scale)