import bpy

#Used to check if a certain Object is selected
rig_name = "PoneRig"
hair_name = "HairRig"
tail_name = "TailRig"

#IK FK Bones

hindlegL = ["IK_H3.L","FK_H2.L" ,"FK_H3.L" ,"FK_H4.L"]
hindlegR = ["IK_H3.R","FK_H2.R" ,"FK_H3.R" ,"FK_H4.R"]
forelegL = ["IK_V4.L","FK_V2.L" ,"FK_V3.L" ,"FK_V4.L"]
forelegR = ["IK_V4.R","FK_V2.R" ,"FK_V3.R" ,"FK_V4.R"]

#Wing Bones

wings = ["Wing1_ctr.L","Wing1_ctr.R","Wing2_ctr.L","Wing2_ctr.R"]


#extra values & functions

def H_toggle(self, context):
    
    if bpy.context.active_object.data.get("rig_name") == "PoneRig":
        pone = bpy.context.active_object
        for child in pone.children:
            if child.data.get("hair_name") or child.data.get("tail_name"):
                for grandChild in child.children:
                    if grandChild.type == 'CURVE':
                        grandChild.modifiers["Softbody"].show_viewport = self.hair_physics
                        grandChild.modifiers["Softbody"].show_render = self.hair_physics

    
    return 'NONE'

def HL_toggle(self, context):
    if bpy.context.active_object.data.get("rig_name") == "PoneRig":
        pone = bpy.context.active_object
        for child in pone.children:
            if child.data.get("hair_name"):
                child.data.layers[23] = self.mane_layer
    return 'NONE'
    
def TL_toggle(self, context):
    if bpy.context.active_object.data.get("rig_name") == "PoneRig":
        pone = bpy.context.active_object
        for child in pone.children:
            if child.data.get("tail_name"):
                child.data.layers[23] = self.tail_layer
                
    return 'NONE'


bpy.types.Scene.hair_physics = bpy.props.BoolProperty(
    name = "Hair_Physics",
    default = False,
    update=H_toggle
    )
bpy.types.Scene.tail_layer = bpy.props.BoolProperty(
    name = "Tail_Layer",
    default = False,
    update=TL_toggle
    )
bpy.types.Scene.mane_layer = bpy.props.BoolProperty(
    name = "Hair_Layer",
    default = False,
    update=HL_toggle
    )


    #Panel some Rig Properties
class Rig_Properties(bpy.types.Panel):
    bl_space_type = "VIEW_3D"
    bl_region_type = "UI"
    bl_label = "Rig Properties"
    
    
    
    #Checks if rig is selected
    @classmethod
    def poll(self, context):
        return(context.active_object.data.get("rig_name") == rig_name)
    
    def draw(self, context):
        layout = self.layout
        
        armature = context.active_object.data
        
            ###create sliders
        pose_bones = bpy.context.active_object.data
        selected_bones_set = set(map(lambda x: x.name, bpy.context.selected_pose_bones))
            
        def tieSliderToProp(bones, property, textLabel):
            if(selected_bones_set.intersection(bones)):
                row = layout.row()
                row.prop(pose_bones, property, text=textLabel, slider=True)
        
            ###IK-FK sliders
        tieSliderToProp(hindlegL, '["IK_FK_hindLeg.L"]', "hindLeg.L IK")
        tieSliderToProp(hindlegR, '["IK_FK_hindLeg.R"]', "hindLeg.R IK")
        tieSliderToProp(forelegL, '["IK_FK_foreleg.L"]', "foreleg.L IK")
        tieSliderToProp(forelegR, '["IK_FK_foreleg.R"]', "foreleg.R IK")
        
            ###X-ray visibility
        xray = layout.row()
        xray.label(text="X-ray:")
        xray.prop(context.active_object, "show_x_ray", toggle=True, text="X-ray")
        
        HairP = layout.row()
        HairP.label(text="Hair Physics:")
        HairP.prop(context.scene, "hair_physics", toggle=True, text="Enable", icon='PHYSICS')
        


    #Panel for showing/hiding Rig Layers
class Rig_Layers(bpy.types.Panel):
    bl_space_type = "VIEW_3D"
    bl_region_type = "UI"
    bl_label = "Rig Layers"
    
    #mane_layer = True
    #tail_layer = True
    
    
    #Checks if rig is selected
    @classmethod
    def poll(self, context):
        return(context.active_object.data.get("rig_name") == rig_name)
    
    def draw(self, context):
        layout = self.layout
        #col = layout.column()
        
        armature = context.active_object.data
            ###Layers
            #Body
        body = layout.row()      
        body.label(text="Main:")
        body.prop(armature , "layers", index=0, toggle=True, text="Basics")
        body.prop(armature , "layers", index=16, toggle=True, text="Face")
        
        hindleg = layout.row()
        hindleg.label(text="hindlegL:")
        hindleg.prop(armature , "layers", index=19, toggle=True, text="IK")
        hindleg.prop(armature , "layers", index=18, toggle=True, text="FK")
        
        foreleg = layout.row()      
        foreleg.label(text="forelegR:")
        foreleg.prop(armature , "layers", index=3, toggle=True, text="IK")
        foreleg.prop(armature , "layers", index=2, toggle=True, text="FK")
        
        wings = layout.row()      
        wings.label(text="Wings:")
        wings.prop(armature , "layers", index=1, toggle=True, text="Wings")
        
            #Hair
        
        
        Hair = layout.row()
        Hair.label(text="Hair:")
        Hair.prop(context.scene, "mane_layer", toggle=True, text="mane")
        Hair.prop(context.scene, "tail_layer", toggle=True, text="tail")

    #init Panels


def register():
    bpy.utils.register_class(Rig_Properties)
    bpy.utils.register_class(Rig_Layers)


def unregister():
    bpy.utils.unregister_class(Rig_Properties)
    bpy.utils.unregister_class(Rig_Layers)


#if __name__ == "__main__":
#    register()
    
register()