/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.action;

import com.group_finity.mascot.Mascot;
import com.group_finity.mascot.action.Action;
import com.group_finity.mascot.animation.Animation;
import com.group_finity.mascot.environment.MascotEnvironment;
import com.group_finity.mascot.exception.LostGroundException;
import com.group_finity.mascot.exception.VariableException;
import com.group_finity.mascot.hotspot.Hotspot;
import com.group_finity.mascot.script.Variable;
import com.group_finity.mascot.script.VariableMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public abstract class ActionBase
implements Action {
    private static final Logger log = Logger.getLogger(ActionBase.class.getName());
    public static final String PARAMETER_DURATION = "Duration";
    private static final boolean DEFAULT_CONDITION = true;
    public static final String PARAMETER_CONDITION = "Condition";
    private static final int DEFAULT_DURATION = Integer.MAX_VALUE;
    public static final String PARAMETER_DRAGGABLE = "Draggable";
    private static final boolean DEFAULT_DRAGGABLE = true;
    private Mascot mascot;
    private int startTime;
    private List<Animation> animations;
    private VariableMap variables;
    private ResourceBundle schema;

    public ActionBase(ResourceBundle schema, List<Animation> animations, VariableMap context) {
        this.schema = schema;
        this.animations = animations;
        this.variables = context;
    }

    public String toString() {
        try {
            return "Action (" + this.getClass().getSimpleName() + "," + this.getName() + ")";
        }
        catch (VariableException e) {
            return "Action (" + this.getClass().getSimpleName() + "," + null + ")";
        }
    }

    @Override
    public void init(Mascot mascot) throws VariableException {
        this.setMascot(mascot);
        this.setTime(0);
        this.getVariables().put("mascot", (Object)mascot);
        this.getVariables().put("action", (Object)this);
        this.getVariables().init();
        for (Animation animation : this.animations) {
            animation.init();
        }
    }

    @Override
    public void next() throws LostGroundException, VariableException {
        this.initFrame();
        this.getMascot().getAffordances().clear();
        this.refreshHotspots();
        this.tick();
    }

    private void initFrame() {
        this.getVariables().initFrame();
        for (Animation animation : this.getAnimations()) {
            animation.initFrame();
        }
    }

    protected List<Animation> getAnimations() {
        return this.animations;
    }

    protected abstract void tick() throws LostGroundException, VariableException;

    @Override
    public boolean hasNext() throws VariableException {
        boolean effective = this.isEffective();
        boolean intime = this.getTime() < this.getDuration();
        return effective && intime;
    }

    protected void refreshHotspots() {
        this.getMascot().getHotspots().clear();
        try {
            if (this.getAnimation() != null) {
                for (Hotspot hotspot : this.getAnimation().getHotspots()) {
                    this.getMascot().getHotspots().add(hotspot);
                }
            }
        }
        catch (VariableException ex) {
            this.getMascot().getHotspots().clear();
        }
    }

    public Boolean isDraggable() throws VariableException {
        return this.eval(this.schema.getString(PARAMETER_DRAGGABLE), Boolean.class, true);
    }

    private Boolean isEffective() throws VariableException {
        return this.eval(this.schema.getString(PARAMETER_CONDITION), Boolean.class, true);
    }

    private int getDuration() throws VariableException {
        return ((Number)this.eval(this.schema.getString(PARAMETER_DURATION), Number.class, Integer.MAX_VALUE)).intValue();
    }

    private void setMascot(Mascot mascot) {
        this.mascot = mascot;
    }

    protected Mascot getMascot() {
        return this.mascot;
    }

    protected int getTime() {
        return this.getMascot().getTime() - this.startTime;
    }

    protected void setTime(int time) {
        this.startTime = this.getMascot().getTime() - time;
    }

    private String getName() throws VariableException {
        return this.eval(this.schema.getString("Name"), String.class, null);
    }

    protected Animation getAnimation() throws VariableException {
        for (Animation animation : this.getAnimations()) {
            if (!animation.isEffective(this.getVariables())) continue;
            return animation;
        }
        return null;
    }

    protected VariableMap getVariables() {
        return this.variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putVariable(String key, Object value) {
        VariableMap variableMap = this.getVariables();
        synchronized (variableMap) {
            this.getVariables().put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T eval(String name, Class<T> type, T defaultValue) throws VariableException {
        VariableMap variableMap = this.getVariables();
        synchronized (variableMap) {
            Variable variable = this.getVariables().getRawMap().get(name);
            if (variable != null) {
                return type.cast(variable.get(this.getVariables()));
            }
        }
        return defaultValue;
    }

    protected MascotEnvironment getEnvironment() {
        return this.getMascot().getEnvironment();
    }

    protected ResourceBundle getSchema() {
        return this.schema;
    }
}

