init python:
    import time
    from selenium import webdriver
    from selenium.webdriver.common.by import By
    from selenium.webdriver.support.ui import WebDriverWait
    from selenium.webdriver.support import expected_conditions as EC
    from selenium.webdriver.common.keys import Keys
    import re

    CLEANR = re.compile('<.*?>')

    def cleanhtml(raw_html):
        cleantext = re.sub(CLEANR, '', raw_html)
        return cleantext

    #options = webdriver.ChromeOptions()
    #options.add_argument("headless")
    #driver = webdriver.Chrome(executable_path='C:\Users\user\Downloads\RenPy TVNDNE\chromedriver.exe', chrome_options=options)
    driver = webdriver.Chrome('{}\chromedriver.exe'.format(renpy.config.gamedir))

    # Log In to Novel AI
    driver.get('https://novelai.net/login')

# Declare characters used by this game.
define s = Character(_("Sylvie"), color="#c8ffc8")
define m = Character(_("Me"), color="#c8c8ff")

#Define variables used throughout
default week = 0
default lovemeter = 0
default test = ""
default protag = ""
default waifu = ""
default proseString = ""
default action = ""
default number = -1
#default recovery_html = ""
default username = ""
default password = ""

# The game starts here.
label start:

    # Start by playing some music.
    play music "illurock.opus"

    scene bg lecturehall
    with fade

    python:
        username = renpy.input("Enter NovelAI Username:")
        password = renpy.input("Enter NovelAI Password:")

        WebDriverWait(driver, 5000).until(EC.presence_of_element_located((By.XPATH, '//*[@id="username"]'))).send_keys(username)
        driver.find_element_by_xpath('//*[@id="password"]').send_keys(password)
        driver.find_element_by_xpath("//input[contains(@type,\"submit\")]").click()

        #Get to a Prose Window
        WebDriverWait(driver, 5000).until(EC.presence_of_element_located((By.XPATH, '//button[contains(@aria-label,\"Close Modal\")]'))).click()
        time.sleep(1)
        driver.find_element_by_xpath("//button[contains(@style,\"flex-grow: 2.5;\")]").click()
        time.sleep(3)

        def printprose(prose):
            prose = prose.replace("\'", "\\\'")
            element = driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]")
            driver.execute_script('var ele=arguments[0]; ele.innerHTML += \'{}\';'.format(prose), element)
            driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").send_keys(Keys.END)

        def clearprose():
            element = driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]")
            driver.execute_script('var ele=arguments[0]; ele.innerHTML = \'\';', element)

        printprose("==Week -3 of School==")
        printprose("Scenario: You are asked to introduce yourself to the class on the first day of school. You are standing in front of the whole class, including some cute girls who catch your eyes. Their gaze is making you sweat, and your heart beat faster. It's becoming almost suffocating.")
        printprose("Your Action: You gulp and overcome your jitters. You introduce yourself, and tell the class a little bit about your interests. You mention that you've transfered from an old school, and used to be involved in a lot of school clubs.")
        printprose("Outcome: Afterwards, you hear a cute girl say that you sound like an interesting person. Her friends all agree.")
        printprose("ARBITRATOR: Gain 5 love points out of five.")
        printprose("==Week -2 of School==")
        printprose("Scenario: You're eating lunch with her and her friends, and a debate starts about where you all should spend the rest of the lunch period. Your best friend says you should hang out in the basketball court, while her friend is saying that you should ditch class and leave school together.")
        printprose("Your Action: You consider the question for a long time, before arriving at the perfect compromise answer: 'We should go to the library!'")
        printprose("Outcome: Everyone looks at you in confusion. Nobody is in the mood for the library today. Your suggestion was terrible.")
        printprose("ARBITRATOR: Gain 0 love points out of five.")
        printprose("==Week -1 of School==")
        printprose("Scenario: You are invited to the student council room. Nobody else is there but you and her. She challenges you to a game of Risk. While you are playing, she tells you that she'll let you keep Australia if you agree to join the student council with her.")
        printprose("Your Action: You turn down her offer to join the student council. You have too many responsibilities as it is!")
        printprose("Outcome: Her face falls, and she is clearly disappointed with your answer. The game continues in silence, and when it finishes she leaves without another word. You get the sense that you hurt her feelings.")
        printprose("ARBITRATOR: Gain 0 love points out of five.")
        printprose("==Week 0 of School==")
        printprose("Scenario: You run into her in the library, and see her quietly reading. She hasn't noticed your presence as you walk in, and seems deeply engrossed in her book.")
        printprose("Your Action: You sit down across from her, and ask her what she's reading.")
        printprose("Outcome: She smiles, and seems thrilled that you're here. She clearly considers you much more interesting than the book she was just reading.")
        printprose("ARBITRATOR: Gain 2 love point out of five.")

    "(Use developer console to 'load' previous game here.)"

    python:
        protag = renpy.input("What is your name?")

    show sylvie green normal

    screen Lovemeter:
        text "{color=#9933ff}Lovemeter: [lovemeter]/100{/color}" xpos 0.05 ypos 0.05 size 22

    show screen Lovemeter

    python:
        waifu = renpy.input("What is your waifu's name?")

    python:
        def verifyscore():
            proseString = driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").get_attribute('innerHTML')
            proseString = proseString.split("==Week {} of School==".format(week),1)[1]
            if "ARBITRATOR:" not in proseString:
                printprose("ARBITRATOR: ")
                #driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").send_keys(Keys.RETURN)
                #driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").send_keys("ARBITRATOR: ")
                driver.find_element_by_xpath("//button[contains(@aria-label,\"Send\")]").click()
                time.sleep(5)

        def cleanstory(search_string):
            try:
                prose_html = driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").get_attribute('innerHTML')
                substrings = prose_html.split("==Week {} of School==".format(week),1)
                prose_substring = substrings[1]
                prose_html = substrings[0]
                if search_string in prose_substring:
                    prose_substring = prose_substring.split(search_string,1)[0]
                prose_html = prose_html + "==Week {} of School==".format(week) + prose_substring
                prose_html = prose_html.replace("\'", "\\\'")

                element = driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]")
                driver.execute_script('var ele=arguments[0]; ele.innerHTML = \'{}\';'.format(prose_html), element)
            except:
                pass

    while 0 < 1:
        python:
                week = week + 1

                def generateweek():
                    #inner = driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").get_attribute('innerHTML')
                    #if len(inner) < 1500:
                        #element = driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]")
                        #driver.execute_script('var ele=arguments[0]; ele.innerHTML = \'{}\';'.format(recovery_html), element)

                    printprose('==Week {} of School=='.format(week))

                    if week == 1:
                        printprose("Scenario: Your name is {}, and it's your first day of high school. You're curious to see what the year will have in store for you. You were assigned your seat behind the beautiful {}. She starts chatting with you, and talks about how excited she is for the new school year, and asks what school clubs you plan on joining.".format(protag, waifu))
                    elif week == 2:
                        printprose("Scenario: {} tries to strike up a conversation again with you. Something about your conversation last week was interesting to her. She tells you that she joined a club and is having a lot of fun. She asks if you want to join the club as well.".format(waifu))
                    else:
                        #driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").send_keys(Keys.END)
                        printprose("Scenario: ")
                        #driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").send_keys(Keys.RETURN)
                        #driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").send_keys("Scenario: ")
                        driver.find_element_by_xpath("//button[contains(@aria-label,\"Send\")]").click()
                        time.sleep(5)
                        cleanstory("Your Action")
                        cleanstory("==Week")

                generateweek()
                #driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").send_keys(Keys.RETURN)

                try:
                    proseString = driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").get_attribute('innerHTML')
                except:
                    time.sleep(1)
                    driver.refresh()
                    WebDriverWait(driver, 5000).until(EC.presence_of_element_located((By.XPATH, "//div[contains(@class,\"ProseMirror\")]")))
                    proseString = driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").get_attribute('innerHTML')
                if "==Week {} of School==".format(week) in proseString:
                    proseString = proseString.split("==Week {} of School==".format(week),1)[1]
                else:
                    while "==Week {} of School==".format(week) not in proseString:
                        proseString = driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").get_attribute('innerHTML')
                        generateweek()
                proseString = cleanhtml(proseString)

                action = renpy.input("==Week {} of School==\n{}\nWhat do you do?".format(week, proseString.split("Scenario: ",1)[1]))
                action = "Your Action: " + action
                printprose(action)
                #driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").send_keys(action)
                #driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").send_keys(Keys.RETURN)
                #driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").send_keys("Outcome:")
                printprose("Outcome:")
                driver.find_element_by_xpath("//button[contains(@aria-label,\"Send\")]").click()
                time.sleep(5)

                cleanstory("***")
                cleanstory("==Week")
                verifyscore()
                cleanstory("***")
                cleanstory("==Week")

                #Grab Outcome
                try:
                    proseString = driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").get_attribute('innerHTML')
                except:
                    time.sleep(1)
                    driver.refresh()
                    WebDriverWait(driver, 5000).until(EC.presence_of_element_located((By.XPATH, "//div[contains(@class,\"ProseMirror\")]")))
                    proseString = driver.find_element_by_xpath("//div[contains(@class,\"ProseMirror\")]").get_attribute('innerHTML')
                proseStringRaw = proseString
                proseString = cleanhtml(proseString)
                if "==Week {}".format(week) in proseString:
                    proseString = proseString.split("==Week {}".format(week),1)[1]
                else:
                    proseString = proseString.split("==Week {}".format(week - 1),1)[1]
                    proseString = proseString.split("Outcome:",1)[1]
                if "Outcome:" in proseString:
                    proseString = proseString.split("Outcome:",1)[1]
                if "ARBITRATOR:" in proseString:
                    latestScore = proseString.split("ARBITRATOR:",1)[1]
                    split_string = proseString.split("ARBITRATOR:",1)
                    proseString = split_string[0]
                else:
                    latestScore = "0"

                #Grab Score
                latestScore = cleanhtml(latestScore)
                number = re.findall('\d+', latestScore)
                number = int(str(''.join(number)))
                if number > 5:
                    number = 5
                number -= 1
                lovemeter = lovemeter + number
        "[proseString] {color=#33cc33}([number] love points.){/color}"
