﻿## This file contains some of the options that can be changed to customize
## your Ren'Py game. It only contains the most common options... there
## is quite a bit more customization you can do.
##
## Lines beginning with two '#' marks are comments, and you shouldn't
## uncomment them. Lines beginning with a single '#' mark are
## commented-out code, and you may want to uncomment them when
## appropriate.
init -2: 
    image blendenbild:
        "images/btn/blende1.png"
        xalign 0.5 yalign 0.5 xanchor 0.5 yanchor 0.5 zoom 1 subpixel True
        ease 1 zoom 2

init -1 python hide:
    ## Should we enable the use of developer tools? This should be
    ## set to False before the game is released, so the user can't
    ## cheat using developer tools.
    
    menublende = ImageDissolve(im.Tile("images/btn/blende1.png"), 0.5, 256)
    gamemenublende = ImageDissolve(im.Tile("images/btn/blende2.png"), 0.25, 256)   
    config.developer = False

    ## These control the width and height of the screen.

    config.screen_width = 960
    config.screen_height = 540

    ## This controls the title of the window, when Ren'Py is
    ## running in a window.

    config.window_title = u"Bernd und das Rätsel um Unteralterbach (v2.1)"

    # These control the name and version of the game, that are reported
    # with tracebacks and other debugging logs.
    config.name = "UAB"
    config.version = "2.1"
    
    #########################################
    # Themes
    
    ## We then want to call a theme function. themes.roundrect is
    ## a theme that features the use of rounded rectangles. It's
    ## the only theme we currently support.
    ##
    ## The theme function takes a number of parameters that can
    ## customize the color scheme.
    theme.unteralter(                                    
        ## The color of an idle widget face.
        widget = "#000",
        ## The color of a focused widget face.
        widget_hover = "#fc2676",
        ## The color of the text in a widget.
        widget_text = "#fff",
        ## The color of the text in a selected widget. (For example, the current value of a preference.)
        widget_selected = "#fff",
        ## The color of a disabled widget face. 
        disabled = "#ffb0cd",
        ## The color of disabled widget text.
        disabled_text = "#fff",
        ## The color of informational labels.
        label = "#fff",
        ## The color of a frame containing widgets.
        frame = "#fff",
        ## The background of the main menu. This can be a color
        ## beginning with '#', or an image filename. The latter
        ## should take up the full height and width of the screen.
        
        mm_root = "#fff0", #"#f8c821",
        #mm_root = "images/menu_bg.jpg",        
        # zm_root = "#7002",
        
        ## The background of the game menu. This can be a color
        ## beginning with '#', or an image filename. The latter
        ## should take up the full height and width of the screen.
       
        #gm_root = "images/menubg_main.jpg",
        
        ## If this is True, the in-game window is rounded. If False,
        ## the in-game window is square.
        
        rounded_window = False,

        ## And we're done with the theme. The theme will customize
        ## various styles, so if we want to change them, we should
        ## do so below.            
        )


    #########################################
    ## These settings let you customize the window containing the
    ## dialogue and narration, by replacing it with an image.

    ## The background of the window. In a Frame, the two numbers
    ## are the size of the left/right and top/bottom borders,
    ## respectively.
    
    style.say_who_window.background = Frame("images/namebox.png", 16, 34)
    style.window.background = None #"images/dialoguebox.png" #Frame("images/frame.png", 12, 12)

    ## Margin is space surrounding the window, where the background
    ## is not drawn.
  
    style.say_who_window.top_padding = 0
    style.say_who_window.bottom_padding = 0
    style.say_who_window.left_padding = 32
    style.say_who_window.right_padding = 8
    
    ## Padding is space inside the window, where the background is drawn.

    #style.window.left_margin = 35
    #style.window.right_margin = 35
    #style.window.top_margin = 24
    #style.window.bottom_margin = 21    
    
    style.window.left_padding = 40
    style.window.right_padding = 40
    style.window.top_padding = 29
    style.window.bottom_padding = 10

    ## This is the minimum height of the window, including the margins and padding.
    
    style.say_who_window.xminimum = 20
    #style.window.yminimum = 200
    
    #########################################
    ## This lets you change the placement of the main menu.

    ## The way placement works is that we find an anchor point
    ## inside a displayable, and a position (pos) point on the
    ## screen. We then place the displayable so the two points are
    ## at the same place.

    ## An anchor/pos can be given as an integer or a floating point
    ## number. If an integer, the number is interpreted as a number
    ## of pixels from the upper-left corner. If a floating point,
    ## the number is interpreted as a fraction of the size of the
    ## displayable or screen.

    #style.mm_menu_frame.xpos = 0.5
    #style.mm_menu_frame.xanchor = 0.5
    #style.mm_menu_frame.ypos = 0.75
    #style.mm_menu_frame.yanchor = 0.5

    #########################################
    ## These let you customize the default font used for text in Ren'Py.

    ## The file containing the default font.

    style.default.font = "uabsans.ttf"
    #style.default.line_overlap_split = 2
    #style.default.line_spacing = 1
    
    
    ## The default size of text.

    # style.default.size = 22 # für die DejaVuSans.ttf
    style.default.size = 26
    
    ## Note that these only change the size of some of the text. Other
    ## buttons have their own styles.


    #########################################
    ## These settings let you change some of the sounds that are used by
    ## Ren'Py.

    ## Set this to False if the game does not have any sound effects.

    config.has_sound = True

    ## Set this to False if the game does not have any music.

    config.has_music = True

    ## Set this to False if the game does not have voicing.

    config.has_voice = False

    ## Sounds that are used when button and imagemaps are clicked.

    # style.button.activate_sound = "click.wav"
    # style.imagemap.activate_sound = "click.wav"

    ## Sounds that are used when entering and exiting the game menu.

    # config.enter_sound = "click.wav"
    #config.exit_sound = "sound/button_click.ogg"

    ## A sample sound that can be played to check the sound volume.

    # config.sample_sound = "click.wav"

    ## Music that is played while the user is at the main menu.

    config.main_menu_music = "music/menu1.ogg"

    #########################################
    ## Help.

    ## This lets you configure the help option on the Ren'Py menus.
    ## It may be:
    ## - A label in the script, in which case that label is called to
    ##   show help to the user.
    ## - A file name relative to the base directory, which is opened in a
    ##   web browser.
    ## - None, to disable help.   
    #config.help = "README.txt"
    
    #########################################
## Transitions.

    ## Used when entering the game menu from the game.
    config.enter_transition = gamemenublende #CropMove(0.2, "wipedown") #Dissolve(0.2)

    ## Used when exiting the game menu to the game.
    config.exit_transition = gamemenublende #CropMove(0.2, "wipeup") #Dissolve(0.2)

    ## Used between screens of the game menu.
    config.intra_transition = menublende #CropMove(0.3, "wipedown") #Dissolve(0.2)

    ## Used when entering the game menu from the main menu.
    config.main_game_transition = menublende #Fade(0.4)

    ## Used when returning to the main menu from the game.
    config.game_main_transition = menublende #Dissolve(0.4)

    ## Used when entering the main menu from the splashscreen.
    config.end_splash_transition = None #menublende #menublende #Dissolve(0.4)

    ## Used when entering the main menu after the game has ended.
    config.end_game_transition = menublende

    ## Used when a game is loaded.
    config.after_load_transition = Fade(0.5,0,0.5, color="#000") #menublende #fade

    ## Used when the window is shown.
    config.window_show_transition = Dissolve(0.3)

    ## Used when the window is hidden.
    config.window_hide_transition = Dissolve(0.3)

    #########################################
    ## This is the name of the directory where the game's data is
    ## stored. (It needs to be set early, before any other init code
    ## is run, so the persistent information can be found by the init code.)    
python early:
    config.save_directory = None #"UAB_2.x"
    config.savedir = config.gamedir +  "/saves"

init -1 python hide:
    #########################################
    ## Default values of Preferences.

    ## Note: These options are only evaluated the first time a
    ## game is run. To have them run a second time, delete
    ## game/saves/persistent

    ## Should we start in fullscreen mode?

    config.default_fullscreen = False

    ## The default text speed in characters per second. 0 is infinite.

    config.default_text_cps = 30

    #########################################
    ## More customizations can go here.
    #config.mouse = { 'default' : (("images/cursor1.png", 0, 0), ("images/cursor1.png", 0, 0)) }
    config.window_icon = "images/icon.png"
    config.autosave_frequency = 200
    config.has_autosave = False
    
    #config.rollback_enabled = True
    #config.hard_rollback_limit = 10    
    #config.fix_rollback_without_choice = True
    
    style.zm_root = Style(style.default)
    style.zm_root.background = "#03f2"
    style.zm_root.xfill = True
    style.zm_root.yfill = True
                         
## This section contains information about how to build your project into 
## distribution files.
init python:
    
    ## The name that's used for directories and archive files. For example, if
    ## this is 'mygame-1.0', the windows distribution will be in the
    ## directory 'mygame-1.0-win', in the 'mygame-1.0-win.zip' file.
    build.directory_name = "Unteralterbach"
    
    ## The name that's uses for executables - the program that users will run
    ## to start the game. For example, if this is 'mygame', then on Windows,
    ## users can click 'mygame.exe' to start the game.
    build.executable_name = "Unteralterbach"
    
    ## If True, Ren'Py will include update information into packages. This
    ## allows the updater to run.
    build.include_update = False
    
    ## File patterns:
    ## 
    ## The following functions take file patterns. File patterns are case-
    ## insensitive, and matched against the path relative to the base
    ## directory, with and without a leading /. If multiple patterns match,
    ## the first is used.
    ##    
    ##
    ## In a pattern:
    ##
    ## / 
    ##     Is the directory separator.
    ## *
    ##     Matches all characters, except the directory separator.
    ## **
    ##     Matches all characters, including the directory separator.
    ##
    ## For example:
    ##
    ## *.txt
    ##     Matches txt files in the base directory.
    ## game/**.ogg
    ##     Matches ogg files in the game directory or any of its subdirectories.
    ## **.psd
    ##    Matches psd files anywhere in the project.

    ## Classify files as None to exclude them from the built distributions.

    build.classify('**~', None)
    build.classify('**.bak', None)
    build.classify('**/.**', None)
    build.classify('**/#**', None)
    build.classify('**/**.rpy', None)
    build.classify('game/saves/**', None)
    build.classify('game/cache/**', None)
    build.classify('game/**.rpyb', None)
    build.classify('tmp/**', None)
    build.classify('log.txt', None)
    
    # build.classify('**/DejaVuSans.**', None)
    # klappt nicht mal. :( alles im commons-ordner muss man nach dem builden manuell löschen.
    # alles bis auf: die rp**-dateien im commons-grundverzeichnis und die ordner _compat, _layout, _theme_unteralter
    
    build.classify('game/presplash.png', 'all')  # darf nicht archiviert werden. sonst erscheint es nicht beim launchen.
    
    build.archive('001', 'all') # die packdatei für skripte
    build.archive('002', 'all') # die packdatei für bilder
    build.archive('003', 'all') # die packdatei für sounds
    
    ## To archive files, classify them as 'archive'.
    
    build.classify('game/**.rpy', '001')
    build.classify('game/**.rpyc', '001')
    build.classify('game/images/**', '002')
    build.classify('game/tl/english/images/**', '002')
    build.classify('game/**.ttf', '002')    
    build.classify('game/**.ogg', '003')

    ## Files matching documentation patterns are duplicated in a mac app
    ## build, so they appear in both the app and the zip file.

    #build.documentation('*.html')
    #build.documentation('*.txt')
    