﻿init -1300 python:
    def roundrect_based_theme(name, file_prefix, Box=None, frame_png=None):

        if Box is None:
            def Box(color, ignored):
                return Frame(theme.OneOrTwoColor(file_prefix + "_box.png", color), 12, 12)

        if frame_png is not None:
            def FrameBox(color, ignored):
                return Frame(theme.OneOrTwoColor(file_prefix + frame_png, color), 12, 12)
        else:
            FrameBox = Box

        def frames(
            less_rounded,
            frame):

            theme.clear_frames()

            style.frame.background = Box(frame, less_rounded)

            style.frame.xpadding = 6
            style.frame.ypadding = 6

        setattr(theme, name + "_frames", frames)


        def buttons(text_size,
                    less_rounded,
                    widget,
                    widget_hover,
                    widget_text,
                    widget_selected,
                    disabled,
                    disabled_text):

            theme.clear_buttons()

            style.button.background = Box(widget, less_rounded)
            style.button.hover_background = Box(widget_hover, less_rounded)
            style.button.insensitive_background = Box(disabled, less_rounded)

            style.button_text.size = text_size
            style.button_text.color = widget_text
            style.button_text.selected_color = widget_selected
            style.button_text.insensitive_color = disabled_text

            if less_rounded:
                style.button.xpadding = 6
            else:
                style.button.xpadding = 12

            style.button.ypadding = 1
            style.button.xmargin = 1
            style.button.ymargin = 1

            style.button_text.xalign = 0.5
            style.button_text.yalign = 0.5
            style.button_text.text_align = 0.5

        setattr(theme, name + "_buttons", buttons)

        def large_buttons(
            text_size,
            less_rounded,
            widget,
            widget_hover,
            widget_text,
            widget_selected,
            disabled,
            disabled_text):

            theme.clear_large_buttons()

            if less_rounded:
                style.large_button.xpadding = 6
            else:
                style.large_button.xpadding = 12

            style.large_button.ypadding = 1
            style.large_button.xmargin = 1
            style.large_button.ymargin = 1

            style.large_button.background = Box(widget, less_rounded)
            style.large_button.hover_background = Box(widget_hover, less_rounded)
            style.large_button.insensitive_background = Box(disabled, less_rounded)

            style.large_button_text.size = text_size
            style.large_button_text.color = widget_text
            style.large_button_text.selected_color = widget_selected
            style.large_button_text.insensitive_color = disabled_text

            style.large_button_text.xalign = 0
            style.large_button_text.yalign = 0

        setattr(theme, name + "_large_buttons", large_buttons)

        def labels(
            text_size,
            label):

            theme.clear_labels()

            style.label_text.size = text_size
            style.label_text.color = label

        setattr(theme, name + "_labels", labels)

        def prompts(
            text_size,
            label):

            theme.clear_prompts()

            style.prompt_text.size = text_size
            style.prompt_text.color = label

            style.prompt.xalign = 0.5
            style.prompt_text.text_align = 0.5
            style.prompt_text.layout = "subtitle"

        setattr(theme, name + "_prompts", prompts)


        def bars(
            widget,
            widget_hover):

            theme.clear_bars()

            def img(name, color, x, y):
                rv = theme.OneOrTwoColor(file_prefix + name + ".png", color)
                if x is not None:
                    rv = Frame(rv, x, y, tile=True)
                return rv

            # Bars.
            style.bar.ymaximum = 24
            style.bar.left_gutter = 6
            style.bar.right_gutter = 6
            style.bar.thumb_offset = 6

            style.bar.left_bar = img("slider_full", widget, 12, 0)
            style.bar.right_bar = img("slider_empty", widget, 12, 0)
            style.bar.thumb = img("slider_thumb", widget, None, None)
            style.bar.hover_left_bar = img("slider_full", widget_hover, 12, 0)
            style.bar.hover_right_bar = img("slider_empty", widget_hover, 12, 0)
            style.bar.hover_thumb = img("slider_thumb", widget_hover, None, None)

            style.vbar.xmaximum = 24
            style.vbar.top_gutter = 6
            style.vbar.bottom_gutter = 6
            style.vbar.thumb_offset = 6

            style.vbar.bottom_bar = img("vslider_full", widget, 0, 12)
            style.vbar.top_bar = img("vslider_empty", widget, 0, 12)
            style.vbar.thumb = img("vslider_thumb", widget, None, None)
            style.vbar.hover_bottom_bar = img("vslider_full", widget_hover, 0, 12)
            style.vbar.hover_top_bar = img("vslider_empty", widget_hover, 0, 12)
            style.vbar.hover_thumb = img("vslider_thumb", widget_hover, None, None)

            # Sliders.
            style.slider.ymaximum = 24
            style.slider.left_gutter = 6
            style.slider.right_gutter = 6
            style.slider.thumb_offset = 6

            style.slider.left_bar = img("slider_full", widget, 12, 0)
            style.slider.right_bar = img("slider_empty", widget, 12, 0)
            style.slider.thumb = img("slider_thumb", widget, None, None)
            style.slider.hover_left_bar = img("slider_full", widget_hover, 12, 0)
            style.slider.hover_right_bar = img("slider_empty", widget_hover, 12, 0)
            style.slider.hover_thumb = img("slider_thumb", widget_hover, None, None)

            style.vslider.xmaximum = 24
            style.vslider.top_gutter = 6
            style.vslider.bottom_gutter = 6
            style.vslider.thumb_offset = 6

            style.vslider.bottom_bar = img("vslider_full", widget, 0, 12)
            style.vslider.top_bar = img("vslider_empty", widget, 0, 12)
            style.vslider.thumb = img("vslider_thumb", widget, None, None)
            style.vslider.hover_bottom_bar = img("vslider_full", widget_hover, 0, 12)
            style.vslider.hover_top_bar = img("vslider_empty", widget_hover, 0, 12)
            style.vslider.hover_thumb = img("vslider_thumb", widget_hover, None, None)


            # Scrollbars.
            style.scrollbar.left_gutter = 6
            style.scrollbar.right_gutter = 6
            style.scrollbar.thumb_offset = 6
            style.scrollbar.ymaximum = 12

            style.scrollbar.left_bar = img("scrollbar", widget, 12, 0)
            style.scrollbar.right_bar = img("scrollbar", widget, 12, 0)
            style.scrollbar.thumb = img("scrollbar_thumb", widget, None, None)
            style.scrollbar.hover_left_bar = img("scrollbar", widget_hover, 12, 0)
            style.scrollbar.hover_right_bar = img("scrollbar", widget_hover, 12, 0)
            style.scrollbar.hover_thumb = img("scrollbar_thumb", widget_hover, None, None)

            style.vscrollbar.top_gutter = 6
            style.vscrollbar.bottom_gutter = 6
            style.vscrollbar.thumb_offset = 6
            style.vscrollbar.xmaximum = 12

            style.vscrollbar.left_bar = img("vscrollbar", widget, 0, 12)
            style.vscrollbar.right_bar = img("vscrollbar", widget, 0, 12)
            style.vscrollbar.thumb = img("vscrollbar_thumb", widget, None, None)
            style.vscrollbar.hover_left_bar = img("vscrollbar", widget_hover, 0, 12)
            style.vscrollbar.hover_right_bar = img("vscrollbar", widget_hover, 0, 12)
            style.vscrollbar.hover_thumb = img("vscrollbar_thumb", widget_hover, None, None)

        setattr(theme, name + "_bars", bars)

        def main(
            widget = (0, 60, 120, 255),
            widget_hover = (0, 80, 160, 255),
            widget_text = (200, 225, 255, 255),
            widget_selected = (255, 255, 200, 255),
            disabled = (64, 64, 64, 255),
            disabled_text = (200, 200, 200, 255),
            label = (255, 255, 255, 255),
            frame = (100, 150, 200, 255),

            text_size=None,
            small_text_size=None,
            less_rounded = False,

            # Compat for the old roundrect theme.
            window = None,
            button_menu = None,
            rounded_window = True,
            outline_bars = False,
            mm_root = None,
            gm_root = None):

            if button_menu is None:
                if (config.script_version is not None) and (config.script_version < (6, 9, 0)):
                    button_menu = True
                else:
                    button_menu = False

            layout.defaults()

            if config.screen_width <= 640:
                text_size = text_size or 18
                small_text_size = small_text_size or 12
                less_rounded = True

            else:
                text_size = text_size or 22
                small_text_size = small_text_size or 16
                radius = 12

            frames(
                less_rounded,
                frame)

            buttons(
                text_size,
                less_rounded,
                widget,
                widget_hover,
                widget_text,
                widget_selected,
                disabled,
                disabled_text)

            large_buttons(
                small_text_size,
                less_rounded,
                widget,
                widget_hover,
                widget_text,
                widget_selected,
                disabled,
                disabled_text)

            labels(
                text_size,
                label)

            prompts(
                text_size,
                label)

            bars(
                widget,
                widget_hover)

            if mm_root is not None:
                style.mm_root.background = mm_root

            if gm_root is not None:
                style.gm_root.background = gm_root

            if window is not None:

                if rounded_window:
                    style.window.background = RoundRect(window, less_rounded)
                    style.window.xpadding = 6
                    style.window.xmargin = 6
                    style.window.ypadding = 6
                    style.window.ymargin = 6
                else:
                    style.window.background = Solid(window)
                    style.window.xpadding = 6
                    style.window.xmargin = 0
                    style.window.ypadding = 6
                    style.window.ymargin = 0


            if button_menu:
                layout.button_menu()

        setattr(theme, name, main)

    roundrect_based_theme("unteralter", "images/theme/uab")   

# This file is in the public domain. Feel free to modify it as a basis
# for your own screens.
##############################################################################
# Say
#
# Screen that's used to display adv-mode dialogue.
# http://www.renpy.org/doc/html/screen_special.html#say
screen sayempty(who, what, side_image=None, two_window=False, ctc = None):
    if not two_window:
        window:
            background None
            has vbox:
                style "say_vbox" xfill True
            if who:
                text who id "who"
            text what id "what" size 25 font "waldlolimon.ttf" outlines [(0,"#0008",3,3)] yoffset 2 xoffset 2
    else:
        window:
            background None
            has vbox:
                style "say_vbox" xfill True
            if who:
                text who id "who"
            text what id "what"
    if _game_menu_screen != None:
        use quick_menu            
screen saysmall(who, what, side_image=None, two_window=False, ctc = None):
    default side_image = None
    default two_window = True
    if not two_window:
        # The one window variant.
        window:
            background Frame("images/spec/dialogblase.png", 30,30,30,30)
            xmaximum 350 xminimum 60 yminimum 60
            left_margin 20 right_margin 20 top_margin 20 bottom_margin 20
            left_padding 20 right_padding 20 top_padding 20 bottom_padding 20
            id "window"
            has vbox:
                style "say_vbox" xfill True
            if who:
                text who id "who" size 20 text_align 0.5 xalign 0.5 yalign 0.5 xanchor 0.5 yanchor 0.5
            text what id "what" color "#fff" size 20 text_align 0.5 xalign 0.5 yalign 0.5 xanchor 0.5 yanchor 0.5            
    else:
        # The two window variant.
        vbox:
            style "say_two_window_vbox"
            if who:
                window:
                    style "say_who_window" yoffset 24 xoffset 21
                    text who:
                        id "who" outlines [(1,"#0008",1,1)] xoffset -13 yoffset 3 #size 27 line_spacing 2
            window:
                id "window"
                has vbox:
                    style "say_vbox"
                text what id "what" outlines [(1,"#0005",1,1)] #line_spacing 0 line_leading -4 yoffset 0 size 29
screen say(who, what, side_image=None, two_window=True):
    # Defaults for side_image and two_window
    default side_image = None
    default two_window = True
    # Decide if we want to use the one-window or two-window varaint.
    add "images/dialoguebox.png"
    if not two_window:
        # The one window variant.
        window:
            id "window"
            has vbox:
                style "say_vbox" xfill True
            if who:
                text who id "who"
            text what id "what"
    else:
        # The two window variant.
        vbox:
            style "say_two_window_vbox"
            if who:
                window:
                    style "say_who_window" yoffset 24 xoffset 21
                    text who:
                        id "who" outlines [(1,"#0008",1,1)] xoffset -13 yoffset 3 #size 27 line_spacing 2
            window:
                id "window"
                has vbox:
                    style "say_vbox"
                text what id "what" outlines [(1,"#0005",1,1)] #line_spacing 0 line_leading -4 yoffset 0 size 29

    # If there's a side image, display it above the text.
    if side_image:
        add side_image
    else:
        add SideImage() xalign 0.0 yalign 1.0

    # Use the quick menu.
    if _game_menu_screen != None:
        use quick_menu
##############################################################################
# Choice
#
# Screen that's used to display in-game menus.
# http://www.renpy.org/doc/html/screen_special.html#choice

screen choice(items):

    window:
        at menufade
        style "menu_window"
        xalign 0.5
        yalign 0.5
        vbox:
            style "menu"
            spacing 2
            for caption, action, chosen in items:
                if action:
                    button:
                        action action
                        style "menu_choice_button"
                        text caption style "menu_choice"
                else:
                    text caption style "menu_caption"
init -2:
    $ config.narrator_menu = True
    style menu_window is default
    style menu_choice is button_text:
        clear
    style menu_choice_button is button:
        xminimum int(config.screen_width * 0.75)
        xmaximum int(config.screen_width * 0.75)

##############################################################################
# Input
#
# Screen that's used to display renpy.input()
# http://www.renpy.org/doc/html/screen_special.html#input

screen input(prompt):

    window style "input_window":
        has vbox
        text prompt style "input_prompt"
        input id "input" style "input_text"
    use quick_menu
    
##############################################################################
# Nvl
#
# Screen used for nvl-mode dialogue and menus.
# http://www.renpy.org/doc/html/screen_special.html#nvl

screen nvl(dialogue, items=None):

    window:
        style "nvl_window"

        has vbox:
            style "nvl_vbox"

        # Display dialogue.
        for who, what, who_id, what_id, window_id in dialogue:
            window:
                id window_id

                has hbox:
                    spacing 10

                if who is not None:
                    text who id who_id

                text what id what_id

        # Display a menu, if given.
        if items:

            vbox:
                id "menu"

                for caption, action, chosen in items:

                    if action:

                        button:
                            style "nvl_menu_choice_button"
                            action action

                            text caption style "nvl_menu_choice"

                    else:

                        text caption style "nvl_dialogue"

    add SideImage() xalign 0.0 yalign 1.0

    use quick_menu
        
##############################################################################
# Main Menu
#
# Screen that's used to display the main menu, when Ren'Py first starts
# http://www.renpy.org/doc/html/screen_special.html#main-menu

init:
    image langbutton = ConditionSwitch(
        "_preferences.language == None", "images/lang_de.png",
        "_preferences.language == 'english'", "images/lang_en.png")
    $ achi = "gone"
    transform menuani:
        xalign .5 yalign .5 xanchor .5 yanchor .5 zoom 0.99 subpixel True
        parallel:
            block:
                ease 3 rotate 0.5
                ease 4 rotate -0.5
                ease 3 rotate 0
            repeat    
        parallel:
            block:
                ease 2 zoom 1.00
                ease 3 zoom 1.01
                ease 4 zoom 0.99
            repeat    
           
       
screen main_menu():
    # This ensures that any other menu screen is replaced.
    tag menu
    # The background of the main menu.
    add "mainmenu_bg"
    window:
        style "mm_root"
    imagemap:
        at menu_idle1
        ground "images/mainmenu_ground.png"
        insensitive "images/mainmenu_insen.png"        
        hover "images/mainmenu_hover.png"
        hotspot (386,271,187,53) action [Play("sound", "sound/button_click.ogg"), Start()] hovered Play("sound2", "sound/button_hov.ogg")         
        hotspot (427,325,105,41) action If ((persistent.einmalgespeichert == True), true = [ShowMenu("load"), Play("sound", "sound/button_click.ogg")], false = None ) hovered Play("sound2", "sound/button_hov.ogg") #persistent.einmalgespeichert != None or       
        hotspot (408,367,142,43) action [ShowMenu("preferences"), Play("sound", "sound/button_click.ogg")] hovered Play("sound2", "sound/button_hov.ogg")
        hotspot (442,411,78,39) action [ShowMenu("hilfe"), Play("sound", "sound/button_click.ogg")] hovered Play("sound2", "sound/button_hov.ogg")
        hotspot (399,451,160,44) action Jump("mainmenu_bye") hovered Play("sound2", "sound/button_hov.ogg")
        
    if persistent.sexy and persistent.feen: #or persistent.steffi == True or persistent.doerflerin1 == True or persistent.doerflerin2 == True or persistent.ursula == True or persistent.lauralau == True]:
        window:
            xanchor 0.5 yanchor 0.5 xalign 0.5 yalign 0.5 xpadding 0 ypadding 0
            at untenrein
            imagemap:
                at menu_extraidle
                ground "images/asser_ground.png"
                hover "images/asser_hover.png"
                hotspot (774,467,116,70) action [Play("sound", "sound/button_click.ogg"), ShowMenu("seksmenu")] hovered Play("sound2", "sound/button_hov.ogg")
    if persistent.achi_aufb == True or persistent.achi_durc == True:
        window:
            xanchor 0.5 yanchor 0.5 xalign 0.5 yalign 0.5 xpadding 0 ypadding 0
            at untenrein
            imagemap:
                at menu_extraidle
                ground "images/achibtn_ground.png"
                hover "images/achibtn_hover.png"
                hotspot (68,466,118,64) action [Play("sound", "sound/button_click.ogg"), ShowMenu("achievements")] hovered Play("sound2", "sound/button_hov.ogg")  
    window: # bildergalerie-button
        at menu_idle0
        xanchor 0.5 yanchor 0.5 xalign 0.5 yalign 0.5 xpadding 0 ypadding 0    
        add "images/mainmenu_titel.png" 
        text "v2.1" xalign 0.99 yalign 0.06 size 11 color "#000"  # version number
    if persistent.menubgfrei != 1:
        window: # hintergrundwechselbutton
            at rechtsrein
            xanchor 1 yanchor 1 xpos 0.93 ypos 0.12 xpadding 0 ypadding 0 xoffset 1
            if persistent.menubg == 1 and persistent.menubgfrei >= 2:
                imagebutton idle "images/bgbtn1.png" hover "images/bgbtn1.png" action [Play("sound", "sound/fotoklick.ogg"), SetField(persistent, 'menubg', 2)]
            elif persistent.menubg == 2 and persistent.menubgfrei == 2:
                imagebutton idle "images/bgbtn2.png" hover "images/bgbtn2.png" action [Play("sound", "sound/fotoklick.ogg"), SetField(persistent, 'menubg', 1)]
            elif persistent.menubg == 2 and persistent.menubgfrei >= 3:
                imagebutton idle "images/bgbtn2.png" hover "images/bgbtn2.png" action [Play("sound", "sound/fotoklick.ogg"), SetField(persistent, 'menubg', 3)]
            elif persistent.menubg == 3:
                imagebutton idle "images/bgbtn3.png" hover "images/bgbtn3.png" action [Play("sound", "sound/fotoklick.ogg"), SetField(persistent, 'menubg', 1)]
    window: # sprachenbutton
        xanchor 0.5 yanchor 0.5 xalign 0.5 yalign 0.5 xpadding 0 ypadding 0        
        at rechtsrein
        imagemap:
            at menu_extraidle_vertikal
            ground "images/spec/leer.png"
            idle "langbutton"
            hover "langbutton"
            hotspot (906,178,54,71) action If ((_preferences.language == None), true = [Play("sound", "sound/button_click.ogg"), Language("english")], false = [Play("sound", "sound/button_click.ogg"), Language(None)])
    window: # bildergalerie-button
        xpadding 0 ypadding 0 xanchor 0.5 yanchor 0.5 xalign 0.5 yalign 0.5
        at linksrein
        imagemap:
            at menu_extraidle_vertikal
            ground "images/galbtn_ground.png"
            hover "images/galbtn_hover.png"
            hotspot (9,183,51,85) action [Play("sound", "sound/button_click.ogg"), ShowMenu("bildergalerie")] hovered Play("sound2", "sound/button_hov.ogg")

label mainmenu_bye:
    stop music fadeout 0.4
    call screen postsplash
screen postsplash():
    add "mainmenu_bg"
    window:
        at einfaden
        ypadding 0 xpadding 0
        frame background "#000":
            xfill True yfill True
            timer 0.5 action Quit(confirm=False)

##############################################################################
# 
# Achievements
#
screen achievements():
    key "K_ESCAPE" action [Play("sound", "sound/button_click2.ogg"), Return()]
    key "mouseup_3" action [Play("sound", "sound/button_click2.ogg"), Return()]    
    tag menu
    add "images/menubg_achi.jpg"
    imagemap:
        at untenrein
        ground "images/achi_ground.png"
        hover "images/achi_hover.png"
        hotspot (741,443,101,38) action [Play("sound", "sound/button_click2.ogg"), Return()]
    vbox:
        at untenrein
        yalign .58 xalign .5
        viewport:
            scrollbars "vertical"
            mousewheel True
            draggable True
            xmaximum 600
            ymaximum 300
            frame:
                yalign .5 xalign .5 xmaximum 600
                grid 2 18:
                    xfill True spacing 10
                    hbox:
                        if persistent.achi_durc == True:
                            add "achi_durc"
                        if persistent.achi_durc != True:
                            add "achi_durc_sw"
                        null width 10
                        vbox:
                            text _("Durchstarter") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_durc == True:
                                text _("10 verschiedene Intro-Zitate gesehen") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_durc != True:
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:
                        if persistent.achi_aufb == True:
                            add "achi_aufb"
                        if persistent.achi_aufb != True:
                            add "achi_aufb_sw"                        
                        null width 10
                        vbox:
                            text _("Aufbruch") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_aufb == True:
                                text _("Den Keller verlassen") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_aufb != True:
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:
                        if persistent.achi_fami == True:
                            add "achi_fami"
                        if persistent.achi_fami != True:
                            add "achi_fami_sw"                        
                        null width 10
                        vbox:
                            text _("Familienglück") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_fami == True:
                                text _("Kleine Schwester rapiert") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_fami != True:                           
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14                                
                    hbox:
                        if persistent.achi_schm == True:
                            add "achi_schm"
                        if persistent.achi_schm != True:
                            add "achi_schm_sw"                        
                        null width 10
                        vbox:
                            text _("Schmerzfrei") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_schm == True:
                                text _("Arbeitsbereitschaft bewiesen") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_schm != True:                           
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:
                        if persistent.achi_karm == True:
                            add "achi_karm"
                        if persistent.achi_karm != True:
                            add "achi_karm_sw"                        
                        null width 10
                        vbox:
                            text _("Bernd von Karma") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_karm == True:
                                text _("Verhör gemeistert") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_karm != True:           
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:
                        if persistent.achi_taus == True:
                            add "achi_taus"
                        if persistent.achi_taus != True:
                            add "achi_taus_sw"
                        null width 10
                        vbox:
                            text _("Tausendundein Stoß ") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_taus == True:
                                text _("Aisha gesegnet") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_taus != True:                           
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14                                         
                    hbox:                
                        if persistent.achi_erna == True:
                            add "achi_erna"
                        if persistent.achi_erna != True:
                            add "achi_erna_sw"                        
                        null width 10
                        vbox:
                            text _("Ernährungsexperte") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_erna == True:
                                text _("Laugenstange verzehrt") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_erna != True:         
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_heul == True:
                            add "achi_heul"
                        if persistent.achi_heul != True:
                            add "achi_heul_sw"                        
                        null width 10
                        vbox:
                            text _("Heulboje") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_heul == True:
                                text _("Zweimal im Kampf geweint") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_heul != True:       
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_blag == True:
                            add "achi_blag"
                        if persistent.achi_blag != True:
                            add "achi_blag_sw"                        
                        null width 10
                        vbox:
                            text _("Blagen schlagen") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_blag == True:
                                text _("Waldfeen bezwungen") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_blag != True:     
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_maer == True:
                            add "achi_maer"
                        if persistent.achi_maer != True:
                            add "achi_maer_sw"                        
                        null width 10
                        vbox:
                            text _("Märchenonkel") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_maer == True:
                                text _("Waldfeen geweitet") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_maer != True:  
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_mora == True:
                            add "achi_mora"
                        if persistent.achi_mora != True:
                            add "achi_mora_sw"                        
                        null width 10
                        vbox:
                            text _("Moralapostel") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_mora == True:
                                text _("CiD beigetreten") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_mora != True:          
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_gran == True:
                            add "achi_gran"
                        if persistent.achi_gran != True:
                            add "achi_gran_sw"                        
                        null width 10
                        vbox:
                            text _("Grannylover") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_gran == True:
                                text _("Tittenjob von Steffi erhalten") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_gran != True:           
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_kell == True:
                            add "achi_kell"
                        if persistent.achi_kell != True:
                            add "achi_kell_sw"                        
                        null width 10
                        vbox:
                            text _("Kellerkind") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_kell == True:
                                text _("Ritzel perfekt besiegt") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_kell != True:            
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_inqu == True:
                            add "achi_inqu"
                        if persistent.achi_inqu != True:
                            add "achi_inqu_sw"                        
                        null width 10
                        vbox:
                            text _("Inquisitor") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_inqu == True:
                                text _("Hexenzwillinge geweitet") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_inqu != True:              
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:
                        if persistent.achi_wald == True:
                            add "achi_wald"
                        if persistent.achi_wald != True:
                            add "achi_wald_sw"                        
                        null width 10
                        vbox:
                            text _("Waldhexenlolizeit") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_wald == True:
                                text _("Mit Junghexen heimgeflogen") yoffset -1 color "#ff2d7c" size 14            
                            if persistent.achi_wald != True:
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_porz == True:
                            add "achi_porz"
                        if persistent.achi_porz != True:
                            add "achi_porz_sw"                        
                        null width 10
                        vbox:
                            text _("Porzellankiste") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_porz == True:
                                text _("Freizeit im KZ verbracht") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_porz != True:          
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_erdb == True:
                            add "achi_erdb"
                        if persistent.achi_erdb != True:
                            add "achi_erdb_sw"                        
                        null width 10
                        vbox:
                            text _("Erdbeerernte") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_erdb == True:
                                text _("Maja Grünzeug geweitet") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_erdb != True:          
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_helm == True:
                            add "achi_helm"
                        if persistent.achi_helm != True:
                            add "achi_helm_sw"                        
                        null width 10
                        vbox:
                            text _("Helmut Newton") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_helm == True:
                                text _("Lichtbilder von Laura erstellt") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_helm != True:         
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_slav == True:
                            add "achi_slav"
                        if persistent.achi_slav != True:
                            add "achi_slav_sw"                        
                        null width 10
                        vbox:
                            text _("Slavenfreund") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_slav == True:
                                text _("Laura Belanova geweitet") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_slav != True:      
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_tele == True:
                            add "achi_tele"
                        if persistent.achi_tele != True:
                            add "achi_tele_sw"                        
                        null width 10
                        vbox:
                            text _("Telekomb") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_tele == True:
                                text _("Am Freitag telefoniert") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_tele != True:         
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_meis == True:
                            add "achi_meis"
                        if persistent.achi_meis != True:
                            add "achi_meis_sw"                        
                        null width 10
                        vbox:
                            text _("Meisterkonditor") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_meis == True:
                                text _("Nele Büttner und Stephanie geweitet") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_meis != True:              
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_stoe == True:
                            add "achi_stoe"
                        if persistent.achi_stoe != True:
                            add "achi_stoe_sw"                        
                        null width 10
                        vbox:
                            text _("Störfaktor") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_stoe == True:
                                text _("Alice maximal bequatscht") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_stoe != True:        
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_inne == True:
                            add "achi_inne"
                        if persistent.achi_inne != True:
                            add "achi_inne_sw"                        
                        null width 10
                        vbox:
                            text _("Innen kaputt") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_inne == True:
                                text _("Laura mit Besenstiel rapiert") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_inne != True:   
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_schl == True:
                            add "achi_schl"
                        if persistent.achi_schl != True:
                            add "achi_schl_sw"                        
                        null width 10
                        vbox:
                            text _("Schlachtbank") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_schl == True:
                                text _("Trollbo vernichtet") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_schl != True:              
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_cybe == True:
                            add "achi_cybe"
                        if persistent.achi_cybe != True:
                            add "achi_cybe_sw"                        
                        null width 10
                        vbox:
                            text _("Cybercrime") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_cybe == True:
                                text _("Kim Hartmann geweitet") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_cybe != True:        
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_raps == True:
                            add "achi_raps"
                        if persistent.achi_raps != True:
                            add "achi_raps_sw"                        
                        null width 10
                        vbox:
                            text _("Rapstar") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_raps == True:
                                text _("Mauss weggeburnt") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_raps != True:       
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_dich == True:
                            add "achi_dich"
                        if persistent.achi_dich != True:
                            add "achi_dich_sw"                        
                        null width 10
                        vbox:
                            text _("Dichter und Weiter") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_dich == True:
                                text _("Annemarie Reiter geweitet") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_dich != True:  
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_nein == True:
                            add "achi_nein"
                        if persistent.achi_nein != True:
                            add "achi_nein_sw"                        
                        null width 10
                        vbox:
                            text _("Nein, Papi, nein!") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_nein == True:
                                text _("Henrike Fuchs geweitet") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_nein != True:    
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:
                        if persistent.achi_lyri == True:
                            add "achi_lyri"
                        if persistent.achi_lyri != True:
                            add "achi_lyri_sw"                        
                        null width 10
                        vbox:
                            text _("Lolilyriklauscher") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_lyri == True:
                                text _("Annemaries Gesamtwerk gehört") yoffset -1 color "#ff2d7c" size 14            
                            if persistent.achi_lyri != True:
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14                                
                    hbox:                
                        if persistent.achi_geho == True:
                            add "achi_geho"
                        if persistent.achi_geho != True:
                            add "achi_geho_sw"                        
                        null width 10
                        vbox:
                            text _("Die Gehörnte") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_geho == True:
                                text _("Emily Geiger geweitet") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_geho != True:      
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_woll == True:
                            add "achi_woll"
                        if persistent.achi_woll != True:
                            add "achi_woll_sw"                        
                        null width 10
                        vbox:
                            text _("Wolle Rose kaufe?") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_woll == True:
                                text _("Klein Ursula / Röschen prostituiert") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_woll != True:  
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox: 
                        if persistent.achi_bern == True:
                            add "achi_bern"
                        if persistent.achi_bern != True:
                            add "achi_bern_sw"                        
                        null width 10
                        vbox:
                            text _("Berndstyle 4 Ever") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_bern == True:
                                text _("Versager-Ende erlebt") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_bern != True:
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14                                
                    hbox:                
                        if persistent.achi_fehl == True:
                            add "achi_fehl"
                        if persistent.achi_fehl != True:
                            add "achi_fehl_sw"                        
                        null width 10
                        vbox:
                            text _("99% Fehl") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_fehl == True:
                                text _("10x Game Over") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_fehl != True: 
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_geni == True:
                            add "achi_geni"
                        if persistent.achi_geni != True:
                            add "achi_geni_sw"                        
                        null width 10
                        vbox:
                            text _("Genießer") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_geni == True:
                                text _("Abspann komplett angesehen") yoffset -1 color "#ff2d7c" size 14
                            if persistent.achi_geni != True:       
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_asse == True:
                            add "achi_asse"
                        if persistent.achi_asse != True:
                            add "achi_asse_sw"                        
                        null width 10
                        vbox:
                            text _("Asservatenspezialist") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_asse == True:
                                text _("Asservatenkammer lückenlos gefüllt") yoffset -1 color "#ff2d7c" size 14            
                            if persistent.achi_asse != True:
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                    hbox:                
                        if persistent.achi_einh == True:
                            add "achi_einh"
                        if persistent.achi_einh != True:
                            add "achi_einh_sw"                        
                        null width 10
                        vbox:
                            text _("Einhandzocker") yoffset -1 color "#000" size 19 bold True
                            if persistent.achi_einh == True:
                                text _("Pizza-Hauptpfad gemeistert") yoffset -1 color "#ff2d7c" size 14            
                            if persistent.achi_einh != True:
                                text ". . . . . . . . . . . ." yoffset -1 color "#ff2d7c" size 14
                                
                                
    add "images/achi_fore.png" at untenrein
    add "images/mainmenu_titel.png" at menuani_titelraus
#    
init -2:
    # Make all the main menu buttons be the same size.
    style mm_button:
        size_group "mm"
##############################################################################
# Navigation
#
# Screen that's included in other screens to display the game menu
# navigation and background.
# http://www.renpy.org/doc/html/screen_special.html#navigation
screen navigation():
    # The background of the game menu.
    #window:
    #    style "gm_root"

    # The various buttons.
    frame:
        style_group "gm_nav"
        xalign .877
        yalign .94
        
        has vbox

        textbutton _("Zurück") action Return()
        #textbutton _("Optionen") action ShowMenu("preferences")
        #textbutton _("Speichern") action ShowMenu("save")
        #textbutton _("Laden") action ShowMenu("load")
        textbutton _("Hauptmenü") action MainMenu()
        textbutton _("Hilfe") action ShowMenu("hilfe")               #Help()
        #textbutton _("Verlassen") action Quit()

init -2:
    # Make all game menu navigation buttons the same size.
    style gm_nav_button:
        size_group "gm_nav"
    
screen hilfe():
    key "K_ESCAPE" action [ShowMenu('main_menu'), Play("sound", "sound/button_click2.ogg")]
    key "mouseup_3" action [ShowMenu('main_menu'), Play("sound", "sound/button_click2.ogg")]
    tag menu
    #window:
    #    style "gm_root"
    add "images/menubg_pref.jpg"
    frame:
        at untenrein
        xmaximum 600 xminimum 430 ymaximum 500 xalign .5 yalign .5
        vbox:
            xalign 0.5 yalign 0.5 xoffset -5 yoffset 15
            side "c b r":
                xmaximum 410 ymaximum 254 xalign .5 yalign .5
                viewport id "vp":                   
                    mousewheel True
                    draggable True
                    frame background "#fff":
                        style_group "hilfe"                        
                        top_padding 20 bottom_padding 20 left_padding 20 right_padding 20
                        vbox:
                            xfill True
                            text _("Hilfreiche Notizen an mich selbst.{p}Was mach ich wie und warum?") color "#000" size 20
                            null height 15
                            text _("{u}Tastenbelegung{/u}") color "#000" size 18
                            null height 7
                            text _("Ingame-Optionsmenü = Escape / Maus2{p}Vollbild / Fenster = Alt+Enter / f / F11{p}Verlassen = Alt+F4{p}Textbox ein / aus = h{p}Bildschirmschuss = s{p}Vorspulen = Strg") color "#000" size 18
                            null height 15
                            text _("{u}Allgemeines{/u}") color "#000" size 18
                            null height 7
                            text _("Mein Wesen:{p}Bin ich ein fanatischer Gutmensch? Oder eine perverse Drecksau? Oder etwas dazwischen? Ich frage mich, was passiert wäre, wenn ich hier und da anders reagiert hätte. Wenn man das doch nur herausfinden könnte... Sicher wär es die Mühe wert.") color "#000" size 18
                            null height 15
                            text _("Gameovers:{p}Sie lauern überall. Ich sollte also immer ausreichend neue Speicherstände anlegen. Aus Versehen in eine ausweglose Situation hineinzuspeichern, ist nicht möglich. Denn da wird die Speicherfunktion automatisch deaktiviert.") color "#000" size 18
                            null height 15                            
                            text _("Allgemein:{p}Je weniger ich die Vorspultaste benutze, desto größer sind meine Aussichten auf Erfolg...") color "#000" size 18
                            null height 15
                null height 20
                vbar value YScrollValue("vp")
            textbutton _("Zurück") action [Play("sound", "sound/button_click2.ogg"), Return()]  xalign 0.99 yoffset -10
    add "images/hilfemenu_fore.png" at untenrein
    add "images/mainmenu_titel.png" at menuani_titelraus    
init -2 python:
    style.hilfe_bar.thumb_offset = 0
    
##############################################################################
# Save, Load
#
# Screens that allow the user to save and load the game.
# http://www.renpy.org/doc/html/screen_special.html#save
# http://www.renpy.org/doc/html/screen_special.html#load
# Since saving and loading are so similar, we combine them into
# a single screen, file_picker. We then use the file_picker screen
# from simple load and save screens.

screen file_picker():
    add "images/save_bg.png"
    vbox:
        yalign .5 xalign .5 yoffset 16
        viewport:
            scrollbars "vertical"
            mousewheel True
            draggable True
            xmaximum 680
            ymaximum 330
            frame:
                style "file_picker_frame"
                yalign .5 xalign .5
                $ columns = 2
                $ rows = 50
                # Display a grid of file slots.
                grid columns rows:
                    transpose False
                    xfill True
                    style_group "file_picker"
                    # Display ten file slots, numbered 1 - 10.
                    for i in range(1, columns * rows + 1):
                        frame:
                            ymaximum 65 yminimum 65 xmaximum 345 xpadding 0 ypadding 0 xalign .5 yalign .5
                            button:
                                xalign .5 yalign .5
                                action [FileAction(i), SetField(persistent, 'einmalgespeichert', True)]
                                xminimum 330 xmaximum 330
                                yminimum 58 ymaximum 58
                                left_padding 10 right_padding 10 top_padding 10 bottom_padding 10
                                has hbox
                                # Add the screenshot.
                                add FileScreenshot(i, empty="images/spec/screenshot_leer.png")
                                null width 4
                                # Format the description, and add it as text.
                                if _preferences.language == "english":
                                    $ emptysavefile = "Empty"
                                else:
                                    $ emptysavefile = "Leer"
                                $ file_name = FileSlotName(i, columns * rows)
                                $ file_time = FileTime(i, empty=_("Empty Slot."))
                                $ save_name = FileSaveName(i)            
                                text "[file_name]. [file_time!t]\n[save_name!t]"                      
                            imagebutton yalign 0.24 xalign 0.97 idle _("images/spec/state_x.png") hover _("images/spec/state_x2.png") insensitive _("images/spec/state_x_ins.png") action FileDelete(i) 
                            #key "save_delete" action FileDelete(i)
        null height 2     
        hbox:
            xalign 0.5 xoffset -6 xfill True xmaximum 664
            hbox:
                xpos 0
                textbutton _("Speicherstände"):#str(1):
                    action FilePage(1) text_size 20
                textbutton _("Schnellspeicherstände"):
                    action FilePage("quick") text_size 20
                #textbutton _("Autospeicherstände"):
                #    action FilePage("auto") text_size 20
            hbox:
                xpos 1.0 xanchor 1.0
                if _game_menu_screen == 'preferences_ingame':
                    textbutton "Zurück" xalign .5 yalign .5 action ShowMenu('preferences_ingame') text_size 20
                elif _game_menu_screen == 'preferences_nosave' and speicherpunkt == False:
                    textbutton "Zurück" xalign .5 yalign .5 action ShowMenu('preferences_nosave') text_size 20
                else:    
                    textbutton "Zurück" xalign .5 yalign .5 action [Play("sound", "sound/button_click2.ogg"), Return()] text_size 20

#
init:
    $ speicherpunkt = False                
screen save():
    if _game_menu_screen == 'preferences_ingame':
        key "K_ESCAPE" action ShowMenu('preferences_ingame')
        key "mouseup_3" action ShowMenu('preferences_ingame')
    elif _game_menu_screen == 'preferences_nosave':
        key "K_ESCAPE" action Return()
        key "mouseup_3" action Return()
    window:
        style "zm_root"
    # This ensures that any other menu screen is replaced.
    tag menu
    #use navigation
    use file_picker
    add "images/filepicker_fore.png"
    add "images/save_title.png"
screen load(): 
    if _game_menu_screen == 'preferences_ingame':
        key "K_ESCAPE" action ShowMenu('preferences_ingame') 
        key "mouseup_3" action ShowMenu('preferences_ingame')
    elif _game_menu_screen == 'preferences_nosave':
        key "K_ESCAPE" action ShowMenu('preferences_nosave') 
        key "mouseup_3" action ShowMenu('preferences_nosave')        
    else:
        key "K_ESCAPE" action [Play("sound", "sound/button_click2.ogg"), Return()]
        key "mouseup_3" action [Play("sound", "sound/button_click2.ogg"), Return()]
    if _game_menu_screen == 'preferences_ingame' or _game_menu_screen == 'preferences_nosave':
        window:
            style "zm_root"   
    else:
        add "images/menubg_achi.jpg"
        #window:
        #    style "gm_root"
    tag menu
    use file_picker
    add "images/filepicker_fore.png"    
    add "images/load_title.png"    
    if _game_menu_screen != 'preferences_ingame' and _game_menu_screen != 'preferences_nosave':
        add "images/mainmenu_titel.png" at menuani_titelraus
init -2:
    style file_picker_frame is menu_frame
    style file_picker_nav_button is small_button
    style file_picker_nav_button_text is small_button_text
    style file_picker_button is large_button
    style file_picker_text is large_button_text
init -2 python:    
    config.thumbnail_width = 66
    config.thumbnail_height = 37    
    style.file_picker_text.color = "#fc2676" 
    style.file_picker_text.hover_color = "#000"
    style.file_picker_nav_button_text.color = "#fff" 
    style.file_picker_nav_button_text.hover_color = "#fff"
    #style.file_picker_text.outlines = [(1,"#0005",0,0.5)]
    #style.file_picker_nav_button_text.outlines = [(1,"#0005",0,0.5)]

#############################################################################
# Seks-Menü
#
init:
    $ galeriebild = ""
    $ vomseksmenu = False
screen seksmenu():
    key "K_ESCAPE" action [Play("sound", "sound/button_click2.ogg"), Return()]
    key "mouseup_3" action [Play("sound", "sound/button_click2.ogg"), Return()]
    tag menu
    add "images/menubg_seks.jpg"
    imagemap:
        at untenrein
        ground "images/seksmenu_ground.png"
        idle "images/seksmenu_idle.png"
        insensitive "images/seksmenu_insensitive.png"
        hover "images/seksmenu_hover.png"
        selected_idle "images/seksmenu_hover.png"
        selected_hover "images/seksmenu_hover.png"
        # standards
        hotspot (290, 155, 124, 80) action If (( persistent.feen == True), true = [ SetVariable("vomseksmenu", True), Start("Seks_Feen") ], false = None)
        hotspot (290, 238, 124, 80) action If (( persistent.laura == True), true = [ SetVariable("vomseksmenu", True), Start("Seks_Laura") ], false = None)
        hotspot (290, 323, 124, 80) action If (( persistent.henrike == True), true = [ SetVariable("vomseksmenu", True), Start("Seks_Henrike") ], false = None)
        hotspot (418, 155, 124, 80) action If (( persistent.hexen == True), true = [ SetVariable("vomseksmenu", True), Start("Seks_Hexen") ], false = None)
        hotspot (418, 238, 124, 80) action If (( persistent.nele == True), true = [ SetVariable("vomseksmenu", True), Start("Seks_Nele") ], false = None)
        hotspot (418, 323, 124, 80) action If (( persistent.kim == True), true = [ SetVariable("vomseksmenu", True), Start("Seks_Kim") ], false = None)
        hotspot (547, 155, 124, 80) action If (( persistent.maja == True), true = [ SetVariable("vomseksmenu", True), Start("Seks_Maja") ], false = None)
        hotspot (547, 238, 124, 80) action If (( persistent.annemarie == True), true = [ SetVariable("vomseksmenu", True), Start("Seks_Annemarie") ], false = None)
        hotspot (547, 323, 124, 80) action If (( persistent.emily == True), true = [ SetVariable("vomseksmenu", True), Start("Seks_Emily") ], false = None)
        # specials
        hotspot (119, 155, 124, 80) action If (( persistent.lauralau == True), true = [ SetVariable("vomseksmenu", True), Start("Seks_Lauralau") ], false = None)
        hotspot (119, 238, 124, 80) action If (( persistent.aisha == True), true = [ SetVariable("vomseksmenu", True), Start("Seks_Aisha") ], false = None)
        hotspot (119, 323, 124, 80) action If (( persistent.steffi == True), true = [ SetVariable("vomseksmenu", True), Start("Seks_Steffi") ], false = None)
        hotspot (716, 155, 124, 80) action If (( persistent.doerflerin1 == True), true = [ SetVariable("vomseksmenu", True), Start("Seks_Doerflerin1") ], false = None)
        hotspot (716, 238, 124, 80) action If (( persistent.doerflerin2 == True), true = [ SetVariable("vomseksmenu", True), Start("Seks_Doerflerin2") ], false = None)
        hotspot (716, 323, 124, 80) action If (( persistent.ursula == True), true = [ SetVariable("vomseksmenu", True), Start("Seks_Ursula") ], false = None)
        # zurück
        hotspot (431,437,100,44) action [Play("sound", "sound/button_click2.ogg"), Return()]
        #
    add "images/seksmenu_fore.png" xalign 0.0 yalign 0.0 xanchor 0.0 yanchor 0.0 at untenrein
    add "images/mainmenu_titel.png" at menuani_titelraus
#    
##############################################################################
# Galerie
#
screen bildergalerie_bild():
    modal True
    key "mouseup_1" action Hide("bildergalerie_bild")
    window:
        at einfaden xpadding 0 ypadding 0
        add "blacktrans"
        if galeriebild == "go_neet":
            add "images/det/dtl-gameoverneet.jpg"
        elif galeriebild == "go_schweine":
            add "images/det/dtl-gameoverschweine.jpg"
        elif galeriebild == "go_waldleiche":
            add "images/det/dtl-gameoverwaldleiche.jpg"
        elif galeriebild == "waldnele":
            add "images/det/dtl-waldnele1.png" yoffset -150
        elif galeriebild == "zeit1":
            add "images/seksno/zeitung_feen.png"
        elif galeriebild == "gurke1":
            add "images/det/dtl-gurke1.png"
        elif galeriebild == "gurke2":
            add "images/det/dtl-gurke2.png"
        elif galeriebild == "gurke3":
            add "images/det/dtl-gurke3.png"        
        #
        elif galeriebild == "go_hirn":
            add "images/det/dtl-gameoverhirn.jpg"
        elif galeriebild == "go_grill2":
            add "images/det/dtl-grill2.jpg"
        elif galeriebild == "zeit2":
            add "images/seksno/zeitung_hexen.png"
        elif galeriebild == "zeit3":
            add "images/seksno/zeitung_maja.png"
        elif galeriebild == "go_verp":
            add "images/det/dtl-gameovergewindestange.jpg"
        elif galeriebild == "zeit4":
            add "images/seksno/zeitung_laura.png"
        elif galeriebild == "ritzel":
            add "images/det/ritzelkarte.jpg"
        elif galeriebild == "zeit5":
            add "images/seksno/zeitung_nele.png"
        elif galeriebild == "zeit6":
            add "images/seksno/zeitung_kim.png"
        elif galeriebild == "femin":
            add "images/det/dtl-feministen.jpg"
        #
        elif galeriebild == "zeit7":
            add "images/seksno/zeitung_henrike.png"
        elif galeriebild == "zeit8":
            add "images/seksno/zeitung_annemarie.png"
        elif galeriebild == "zeit9":
            add "images/seksno/zeitung_emily.png"
        elif galeriebild == "daem1":
            add "images/det/dtl-daemonen1.jpg"
        elif galeriebild == "daem2":
            add "images/det/dtl-daemonen2.jpg"
        elif galeriebild == "mittel1":
            add "images/det/mittel1.jpg"
        elif galeriebild == "mittel2":
            add "images/det/mittel2.jpg"
        elif galeriebild == "mittel3":
            add "images/det/mittel3.jpg"
        #
        elif galeriebild == "emi1":
            add "images/det/dtl-emilykunst1.jpg"
        elif galeriebild == "emi2":
            add "images/det/dtl-emilykunst2.jpg"
        elif galeriebild == "emi3":
            add "images/det/dtl-emilykunst3.jpg"
        elif galeriebild == "loli1":
            add "images/det/dtl-kinderkunst1.jpg"
        elif galeriebild == "loli2":
            add "images/det/dtl-kinderkunst2.jpg"
        elif galeriebild == "loli3":
            add "images/det/dtl-kinderkunst3.jpg"
        elif galeriebild == "loli4":
            add "images/det/dtl-kinderkunst4.jpg"
        elif galeriebild == "loli5":
            add "images/det/dtl-kinderkunst5.jpg"
        #
        elif galeriebild == "porn_henr":
            add "images/det/porn_henr.jpg" xalign 0.5
        elif galeriebild == "porn_capt":
            add "images/det/porn_capt.jpg" xalign 0.5            
        elif galeriebild == "porn_enge":
            add "images/det/porn_enge.jpg" xalign 0.5
        elif galeriebild == "porn_kimm":
            add "images/det/porn_kimm.jpg" xalign 0.5
        elif galeriebild == "porn_zapf":
            add "images/det/porn_zapf.jpg" xalign 0.5
        elif galeriebild == "porn_hure":
            add "images/det/porn_hure.jpg" xalign 0.5   
        #    
        elif galeriebild == "porn_fick2":
            add "images/det/porn_fick2.jpg" xalign 0.5
        elif galeriebild == "porn_fick":
            add "images/det/porn_fick.jpg" xalign 0.5       
        elif galeriebild == "porn_cybe":
            add "images/det/porn_cybe.jpg" xalign 0.5        
        elif galeriebild == "porn_ursu":
            add "images/det/porn_ursu.jpg" xalign 0.5      
        elif galeriebild == "kinderhass":
            add "images/det/kinderhasser-o-vision.jpg" xalign 0.5      
        elif galeriebild == "fanart":
            add "images/bg/whng-schrank.jpg" xalign 0.5      
        #
screen bildergalerie():
    key "K_ESCAPE" action [Play("sound", "sound/button_click2.ogg"), Return()]
    key "mouseup_3" action [Play("sound", "sound/button_click2.ogg"), Return()]
    tag menu
    add "images/menubg_achi.jpg"
    frame:
        at untenrein
        xalign .5 yalign .5 xmaximum 700 ymaximum 320 left_padding 15 right_padding 15 top_padding 15 bottom_padding 15 xanchor 0.5 yanchor 0.5
        vbox:
            text _("Ich weiß auch nicht, woher diese Bilder kommen...") text_align .5 xalign .5 size 17 color "#000"
            null height 10
            grid 8 6:
                spacing 5
                if persistent.gal_go_neet != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:
                    imagebutton idle "images/gal/thumbs/dtl-gameoverneet.jpg" hover "images/gal/thumbs/dtl-gameoverneet.jpg" action [ SetVariable("galeriebild", "go_neet"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_go_schweine != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:
                    imagebutton idle "images/gal/thumbs/dtl-gameoverschweine.jpg" hover "images/gal/thumbs/dtl-gameoverschweine.jpg" action [ SetVariable("galeriebild", "go_schweine"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_go_waldleiche != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:
                    imagebutton idle "images/gal/thumbs/dtl-gameoverwaldleiche.jpg" hover "images/gal/thumbs/dtl-gameoverwaldleiche.jpg" action [ SetVariable("galeriebild", "go_waldleiche"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_waldnele != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:
                    imagebutton idle "images/gal/thumbs/dtl-waldnele1.jpg" hover "images/gal/thumbs/dtl-waldnele1.jpg" action [ SetVariable("galeriebild", "waldnele"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_zeit1 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:
                    imagebutton idle "images/gal/thumbs/zeitung_feen.jpg" hover "images/gal/thumbs/zeitung_feen.jpg" action [ SetVariable("galeriebild", "zeit1"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_gurke1 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:
                    imagebutton idle "images/gal/thumbs/dtl-gurke1.jpg" hover "images/gal/thumbs/dtl-gurke1.jpg" action [ SetVariable("galeriebild", "gurke1"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_gurke2 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:
                    imagebutton idle "images/gal/thumbs/dtl-gurke2.jpg" hover "images/gal/thumbs/dtl-gurke2.jpg" action [ SetVariable("galeriebild", "gurke2"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_gurke3 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:
                    imagebutton idle "images/gal/thumbs/dtl-gurke3.jpg" hover "images/gal/thumbs/dtl-gurke3.jpg" action [ SetVariable("galeriebild", "gurke3"), Show("bildergalerie_bild", transition=Dissolve(0.2))]        
                #
                if persistent.gal_go_hirn != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:                    
                    imagebutton idle "images/gal/thumbs/dtl-gameoverhirn.jpg" hover "images/gal/thumbs/dtl-gameoverhirn.jpg" action [ SetVariable("galeriebild", "go_hirn"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_go_grill2 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:                    
                    imagebutton idle "images/gal/thumbs/dtl-grill2.jpg" hover "images/gal/thumbs/dtl-grill2.jpg" action [ SetVariable("galeriebild", "go_grill2"), Show("bildergalerie_bild", transition=Dissolve(0.2))]                   
                if persistent.gal_zeit2 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/zeitung_hexen.jpg" hover "images/gal/thumbs/zeitung_hexen.jpg" action [ SetVariable("galeriebild", "zeit2"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_zeit3 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/zeitung_maja.jpg" hover "images/gal/thumbs/zeitung_maja.jpg" action [ SetVariable("galeriebild", "zeit3"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_go_verp != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/dtl-gameovergewindestange.jpg" hover "images/gal/thumbs/dtl-gameovergewindestange.jpg" action [ SetVariable("galeriebild", "go_verp"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_zeit4 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/zeitung_laura.jpg" hover "images/gal/thumbs/zeitung_laura.jpg" action [ SetVariable("galeriebild", "zeit4"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_ritzel != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/ritzelkarte.jpg" hover "images/gal/thumbs/ritzelkarte.jpg" action [ SetVariable("galeriebild", "ritzel"), Show("bildergalerie_bild", transition=Dissolve(0.2))]                    
                if persistent.gal_zeit5 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/zeitung_nele.jpg" hover "images/gal/thumbs/zeitung_nele.jpg" action [ SetVariable("galeriebild", "zeit5"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_zeit6 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/zeitung_kim.jpg" hover "images/gal/thumbs/zeitung_kim.jpg" action [ SetVariable("galeriebild", "zeit6"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_femin != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/dtl-feministen.jpg" hover "images/gal/thumbs/dtl-feministen.jpg" action [ SetVariable("galeriebild", "femin"), Show("bildergalerie_bild", transition=Dissolve(0.2))]           
                #
                if persistent.gal_zeit7 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:                    
                   imagebutton idle "images/gal/thumbs/zeitung_henrike.jpg" hover "images/gal/thumbs/zeitung_henrike.jpg" action [ SetVariable("galeriebild", "zeit7"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_zeit8 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                   imagebutton idle "images/gal/thumbs/zeitung_annemarie.jpg" hover "images/gal/thumbs/zeitung_annemarie.jpg" action [ SetVariable("galeriebild", "zeit8"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_zeit9 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                   imagebutton idle "images/gal/thumbs/zeitung_emily.jpg" hover "images/gal/thumbs/zeitung_emily.jpg" action [ SetVariable("galeriebild", "zeit9"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_daem1 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                   imagebutton idle "images/gal/thumbs/dtl-daemonen1.jpg" hover "images/gal/thumbs/dtl-daemonen1.jpg" action [ SetVariable("galeriebild", "daem1"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_daem2 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                   imagebutton idle "images/gal/thumbs/dtl-daemonen2.jpg" hover "images/gal/thumbs/dtl-daemonen2.jpg" action [ SetVariable("galeriebild", "daem2"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_mittel1 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                   imagebutton idle "images/gal/thumbs/mittel1.jpg" hover "images/gal/thumbs/mittel1.jpg" action [ SetVariable("galeriebild", "mittel1"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_mittel2 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                   imagebutton idle "images/gal/thumbs/mittel2.jpg" hover "images/gal/thumbs/mittel2.jpg" action [ SetVariable("galeriebild", "mittel2"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_mittel3 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                   imagebutton idle "images/gal/thumbs/mittel3.jpg" hover "images/gal/thumbs/mittel3.jpg" action [ SetVariable("galeriebild", "mittel3"), Show("bildergalerie_bild", transition=Dissolve(0.2))]           
                #
                if persistent.gal_emi1 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                   imagebutton idle "images/gal/thumbs/dtl-emilykunst1.jpg" hover "images/gal/thumbs/dtl-emilykunst1.jpg" action [ SetVariable("galeriebild", "emi1"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_emi2 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                   imagebutton idle "images/gal/thumbs/dtl-emilykunst2.jpg" hover "images/gal/thumbs/dtl-emilykunst2.jpg" action [ SetVariable("galeriebild", "emi2"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_emi3 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                   imagebutton idle "images/gal/thumbs/dtl-emilykunst3.jpg" hover "images/gal/thumbs/dtl-emilykunst3.jpg" action [ SetVariable("galeriebild", "emi3"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_loli1 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                   imagebutton idle "images/gal/thumbs/dtl-kinderkunst1.jpg" hover "images/gal/thumbs/dtl-kinderkunst1.jpg" action [ SetVariable("galeriebild", "loli1"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_loli2 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                   imagebutton idle "images/gal/thumbs/dtl-kinderkunst2.jpg" hover "images/gal/thumbs/dtl-kinderkunst2.jpg" action [ SetVariable("galeriebild", "loli2"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_loli3 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/dtl-kinderkunst3.jpg" hover "images/gal/thumbs/dtl-kinderkunst3.jpg" action [ SetVariable("galeriebild", "loli3"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_loli4 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/dtl-kinderkunst4.jpg" hover "images/gal/thumbs/dtl-kinderkunst4.jpg" action [ SetVariable("galeriebild", "loli4"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_loli5 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/dtl-kinderkunst5.jpg" hover "images/gal/thumbs/dtl-kinderkunst5.jpg" action [ SetVariable("galeriebild", "loli5"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_kinderhass != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/kinderhasser-o-vision.jpg" hover "images/gal/thumbs/kinderhasser-o-vision.jpg" action [ SetVariable("galeriebild", "kinderhass"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                #    
                if persistent.gal_porn_henr != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/porn_henr.jpg" hover "images/gal/thumbs/porn_henr.jpg" action [ SetVariable("galeriebild", "porn_henr"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_porn_capt != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/porn_capt.jpg" hover "images/gal/thumbs/porn_capt.jpg" action [ SetVariable("galeriebild", "porn_capt"), Show("bildergalerie_bild", transition=Dissolve(0.2))]                    
                if persistent.gal_porn_enge != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:               
                    imagebutton idle "images/gal/thumbs/porn_enge.jpg" hover "images/gal/thumbs/porn_enge.jpg" action [ SetVariable("galeriebild", "porn_enge"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_porn_kimm != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/porn_kimm.jpg" hover "images/gal/thumbs/porn_kimm.jpg" action [ SetVariable("galeriebild", "porn_kimm"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_porn_zapf != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/porn_zapf.jpg" hover "images/gal/thumbs/porn_zapf.jpg" action [ SetVariable("galeriebild", "porn_zapf"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_porn_hure != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/porn_hure.jpg" hover "images/gal/thumbs/porn_hure.jpg" action [ SetVariable("galeriebild", "porn_hure"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_porn_fick2 != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/porn_fick2.jpg" hover "images/gal/thumbs/porn_fick2.jpg" action [ SetVariable("galeriebild", "porn_fick2"), Show("bildergalerie_bild", transition=Dissolve(0.2))]     
                if persistent.gal_porn_fick != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/porn_fick.jpg" hover "images/gal/thumbs/porn_fick.jpg" action [ SetVariable("galeriebild", "porn_fick"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_porn_cybe != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/porn_cybe.jpg" hover "images/gal/thumbs/porn_cybe.jpg" action [ SetVariable("galeriebild", "porn_cybe"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_porn_ursu != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/porn_ursu.jpg" hover "images/gal/thumbs/porn_ursu.jpg" action [ SetVariable("galeriebild", "porn_ursu"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                if persistent.gal_fanart != True:
                    add "images/gal/dummy.jpg" xalign 0.5
                else:    
                    imagebutton idle "images/gal/thumbs/fanart.jpg" hover "images/gal/thumbs/fanart.jpg" action [ SetVariable("galeriebild", "fanart"), Show("bildergalerie_bild", transition=Dissolve(0.2))]
                add "images/gal/dummy_empty.jpg"
                add "images/gal/dummy_empty.jpg"                   
            vbox:
                null height 10
                xalign 1.0 yalign 1.0
                textbutton "Zurück" action [Play("sound", "sound/button_click2.ogg"), Return()] xoffset 3 yoffset 2 xminimum 90
    add "images/galerie_fore.png" at untenrein
    add "images/mainmenu_titel.png" at menuani_titelraus    
#
##############################################################################
# Preferences
#
# Screen that allows the user to change the preferences.
# http://www.renpy.org/doc/html/screen_special.html#prefereces
screen preferences_saveonly():
    key "K_ESCAPE" action Return() 
    key "mouseup_3" action Return()
    window:
        style "zm_root"
    tag menu
    grid 1 1:
        xalign 0.5
        yalign 0.5
        vbox:
            frame:
                style_group "yesno"                 
                top_padding 16  
                bottom_padding 20                
                left_padding 20
                right_padding 20
                has vbox    
                text _("{color=#000}Willste speichern?{/color}")
                null height 12
                hbox:
                    xalign .5
                    textbutton _("Ja.") action ShowMenu('save')
                    textbutton _("Nein.") action Return()

screen preferences_nosave():
    tag menu
    use preferences_ingame
screen preferences_ingame():
    tag menu        
    imagemap:
        ground "images/optmenu_ground.png"
        hover "images/optmenu_hover.png"
        if _preferences.fullscreen == False:
            hotspot (422,76,112,29) action [Preference("display", "fullscreen")]
        elif _preferences.fullscreen == True:
            hotspot (422,76,112,29) action [Play("sound2", "sound/button_hov.ogg"), Preference("display", "window")]
        if _preferences.skip_unseen == False:
            hotspot (412,135,134,32) action [Preference("skip", "all"), Play("sound2", "sound/button_hov.ogg")]
        elif _preferences.skip_unseen == True:
            hotspot (412,135,134,32) action [Preference("skip", "seen"), Play("sound2", "sound/button_hov.ogg")]
        hotspot (404,372,149,27) action MainMenu()
        if _game_menu_screen == 'preferences_ingame':
            hotspot (410,403,138,27) action ShowMenu('save')
        hotspot (435,433,88,27) action ShowMenu("load")
        hotspot (427,462,101,28) action Return()
    if _preferences.fullscreen == True:
        add "images/optmenu_switch1.png"
    if _preferences.skip_unseen == False:
        add "images/optmenu_switch2.png"
    if _game_menu_screen == 'preferences_nosave':
        add "images/optmenu_nosave.png"
    vbox:
        xalign 0.5 ypos 0.363  xmaximum 140      
        bar value Preference("text speed")
        null height 35
        bar value Preference("music volume")
        null height 35
        bar value Preference("sound volume")
    textbutton _("{size=10}RESET{/size}") action Preference("text speed", 30) xalign 0.5 yalign 0.5 xoffset -95 yoffset -60 xpadding 3
screen preferences():
    key "K_ESCAPE" action [Play("sound", "sound/button_click2.ogg"), Return()]
    key "mouseup_3" action [Play("sound", "sound/button_click2.ogg"), Return()]
    add "images/menubg_pref.jpg"
    tag menu
    #window:
    #    style "gm_root"
    window:
        at untenrein
        xpadding 0 ypadding 0
        imagemap:
            ground "images/optmenu1_ground.png"
            hover "images/optmenu1_hover.png"     
            hotspot (424,356,105, 35) action [Play("sound", "sound/button_click2.ogg"), Return()]  
        hbox:
            xpos 0.487
            ypos 0.28
            style_group "pref"
            vbox:
                xminimum 160
                if _preferences.fullscreen == False:
                    textbutton _("Fenster") action Preference("display", "fullscreen") xminimum 160
                elif _preferences.fullscreen == True:
                    textbutton _("Vollbild") action [Play("sound2", "sound/button_hov.ogg"), Preference("display", "window")] xminimum 160
                if _preferences.skip_unseen == False:
                    textbutton _("nur Gelesenes") action [Preference("skip", "all"), Play("sound2", "sound/button_hov.ogg")] xmaximum 160 xminimum 160
                elif _preferences.skip_unseen == True:
                    textbutton _("alles.jpg") action [Preference("skip", "seen"), Play("sound2", "sound/button_hov.ogg")] xminimum 160
                null height 1                     
                if persistent.sexy == True:
                    textbutton _("sichtbar") action [SetField(persistent, 'sexy', False), Play("sound2", "sound/button_hov.ogg")] xminimum 160
                elif persistent.sexy == False:
                    textbutton _("unsichtbar") action [SetField(persistent, 'sexy', True), Play("sound2", "sound/button_hov.ogg")] xminimum 160
                elif not persistent.sexy != None:
                    null height 31                
                null height 3
                bar value Preference("text speed")  xmaximum 158
                null height 6
                bar value Preference("music volume")  xmaximum 158           
                null height 6
                bar value Preference("sound volume")  xmaximum 158
        textbutton _("{size=10}RESET{/size}") action Preference("text speed", 30) xalign 0.5 yalign 0.5 xpadding 3 yoffset -7 xoffset 157 at rotate90 #xoffset -163 yoffset 9 #yoffset -13 xoffset 161 #
        add "images/optmenu1_fore.png"
        if not persistent.sexy != None:
            add "images/optmenu1_erased.png"

    add "images/mainmenu_titel.png" at menuani_titelraus
init -2:
    style pref_button:
        size_group "pref"
        xalign 0.5
        top_padding 0
        bottom_padding 2
        top_margin 1
        bottom_margin 0
    style pref_slider:
        xmaximum 160
        xalign 0.5
        
init -2 python:    
    style.pref_vbox.xalign = 0.5
    style.pref_label.xalign = 0.5
    _preferences.afm_time = 6
    # style.soundtest_button.xalign = 0.5    
    # style.pref_frame.xfill = True
    # style.pref_frame.xmargin = 5
    # style.pref_frame.top_margin = 60
    # style.pref_frame.xalign = 0.5
    # style.pref_vbox.xfill = True
    # style.pref_slider.thumb = "images/thumb.png"
    # style.pref_slider.thumb_shadow = None
    
##############################################################################
# Yes/No Prompt
#
# Screen that asks the user a yes or no question.
# http://www.renpy.org/doc/html/screen_special.html#yesno-prompt

screen yesno_prompt(message, yes_action, no_action):
    modal True
    add "images/menubg_yesno.jpg"
    window:
        at menufade
        xalign .5 yalign .5
        style "mm_root"
        frame:
            style_group "yesno"
            xfill False
            xalign .5
            xmargin .05
            xpadding .05        
            yalign .5
            yanchor 0
            ypadding .05
        
            has vbox:
                xalign .5
                yalign .5
                spacing 30
                
            label _(message):
                xalign 0.5
    
            hbox:
                xalign 0.5
                spacing 30
                
                textbutton _("Doch!") action yes_action
                textbutton _("Nee.") action no_action

init -2:
    style yesno_button:
        size_group "yesno"
    style yesno_label_text:
        text_align 0.5
        layout "subtitle"
        color "#fc2676"     
        #outlines [(1,"#0005",0,0.5)]

##############################################################################
# Quick Menu
#
# A screen that's included by the default say screen, and adds quick access to
# several useful functions.
screen quick_menu():
    # Add an in-game quick menu.
    if vomseksmenu == True:
        null
    else:
        hbox:
            style_group "quick"
            imagemap:
                ground "images/dialoguebox_qb_ground.png"
                insensitive "images/dialoguebox_qb_insens.png"
                idle "images/dialoguebox_qbtns1.png"
                hover "images/dialoguebox_qbtns2.png"
                selected_idle "images/dialoguebox_qbtns3.png"
                selected_hover "images/dialoguebox_qbtns3.png"
                hotspot (860,393,21,24) action QuickLoad()
                hotspot (886,393,22,24) action Skip()
                hotspot (911,393,25,25) action Preference("auto-forward", "toggle")                
                if persistent.einmalgespeichert == True:
                    hotspot (834,393,21,24) action If (( _game_menu_screen == "preferences_ingame"), true = QuickSave(), false = None)
                else:
                    hotspot (834,393,21,24) action If (( _game_menu_screen == "preferences_ingame"), true = [ SetField(persistent, 'einmalgespeichert', True), QuickSave() ], false = None)

init -2:
    style quick_button:
        is default
        background None
        xpadding 5        
    style quick_button_text:
        is default
        size 12
        idle_color "de8ea299"
        hover_color "#fff9"
        selected_idle_color "#fff"
        selected_hover_color "#fff"
        insensitive_color "de8ea255"

init -2 python:    
    # Set a default value for the auto-forward time, and note that AFM is
    # turned off by default.
    config.default_afm_time = 10
    config.default_afm_enable = False
#
#