//incomplete
import { randomFromArray } from './util'

export {} from '../../platform/util/tts' //for modified functions

export const TTSVoices = [
    { sid: 17, name: 'Cyllene', category: 'female' },
    { sid: 95, name: 'Leucosia', category: 'female' },
    { sid: 44, name: 'Crina', category: 'female' },
    { sid: 80, name: 'Hespe', category: 'female' },
    { sid: 106, name: 'Ida', category: 'female' },
    { sid: 6, name: 'Alseid', category: 'male' },
    { sid: 10, name: 'Daphnis', category: 'male' },
    { sid: 16, name: 'Echo', category: 'male' },
    { sid: 41, name: 'Thel', category: 'male' },
    { sid: 77, name: 'Nomios', category: 'male' },
    { sid: -1, name: 'Seed Input', category: 'custom' },
]

export const TTSv2Voices = [
    { name: 'Ligeia', category: 'unisex', seed: 'Anananan' },
    { name: 'Aini', category: 'female', seed: 'Aini' },
    { name: 'Orea', category: 'female', seed: 'Orea' },
    { name: 'Claea', category: 'female', seed: 'Claea' },
    { name: 'Lim', category: 'female', seed: 'Lim' },
    { name: 'Aurae', category: 'female', seed: 'Aurae' },
    { name: 'Naia', category: 'female', seed: 'Naia' },
    { name: 'Aulon', category: 'male', seed: 'Aulon' },
    { name: 'Elei', category: 'male', seed: 'Elei' },
    { name: 'Ogma', category: 'male', seed: 'Ogma' },
    { name: 'Raid', category: 'male', seed: 'Raid' },
    { name: 'Pega', category: 'male', seed: 'Pega' },
    { name: 'Lam', category: 'male', seed: 'Lam' },
]

export async function randomTTSSeedPhrase(): Promise<string> {
    // eslint-disable-next-line unicorn/no-await-expression-member
    const words = (await import('../assets/wordlist.json')).default
    const categories = Object.keys(words)
    const maxWords = Math.ceil(Math.random() * 2)
    const spacerSelection = ['_']
    const numberSelection = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9']
    const easterEggSelection = ['smedrins', 'priapus', 'kurumuz']
    let result = ''
    for (let i = 0; i < maxWords; ++i) {
        if (i === 0 || Math.random() > 0.3) {
            // easter-egg
            if (Math.floor(Math.random() * 1420) === 0) {
                result = result + randomFromArray(easterEggSelection)
            } else {
                const collName = randomFromArray(categories)
                const coll = (words as Record<string, any>)[collName]
                result = result + randomFromArray(coll)
            }
        } else {
            const numbers = Math.ceil(Math.random() * 4)
            for (let j = 0; j < numbers; ++j) {
                result = result + randomFromArray(numberSelection)
            }
        }
        if (i < maxWords - 1) {
            result = result + randomFromArray(spacerSelection)
        }
    }
    return result
}
