//used by shared files, for the most part

import { Platform } from 'react-native'

export const isSafari = false
export const isInternetExplorer = false
export const isChromium = false
export const isSpellCheckSupported = true

export const chromeMajorVersion = Number.NaN

export const isBrowser = Platform.OS === 'web'
export const isMacOS = Platform.OS === 'macos'
export const isTouchScreenDevice = Platform.OS in ['android', 'ios']
export const isMobileDevice = Platform.OS in ['android', 'ios']
export const isIOS = Platform.OS === 'ios'

export const isRegExpLookBehindSupported = (() => {
    // test if lookbehind regexp is constructible
    try {
        new RegExp('(?<=)')
        return true
    } catch {
        return false
    }
})()
