﻿import { Platform } from 'react-native'
import * as MediaLibrary from 'expo-media-library'
import * as FileSystem from 'expo-file-system'
import * as Sharing from 'expo-sharing'
import { Environment } from '../../shared/globals/constants'

//stripped, only for what is necessary to other shared files
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
export function logError(message: any, report: boolean = true, additional: any = ''): void {
    if (additional) {
        // eslint-disable-next-line no-console
        console.error(additional, message)
    } else {
        // eslint-disable-next-line no-console
        console.error(message)
    }
    //if (report) Sentry.captureException(message)
}

// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
export function logWarning(message: any, report: boolean = false, additional: any = ''): void {
    if (additional) {
        // eslint-disable-next-line no-console
        console.warn(additional, message)
    } else {
        // eslint-disable-next-line no-console
        console.warn(message)
    }
    //if (report) Sentry.captureMessage(message, Sentry.Severity.Warning)
}

// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
export function logInfo(message: any, report: boolean = false, additional: any = ''): void {
    if (additional) {
        // eslint-disable-next-line no-console
        console.info(additional, message)
    } else {
        // eslint-disable-next-line no-console
        console.info(message)
    }
    //if (report) Sentry.captureMessage(message, Sentry.Severity.Info)
}

export function logDebug(...message: any[]): void {
    if (Environment !== 'production') {
        // eslint-disable-next-line no-console
        console.debug(...message)
    }
}

//#f00 Note: not an async on frontend.
export async function downloadTextFile(text: string, name: string): Promise<void> {
    name = name.replace(/["%*/:<>?\\|]/g, '_') //sanitize the name

    //keeping this other dumb stuff I did, in case I need to switch back to this other system
    //const granted = PermissionsAndroid.request(PermissionsAndroid.PERMISSIONS.WRITE_EXTERNAL_STORAGE)
    /*if (Platform.OS === 'android') {
        const rootUri = StorageAccessFramework.getUriForDirectoryInRoot('novelai')
        console.log(rootUri)
        const permissions = await StorageAccessFramework.requestDirectoryPermissionsAsync(rootUri)
        console.log(permissions)
        if (permissions.granted) {
            const type = name.split('.').pop()
            console.log(type)
            const path = await StorageAccessFramework.createFileAsync(
                permissions.directoryUri,
                name,
                `text/${type === 'txt' ? 'plain' : type}`
            )
            console.log(path)
            await StorageAccessFramework.writeAsStringAsync(path, text, { encoding: 'utf8' })
            console.log(await FileSystem.readAsStringAsync(path))
        }
    } else {*/

    //downloads file to a hidden folder
    const path = FileSystem.documentDirectory + name
    await FileSystem.writeAsStringAsync(path, text, { encoding: FileSystem.EncodingType.UTF8 })

    //associates it to a visible folder? I'm not sure, mobile is weird
    if (Platform.OS === 'ios') {
        await Sharing.shareAsync(path, { UTI: 'public.item' })
    } else {
        const permission = await MediaLibrary.requestPermissionsAsync()

        if (permission.status === 'granted') {
            try {
                const asset = await MediaLibrary.createAssetAsync(path)
                const location = await MediaLibrary.getAlbumAsync('NovelAI')
                if (location == null) {
                    await MediaLibrary.createAlbumAsync('NovelAI', asset, false)
                } else {
                    await MediaLibrary.addAssetsToAlbumAsync([asset], location, false)
                }
            } catch (error) {
                console.error('Could not download file: ', error)
            }
        } else {
            console.warn('Could not download file: media permission not granted.')
        }
    }
    //}

    /*writeFile(path, text, 'utf8')
        .then((success) => {
            console.log('File written!', success)
        })
        .catch((error) => {
            console.log('Error encountered while downloading file: ', error)
        })*/
}

//we'll cross that bridge when we get there
export function downloadFile(buffer: Uint8Array, name: string, type: string): void {}

export function isTouchDevice(): boolean {
    return true
}

export const isIOS = (function () {
    return Platform.OS === 'ios'
})()

export function isMobileDevice(size: number = 425): boolean {
    return true
}

export function browserHasPoorSpellcheckPerformance(): boolean {
    return getChromiumVersion() === '96'
}

export function getChromiumVersion(): string | undefined {
    return '97'
}

export const isSafari = false

export function createObjectURL(file: any): string {
    return ''
}
