import { useEffect } from 'react'
import { useRecoilCallback, useRecoilState, useRecoilValue, useSetRecoilState } from 'recoil'
import { getStorage } from '../../shared/data/storage/storage'
import { StoryId } from '../../shared/data/story/storycontainer'
import { GlobalUserContext } from '../../shared/globals/globals'
import { SelectedStory, SelectedStoryId, Session, SessionValue } from '../../shared/globals/state'
import { logError } from '../../shared/util/browser'

//could be shared if nProgress is replaced with empty function: babel-plugin-import-redirect
//the only lines edited were those with nProgress on it
export function useLoadUnloadedStory(): void {
    const [selectedStory, setSelectedStory] = useRecoilState(SelectedStory)

    const authenticated = useRecoilValue(SessionValue('authenticated'))
    const session = useRecoilValue(Session)

    const setLoaded = useRecoilCallback(({ snapshot }) => async (storyId: StoryId, error?: string) => {
        const currentStoryId = await snapshot.getPromise(SelectedStoryId)
        if (currentStoryId === storyId) {
            setSelectedStory({ id: storyId, loaded: true, error: error })
        }
    })

    useEffect(() => {
        if (!authenticated) return
        if (selectedStory.loaded) return

        const storage = getStorage(session)
        const currentStoryMetadata = GlobalUserContext.stories.get(selectedStory.id)
        const currentStoryContent = GlobalUserContext.storyContentCache.get(selectedStory.id)

        if (!currentStoryMetadata) return

        if (currentStoryContent) {
            setSelectedStory({ ...selectedStory, loaded: true })
            return
        }

        const storyId = selectedStory.id
        storage
            .getStoryContent(currentStoryMetadata)
            .then((storyContent) => {
                GlobalUserContext.storyContentCache.set(storyId, storyContent)
                setLoaded(storyId)
            })
            .catch((error) => {
                // TODO: show error in the UI
                logError(error)
                setLoaded(storyId, `${error.message ?? error}`)
            })

        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [authenticated, selectedStory, setSelectedStory])
}
