import AsyncStorage from '@react-native-async-storage/async-storage';
import {
    StoryContainer,
    StoryContent,
    StoryId,
    StoryMetadata,
} from '../../../shared/data/story/storycontainer'
import { AIModule, PresetId, StoryPreset } from '../../../shared/data/story/storysettings'
import { User } from '../../../shared/data/user/user'
import { IStorage } from '../../../shared/data/storage/storage'
import { KeyStore } from '../../../shared/data/storage/keystore/keystore'

export class LocalStorage implements IStorage {
    user: User

    constructor(user: User) {
        this.user = user
    }
    async saveSettings(): Promise<void> {
        throw undefined
    }
    async savePreset(): Promise<PresetId> {
        throw undefined
    }
    async getPresets(): Promise<Array<StoryPreset>> {
        throw undefined
    }
    async deletePreset(): Promise<void> {
        throw undefined
    }
    async saveStory(story: StoryContainer): Promise<string> {
        AsyncStorage.setItem(`story:${story.metadata.id}`, story.metadata.serialize())
        AsyncStorage.setItem(`storycontent:${story.metadata.id}`, story.content.serialize())
        return story.metadata.id
    }
    async getStories(): Promise<Array<StoryMetadata>> {
        const stories = [] as StoryMetadata[]
        const keys = await AsyncStorage.getAllKeys()
        for (const key of keys) {
            if (!key.startsWith('story:')) {
                continue
            }
            const story = await AsyncStorage.getItem(key)
            if (!story) {
                continue
            }
            stories.push(StoryMetadata.deserialize(story))
        }
        return stories
    }
    async getStoryContents(): Promise<Map<StoryId, StoryContent>> {
        const contents = new Map<StoryId, StoryContent>()
        const stories = await this.getStories()
        for (const story of stories) {
            const content = await this.getStoryContent(story.id)
            contents.set(story.id, content)
        }
        return contents
    }
    async getStoryContent(storyId: string): Promise<StoryContent> {
        const serialized = await AsyncStorage.getItem(`storyContent:${storyId}`)
        if (!serialized) {
            throw 'Could not retrieve content from local storage'
        }
        const deserialized = StoryContent.deserialize(serialized)
        return deserialized
    }
    async deleteStory(storyMetadata: StoryMetadata): Promise<void> {
        AsyncStorage.removeItem(`story:${storyMetadata.id}`)
        AsyncStorage.removeItem(`storycontent:${storyMetadata.id}`)
    }
    async getModules(): Promise<AIModule[]> {
        throw undefined
    }
    async saveModule(): Promise<string> {
        throw undefined
    }
    async deleteModule(): Promise<void> {
        throw undefined
    }
    getKeyStore(): Promise<KeyStore> {
        return Promise.reject()
    }
    saveKeyStore(): Promise<void> {
        return Promise.reject()
    }
    getStoryShelves(): Promise<Array<StoryMetadata>> {
        return Promise.reject()
    }
    saveStoryShelf(): Promise<string> {
        return Promise.reject()
    }
    deleteStoryShelf(): Promise<void> {
        return Promise.reject()
    }
}
