import React, { useMemo } from 'react'
import { StyleProp, TextStyle, View } from 'react-native'
import styled from 'styled-components/native'
import { MatchBit } from '../../../shared/data/storage/search'
import { BodyMedium400M } from '../../styles/fonts'

const HighlightContainer = styled.Text`
    ${BodyMedium400M};
`
const Highlight = styled.Text`
    background: ${(props) => props.theme.colors.textHighlight};
`

export function TextHighlight(props: {
    text: string
    highlight?: MatchBit[]
    style?: StyleProp<TextStyle>
    lines?: number
}): JSX.Element {
    const flatText = useMemo(() => {
        return props.text.replace(/\r?\n|\r/g, ' ')
    }, [props.text])
    let text

    if (props.highlight && props.highlight.length > 0) {
        const blocks = []
        if (props.highlight[0].start > 0) {
            blocks.push(props.text.slice(0, props.highlight[0].start))
        }

        for (const match of props.highlight) {
            blocks.push(<Highlight key={blocks.length}>{props.text.slice(match.start, match.end)}</Highlight>)
            if (match.end !== match.next) {
                blocks.push(props.text.slice(match.end, match.next))
            }
        }

        text = (
            <HighlightContainer numberOfLines={props.lines ?? 2} style={props.style}>
                {blocks.map((block) => block)}
            </HighlightContainer>
        )
    } else {
        text =
            flatText.length > 0 ? (
                <HighlightContainer numberOfLines={props.lines ?? 2} style={props.style}>
                    {flatText}
                </HighlightContainer>
            ) : (
                <View style={{ height: 5 }} />
            )
    }

    return text
}
