import React, { StrictMode } from 'react'
import { useKeepAwake } from 'expo-keep-awake'
import { RecoilRoot } from 'recoil'
import { RootSiblingParent } from 'react-native-root-siblings'

import dayjs from 'dayjs'
import utc from 'dayjs/plugin/utc'
import timezone from 'dayjs/plugin/timezone'

import { Environment, PaddleSandbox, PaddleVendorID } from '../../shared/globals/constants'
import App from './app'
import { GestureHandlerRootView } from 'react-native-gesture-handler'
import { SafeAreaProvider } from 'react-native-safe-area-context'
import { createNavigationContainerRef, NavigationContainer } from '@react-navigation/native'

dayjs.extend(utc)
dayjs.extend(timezone)

export const navigationContainerRef = createNavigationContainerRef()

export default function Root(): JSX.Element {
    Environment === 'debug' ? useKeepAwake() : null
    //I heard you liked roots?
    return (
        <RecoilRoot>
            <GestureHandlerRootView style={{ flex: 1 }}>
                <RootSiblingParent>
                    <SafeAreaProvider>
                        <NavigationContainer ref={navigationContainerRef}>
                            <App />
                        </NavigationContainer>
                    </SafeAreaProvider>
                </RootSiblingParent>
            </GestureHandlerRootView>
        </RecoilRoot>
    )
}
