import React from 'react'
import { Scenario, storyAsScenario } from '../../../shared/data/story/scenario'
import { AIModule } from '../../../shared/data/story/storysettings'
import { StoryStateValue } from '../../../shared/globals/state'

// Wrapper to import the current Story as a placeholder'ed Scenario, handles cases where story import fails.
export function scenarioStarter(
    selectedStory: StoryStateValue,
    aiModules: AIModule[],
    setImportedScenario: React.Dispatch<React.SetStateAction<Scenario>>,
    setImported: React.Dispatch<React.SetStateAction<boolean>>
): void {
    const scenario = storyAsScenario(selectedStory.id, aiModules)
    if (scenario === undefined) {
        setImported(false)
    } else {
        setImportedScenario(scenario)
        setImported(true)
    }
}
