﻿import styled from 'styled-components/native'
import { SafeAreaView } from 'react-native-safe-area-context'
import { PlusIcon } from '../common/icons'
import { HeadingLarge600M, BodyLarge400M, SoftFade } from '../../styles/fonts'

export const Menubar = styled(SafeAreaView)`
    background-color: ${(props) => props.theme.colors.bg1};
    border-color: ${(props) => props.theme.colors.bg3};
    border-right-width: 1px;
    flex: 1;
    flex-direction: column;
`

export const Header = styled.View`
    align-items: flex-end;
    background-color: ${(props) => props.theme.colors.bg1};
    flex-direction: row;
    padding: 20px;
`

export const HeaderTitle = styled.Text.attrs(() => ({
    numberOfLines: 1,
}))`
    ${HeadingLarge600M}
    overflow: hidden;
    font-size: 22px;
    line-height: 25px;
    margin-bottom: -13px;
    padding-left: 10px;
    padding-top: 11px;
`

export const HeaderSubTitle = styled.Text.attrs(() => ({
    numberOfLines: 1,
}))`
    ${BodyLarge400M};
    ${SoftFade}
    margin-bottom: -3px;
    line-height: 20px;
    overflow: hidden;
`

export const ButtonsBlock = styled.View`
    background-color: ${(props) => props.theme.colors.bg1};
    margin: 10px;
    flex-direction: row;
    align-items: stretch;
`

export const Plus = styled(PlusIcon).attrs((props) => ({
    primary: props.theme.colors.textHeadings,
}))`
    padding: 10px;
`
