﻿import React from 'react'
import { useRecoilValue, useSetRecoilState } from 'recoil'
import { Pressable } from 'react-native'
import { TextInput } from 'react-native-gesture-handler'
import { LoreSidebarMain, LoreSidebarEntryStyle, LoreSidebarHeading } from './lorebookitems.style'
import { HeadingSmall600 } from '../../styles/fonts'
import { ArrowDownIcon, ArrowUpIcon } from '../common/icons'
import { LoreEntry } from '../../../shared/data/ai/loreentry'
import { SelectedStory, StoryUpdate } from '../../../shared/globals/state'
import { GlobalUserContext } from '../../../shared/globals/globals'

export function LoreSidebarEntry(props: { lore: LoreEntry }): JSX.Element {
    const [active, setActive] = React.useState(false)
    const toggleActive = () => {
        setActive(!active)
    }
    const selectedStory = useRecoilValue(SelectedStory)
    const currentStoryMetadata = GlobalUserContext.stories.get(selectedStory.id)
    const setStoryUpdate = useSetRecoilState(StoryUpdate(''))

    const setText = (text: string) => {
        if (props.lore && currentStoryMetadata) {
            props.lore.text = text
            props.lore.lastUpdatedAt = new Date()
            setStoryUpdate(currentStoryMetadata.save())
        }
    }
    return (
        <LoreSidebarEntryStyle>
            <LoreSidebarHeading onPress={toggleActive}>
                <HeadingSmall600>{props.lore.displayName}</HeadingSmall600>{' '}
                {active ? <ArrowUpIcon /> : <ArrowDownIcon />}
            </LoreSidebarHeading>
            <LoreSidebarMain active={active}>
                {active ? (
                    //note: use autosizeable text area?
                    <TextInput
                        style={{ textAlignVertical: 'top' }}
                        multiline={true}
                        //minRows={3}
                        //maxRows={8}
                        //cacheMeasurements
                        value={props.lore.text}
                        onChangeText={(text) => {
                            setText(text)
                        }}
                    ></TextInput>
                ) : (
                    <Pressable onPress={toggleActive}>{props.lore.text}</Pressable>
                )}
            </LoreSidebarMain>
        </LoreSidebarEntryStyle>
    )
}
