import styled, { css } from 'styled-components/native'
import BackgroundImage from '../../assets/images/background.png'
import { HeadingLarge600M, BodyMedium400M } from '../../styles/fonts'
import { RegularButtonText, SubmitButton, SubmitButtonText } from '../common/button.style'

export const Background = styled.ImageBackground.attrs((props) => ({
    source: props.source || BackgroundImage,
}))`
    resize-mode: cover;
    height: 100%;
    width: 100%;
`

export const LandingView = styled.View`
    padding: 30px;
    width: 100%;
    height: 100%;
    background-color: ${(props) => props.theme.colors.bg3 + 'aa'};
`

export const TitleText = styled.Text`
    ${HeadingLarge600M}
    text-align: center;
    margin-left: 10px;
    margin-right: 4px;
    align-self: flex-end;
`

export const SubtitleText = styled.Text`
    color: ${(props) => props.theme.colors.textDisabled};
    font-family: ${(props) => props.theme.fonts.headings};
    font-size: 15px;
    font-weight: 400;
    align-self: flex-end;
    margin-bottom: 3px;
`

const SloganText = css`
    ${HeadingLarge600M}
    font-size: 28px;
    line-height: 50px;
    margin-top: -16px;
`

export const HeaderText = styled.Text`
    ${SloganText};
    color: ${(props) => props.theme.colors.textHeadings};
    padding-top: 120px;
`

export const TypeWriterText = styled.Text`
    ${SloganText};
    padding-left: 2px;
`

export const PromoText = styled.Text`
    ${BodyMedium400M}
    margin-top: 14px;
    flex: 1;
`

export const LoginButton = styled(SubmitButton)`
    margin-top: 30px;
`

export const LoginButtonText = styled(SubmitButtonText)`
    font-size: 18px;
    margin: 2px;
`

export const SignUpButtonText = styled(RegularButtonText)`
    font-size: 18px;
    margin: 2px;
`
