﻿import React, { useEffect, useState, useRef } from 'react'
import { useRecoilState, useRecoilValue, useSetRecoilState } from 'recoil'
import styled from 'styled-components/native'
import { GlobalUserContext } from '../../../../shared/globals/globals'
import { SelectedStory, StoryUpdate, TokenizerText, TokenizerOpen } from '../../../../shared/globals/state'
import { InputSelected } from '../../../globals/state'
import { BodyMedium400M, BodyMedium700M, SoftFade } from '../../../styles/fonts'
import { getModelEncoderType } from '../../../tokenizer/encoder'
import { WorkerInterface } from '../../../tokenizer/interface'
import { SubtleButton } from '../../common/button.style'

export default function ContextEditor(props: { contextIndex: number; placeholder: string }): JSX.Element {
    const selectedStory = useRecoilValue(SelectedStory)

    const currentStory = GlobalUserContext.stories.get(selectedStory.id)
    const currentStoryContent = GlobalUserContext.storyContentCache.get(selectedStory.id)
    const setInputSelected = useSetRecoilState(InputSelected)

    const [usedTokens, setUsedTokens] = useState(props.contextIndex)

    const [storyUpdate, setStoryUpdate] = useRecoilState(StoryUpdate(''))

    const setTokenizerText = useSetRecoilState(TokenizerText)
    const setTokenizerOpen = useSetRecoilState(TokenizerOpen)

    useEffect(() => {
        if (!currentStoryContent || !currentStoryContent.context[props.contextIndex]) {
            return
        }
        const encoderType = getModelEncoderType(currentStoryContent.settings.model)

        new WorkerInterface()
            .encode(currentStoryContent.context[props.contextIndex].text, encoderType)
            .then((encoded) => {
                setUsedTokens(encoded.length)
            })
    }, [currentStory, currentStoryContent, props.contextIndex, storyUpdate])

    const [value, setValue] = useState(currentStoryContent?.context[props.contextIndex]?.text)
    useEffect(() => {
        setValue(currentStoryContent?.context[props.contextIndex]?.text)
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [currentStoryContent?.context[props.contextIndex]?.text, setValue])
    const saveRef = useRef(0)
    const setMemory = (memory: string) => {
        if (!currentStoryContent || !currentStoryContent.context[props.contextIndex] || !currentStory) {
            return
        }
        currentStoryContent.context[props.contextIndex] = {
            ...currentStoryContent.context[props.contextIndex],
            text: memory,
        }
        setStoryUpdate(currentStory.save())
    }
    const queueSetMemory = (memory: string) => {
        clearTimeout(saveRef.current)
        setValue(memory)
        saveRef.current = setTimeout(() => setMemory(memory), 500) as any as number
    }

    return (
        <Container>
            {currentStoryContent?.context !== undefined ? (
                <MemoryInput
                    value={value}
                    onChangeText={(text: string) => queueSetMemory(text)}
                    onFocus={() => setInputSelected(true)}
                    placeholder={props.placeholder}
                    multiline={true}
                    blurOnSubmit={true}
                />
            ) : (
                <></>
            )}
            <UsedMax
                onPress={() => {
                    setTokenizerText(value ?? '')
                    setTokenizerOpen(true)
                }}
            >
                <UsedMaxText>{usedTokens}</UsedMaxText>
                <UsedMaxText>&nbsp;{usedTokens === 1 ? 'token' : 'tokens'}</UsedMaxText>
            </UsedMax>
        </Container>
    )
}

const Container = styled.View`
    background-color: ${(props) => props.theme.colors.bg0};
    padding: 10px 5px 20px;
`

const UsedMax = styled(SubtleButton)`
    flex-direction: row;
    flex-wrap: nowrap;
    font-size: 0.9rem;
    bottom: 0;
    margin: 0 5px 0 0;
    opacity: 0.7;
    position: absolute;
    right: 0;
`

const UsedMaxText = styled.Text`
    ${BodyMedium700M}
    ${SoftFade}
`

const MemoryInput = styled.TextInput`
    ${BodyMedium400M}
    text-align-vertical: top;
    line-height: 20px;
    max-height: 157px;
    min-height: 100px;
    padding-left: 10px;
`
