import React, { useState, MutableRefObject } from 'react'
import { View, TouchableOpacity } from 'react-native'
import { UniqueId } from '../../../shared/data/document/util'
import { useReload } from '../../../shared/hooks/useReload'
import { BodyLarge600 } from '../../styles/fonts'
import { FlexRow } from '../common/common.style'
import { EditorModel } from './editormodel'
import { Paragraph } from './model'

export function TestOptions(props: {
    editorModel: EditorModel
    heigthsReloadRef: React.MutableRefObject<() => null>
    redraw: () => void
    setOverlayVisible: React.Dispatch<React.SetStateAction<boolean>>
}): JSX.Element {
    const [initialized, setInitialized] = useState(false)

    return (
        <View>
            <FlexRow grow={false}>
                <TouchableOpacity onPress={() => props.editorModel.refreshSegments()}>
                    <BodyLarge600>Refresh</BodyLarge600>
                </TouchableOpacity>
                <TouchableOpacity onPress={() => props.editorModel.logs()}>
                    <BodyLarge600>Logs</BodyLarge600>
                </TouchableOpacity>
                <TouchableOpacity onPress={() => props.editorModel.check()}>
                    <BodyLarge600>Check</BodyLarge600>
                </TouchableOpacity>
                <TouchableOpacity
                    onPress={() => {
                        if (!initialized) setInitialized(true)
                        props.editorModel.initTestData()
                    }}
                >
                    <BodyLarge600>{initialized ? 'Reinitialize' : 'Initialize'}</BodyLarge600>
                </TouchableOpacity>
                <TouchableOpacity onPress={props.redraw}>
                    <BodyLarge600>Redraw</BodyLarge600>
                </TouchableOpacity>
                {initialized && (
                    <TouchableOpacity onPress={() => props.editorModel.defaultData()}>
                        <BodyLarge600>Reset</BodyLarge600>
                    </TouchableOpacity>
                )}
            </FlexRow>
            <FlexRow>
                {initialized && (
                    <>
                        <TouchableOpacity>
                            <BodyLarge600>Calc Heights</BodyLarge600>
                        </TouchableOpacity>
                        <TouchableOpacity onPress={() => props.setOverlayVisible((visible) => !visible)}>
                            <BodyLarge600>Overlays</BodyLarge600>
                        </TouchableOpacity>
                        <TouchableOpacity onPress={() => props.editorModel.checkValues()}>
                            <BodyLarge600>Check Data</BodyLarge600>
                        </TouchableOpacity>
                    </>
                )}
            </FlexRow>
        </View>
    )
}

export function ParagraphBoundariesOverlay(props: {
    paragraphData: Map<number, Paragraph>
    paragraphOrder: UniqueId[]
    reloadRef: MutableRefObject<() => void>
}): JSX.Element {
    const reload = useReload()
    props.reloadRef.current = reload

    return (
        <View style={{ position: 'absolute', zIndex: 10, marginVertical: 10 }}>
            {props.paragraphOrder.map((id, index) => (
                <View
                    key={id}
                    style={{
                        height: props.paragraphData.get(id)?.dimensions.height ?? 0,
                        width: props.paragraphData.get(id)?.dimensions.width ?? 0,
                        backgroundColor: 'white',
                        opacity: 0.2,
                        //borderColor: 'white',
                        //borderWidth: 1,
                        //borderBottomWidth: index < props.paragraphOrder.length - 1 ? 0 : 1,
                    }}
                >
                    <View
                        style={{
                            position: 'absolute',
                            backgroundColor: 'white',
                            height: 21,
                            width: props.paragraphData.get(id)?.dimensions.lastLine ?? 0,
                            bottom: 0,
                        }}
                    />
                </View>
            ))}
        </View>
    )
}
