import styled, { css } from 'styled-components/native'

export const FullSize = styled.View`
    width: 100%;
    height: 100%;
    margin: 0px;
`

export const FlexRow = styled.View<{ grow?: boolean }>`
    flex-direction: row;
    align-items: center;
    justify-content: space-between;
    ${(props) =>
        props.grow ?? true
            ? css`
                  flex-grow: 1;
                  flex-shrink: 1;
                  width: 100%;
              `
            : css`
                  flex-grow: 0;
                  flex-shrink: 0;
              `};
`

export const FlexCol = styled.View<{ wide?: boolean }>`
    flex-direction: column;
    align-items: ${(props) => (props.wide ? 'unset' : 'flex-start')};
    justify-content: space-between;
    flex-grow: 1;
    flex-shrink: 1;
    width: 100%;
`

export const FlexColSpacer = styled.View<{ min: number; max: number }>`
    flex: 1 1 ${(props) => props.max}px;
    min-height: ${(props) => props.min}px;
    max-height: ${(props) => props.max}px;
`

export const FlexSpaceFull = styled.View`
    flex-grow: 1;
    flex-shrink: 1;
    flex-basis: 1;
`
