﻿import React from 'react'
import { StyleProp, View, ViewStyle } from 'react-native'
import Icon from 'react-native-vector-icons/MaterialIcons'
import styled from 'styled-components/native'
import { BodyMedium400Faded, BodyMedium600M, HeadingSmall600M } from '../../styles/fonts'

export default function Checkbox(props: {
    value: boolean
    setValue: (newValue: boolean) => void
    checkedText?: string | JSX.Element
    uncheckedText?: string | JSX.Element
    hideIcons?: boolean
    disabled?: boolean
    label: string
    alternate?: boolean
    tooltip?: string //not yet implemented
    style?: StyleProp<ViewStyle> //might need revision, currently passed to all sub components
}): JSX.Element {
    return (
        <CheckboxArea disabled={props.disabled} style={props.style}>
            <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                <Label alternate={props.alternate ?? false}>{props.label}</Label>
                <CheckboxBody toggled={props.value} onPress={() => props.setValue(!props.value)}>
                    <CheckboxInner toggled={props.value}>
                        {props.hideIcons ? <></> : props.value ? <Check /> : <Cross />}
                    </CheckboxInner>
                </CheckboxBody>
            </View>
            {props.checkedText && (
                <CheckBoxTextArea>
                    {props.value ? (
                        <BodyMedium400Faded>{props.checkedText}</BodyMedium400Faded>
                    ) : (
                        <BodyMedium400Faded>{props.uncheckedText}</BodyMedium400Faded>
                    )}
                </CheckBoxTextArea>
            )}
        </CheckboxArea>
    )
}

const Label = styled.Text<{ alternate?: boolean }>`
    ${(props) => (props.alternate ? BodyMedium600M : HeadingSmall600M)};
`

const CheckboxArea = styled.View<{ disabled?: boolean }>`
    ${(props) => props.disabled && 'opacity: 0.5'};
    margin-vertical: 10px;
`

const CheckboxBody = styled.Pressable<{ toggled: boolean }>`
    background: ${(props) => (props.toggled ? props.theme.colors.textHeadings : props.theme.colors.bg0)};
    width: 47px;
    height: 20px;
`

const CheckboxInner = styled.View<{ toggled: boolean }>`
    background: ${(props) => (props.toggled ? props.theme.colors.bg0 : props.theme.colors.bg3)};
    ${(props) => (props.toggled ? 'right: 2px' : 'left: 2px')};
    position: absolute;
    height: 16px;
    width: 25px;
    margin-top: 2px;
    justify-content: center;
    align-items: center;
`

//name set in checkbox element
const Check = styled(Icon).attrs((props) => ({
    name: 'done',
    size: 16,
}))`
    color: ${(props) => props.theme.colors.textHeadings};
`

const Cross = styled(Icon).attrs((props) => ({
    name: 'close',
    size: 16,
}))`
    color: ${(props) => props.theme.colors.textMain};
    opacity: 0.5;
`

//needs to be styled, will be once needed
const CheckBoxTextArea = styled.View`
    padding-vertical: 5px;
`
