import React from 'react'
import { useRecoilValue } from 'recoil'
import { ThemeProvider } from 'styled-components'
import { createNativeStackNavigator } from '@react-navigation/native-stack'
import { setRootViewBackgroundColor } from '@pnthach95/react-native-root-view-background'
import { SiteTheme } from '../../shared/globals/state'
import { App as StyledApp } from './app.style'
import LandingPage from './landing/landing'
import LoginPage from './landing/login'
import StoryApp from './storyapp'
import { useSafeAreaInsets } from 'react-native-safe-area-context'
import SignUp from './landing/signup'
import { sanitizeTheme } from '../util/sanitizetheme'
import Settings from './settings/settingsscreen'
import TestArea from './testarea'

export type RootStackParamList = {
    landing: undefined
    login: undefined
    signup: undefined
    storyapp: undefined
    settings: undefined
    testarea: undefined
}

const Stack = createNativeStackNavigator<RootStackParamList>()

export default function App(): JSX.Element {
    const siteTheme = useRecoilValue(SiteTheme)
    const { top, bottom } = useSafeAreaInsets()

    React.useEffect(() => {
        setRootViewBackgroundColor(siteTheme.colors.bg0)
    }, [siteTheme])

    return (
        <ThemeProvider theme={sanitizeTheme(siteTheme)}>
            <StyledApp>
                <Stack.Navigator
                    initialRouteName="landing"
                    screenOptions={{
                        presentation: 'modal',
                        animation: 'none',
                        headerShown: false,
                        contentStyle: {
                            marginTop: top,
                            marginBottom: bottom,
                        },
                    }}
                >
                    <Stack.Screen name="landing" component={LandingPage} />
                    <Stack.Screen name="login" component={LoginPage} />
                    <Stack.Screen name="signup" component={SignUp} />
                    <Stack.Screen name="storyapp" component={StoryApp} />
                    <Stack.Screen name="settings" component={Settings} />
                    <Stack.Screen name="testarea" component={TestArea} />
                </Stack.Navigator>
            </StyledApp>
        </ThemeProvider>
    )
}
