﻿const { getDefaultConfig } = require('metro-config')

module.exports = (async () => {
    const {
        resolver: { sourceExts, assetExts },
    } = await getDefaultConfig()
    return {
        transformer: {
            babelTransformerPath: require.resolve('react-native-svg-transformer'),
        },
        resolver: {
            assetExts: assetExts.filter((ext) => ext !== 'svg'),
            sourceExts: [...sourceExts, 'svg', 'cjs'],
            /*extraNodeModules: {   //Note, can use this in the future, changes requires even in packages
                stream: require.resolve('readable-stream'),
            },*/
        },
    }
})()
