# Advanced: Prompt Mixing

## Prompt Mixing

Prompt Mixing averages out the text vectors of two different prompts. For example, it is very useful when you want to insert an artist's style but don't want it to have too much influence over your generation. Some tags have a tendency to easily overpower your prompt, with prompt mixing you may alleviate this issue.

Spacing before or after the `|` symbol is not needed.


**Example:**

With a bit of tweaking you too can have your perfect catfrog!
![Promptmixing: no-green forest](../assets/cat_frog1.png)

```prompt
cat|frog
```
![Promptmixing: cat on its own](../assets/cat1.png)
![Promptmixing: cat|frog combined creates catfrogs!](../assets/catfrog1.png)

You can add a value to the strength of the how much the AI will weigh each additional image prompt after the prompt. If no value is used it defaults to 1.
**Example:** `:0.1` ~ `:100`

Negative values in very low numbers should theoretically reverse the vectors. This does still require testing.
Negative values of `:-1` will always result in black images.

If the combined negatives add up to sum of positives (-1) everything will return just black as well.



**Goose Tip:** Results will vary widely and prompt mixing with negatives is not always simple. Removing concepts from some prompts can yield very strange results. From our testing we've found that any values above `:0.4` create some rather jarring imagery.

**Example:**
The AI likes to render a simple forest prompt with a lot of greenery. In this case let's aim for a forest that is a little less healthy.

![Promptmixing: regular forest](../assets/negativepromptmixing-forest1.png)

By telling the AI to remove it's interpretation of the prompt "green" we receive a much more sickly looking forest, but the composition seems a lot more stifled, almost unnaturally repetitive. 

![Promptmixing: no-green forest](../assets/negativepromptmixing-forestnogreen1.png)



### Example Syntax

```prompt
Prompt1|Prompt2 :0.3
```

> Note: the number corresponds to prompt 2's strength, if none is given, it defaults to 1.

### Examples

```prompt
cat:1|happy:-0.2|cute:-0:3
```
